/*
 *   LADCCA
 *    
 *   Copyright (C) 2002, 2003 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_COMM_EVENT_H__
#define __LADCCA_COMM_EVENT_H__

#include <uuid/uuid.h>

#include <ladcca/loader.h>
#include <ladcca/internal_headers.h>

/*
 * Comm protocol versioning
 *
 * If the low-level protocol versions of client and
 * server don't match, the socket is immediately closed.
 *
 * Protocol versions:
 *
 * 0.4.0:   2
 * < 0.4.0: 1 (implied by CCA_Comm_Event_Connect,
 *             which the protocol field replaces)
 */

#define CCA_COMM_PROTOCOL_VERSION 2


enum CCA_Comm_Event_Type
{
  CCA_Comm_Event_Connect = 1,
  CCA_Comm_Event_Iface_Connect,
  CCA_Comm_Event_Event,
  CCA_Comm_Event_Config,
  CCA_Comm_Event_Exec,
  CCA_Comm_Event_Ping,
  CCA_Comm_Event_Pong,
  CCA_Comm_Event_Close,
  CCA_Comm_Event_Protocol_Mismatch
};

struct _cca_comm_event   
{
  enum CCA_Comm_Event_Type type;
  union
  {
    cca_connect_params_t *connect;
    cca_event_t          *event;  
    cca_config_t         *config;
    cca_exec_params_t    *exec;
    char                 *string;
    long                  number;
  } event_data;
};


void cca_comm_event_init (cca_comm_event_t * event);
void cca_comm_event_free (cca_comm_event_t * event);

cca_comm_event_t * cca_comm_event_new ();
void               cca_comm_event_destroy (cca_comm_event_t * event);

void cca_comm_event_set_type              (cca_comm_event_t *, enum CCA_Comm_Event_Type);
void cca_comm_event_set_connect           (cca_comm_event_t *, cca_connect_params_t *);
void cca_comm_event_set_event             (cca_comm_event_t *, cca_event_t *);
void cca_comm_event_set_config            (cca_comm_event_t *, cca_config_t *);
void cca_comm_event_set_protocol_mismatch (cca_comm_event_t *, cca_protocol_t);
void cca_comm_event_set_exec              (cca_comm_event_t *, cca_exec_params_t *);

enum CCA_Comm_Event_Type  cca_comm_event_get_type (cca_comm_event_t *);

cca_connect_params_t * cca_comm_event_take_connect (cca_comm_event_t * event);
cca_event_t *          cca_comm_event_take_event   (cca_comm_event_t * event);
cca_config_t *         cca_comm_event_take_config  (cca_comm_event_t * event);
cca_exec_params_t *    cca_comm_event_take_exec    (cca_comm_event_t * event);

#endif /* __LADCCA_COMM_EVENT_H__ */
