/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "song.h"


Song::Song()
{
    clear();
}


bool
Song::sameAs( const Song &song )
{
    if ( artist() != song.artist() )
        return false;

    if ( album() != song.album() )
        return false;

    if ( track() != song.track() )
        return false;

    return true;
}


void
Song::fetch( const Song &song )
{
    setArtist( song.artist() );
    setAlbum( song.album() );
    setTrack( song.track() );
    setStation( song.station() );
    setCover( song.cover() );
    setDuration( song.duration() );
    setProgress( song.progress() );
    setArtistUrl( song.artistUrl() );
    setAlbumUrl( song.albumUrl() );
    setTrackUrl( song.trackUrl() );
}


void
Song::clear()
{
    setArtist( "" );
    setAlbum( "" );
    setTrack( "" );
    setStation( "" );
    setCover( "" );
    setDuration( 0 );
    setProgress( 0 );
    setArtistUrl( "" );
    setAlbumUrl( "" );
    setTrackUrl( "" );
}

