/*  This is the LCDproc driver for MatrixOrbital GLK Graphic Displays
                                         http://www.matrixorbital.com

    Copyright (C) 2001, Philip Pokorny
		  2001, David Glaude

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 */

#ifndef GLKPROTO_H
#define GLKPROTO_H

/* Necessary pre-defines */
#include <termios.h>

/* Protocol values */
extern unsigned char  GLKCommand ;
extern unsigned char  GLKConfirm ;
extern unsigned char  GLKDeny ;

extern unsigned char  GLKBufferFull ;
extern unsigned char  GLKBufferEmpty ;

#define GLKFLOW_OK  (0)
#define GLKFLOW_STOPPED  (1)
#define GLKFLOW_DISABLE  (-1)

/* Structure to hold various information about a
 *    device
 */
#define UNGETBUFSIZE  (16)
typedef struct {
      int  fd ;
      struct termios  saved ;
      int  flow ;
      int  timeout ;
      int  ungetin, ungetout ;
      unsigned char  ungetbuf[UNGETBUFSIZE] ;
   } GLKDisplay ;

/* Quote from Matrix Orbital GLK users manual:
 *
 *    ... during file downloads, the modules may need
 *    to spend considerable time moving files to make
 *    room for the new file.  This delay during download
 *    can be as much as a minute, but generally it will
 *    not exceed 10 seconds.
 */

/* Default timeout = 25.4 seconds */
#define GLK_TIMEOUT  (254)

/* Functions */
GLKDisplay * glkopen( char * name, tcflag_t speed );
int glktimeout( GLKDisplay * fd, int timeout );
int glkclose( GLKDisplay * );
int glkput_confirm( GLKDisplay * fd, int c );
int glkputa_confirm( GLKDisplay * fd, int len, unsigned char * str );
int glkput_echo( GLKDisplay * fd, int c );
int glkputl( GLKDisplay * fd, ... );
int glkputa( GLKDisplay * fd, int len, unsigned char * str );
int glkputs( GLKDisplay * fd, char * str );
int glkput( GLKDisplay * fd, int c );
int glkget( GLKDisplay * fd );
int glkgetc( GLKDisplay * fd );
int glkpoll( GLKDisplay * fd, int timeout );
int glkflow( GLKDisplay * fd, int full, int empty );

int glkunget( GLKDisplay * fd, int c );

#endif
