/*
 * $Id: cmds_sn2.c,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern int config_cmd(command_t *), config_parse(command_t *);
extern void config_help(command_t *), config_usage(command_t *);
extern char *config_complete(command_t *);

extern int cpu_cmd(command_t *), cpu_parse(command_t *);
extern void cpu_help(command_t *), cpu_usage(command_t *);
extern char *cpu_complete(command_t *);

extern int hwpath_cmd(command_t *), hwpath_parse(command_t *);
extern void hwpath_help(command_t *), hwpath_usage(command_t *);
extern char *hwpath_complete(command_t *);

extern int vertex_cmd(command_t *), vertex_parse(command_t *);
extern void vertex_help(command_t *), vertex_usage(command_t *);
extern char *vertex_complete(command_t *);

_command_t cmdset_sn2[] = {
	{"config", 0, config_cmd, config_parse, config_help, config_usage,
		config_complete},
	{"cpu", 0, cpu_cmd, cpu_parse, cpu_help, cpu_usage, cpu_complete},
	{"hwpath", 0, hwpath_cmd, hwpath_parse, hwpath_help,
		hwpath_usage, hwpath_complete},
	{"vertex", 0, vertex_cmd, vertex_parse, vertex_help,  
		vertex_usage, vertex_complete},
	{(char *)0 }
};
