/*
 * $Id: kl_dump_alpha.h,v 1.1 2004/12/21 23:26:21 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

/* This header file holds the architecture specific crash dump header */
#ifndef __KL_DUMP_ALPHA_H
#define __KL_DUMP_ALPHA_H

/* macros
 */
#define KL_DUMP_MAGIC_NUMBER_ALPHA     0xdeaddeadULL  /* magic number         */
#define KL_DUMP_VERSION_NUMBER_ALPHA   0x2        /* version number          */

/* structures
 */

/*  Header for architecture-specific stuff.
 *  It follows right after the dump header.
 */
typedef struct kl_dump_header_alpha_s {
        uint64_t               magic_number; /* magic number for architecture */
        uint32_t               version;     /* version number of this dump */
        uint32_t               header_size; /* size of this header */
} kl_dump_header_alpha_t;

/* function declarations
 */
int kl_set_dumparch_alpha(void);

#endif /* __KL_DUMP_ALPHA_H */
