/*
 * $Id: kl_mem_ppc64.h,v 1.1 2004/12/21 23:26:22 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 * Copyright (C) 2003, 2004 IBM Corporation
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __KL_MEM_PPC64_H
#define __KL_MEM_PPC64_H


#define KL_PAGE_SHIFT_PPC64	    12
#define KL_PAGE_SIZE_PPC64          (1UL << KL_PAGE_SHIFT_PPC64)
#define KL_PAGE_MASK_PPC64	     (~(KL_PAGE_SIZE_PPC64-1))
#define KL_PAGE_OFFSET_PPC64	    0xc000000000000000
#define KL_PTE_SHIFT_PPC64	    16

#define KL_PGDIR_SHIFT_PPC64        (KL_PAGE_SHIFT_PPC64 + (KL_PAGE_SHIFT_PPC64 -3) + (KL_PAGE_SHIFT_PPC64 -2))
#define KL_PGDIR_SIZE_PPC64         (1UL<<KL_PGDIR_SHIFT_PPC64)
#define KL_PGDIR_MASK_PPC64         (~(KL_PGDIR_SIZE_PPC64-1))
#define KL_PMD_SHIFT_PPC64          (KL_PAGE_SHIFT_PPC64 + KL_PAGE_SHIFT_PPC64 - 3)
#define KL_PMD_SIZE_PPC64           (1UL << KL_PMD_SHIFT_PPC64)
#define KL_PMD_MASK_PPC64           (~(KL_PMD_SIZE_PPC64 -1))

#define KL_PTE_INDEX_SIZE_PPC64     9
#define KL_PMD_INDEX_SIZE_PPC64     10
#define KL_PGD_INDEX_SIZE_PPC64     10
#define KL_PMD_TO_PTEPAGE_SHIFT_PPC64  2

#define KL_PTRS_PER_PGD_PPC64       (1 << KL_PGD_INDEX_SIZE_PPC64)
#define KL_PTRS_PER_PMD_PPC64       (1 << KL_PMD_INDEX_SIZE_PPC64)
#define KL_PTRS_PER_PTE_PPC64       (1 << KL_PTE_INDEX_SIZE_PPC64)
#define KL_PAGE_PRESENT_PPC64           0x001UL

/*
#define KL_PMD_BASE_MASK_PPC64      (~((1UL<<12)-1))
#define KL_PT_BASE_MASK_PPC64       KL_PMD_BASE_MASK_PPC64
#define KL_PAGE_BASE_MASK_PPC64     KL_PMD_BASE_MASK_PPC64

#define KL_PAGE_PRESENT_PPC64		0x001UL
#define KL_PAGE_USER_PPC64              0x002UL
#define KL_PAGE_RW_PPC64		0x004UL
#define KL_PAGE_DIRTY_PPC64		0x080UL
#define KL_PAGE_ACCESSED_PPC64          0x100UL

#define KL_KERNPG_TABLE_PPC64	(KL_PAGE_PRESENT_PPC64 | KL_PAGE_RW_PPC64 | KL_PAGE_ACCESSED_PPC64 | KL_PAGE_DIRTY_PPC64)
*/

#define kl_pgd_none_ppc64(x)    (!x)
#define kl_pgd_bad_ppc64(x)     (x == 0)
#define kl_pmd_none_ppc64(x)    (!x)
#define kl_pmd_bad_ppc64(x)     (x == 0)
#define kl_pte_present_ppc64(x) (x & KL_PAGE_PRESENT_PPC64)
#endif /* _KL_MEM_PPC64_H */
