<?php 

/*

                    Generic  LDAP  Client  Tool
  _    ____   ___  ____    ____ _   _ ____  _     ___  ____   ____ ____
 | |  |  _ \ / _ \   _ \  |  __\ \/ /   _ \  |   / _ \   _ \ |  __   _ \
 | |  | | \ | |_| | |_) ) | |_  \/ / | |_) ) |  | | | | |_) )| |_ | |_) )
 | |__| |_/ |  _  |  __/  | |__ / /\ |  __/  |__| |_| |  _ / | |__|  _ /
 |_________/ _| |_ _|     |____/_/\_\ _|   |____ \___/ _| \_\ ____ _| \_\


 File:          default.php
 LDAPExplorer:  Copyright (c) 1999, 2000, 2001 Terrence Miao
 Version:       1.16
 Author:        Terrence Miao <terrence_miao@email.com>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU Public License along 
 with this package; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 Change Log:

	2000.11.16	- rename files from *.php3 to *.php

	2000.08.09	- preferences of host, port, basedn, binddn, filter have been 
				  added

    2000.03.20	- fix a secure hole in temporary file "/tmp/LE00****". 
				  which never check the link is followed.

    2000.03.13	- cascading Style Sheet support added

 */

class LE_Defaults {

    var $host = array ();	/* host name */
    var $port = array ();	/* port number */
    var $basedn = array ();	/* base dn */
    var $binddn = array ();	/* bind dn */
    var $filter = array ();	/* filter */
    
    var	$root_html;	    	/* root directory of HTML */
    var $maxinputlength;    /* maximum size of input field */
    var	$maxdisplaylen;	    /* maximum display size of cell in table */

    var $maxfsize;	    	/* maximum upload file size in bytes */
    
    var $newattrnum;	    /* number new attributes you can add */

    var $prefix_submit;	    /* prefix of the names in submit form */

    var $download_url;	    /* LDAP Explorer download URL */
    var $homepage_url;	    /* LDAP Explorer homepage URL */

    var $tmpdir;	    	/* temporary directory has all the generated 
			       			   files that including LDAP Explorer tree
			       			   structure info. Should be under $root_html 
			       			   directory */

    var $tmpfile_prefix;    

    var $numofrows;	    	/* num of rows per entry record in temporary file */

    function LE_Defaults () {
    }
}

$default = new LE_Defaults ();

$default->host[0]		= "igloo.its.unimelb.edu.au";
$default->host[1]		= "bucket.its.unimelb.edu.au";
$default->host[2]		= "olympic.its.unimelb.edu.au";
$default->host[3]		= "oscar.its.unimelb.edu.au";
$default->host[4]		= "britannic.its.unimelb.edu.au";
$default->port[0]		= 3389;
$default->port[1]		= 2389;
$default->port[2]		= 1389;
$default->port[3]		= 389;
$default->basedn[0]		= "l=Melbourne, st=Victoria, c=AU";
$default->basedn[1]		= "o=The University of Melbourne,c=AU";
$default->binddn[0]	    = "cn=Directory Manager, o=igloo CA, l=Melbourne, st=Victoria, c=AU";
$default->binddn[1]	    = "cn=Directory Manager";
$default->filter[0]	    = "objectclass=*";

$default->root_html	    = "/var/www/html";	

$default->maxinputlength    = 60;
$default->maxdisplaylen	    = 60;
 
$default->maxfsize	    	= 64000;

$default->newattrnum	    = 2;

$default->prefix_submit	    = "ldapexplorer_";

$default->homepage_url	    = "http://igloo.its.unimelb.edu.au/";
$default->download_url	    = "ftp://igloo.its.unimelb.edu.au/pub/LDAPExplorer";

// $default->tmpdir			= "/tmp";
$default->tmpdir			= "/";
$default->tmpfile_prefix    = "LEOO";

$default->numofrows			= 4;

?> 
