/***************************************************************************
                          campaign.h  -  description
                             -------------------
    begin                : Thu Jun 28 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __CAMPAIGN_H
#define __CAMPAIGN_H

typedef struct {
    char *name; /* file name of scenario file */
    char *next_name_major; /* next scenario in case of major victory */
    char *next_name_minor; /* analouge */
    char *brief; /* initialing message/briefing */
} Camp_Scen_Info;

typedef struct {
    char *file_name; /* file name */
    char *title; /* campaign title */
    char *desc; /* description */
    char *authors; // list of authors //
    int scen_count; /* number of scenarios */
    Camp_Scen_Info *scen_info; /* campaign's scenario information */
    char *final_msg;
    int scen_id;
    int loaded; /* campaign was loaded */
} Camp;

/* load campaign */
int load_camp( char *file_name );

/* delete campaign data*/
void clear_camp();

#endif
