// -*- c-basic-offset: 2 -*-
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USE_KDE
#include <kapp.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kwin.h>
#include <kiconloader.h>
#include <kurl.h>
#else
#include <qapplication.h>
#endif
#include <qtextcodec.h>

#include <qaccel.h>
#include <qimage.h>
#include <qdatetime.h>
#include <qdir.h>
#include <qclipboard.h>
#include <qlayout.h>
#include <qtextview.h>
#include <qpainter.h>
#include <qtabwidget.h>
#if QT_VERSION >= 300
#include <qstylefactory.h>
#else
#include <qwindowsstyle.h>
#endif

#include "licqgui.h"
#include "mainwin.h"
#include "licq_icq.h"
#include "licq_sar.h"
#include "gui-defines.h"
#include "licq_log.h"
#include "licq_translate.h"
#include "licq_utility.h"
#include "adduserdlg.h"
#include "authuserdlg.h"
#include "editgrp.h"
#include "searchuserdlg.h"
#include "utilitydlg.h"
#include "registeruser.h"
#include "skinbrowser.h"
#include "licq_icqd.h"
#include "awaymsgdlg.h"
#include "outputwin.h"
#include "ewidgets.h"
#include "sigman.h"
#include "showawaymsgdlg.h"
#include "optionsdlg.h"
#include "skin.h"
#include "securitydlg.h"
#include "userselectdlg.h"
#include "plugindlg.h"
#include "randomchatdlg.h"
#include "userinfodlg.h"
#include "usereventdlg.h"
#include "reqauthdlg.h"
#include "wharf.h"
#include "keyrequestdlg.h"
#include "usercodec.h"

#include "xpm/history.xpm"
#include "xpm/info.xpm"
#include "xpm/secure_on.xpm"
#include "xpm/secure_off.xpm"
#include "xpm/charset.xpm"
#include "xpm/itemCollapsed.xpm"
#include "xpm/itemExpanded.xpm"
#include "xpm/pixCustomAR.xpm"
#include "xpm/pixPhone.xpm"
#include "xpm/pixCellular.xpm"
#include "xpm/pixBirthday.xpm"
#include "xpm/pixInvisible.xpm"

#include "licq_qt-gui.conf.h"

extern "C" {

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef USE_SCRNSAVER
#include <X11/extensions/scrnsaver.h>
#endif

}

#undef Bool
#undef None
#undef KeyPress
#undef KeyRelease
#undef FocusIn
#undef FocusOut
#undef Status

static QPixmap *ScaleWithBorder(const QPixmap &pm, int w, int h, struct Border border)
{
   QPainter p;

   // top left corner
   QPixmap pmTL(border.left, border.top);
   p.begin(&pmTL);
   p.drawPixmap(0, 0, pm, 0, 0, pmTL.width(), pmTL.height());
   p.end();

   // top border
   QPixmap pmT(pm.width() - border.left - border.right, border.top);
   p.begin(&pmT);
   p.drawPixmap(0, 0, pm, border.left, 0, pmT.width(), pmT.height());
   p.end();
   QImage imT( (pmT.convertToImage()).smoothScale(w - border.left - border.right, pmT.height()) );

   // top right corner
   QPixmap pmTR(border.right, border.top);
   p.begin(&pmTR);
   p.drawPixmap(0, 0, pm, pm.width() - border.right, 0, pmTR.width(), pmTR.height());
   p.end();

   // left border
   QPixmap pmL(border.left, pm.height() - border.top - border.bottom);
   p.begin(&pmL);
   p.drawPixmap(0, 0, pm, 0, border.top, pmL.width(), pmL.height());
   p.end();
   QImage imL( (pmL.convertToImage()).smoothScale(pmL.width(), h - border.top - border.bottom) );

   // center
   QPixmap pmC(pmT.width(), pmL.height());
   p.begin(&pmC);
   p.drawPixmap(0, 0, pm, border.left, border.top, pmC.width(), pmC.height());
   p.end();
   QImage imC( (pmC.convertToImage()).smoothScale(imT.width(), imL.height()) );

   // right border
   QPixmap pmR(border.right, pm.height() - border.top - border.bottom);
   p.begin(&pmR);
   p.drawPixmap(0, 0, pm, pm.width() - border.right, border.top, pmR.width(), pmR.height());
   p.end();
   QImage imR ( (pmR.convertToImage()).smoothScale(pmR.width(), h - border.top - border.bottom) );

   // bottom left border
   QPixmap pmBL(border.left, border.bottom);
   p.begin(&pmBL);
   p.drawPixmap(0, 0, pm, 0, pm.height() - border.bottom, pmBL.width(), pmBL.height());
   p.end();

   // bottom border
   QPixmap pmB(pm.width() - border.left - border.right, border.bottom);
   p.begin(&pmB);
   p.drawPixmap(0, 0, pm, border.left, pm.height() - border.bottom, pmB.width(), pmB.height());
   p.end();
   QImage imB( (pmB.convertToImage()).smoothScale(w - border.left - border.right, pmB.height()) );

   // bottom right border
   QPixmap pmBR(border.right, border.bottom);
   p.begin(&pmBR);
   p.drawPixmap(0, 0, pm, pm.width() - border.right, pm.height() - border.bottom, pmBR.width(), pmBR.height());
   p.end();

   // put the image together
   QPixmap *pmFinal = new QPixmap(w, h, pm.depth());
   p.begin(pmFinal);
   p.drawPixmap(0, 0, pmTL, 0, 0, -1, -1);
   p.drawImage(border.left, 0, imT, 0, 0, -1, -1);
   p.drawPixmap(pmFinal->width() - border.right, 0, pmTR, 0, 0, -1, -1);
   p.drawImage(0, border.top, imL, 0, 0, -1, -1);
   p.drawImage(pmFinal->width() - border.right, border.top, imR, 0, 0, -1, -1);
   p.drawPixmap(0, pmFinal->height() - border.bottom, pmBL, 0, 0, -1, -1);
   p.drawImage(border.left, pmFinal->height() - border.bottom, imB, 0, 0, -1, -1);
   p.drawPixmap(pmFinal->width() - border.right, pmFinal->height() - border.bottom, pmBR, 0, 0, -1, -1);
   p.drawImage(border.left, border.top, imC, 0, 0, -1, -1);
   p.end();

   return (pmFinal);
}


QPixmap& CMainWindow::iconForStatus(unsigned long Status)
{
  if((unsigned short) Status != ICQ_STATUS_OFFLINE && (Status & ICQ_STATUS_FxPRIVATE)
     && !gMainWindow->m_bShowExtendedIcons)
    return gMainWindow->pmPrivate;

  if ((unsigned short) Status == ICQ_STATUS_OFFLINE) return gMainWindow->pmOffline;
  if (Status & ICQ_STATUS_DND) return gMainWindow->pmDnd;
  if (Status & ICQ_STATUS_OCCUPIED) return gMainWindow->pmOccupied;
  if (Status & ICQ_STATUS_NA) return gMainWindow->pmNa;
  if (Status & ICQ_STATUS_AWAY) return gMainWindow->pmAway;
  if (Status & ICQ_STATUS_FREEFORCHAT) return gMainWindow->pmFFC;

  return gMainWindow->pmOnline;
}

QPixmap& CMainWindow::iconForEvent(unsigned short SubCommand)
{
  switch(SubCommand)
  {
  case ICQ_CMDxSUB_URL:
    return gMainWindow->pmUrl;
  case ICQ_CMDxSUB_CHAT:
    return gMainWindow->pmChat;
  case ICQ_CMDxSUB_FILE:
    return gMainWindow->pmFile;
  case ICQ_CMDxSUB_CONTACTxLIST:
    return gMainWindow->pmContact;
  case ICQ_CMDxSUB_AUTHxREQUEST:
  case ICQ_CMDxSUB_AUTHxREFUSED:
  case ICQ_CMDxSUB_AUTHxGRANTED:
    return gMainWindow->pmAuthorize;
  case ICQ_CMDxSUB_MSG:
  default:
    return gMainWindow->pmMessage;
  }
}


static XErrorHandler old_handler = 0;
static int licq_xerrhandler(Display* dpy, XErrorEvent* err)
{
  // XScreenSaverQueryInfo produces a BadDrawable error
  // if it cannot connect to the extension. This happens i.e. when
  // client runs on a 64bit machine and the server on a 32bit one.
  // We need to catch that here and tell the Xlib that we
  // ignore it, otherwise Qt's handler will terminate us. :-(
  if(err->error_code == BadDrawable)
    return 0;

  return (*old_handler)(dpy, err);
}

CMainWindow* gMainWindow = NULL;

//-----CMainWindow::constructor-------------------------------------------------
CMainWindow::CMainWindow(CICQDaemon *theDaemon, CSignalManager *theSigMan,
                         CQtLogWindow *theLogWindow, bool bStartHidden,
                         const char *skinName, const char *iconsName,
                         const char *extendedIconsName, QWidget *parent)
  : QWidget(parent, "MainWindow")
{
  gMainWindow = this;
  licqDaemon = theDaemon;
  licqSigMan = theSigMan;
  licqLogWindow = theLogWindow;
  positionChanges = 0;
#ifdef QT_PROTOCOL_PLUGIN
  m_szUserMenuId = 0;
#endif

  // Overwrite Qt's event handler
  old_handler = XSetErrorHandler(licq_xerrhandler);

  // allocating floating window vector
  if(CUserView::floaties == NULL)
      CUserView::floaties = new UserFloatyList;

  // set up appicon and docking, code supplied by Mark Deneed
  WId win = winId();     // get the window
  XWMHints *hints;  // hints
  Display *dsp = x11Display();  // get the display
  hints = XGetWMHints(dsp, win);  // init hints
  hints->window_group = win;  // set set the window hint
  hints->flags = WindowGroupHint;  // set the window group hint
  XSetWMHints(dsp, win, hints);  // set the window hints for WM to use.
  XFree( hints );

  connect(qApp, SIGNAL(aboutToQuit()), this, SLOT(slot_aboutToQuit()));

  // read in info from file
  char szTemp[MAX_FILENAME_LEN];

#ifdef USE_KDE
  gLog.Info("%sKDE GUI configuration.\n", L_INITxSTR);
#else
  gLog.Info("%sQt GUI configuration.\n", L_INITxSTR);
#endif
  snprintf(szTemp, MAX_FILENAME_LEN, "%s/licq_qt-gui.conf", BASE_DIR);
  szTemp[MAX_FILENAME_LEN - 1] = '\0';
  CIniFile licqConf;
  if (! licqConf.LoadFile(szTemp) )
  {
    FILE *f = fopen(szTemp, "w");
    fprintf(f, "%s", QTGUI_CONF);
    fclose(f);
    licqConf.LoadFile(szTemp);
  }

  licqConf.SetSection("appearance");
  QFont f;
  licqConf.ReadStr("Font", szTemp, "default");
#ifdef USE_KDE
  defaultFont = KGlobalSettings::generalFont();
#else
  defaultFont = qApp->font();
#endif
  if (strcmp(szTemp, "default") != 0)
  {
#if QT_VERSION >= 300
    f.fromString(szTemp);
#else
    f.setRawName(szTemp);
#endif
    qApp->setFont(f, true);
  }
  licqConf.ReadStr("EditFont", szTemp, "default");
  if(!strcmp(szTemp, "default"))
    f = qApp->font();
  else
#if QT_VERSION >= 300
    f.fromString(szTemp);
#else
    f.setRawName(szTemp);
#endif
  delete MLEditWrap::editFont;
  MLEditWrap::editFont = new QFont(f);

  licqConf.ReadBool("GridLines", m_bGridLines, false);
  licqConf.ReadBool("FontStyles", m_bFontStyles, true);
  licqConf.ReadBool("ShowHeader", m_bShowHeader, true);
  licqConf.ReadBool("ShowOfflineUsers", m_bShowOffline, true);
  licqConf.ReadBool("AlwaysShowONU", m_bAlwaysShowONU, true);
  licqConf.ReadBool("ShowDividers", m_bShowDividers, true);
  licqConf.ReadNum("SortByStatus", m_nSortByStatus, 1);
  licqConf.ReadNum("SortColumn", m_nSortColumn, 0);
  licqConf.ReadBool("SortColumnAscending", m_bSortColumnAscending, true);
  licqConf.ReadBool("ShowGroupIfNoMsg", m_bShowGroupIfNoMsg, true);
  licqConf.ReadBool("BoldOnMsg", m_bBoldOnMsg, true);
  licqConf.ReadBool("ManualNewUser", m_bManualNewUser, false);
  licqConf.ReadBool("UseThreadView", m_bThreadView, false);
  licqConf.ReadNum("TVGroupStates", m_nGroupStates, 0xFFFFFFFE);
  licqConf.ReadBool("ShowExtIcons", m_bShowExtendedIcons, true);
  licqConf.ReadBool("SystemBackground", m_bSystemBackground, false);
  licqConf.ReadBool("SendFromClipboard", m_bSendFromClipboard, true);
  licqConf.ReadBool("MsgChatView", m_bMsgChatView, true );
#if QT_VERSION < 300
  m_bTabbedChatting = false;
#else
  licqConf.ReadBool("TabbedChatting", m_bTabbedChatting, true);
#endif
  licqConf.ReadBool("AutoPosReplyWin", m_bAutoPosReplyWin, true);
  licqConf.ReadBool("AutoSendThroughServer", m_bAutoSendThroughServer, false);
  licqConf.ReadBool("EnableMainwinMouseMovement", m_bEnableMainwinMouseMovement, true);

  licqConf.ReadBool("showPopEmail",m_bPopEmail, false);
  licqConf.ReadBool("showPopPhone",m_bPopPhone, true);
  licqConf.ReadBool("showPopFax",m_bPopFax, false);
  licqConf.ReadBool("showPopCellular",m_bPopCellular, true);
  licqConf.ReadBool("showPopIP",m_bPopIP, false);
  licqConf.ReadBool("showPopLastOnelin",m_bPopLastOnline, false);
  licqConf.ReadBool("showPopOnlineSince", m_bPopOnlineSince, false);
  licqConf.ReadBool("showPopIdleTime", m_bPopIdleTime, true);


  unsigned short nFlash;
  licqConf.ReadNum("Flash", nFlash, FLASH_URGENT);
  m_nFlash = (FlashType)nFlash;
  licqConf.ReadBool("ScrollBar", m_bScrollBar, true);
  bool bFrameTransparent;
  licqConf.ReadBool("Transparent", bFrameTransparent, false);
  unsigned short nFrameStyle;
  licqConf.ReadNum("FrameStyle", nFrameStyle, 51);
  bool bDockIcon48;
  unsigned short nDockMode;
  licqConf.ReadNum("UseDock", nDockMode, (unsigned short)DockNone);
  m_nDockMode = (DockMode)nDockMode;
  licqConf.ReadBool("Dock64x48", bDockIcon48, false);
  char szDockTheme[64];
  licqConf.ReadStr("DockTheme", szDockTheme, "");
  licqConf.ReadBool("Hidden", m_bHidden, false);
  if (!nDockMode) m_bHidden = 0;
  licqConf.ReadBool("AutoRaise", m_bAutoRaise, true);

  licqConf.SetSection("startup");
  licqConf.ReadNum("Logon", m_nAutoLogon, 0);
  if (m_nAutoLogon > 16) m_nAutoLogon = 0;
  licqConf.ReadNum("AutoAway", autoAwayTime, 0);
  licqConf.ReadNum("AutoNA", autoNATime, 0);
  licqConf.ReadNum("AutoOffline", autoOfflineTime, 0);
  licqConf.ReadNum("AutoAwayMess", autoAwayMess, 0);
  licqConf.ReadNum("AutoNAMess", autoNAMess, 0);

  licqConf.SetSection("functions");
  licqConf.ReadBool("AutoClose", m_bAutoClose, true);
  licqConf.ReadBool("AutoPopup", m_bAutoPopup, false);
  licqConf.ReadStr("MsgPopupKey", szTemp, "none");

  m_MsgAutopopupKey = QString::fromLatin1(szTemp);
  if(!(!szTemp || !strcmp(szTemp, "none"))) {
    if(!static_cast<CLicqGui*>(qApp)->grabKey(m_MsgAutopopupKey))
       gLog.Error("%sUnknown popup key: %s\n", L_INITxSTR, szTemp);
  }

  m_nCurrentGroup = gUserManager.DefaultGroup();
  m_nGroupType = GROUPS_USER;

  // load up position and size from file
  licqConf.SetSection("geometry");
  unsigned short xPos, yPos, hVal, wVal;
  licqConf.ReadNum("x", xPos, 100);
  licqConf.ReadNum("y", yPos, 100);
  licqConf.ReadNum("h", hVal, 400);
  licqConf.ReadNum("w", wVal, 150);
  gLog.Info("%sGeometry configuration (%d, %d) (%d x %d)\n", L_INITxSTR,
            xPos, yPos, wVal, hVal);
  if (yPos > QApplication::desktop()->height() - 16) yPos = 0;
  if (xPos > QApplication::desktop()->width() - 16) xPos = 0;

  // Check for qt-gui directory in current base dir
  if (!QDir(QString("%1/%2").arg(BASE_DIR).arg(QTGUI_DIR)).exists())
  {
    QDir d;
    d.mkdir(QString("%1/%2").arg(BASE_DIR).arg(QTGUI_DIR));
  }

  // Load the icons
  licqConf.SetSection("appearance");
  licqConf.SetFlags(0);
  char szIcons[MAX_FILENAME_LEN];
  if (strlen(iconsName) == 0)
    licqConf.ReadStr("Icons", szIcons);
  else
    strcpy(szIcons, iconsName);
  m_szIconSet = NULL;

  // Load the extended icons
  char szExtendedIcons[MAX_FILENAME_LEN];
  if (strlen(extendedIconsName) == 0)
    licqConf.ReadStr("ExtendedIcons", szExtendedIcons, "basic");
  else
    strcpy(szExtendedIcons, extendedIconsName);
  m_szExtendedIconSet = NULL;

  // Load the skin
  char szSkin[MAX_FILENAME_LEN] = "basic";
  if (strlen(skinName) == 0)
    licqConf.ReadStr("Skin", szSkin);
  else
    strcpy(szSkin, skinName);

#if QT_VERSION >= 300
  style = QStyleFactory::create("windows");
#else
  style = new QWindowsStyle;
#endif
  awayMsgDlg = NULL;
  optionsDlg = NULL;
  registerUserDlg = NULL;
#if QT_VERSION >= 300
  userEventTabDlg = NULL;
#endif
  m_nRealHeight = 0;

  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  m_szCaption = tr("Licq (%1)").arg(QString::fromLocal8Bit(o->GetAlias()));
  gUserManager.DropOwner();
  setCaption(m_szCaption);

  // Group Combo Box
  cmbUserGroups = new CEComboBox(false, this);
  connect(cmbUserGroups, SIGNAL(activated(int)), this, SLOT(setCurrentGroup(int)));

  // Widgets controlled completely by the skin
  btnSystem = NULL;
  lblMsg = NULL;
  lblStatus = NULL;
  pmBorder = NULL;
  pmMask = NULL;
  skin = NULL;
  menu = NULL;

  pmSecureOn = QPixmap(secure_on_xpm);
  pmSecureOff = QPixmap(secure_off_xpm);
  pmHistory = QPixmap(history_xpm);
  pmInfo = QPixmap(info_xpm);
  #ifdef USE_KDE
  pmEncoding = KGlobal::iconLoader()->loadIcon("charset", KIcon::Small, 0, KIcon::DefaultState, 0L, true);
  if (pmEncoding.isNull())
    pmEncoding = QPixmap(charset_xpm);
  #else
  pmEncoding = QPixmap(charset_xpm);
  #endif
  ApplyIcons(szIcons, true);
  ApplyExtendedIcons(szExtendedIcons, true);
  initMenu();
  ApplySkin(szSkin, true);
  skin->frame.frameStyle = nFrameStyle;
  skin->frame.transparent = bFrameTransparent;

  // set the icon
  setIconText("Licq");

  // User List
  char key[16], colTitle[32], colFormat[32];
  unsigned short colWidth, colAlign, numColumns;
  licqConf.ReadNum("NumColumns", numColumns, 1);
  for (unsigned short i = 1; i <= numColumns; i++)
  {
     sprintf(key, "Column%d.Title", i);
     licqConf.ReadStr(key, colTitle, "Alias");
     sprintf(key, "Column%d.Format", i);
     licqConf.ReadStr(key, colFormat, "%a");
     sprintf(key, "Column%d.Width", i);
     licqConf.ReadNum(key, colWidth, 100);
     sprintf(key, "Column%d.Align", i);
     licqConf.ReadNum(key, colAlign, 0);
     colInfo.push_back(new CColumnInfo(QString::fromLocal8Bit(colTitle), colFormat, colWidth, colAlign));
  }
  CreateUserView();

  unsigned short nFloaties = 0, xPosF, yPosF, wValF;
  unsigned long nUin;
  licqConf.SetSection("floaties");
  licqConf.ReadNum("Num", nFloaties, 0);
  for (unsigned short i = 0; i < nFloaties; i++)
  {
    sprintf(key, "Floaty%d.Uin", i);
    licqConf.ReadNum(key, nUin, 0);
    sprintf(key, "Floaty%d.X", i);
    licqConf.ReadNum(key, xPosF, 0);
    sprintf(key, "Floaty%d.Y", i);
    licqConf.ReadNum(key, yPosF, 0);
    sprintf(key, "Floaty%d.W", i);
    licqConf.ReadNum(key, wValF, 80);

    if (nUin != 0)
      CreateUserFloaty(nUin, xPosF, yPosF, wValF);
  }

  usprintfHelp = tr("<ul>"
                    "<li><tt>%a - </tt>user alias</li>"
                    "<li><tt>%e - </tt>email</li>"
                    "<li><tt>%f - </tt>first name</li>"
                    "<li><tt>%h - </tt>phone number</li>"
                    "<li><tt>%i - </tt>user ip</li>"
                    "<li><tt>%l - </tt>last name</li>"
                    "<li><tt>%m - </tt># pending messages</li>"
                    "<li><tt>%n - </tt>full name</li>"
                    "<li><tt>%o - </tt>last seen online</li>"
		    "<li><tt>%O - </tt>online since</li>"
                    "<li><tt>%p - </tt>user port</li>"
                    "<li><tt>%s - </tt>full status</li>"
                    "<li><tt>%S - </tt>abbreviated status</li>"
                    "<li><tt>%u - </tt>uin</li>"
                    "<li><tt>%w - </tt>webpage</li></ul>");
  licqIcon = NULL;
#ifdef USE_KDE
  if(m_nDockMode != DockNone)
    licqIcon = new IconManager_KDEStyle(this, mnuSystem);
#else
  switch (m_nDockMode)
  {
    case DockDefault:
      licqIcon = new IconManager_Default(this, mnuSystem, bDockIcon48);
      break;
    case DockThemed:
      licqIcon = new IconManager_Themed(this, mnuSystem, szDockTheme);
      break;
    case DockNone:
      break;
  }
#endif // USE_KDE

   // all settings relating to localization
   licqConf.SetSection("locale");
   licqConf.ReadStr("DefaultEncoding", szTemp, "");
   m_DefaultEncoding = QString::fromLatin1(szTemp);
   licqConf.ReadBool("ShowAllEncodings", m_bShowAllEncodings, false);

   autoAwayTimer.start(10000);  // start the inactivity timer for auto away

   connect (&autoAwayTimer, SIGNAL(timeout()), this, SLOT(autoAway()));
   connect (licqSigMan, SIGNAL(signal_updatedList(CICQSignal *)),
            this, SLOT(slot_updatedList(CICQSignal *)));
   connect (licqSigMan, SIGNAL(signal_updatedUser(CICQSignal *)),
            this, SLOT(slot_updatedUser(CICQSignal *)));
   connect (licqSigMan, SIGNAL(signal_updatedStatus()), this, SLOT(updateStatus()));
   connect (licqSigMan, SIGNAL(signal_doneOwnerFcn(ICQEvent *)),
            this, SLOT(slot_doneOwnerFcn(ICQEvent *)));
   connect (licqSigMan, SIGNAL(signal_logon()),
            this, SLOT(slot_logon()));
   connect (licqSigMan, SIGNAL(signal_ui_viewevent(unsigned long)),
            this, SLOT(slot_ui_viewevent(unsigned long)));
   connect (licqSigMan, SIGNAL(signal_ui_message(unsigned long)),
            this, SLOT(slot_ui_message(unsigned long)));
#ifdef QT_PROTOCOL_PLUGIN
   connect (licqSigMan, SIGNAL(signal_protocolPlugin(unsigned long)),
            this, SLOT(slot_protocolPlugin(unsigned long)));
#endif
            
   m_bInMiniMode = false;
   updateStatus();
   updateEvents();
   updateGroups();
   manualAway = 0;

   resize(wVal, hVal);
   move(xPos, yPos);
   if (!m_bHidden && !bStartHidden) show();

   // automatically logon if requested in conf file
   if (m_nAutoLogon > 0)
   {
      if (m_nAutoLogon >= 10)
        mnuStatus->setItemChecked(ICQ_STATUS_FxPRIVATE, true);

      switch (m_nAutoLogon % 10)
      {
      case 0: break;
      case 1: changeStatus(ICQ_STATUS_ONLINE); break;
      case 2: changeStatus(ICQ_STATUS_AWAY); break;
      case 3: changeStatus(ICQ_STATUS_NA); break;
      case 4: changeStatus(ICQ_STATUS_OCCUPIED); break;
      case 5: changeStatus(ICQ_STATUS_DND); break;
      case 6: changeStatus(ICQ_STATUS_FREEFORCHAT); break;
      default: gLog.Warn("%sInvalid auto online id: %d.\n", L_WARNxSTR, m_nAutoLogon);
      }
   }

   // verify we exist
   if (gUserManager.OwnerUin() == 0)
     slot_register();
   else
   {
     // Do we need to get a password
     ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
     if(o->Password()[0] == '\0')
     {
       gUserManager.DropOwner();
       (void) new UserSelectDlg(licqDaemon);
     }
     else
       gUserManager.DropOwner();
   }

#ifdef QT_PROTOCOL_PLUGIN
   m_nProtoNum = 0;
#endif

#if QT_VERSION > 3
  XClassHint ClassHint;
  ClassHint.res_class = (char *)qAppName();
  ClassHint.res_name = (char *)name();
  XSetClassHint(x11Display(), winId(), &ClassHint);
#endif

}

//-----ApplySkin----------------------------------------------------------------
void CMainWindow::ApplySkin(const char *_szSkin, bool _bInitial)
{
  gLog.Info("%sApplying %s skin.\n", L_INITxSTR, _szSkin);

  if (skin != NULL) delete skin;
  skin = new CSkin(_szSkin);

  // Set the background pixmap and mask
  if (skin->frame.pixmap != NULL)
  {
     if (pmBorder != NULL) delete pmBorder;
     pmBorder = new QPixmap(skin->frame.pixmap);
     if (pmBorder->isNull())
     {
       gLog.Error("%sError loading background pixmap (%s).\n", L_ERRORxSTR, skin->frame.pixmap);
       delete[] skin->frame.pixmap;
       skin->frame.pixmap = NULL;
     }
  }
  else
  {
    setBackgroundMode(PaletteBackground);
#if QT_VERSION >= 300
    unsetPalette();
#endif
  }

  if (skin->frame.mask != NULL)
  {
     if (pmMask != NULL) delete pmMask;
     pmMask = new QPixmap(skin->frame.mask);
     if (pmMask->isNull())
     {
       gLog.Error("%sError loading background mask (%s).\n", L_ERRORxSTR, skin->frame.mask);
       delete[] skin->frame.mask;
       skin->frame.mask = NULL;
     }
  }
  else
  {
    clearMask();
  }

  // Group Combo Box
  cmbUserGroups->setNamedBgColor(skin->cmbGroups.color.bg);
  cmbUserGroups->setNamedFgColor(skin->cmbGroups.color.fg);

  // System Button
  if (btnSystem != NULL) delete btnSystem;
  if (menu != NULL)
  {
    menu->removeItemAt(0);
    delete menu;
  }
  if (!skin->frame.hasMenuBar)
  {
     if (skin->btnSys.pixmapUpNoFocus == NULL)
     {
        btnSystem = new CEButton(skin->btnSys.caption == NULL ?
                                 tr("System") : QString::fromLocal8Bit(skin->btnSys.caption), this);
     }
     else
     {
       btnSystem = new CEButton(new QPixmap(skin->btnSys.pixmapUpFocus),
                                new QPixmap(skin->btnSys.pixmapUpNoFocus),
                                new QPixmap(skin->btnSys.pixmapDown),
                                this);
       btnSystem->setStyle(style);
     }
     connect(btnSystem, SIGNAL(clicked()), this, SLOT(popupSystemMenu()));
     btnSystem->setNamedFgColor(skin->btnSys.color.fg);
     btnSystem->setNamedBgColor(skin->btnSys.color.bg);
     menu = NULL;
  }
  else
  {
#ifdef USE_KDE
    menu = new KMenuBar(this);
#else
    menu = new QMenuBar(this);
#endif
    menu->insertItem(skin->btnSys.caption == NULL ?
                     tr("&System") : QString::fromLocal8Bit(skin->btnSys.caption),
                     mnuSystem);
    btnSystem = NULL;
    skin->AdjustForMenuBar(menu->height());
  }

  
  // Message Label
  delete lblMsg;
  lblMsg = new CELabel(skin->lblMsg.transparent, mnuUserGroups, this);
  if (skin->lblMsg.pixmap != NULL || skin->lblMsg.transparent)
    lblMsg->setStyle(style);
  lblMsg->setFrameStyle(skin->lblMsg.frameStyle);
  lblMsg->setIndent(skin->lblMsg.margin);
  lblMsg->setNamedFgColor(skin->lblMsg.color.fg);
  lblMsg->setNamedBgColor(skin->lblMsg.color.bg);
  if (skin->lblMsg.pixmap != NULL)
  {
#if QT_VERSION < 300
    lblMsg->setBackgroundPixmap(QPixmap(skin->lblMsg.pixmap));
  }
#else
    lblMsg->setBackgroundOrigin(WidgetOrigin);
    lblMsg->setPaletteBackgroundPixmap(QPixmap(skin->lblMsg.pixmap));
  }
  else if (skin->lblMsg.transparent && skin->frame.pixmap)
  {
    lblMsg->setBackgroundOrigin(ParentOrigin);
    lblMsg->setPaletteBackgroundPixmap(QPixmap(skin->frame.pixmap));
  }
#endif

  connect(lblMsg, SIGNAL(doubleClicked()), this, SLOT(callMsgFunction()));
  QToolTip::add(lblMsg, tr("Right click - User groups\n"
                           "Double click - Show next message"));

  // Status Label
  delete lblStatus;
  lblStatus = new CELabel(skin->lblStatus.transparent, mnuStatus, this);
  if (skin->lblStatus.pixmap != NULL || skin->lblStatus.transparent)
    lblStatus->setStyle(style);
  lblStatus->setFrameStyle(skin->lblStatus.frameStyle);
  lblStatus->setIndent(skin->lblStatus.margin);
  lblStatus->setNamedFgColor(skin->lblStatus.color.fg);
  lblStatus->setNamedBgColor(skin->lblStatus.color.bg);
  if (skin->lblStatus.pixmap != NULL)
  {
#if QT_VERSION < 300
    lblStatus->setBackgroundPixmap(QPixmap(skin->lblStatus.pixmap));
  }
#else
    lblStatus->setBackgroundOrigin(WidgetOrigin);
    lblStatus->setPaletteBackgroundPixmap(QPixmap(skin->lblStatus.pixmap));
  }
  else if (skin->lblStatus.transparent && skin->frame.pixmap)
  {
    lblStatus->setBackgroundOrigin(ParentOrigin);
    lblStatus->setPaletteBackgroundPixmap(QPixmap(skin->frame.pixmap));
  }
#endif

  connect(lblStatus, SIGNAL(doubleClicked()), this, SLOT(slot_AwayMsgDlg()));
  QToolTip::add(lblStatus, tr("Right click - Status menu\n"
                              "Double click - Set auto response"));

  if (!_bInitial)
  {
    resizeEvent(NULL);
    userView->setFrameStyle(skin->frame.frameStyle);
    userView->QListView::setPalette(skin->palette(this));
    userView->setColors(skin->colors.online, skin->colors.away,
                        skin->colors.offline, skin->colors.newuser,
                        skin->colors.background, skin->colors.gridlines);
    // Update all the floaties
    CUserView::UpdateFloaties();

    // btnSystem
    if (btnSystem != NULL)
      if ((skin->btnSys.rect.x1 == skin->btnSys.rect.x2) && (skin->btnSys.rect.y1 == skin->btnSys.rect.y2))
        btnSystem->hide();
      else
        btnSystem->show();
    // lblStatus
    if (lblStatus != NULL)
      if ((skin->lblStatus.rect.x1 == skin->lblStatus.rect.x2) && (skin->lblStatus.rect.y1 == skin->lblStatus.rect.y2))
        lblStatus->hide();
      else
        lblStatus->show();
    // lblMsg
    if (lblMsg != NULL)
      if ((skin->lblMsg.rect.x1 == skin->lblMsg.rect.x2) && (skin->lblMsg.rect.y1 == skin->lblMsg.rect.y2))
        lblMsg->hide();
      else
        lblMsg->show();
    // cmbGroups
    if (cmbUserGroups != NULL)
      if ((skin->cmbGroups.rect.x1 == skin->cmbGroups.rect.x2) && (skin->cmbGroups.rect.y1 == skin->cmbGroups.rect.y2))
        cmbUserGroups->hide();
      else
        cmbUserGroups->show();
    if (menu != NULL) menu->show();
    updateUserWin();
    updateEvents();
    updateStatus();
  }
}


//-----CMainWindow::CreateUserView---------------------------------------------
void CMainWindow::CreateUserView()
{
  userView = new CUserView(mnuUser, this);
  userView->QListView::setPalette(skin->palette(this));
  userView->setColors(skin->colors.online, skin->colors.away, skin->colors.offline,
                      skin->colors.newuser, skin->colors.background, skin->colors.gridlines);
  connect (userView, SIGNAL(doubleClicked(QListViewItem *)), SLOT(callDefaultFunction(QListViewItem *)));
}


//-----CMainWindow::CreateUserFloaty---------------------------------------------
void CMainWindow::CreateUserFloaty(unsigned long nUin, unsigned short x,
   unsigned short y, unsigned short w)
{
  if (nUin == 0) return;
  ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
  if (u == NULL) return;

  CUserView *f = new CUserView(mnuUser);
  connect (f, SIGNAL(doubleClicked(QListViewItem *)), SLOT(callDefaultFunction(QListViewItem *)));

  CUserViewItem *i = new CUserViewItem(u, f);

  gUserManager.DropUser(u);

  // not so good, we should allow for multiple guys in one box...
  // perhaps use the viewport sizeHint
  f->setFixedHeight(i->height() + f->frameWidth() * 2);

  if (w != 0)
  {
    if (y > QApplication::desktop()->height() - 16) y = 0;
    if (x > QApplication::desktop()->width() - 16) x = 0;
    f->setGeometry(x, y, w, f->height());
  }

  f->show();
}


//-----CMainWindow::destructor--------------------------------------------------
CMainWindow::~CMainWindow()
{
  delete licqIcon;
  gMainWindow = NULL;
#ifdef QT_PROTOCOL_PLUGIN
  if (m_szUserMenuId)
    free(m_szUserMenuId);
#endif
}


//-----CMainWindow::resizeEvent------------------------------------------------
void CMainWindow::resizeEvent (QResizeEvent *)
{
  userView->setGeometry(skin->frame.border.left, skin->frame.border.top,
                        width() - skin->frameWidth(), height() - skin->frameHeight());

  if (!skin->frame.hasMenuBar)
    btnSystem->setGeometry(skin->borderToRect(&skin->btnSys, this));

  // Do this to save the new geometry
  positionChanges++;
  
  // Resize the background pixmap and mask
  QPixmap *p;
  if (skin->frame.pixmap != NULL)
  {
    p = ScaleWithBorder(*pmBorder, width(), height(), skin->frame.border);
#if QT_VERSION >= 300
    setPaletteBackgroundPixmap(*p);

    // set the palette for the labels here as well
    if (skin->lblMsg.transparent)
      lblMsg->setPaletteBackgroundPixmap(*p);

    if (skin->lblStatus.transparent)
      lblStatus->setPaletteBackgroundPixmap(*p);
#else
    setBackgroundPixmap(*p);
#endif
    delete p;
  }
  if (skin->frame.mask != NULL)
  {
    p = ScaleWithBorder(*pmMask, width(), height(), skin->frame.border);
    bmMask = *p;
    setMask(bmMask);
    delete p;
  }

/*  Set geometry of our widgets
  Hide the widget if all position values are equal because this would result
  in a unusable 1-pixel widget*/
  // cmbUserGroups
  if (cmbUserGroups != NULL)
    if ((skin->cmbGroups.rect.x1 == skin->cmbGroups.rect.x2) && (skin->cmbGroups.rect.y1 == skin->cmbGroups.rect.y2))
      cmbUserGroups->hide();
    else
      cmbUserGroups->setGeometry(skin->borderToRect(&skin->cmbGroups, this));
  // lblMsg
  if (lblMsg != NULL)
    if ((skin->lblMsg.rect.x1 == skin->lblMsg.rect.x2) && (skin->lblMsg.rect.y1 == skin->lblMsg.rect.y2))
      lblMsg->hide();
    else
      lblMsg->setGeometry(skin->borderToRect(&skin->lblMsg, this));
  // lblStatus
  if (lblStatus != NULL)
    if ((skin->lblStatus.rect.x1 == skin->lblStatus.rect.x2) && (skin->lblStatus.rect.y1 == skin->lblStatus.rect.y2))
      lblStatus->hide();
    else
      lblStatus->setGeometry(skin->borderToRect(&skin->lblStatus, this));
  // btnSystem
  if (btnSystem != NULL)
    if ((skin->btnSys.rect.x1 == skin->btnSys.rect.x2) && (skin->btnSys.rect.y1 == skin->btnSys.rect.y2))
      btnSystem->hide();
    else
      btnSystem->setGeometry(skin->borderToRect(&skin->btnSys, this));
}

void CMainWindow::moveEvent(QMoveEvent* e)
{
  if(isVisible())  positionChanges++;

  QWidget::moveEvent(e);
}

void CMainWindow::closeEvent( QCloseEvent *e )
{
#if 0
    qDebug("closeEvent() visible %d", isVisible());
    qDebug("geometry: x: %d y: %d, w: %d, h: %d", geometry().x(), geometry().y(), geometry().width(), geometry().height());
    qDebug("x: %d, y: %d, w: %d, h: %d", x(), y(), size().width(), size().height());
    qDebug(" toGlobal: x %d, y %d", mapToGlobal(QPoint(0,0)).x(), mapToGlobal(QPoint(0,0)).y());
#endif

  if(isVisible() && positionChanges > 1)
  {
    // save window position and size
    char buf[MAX_FILENAME_LEN];
    snprintf(buf, MAX_FILENAME_LEN, "%s/licq_qt-gui.conf", BASE_DIR);
    buf[MAX_FILENAME_LEN - 1] = '\0';
    CIniFile licqConf(INI_FxALLOWxCREATE | INI_FxWARN);
    // need some more error checking here...
    licqConf.LoadFile(buf);

    int x, y;
    if(pos().x() < 2 || pos().y() < 2) {
      // WMaker bug.  will investigate...
      QPoint p  = mapToGlobal(QPoint(0, 0));

//      qDebug("wmaker workaround enabled");

      x = p.x() - 1 - ( geometry().x() < p.x() ? geometry().x() : 0);
      y = p.y() - 1 - ( geometry().y() < p.y() ? geometry().y() : 0);
    }
    else
    {
      x = pos().x();
      y = pos().y();
    }

    x = x < 0 ? 0 : x;
    y = y < 0 ? 0 : y;

    licqConf.SetSection("geometry");
    // I'm not sure if we should really test for negative values...
    licqConf.WriteNum("x", (unsigned short)x);
    licqConf.WriteNum("y", (unsigned short)y);
    licqConf.WriteNum("h", (unsigned short)(size().height() < 0 ? 0 : (m_bInMiniMode ? m_nRealHeight : size().height())));
    licqConf.WriteNum("w", (unsigned short)(size().width() < 0 ? 0 : size().width()));

#if 0
    licqConf.SetSection("floaties");
    licqConf.WriteNum("Num", (unsigned short)CUserView::floaties->size());
    unsigned short i = 0;
    char key[32];
    for (; i < CUserView::floaties->size(); )
    {
      CUserView* iter = CUserView::floaties->at(i);
      sprintf(key, "Floaty%d.Uin", i);
      licqConf.WriteNum(key, iter->firstChild()->ItemUin());
      sprintf(key, "Floaty%d.X", i);
      licqConf.WriteNum(key, (unsigned short)(iter->x() > 0 ? iter->x() : 0));
      sprintf(key, "Floaty%d.Y", i);
      licqConf.WriteNum(key, (unsigned short)(iter->y() > 0 ? iter->y() : 0));
      sprintf(key, "Floaty%d.W", i);
      licqConf.WriteNum(key, (unsigned short)iter->width());
      i++;
    }
#endif

    licqConf.FlushFile();
    licqConf.CloseFile();
  }

  if (licqIcon != NULL)
  {
    e->ignore();
    hide();
  }
  else
  {
    e->ignore();
    slot_shutdown();
  }
}


// Receive key press events for the main widget
// Ctrl-M : toggle mini mode
// Ctrl-H : hide window
// Ctrl-I : next message
// Ctrl-X : exit
// Ctrl-V : View message
// Ctrl-S : Send message
// Ctrl-U : Send Url
// Ctrl-C : Send chat request
// Ctrl-F : Send File
// Ctrl-A : Check Auto response
// Ctrl-P : Popup all messages
// Ctrl-O : Toggle offline users
// Ctrl-L : Redraw user window
// Delete : Remove the user from the group
// Ctrl-Delete : Remove the user from the list

void CMainWindow::keyPressEvent(QKeyEvent *e)
{
  unsigned long nUin = userView->MainWindowSelectedItemUin();

  if (e->key() == Qt::Key_Delete)
  {
    if (nUin == 0) return;
    if (e->state() & ControlButton)
      RemoveUserFromList(nUin, this);
    else
      RemoveUserFromGroup(m_nGroupType, m_nCurrentGroup, nUin, this);
    //e->accept();
    return;
  }
  else if (! (e->state() & ControlButton))
  {
    e->ignore();
    QWidget::keyPressEvent(e);
    return;
  }

  switch(e->key())
  {
    case Qt::Key_M:
      ToggleMiniMode();
      break;

    case Qt::Key_H:
      if (licqIcon != NULL) hide();
      break;

    case Qt::Key_I:
      callMsgFunction();
      break;

    case Qt::Key_X:
      slot_shutdown();
      break;

    case Qt::Key_V:
      callDefaultFunction(nUin);
      break;

    case Qt::Key_S:
      callFunction(mnuUserSendMsg, nUin);
      break;

    case Qt::Key_U:
      callFunction(mnuUserSendUrl, nUin);
      break;

    case Qt::Key_C:
      callFunction(mnuUserSendChat, nUin);
      break;

    case Qt::Key_F:
      callFunction(mnuUserSendFile, nUin);
      break;

    case Qt::Key_A:
      if(nUin)
        (void) new ShowAwayMsgDlg(licqDaemon, licqSigMan, nUin);
      break;

    case Qt::Key_P:
      slot_popupall();
      break;

    case Qt::Key_O:
      ToggleShowOffline();
      break;

    case Qt::Key_L:
      updateUserWin();
      break;

    default:
      e->ignore();
      QWidget::keyPressEvent(e);
      break;
  }

}


//-----CMainWindow::mouseEvent----------------------------------------------
void CMainWindow::mousePressEvent(QMouseEvent *m)
{
   mouseX = m->x();
   mouseY = m->y();
}

/*! \brief Drags the mainwindow around
 *
 * If the appropriate option is set (EnableMainwinMouseMovement = 1) 
 * this drags the mainwindow around when moving the mouse and left 
 * button is pressed.
 */
void CMainWindow::mouseMoveEvent(QMouseEvent *m)
{
  if (m_bEnableMainwinMouseMovement && (m->state() == Qt::LeftButton))
  {
    int deltaX = m->x() - mouseX;
    int deltaY = m->y() - mouseY;
    move(x() + deltaX, y() + deltaY);
  }
}


// ---------------------------------------------------------------------------
inline bool CMainWindow::show_user(ICQUser *u)
{
  return (m_bShowOffline || !u->StatusOffline() || u->NewMessages() > 0 ||
          (m_bAlwaysShowONU && u->OnlineNotify()));
}


void CMainWindow::slot_updatedUser(CICQSignal *sig)
{
  unsigned long nUin = sig->Uin();

  switch(sig->SubSignal())
  {
    case USER_EVENTS:
    {
      // Skip all this if it was just an away message check
      if (sig->Argument() == 0) {
        userView->AnimationAutoResponseCheck(nUin);
        break;
      }
      // Otherwise an event was added or removed
      updateEvents();
      // autoRaise if needed
      if(m_bAutoRaise && sig->Argument() > 0)  raise();

      if (m_bAutoPopup && sig->Argument() > 0)
      {
        ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
        if (u != NULL && u->NewMessages() > 0)
        {
          ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
          unsigned short s = o->Status();
          gUserManager.DropOwner();
          if (s == ICQ_STATUS_ONLINE || s == ICQ_STATUS_FREEFORCHAT)
          {
            bool bCallUserView = false, bCallSendMsg = false;

            if (m_bMsgChatView)
            {
              for (unsigned short i = 0; i < u->NewMessages(); i++)
              {
                if (m_bMsgChatView &&
                    u->EventPeek(i)->SubCommand() == ICQ_CMDxSUB_MSG)
                {
                  bCallSendMsg = true;
                  if (bCallUserView)
                    break;
                }
                else
                {
                  bCallUserView = true;
                  if (!m_bMsgChatView || bCallSendMsg)
                    break;
                }
              }
            }
            gUserManager.DropUser(u);

            if (bCallUserView)
              callFunction(mnuUserView, nUin);
            if (bCallSendMsg)
              callFunction(mnuUserSendMsg, nUin);
          }
          else
            gUserManager.DropUser(u);
        }
        else
        {
          gUserManager.DropUser(u);
        }
      }
      // Fall through
    }
    case USER_BASIC:
    case USER_GENERAL:
    case USER_EXT:
    case USER_STATUS:
    case USER_SECURITY:
    {
      if (nUin == gUserManager.OwnerUin())
      {
        if (sig->SubSignal() == USER_STATUS || sig->SubSignal() == USER_EXT) break;
        ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
        m_szCaption = tr("Licq (%1)").arg(QString::fromLocal8Bit(o->GetAlias()));
        gUserManager.DropOwner();
        if (caption()[0] == '*')
          setCaption(QString("* ") + m_szCaption);
        else
          setCaption(m_szCaption);
        break;
      }
      ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
      if (u == NULL)
      {
        gLog.Warn("%sCMainWindow::slot_updatedUser(): Invalid uin received: %ld\n",
                   L_ERRORxSTR, nUin);
        break;
      }
      if (m_bThreadView && m_nGroupType == GROUPS_USER && m_nCurrentGroup == 0)
      {
        CUserViewItem* i = userView->firstChild();

        while (i)
        {
          if (u->GetInGroup(GROUPS_USER, i->GroupId()))
          {
            CUserViewItem* it = i->firstChild();

            while (it)
            {
              if(it->ItemUin() == nUin)
              {
                delete it;
                if (show_user(u))
                  (void) new CUserViewItem(u, i);
                break;
              }
              it = it->nextSibling();
            }
            if (it == NULL)
            {
              if ( show_user(u) &
                   ((i->GroupId() != 0 && u->GetInGroup(GROUPS_USER, i->GroupId())) ||
                    (i->GroupId() == 0 && u->GetGroups(GROUPS_USER) == 0 && !u->IgnoreList())))
                (void) new CUserViewItem(u, i);
            }
          }
          i = i->nextSibling();
        }
      }
      else if (u->GetInGroup(m_nGroupType, m_nCurrentGroup))
      {
        // Update this user if they are in the current group
        CUserViewItem *i = (CUserViewItem *)userView->firstChild();
        while (i && i->ItemUin() != nUin)
          i = (CUserViewItem *)i->nextSibling();
        if (i != NULL)
        {
          delete i;
          if (show_user(u))
            (void) new CUserViewItem(u, userView);
        }
        else
        {
          if ( show_user(u) &&
               (!u->IgnoreList() || (m_nGroupType == GROUPS_SYSTEM && m_nCurrentGroup == GROUP_IGNORE_LIST)) )
            (void) new CUserViewItem(u, userView);
        }
      }

      if(sig->SubSignal() == USER_STATUS && sig->Argument() == 1)
        userView->AnimationOnline(nUin);
      // Update their floaty
      CUserView *v = CUserView::FindFloaty(nUin);
      if (v != NULL )
      {
        static_cast<CUserViewItem*>(v->firstChild())->setGraphics(u);
        v->triggerUpdate();
      }

#if QT_VERSION >= 300
      // update the tab icon of this user
      if (m_bTabbedChatting && userEventTabDlg)
        userEventTabDlg->updateTabLabel(u);
#endif
      gUserManager.DropUser(u);

      break;
    }
  }
}


// ---------------------------------------------------------------------------

void CMainWindow::slot_updatedList(CICQSignal *sig)
{
  switch(sig->SubSignal())
  {
    case LIST_ALL:
    {
      updateUserWin();
      break;
    }
    case LIST_ADD:
    {
      ICQUser *u = gUserManager.FetchUser(sig->Uin(), LOCK_W);
      if (u == NULL)
      {
        gLog.Warn("%sCMainWindow::slot_updatedList(): Invalid uin received: %ld\n",
                   L_ERRORxSTR, sig->Uin());
        break;
      }

      if(m_bThreadView && m_nGroupType == GROUPS_USER && m_nCurrentGroup == 0)
      {
        CUserViewItem* i = userView->firstChild();

        while(i)
        {
          if(u->GetInGroup(GROUPS_USER, i->GroupId()) && show_user(u))
            (void) new CUserViewItem(u, i);

          i = i->nextSibling();
        }
      }
      else
      {

        if (u->GetInGroup(m_nGroupType, m_nCurrentGroup) && show_user(u) )
          (void) new CUserViewItem(u, userView);
      }
      // as we intercept the user's addition, we set it our default codec
      if (!m_DefaultEncoding.isEmpty())
      {
        u->SetUserEncoding(m_DefaultEncoding.latin1());
      }
      gUserManager.DropUser(u);
      break;
    }

    case LIST_REMOVE:
    {
      // delete their entries in the user list
      QListViewItemIterator it(userView);
      while(it.current())
      {
        CUserViewItem* item = static_cast<CUserViewItem*>(it.current());

        if(sig->Uin() > 0 && item->ItemUin() == sig->Uin()) {
          ++it;
          delete item;
          item = 0;
        }
        else
          ++it;
      }

      updateEvents();
      // If their box is open, kill it
      {
#if QT_VERSION < 300
        QListIterator<UserViewEvent> it(licqUserView);
#else
        QPtrListIterator<UserViewEvent> it(licqUserView);
#endif
        for (; it.current() != NULL; ++it)
        {
          if ((*it)->Uin() == sig->Uin())
          {
            it.current()->close();
            licqUserView.remove(it.current());
            break;
          }
        }
      }
      {
        // if their info box is open, kill it
#if QT_VERSION < 300
        QListIterator<UserInfoDlg> it(licqUserInfo);
#else
        QPtrListIterator<UserInfoDlg> it(licqUserInfo);
#endif
        for(; it.current() != NULL; ++it)
        {
          if((*it)->Uin() == sig->Uin())
          {
            it.current()->close();
            licqUserInfo.remove(it.current());
            break;
          }
        }
      }
      {
        // if their send box is open, kill it
#if QT_VERSION < 300
        QListIterator<UserSendCommon> it(licqUserSend);
#else
        QPtrListIterator<UserSendCommon> it(licqUserSend);
#endif
        for(; it.current() != NULL; ++it)
        {
          if((*it)->Uin() == sig->Uin())
          {
            it.current()->close();
            licqUserSend.remove(it.current());
            break;
          }
        }
      }

      break;
    }

  }  // Switch
}

//-----CMainWindow::updateUserWin-----------------------------------------------
void CMainWindow::updateUserWin()
{
  // set the pixmap and color for each user and add them to the view
  userView->setUpdatesEnabled(false);
  userView->clear();

  bool doGroupView = m_bThreadView &&
    m_nGroupType == GROUPS_USER && m_nCurrentGroup == 0;

  if (doGroupView)
  {
    CUserViewItem* gi = new CUserViewItem(0, tr("Other Users").local8Bit(), userView);
    gi->setOpen(m_nGroupStates & 1);
    GroupList *g = gUserManager.LockGroupList(LOCK_R);
    for (unsigned short i = 0; i < g->size(); i++)
    {
      gi = new CUserViewItem(i+1, (*g)[i], userView);
      gi->setOpen(m_nGroupStates & (1<<QMIN(i+1, 31)));
    }
    gUserManager.UnlockGroupList();
  }
  FOR_EACH_USER_START(LOCK_R)
  {
    // Only show users on the current group and not on the ignore list
    if (!doGroupView && (!pUser->GetInGroup(m_nGroupType, m_nCurrentGroup) ||
      (pUser->IgnoreList() && m_nGroupType != GROUPS_SYSTEM && m_nCurrentGroup != GROUP_IGNORE_LIST) ))
      FOR_EACH_USER_CONTINUE

    // Ignore offline users if necessary
    if (!show_user(pUser))
      FOR_EACH_USER_CONTINUE;

    if (doGroupView)
    {
      for(CUserViewItem* gi = userView->firstChild(); gi; gi = gi->nextSibling())
      {
        if((gi->GroupId() != 0 && pUser->GetInGroup(GROUPS_USER, gi->GroupId())) ||
           (gi->GroupId() == 0 && pUser->GetGroups(GROUPS_USER) == 0 && !pUser->IgnoreList()))
          (void) new CUserViewItem(pUser, gi);
      }
    }
    else
      // Add the user to the list
      (void) new CUserViewItem(pUser, userView);
  }
  FOR_EACH_USER_END
  userView->setUpdatesEnabled(true);
  userView->triggerUpdate();
}


void CMainWindow::updateEvents()
{
  QString szCaption;

  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  unsigned short nNumOwnerEvents = o->NewMessages();
  gUserManager.DropOwner();
  unsigned short nNumUserEvents = ICQUser::getNumUserEvents() - nNumOwnerEvents;

  lblMsg->setBold(false);
  QString s, l;

  if (nNumOwnerEvents > 0)
  {
    s = tr("SysMsg");
    l = tr("System Message");
    if (m_bBoldOnMsg) lblMsg->setBold(true);
    szCaption = "* " + m_szCaption;
//    lblMsg->setPrependPixmap(CMainWindow::iconForEvent(ICQ_CMDxSUB_MSG));
  }
  else if (nNumUserEvents > 0)
  {
    s = tr("%1 msg%2").arg(nNumUserEvents).arg(nNumUserEvents == 1 ? tr(" ") : tr("s"));
    l = tr("%1 message%2").arg(nNumUserEvents).arg(nNumUserEvents == 1 ? tr(" ") : tr("s"));
    if (m_bBoldOnMsg) lblMsg->setBold(true);
    szCaption = "* " + m_szCaption;
//    lblMsg->setPrependPixmap(QPixmap());
  }
  else
  {
    // Update the msg label if necessary
    if (m_bShowGroupIfNoMsg && ICQUser::getNumUserEvents() == 0)
    {
      //lblMsg->setText(cmbUserGroups->currentText());
      s = cmbUserGroups->currentText();
      l = cmbUserGroups->currentText();
    }
    else
    {
      //lblMsg->setText(tr("No msgs"));
      s = tr("No msgs");
      l = tr("No messages");
    }
    szCaption = m_szCaption;
//    lblMsg->setPrependPixmap(QPixmap());
  }
  if (lblMsg->fontMetrics().width(l)+lblMsg->margin() > lblMsg->width())
    lblMsg->setText(s);
  else
    lblMsg->setText(l);
  lblMsg->update();
  setCaption(szCaption);

  if (licqIcon) licqIcon->SetDockIconMsg(nNumUserEvents, nNumOwnerEvents);
}


//-----CMainWindow::setCurrentGroup---------------------------------------------
void CMainWindow::setCurrentGroupMenu(int id)
{
  int index = mnuUserGroups->indexOf(id);
  if (index > gUserManager.NumGroups() + 2)
    index -= 2;
  else if (index > 1)
    index -= 1;

  setCurrentGroup(index);
}

void CMainWindow::setCurrentGroup(int index)
{
  m_nCurrentGroup = index;
  m_nGroupType = GROUPS_USER;
  unsigned short nNumGroups = gUserManager.NumGroups();
  if (m_nCurrentGroup > nNumGroups)
  {
    m_nCurrentGroup -= nNumGroups;
    m_nGroupType = GROUPS_SYSTEM;
  }
  // Update the combo box
  cmbUserGroups->setCurrentItem(index);
  // Update the msg label if necessary
  if (m_bShowGroupIfNoMsg && ICQUser::getNumUserEvents() == 0)
    lblMsg->setText(cmbUserGroups->currentText());

  // Update the group menu
  for (unsigned short i = 0; i < mnuUserGroups->count(); i++)
    mnuUserGroups->setItemChecked(mnuUserGroups->idAt(i), false);
  if (index > gUserManager.NumGroups())
    index += 2;
  else if (index >= 1)
    index += 1;
  mnuUserGroups->setItemChecked(mnuUserGroups->idAt(index), true);

  // Update the user window
  updateUserWin();
}

//-----CMainWindow::updateGroups------------------------------------------------
void CMainWindow::updateGroups()
{
  // update the combo box
  cmbUserGroups->clear();
  mnuUserGroups->clear();
  mnuGroup->clear();
  mnuServerGroup->clear();
  cmbUserGroups->insertItem(tr("All Users"));
  mnuUserGroups->insertItem(tr("All Users"));
  mnuUserGroups->insertSeparator();

  // take care of this first
  mnuGroup->insertItem(tr("Server Group"), mnuServerGroup);
  mnuGroup->insertSeparator();

  GroupList *g = gUserManager.LockGroupList(LOCK_R);
  for (unsigned short i = 0; i < g->size(); i++)
  {
    cmbUserGroups->insertItem(QString::fromLocal8Bit((*g)[i]));
    mnuUserGroups->insertItem(QString::fromLocal8Bit((*g)[i]));
    mnuGroup->insertItem(QString::fromLocal8Bit((*g)[i]), i+1);
    mnuServerGroup->insertItem(QString::fromLocal8Bit((*g)[i]), i+1);
  }
  gUserManager.UnlockGroupList();
  mnuUserGroups->insertSeparator();
  mnuGroup->insertSeparator();

  cmbUserGroups->insertItem(tr("Online Notify"));
  mnuUserGroups->insertItem(tr("Online Notify"));
  mnuGroup->insertItem(tr("Online Notify"), 1000+GROUP_ONLINE_NOTIFY);
  cmbUserGroups->insertItem(tr("Visible List"));
  mnuUserGroups->insertItem(tr("Visible List"));
  mnuGroup->insertItem(tr("Visible List"), 1000+GROUP_VISIBLE_LIST);
  cmbUserGroups->insertItem(tr("Invisible List"));
  mnuUserGroups->insertItem(tr("Invisible List"));
  mnuGroup->insertItem(tr("Invisible List"), 1000+GROUP_INVISIBLE_LIST);
  cmbUserGroups->insertItem(tr("Ignore List"));
  mnuUserGroups->insertItem(tr("Ignore List"));
  mnuGroup->insertItem(tr("Ignore List"), 1000+GROUP_IGNORE_LIST);
  cmbUserGroups->insertItem(tr("New Users"));
  mnuUserGroups->insertItem(tr("New Users"));
  mnuGroup->insertItem(tr("New Users"), 1000+GROUP_NEW_USERS);

  int index = m_nCurrentGroup;
  if (m_nGroupType == GROUPS_SYSTEM)
    index += gUserManager.NumGroups();
  setCurrentGroup(index);
}


//-----CMainWindow::updateStatus------------------------------------------------
void CMainWindow::updateStatus()
{
   char *theColor = skin->colors.offline;
   ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
   unsigned long status = o->Status();
   switch (status)
   {
   case ICQ_STATUS_OFFLINE:
     theColor = skin->colors.offline;
     break;
   case ICQ_STATUS_ONLINE:
   case ICQ_STATUS_FREEFORCHAT:
     theColor = skin->colors.online;
     break;
   case ICQ_STATUS_AWAY:
   case ICQ_STATUS_NA:
   case ICQ_STATUS_OCCUPIED:
   case ICQ_STATUS_DND:
   default:
     theColor = skin->colors.away;
     break;
   }
   if (status != ICQ_STATUS_OFFLINE)
     mnuStatus->setItemChecked(MNUxITEM_STATUSxINVISIBLE, o->StatusInvisible());

   lblStatus->setText(o->StatusStr());
   lblStatus->setPrependPixmap(CMainWindow::iconForStatus(o->StatusFull()));
   lblStatus->update();

   // set icon of the licq main widget for window manager
   setIcon(CMainWindow::iconForStatus(o->StatusFull()));

   gUserManager.DropOwner();

   // set the color if it isn't set by the skin
   if (skin->lblStatus.color.fg == NULL) lblStatus->setNamedFgColor(theColor);

  if (licqIcon) licqIcon->SetDockIconStatus();
}


void CMainWindow::slot_AwayMsgDlg()
{
  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  if(o != NULL) {
    showAwayMsgDlg(o->Status());
    gUserManager.DropOwner();
  }
}


void CMainWindow::slot_doneAwayMsgDlg()
{
  awayMsgDlg = NULL;
}


void CMainWindow::showAwayMsgDlg(unsigned short nStatus)
{
  if(awayMsgDlg == NULL) {
    awayMsgDlg = new AwayMsgDlg();
    connect(awayMsgDlg, SIGNAL(popupOptions(int)), this, SLOT(showOptionsDlg(int)));
    connect(awayMsgDlg, SIGNAL(done()), this, SLOT(slot_doneAwayMsgDlg()));
  }
  else
    awayMsgDlg->raise();

  awayMsgDlg->SelectAutoResponse(nStatus);
}


//----CMainWindow::changeStatusManual-------------------------------------------
void CMainWindow::changeStatusManual(int id)
{
  if (id != ICQ_STATUS_OFFLINE && (id & 0xFF) != ICQ_STATUS_ONLINE)
    showAwayMsgDlg(id);

  changeStatus(id);
}


//----CMainWindow::changeStatus-------------------------------------------------
void CMainWindow::changeStatus(int id)
{
  unsigned long newStatus = ICQ_STATUS_OFFLINE;

  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  if (id == ICQ_STATUS_OFFLINE)
  {
    gUserManager.DropOwner();
    licqDaemon->icqLogoff();
    return;
  }
  else if (id == (int)ICQ_STATUS_FxPRIVATE) // toggle invisible status
  {
    mnuStatus->setItemChecked(ICQ_STATUS_FxPRIVATE,
                              !mnuStatus->isItemChecked(ICQ_STATUS_FxPRIVATE));
    if (o->StatusOffline())
    {
      gUserManager.DropOwner();
      return;
    }
    if (mnuStatus->isItemChecked(ICQ_STATUS_FxPRIVATE))
       newStatus = o->StatusFull() | ICQ_STATUS_FxPRIVATE;
    else
       newStatus = o->StatusFull() & (~ICQ_STATUS_FxPRIVATE);
  }
  else
  {
    newStatus = id;
  }

  // we may have been offline and gone online with invisible toggled
  if (mnuStatus->isItemChecked(ICQ_STATUS_FxPRIVATE))
     newStatus |= ICQ_STATUS_FxPRIVATE;

  // disable combo box, flip pixmap...
  //lblStatus->setEnabled(false);

  // call the right function
  bool b = o->StatusOffline();
  gUserManager.DropOwner();
  if (b)
    licqDaemon->icqLogon(newStatus);
  else
    licqDaemon->icqSetStatus(newStatus);
}


// -----------------------------------------------------------------------------

void CMainWindow::callDefaultFunction(unsigned long _nUin)
{
  unsigned long nUin = _nUin;
  if (nUin == 0) return;
  ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
  // set default function to read or send depending on whether or not
  // there are new messages
  int fcn = (u->NewMessages() == 0 ? mnuUserSendMsg : mnuUserView);
  if (fcn == mnuUserView && m_bMsgChatView)
  {
    // if one of the new events is a msg in chatview mode,
    // change def function to send
    for (unsigned short i = 0; i < u->NewMessages(); i++)
      if (u->EventPeek(i)->SubCommand() == ICQ_CMDxSUB_MSG)
      {
        fcn = mnuUserSendMsg;
	break;
      }
  }
  gUserManager.DropUser(u);

  // See if the clipboard contains a url
  if (fcn == mnuUserSendMsg && m_bSendFromClipboard)
  {
    QString c = QApplication::clipboard()->text();
    if (c.left(5) == "http:" || c.left(4) == "ftp:" || c.left(6) == "https:")
    {
      UserEventCommon *ec = callFunction(mnuUserSendUrl, nUin);
      if (!ec || !ec->inherits("UserSendUrlEvent")) return;
      UserSendUrlEvent* e = static_cast<UserSendUrlEvent*>(ec);
      // Set the url
      e->setUrl(c, "");
      // Clear the buffer now
      QApplication::clipboard()->clear();
      return;
    }
    else if (c.left(5) == "file:" || c.left(1) == "/")
    {
      UserEventCommon *ec = callFunction(mnuUserSendFile, nUin);
      if (!ec || !ec->inherits("UserSendFileEvent")) return;
      UserSendFileEvent* e = static_cast<UserSendFileEvent*>(ec);
      // Set the file
      if(c.left(5) == "file:")
        c.remove(0, 5);
      while (c[0] == '/') c.remove(0, 1);
      c.prepend('/');
      e->setFile(c, "");
      // Clear the buffer now
      QApplication::clipboard()->clear();
      return;
    }
  }

  callFunction(fcn, nUin);
}

void CMainWindow::callDefaultFunction(QListViewItem *i)
{
  if(i == NULL)
    return;

#if 0
  char *szId = ((CUserViewItem *)i)->ItemId();
  unsigned long nPPID = ((CUserViewItem *)i)->ItemPPID();
#else
  callDefaultFunction(((CUserViewItem *)i)->ItemUin());
#endif
}

void CMainWindow::callOwnerFunction(int index)
{
  if (index == OwnerMenuView)
    callFunction(index, gUserManager.OwnerUin());

  else if (index == OwnerMenuGeneral ||
      index == OwnerMenuMore  || index == OwnerMenuWork ||
      index == OwnerMenuAbout || index == OwnerMenuLast ||
      index == OwnerMenuHistory)
    callInfoTab(index, gUserManager.OwnerUin());

  else if (index == OwnerMenuSecurity)
    (void) new SecurityDlg(licqDaemon, licqSigMan);
/*
  else if (index == OwnerMenuPassword)
    (void) new PasswordDlg(licqDaemon, licqSigMan);

  else if (index == OwnerMenuSavedPassword)
    (void) new ChangePassDlg();
*/
  else if (index == OwnerMenuRandomChat)
    (void) new CSetRandomChatGroupDlg(licqDaemon, licqSigMan);

  else
    gLog.Warn("%sInternal Error: CMainWindow::callOwnerFunction(): Unknown index (%d).\n",
              L_WARNxSTR, index);
}


void CMainWindow::callUrlFunction (const char *_szUrl)
{
//  ICQFunctions *f = callFunction(-1, true);
//  if (f != NULL) f->SendUrl(_szUrl, "");
}

void CMainWindow::callFileFunction (const char *_szFile)
{
//  ICQFunctions *f = callFunction(-1, true);
//  if (f != NULL) f->SendFile(_szFile, "");
}


void CMainWindow::callMsgFunction()
{
  // No need for code duplication
  slot_ui_viewevent(0);
}

//-----CMainWindow::callUserFunction-------------------------------------------
void CMainWindow::callUserFunction(int index)
{
  unsigned long nUin = m_nUserMenuUin;

  if (nUin == 0) return;

  switch(index)
  {
    case mnuUserAuthorize:
    {
      (void) new AuthUserDlg(licqDaemon, nUin, true);
      break;
    }
    case mnuUserAuthorizeRequest:
    {
      (void) new ReqAuthDlg(licqDaemon, nUin);
      break;
    }
    case mnuUserCheckResponse:
    {
      (void) new ShowAwayMsgDlg(licqDaemon, licqSigMan, nUin);
      break;
    }
    case mnuUserCustomAutoResponse:
    {
      (void) new CustomAwayMsgDlg(m_nUserMenuUin);
      break;
    }
    case mnuUserFloaty:
    {
      // Check that the floaty does not already exist
      CUserView *v = CUserView::FindFloaty(nUin);
      if (v == NULL)
      {
        CreateUserFloaty(nUin);
      }
      else
      {
        delete v->firstChild();
        if (v->childCount() == 0) delete v;
      }
      break;
    }
    case mnuUserHistory:
    case mnuUserGeneral:
    case mnuUserMore:
    case mnuUserWork:
    case mnuUserAbout:
    case mnuUserLast:
      callInfoTab(index, nUin);
      break;
    case mnuUserRemoveFromList:
      RemoveUserFromList(m_nUserMenuUin, this);
      break;

    case mnuUserSendKey:
    {
      (void) new KeyRequestDlg(licqSigMan, nUin);
      break;
    }

    default:
      callFunction(index, nUin);
  }

}

#ifdef QT_PROTOCOL_PLUGIN
void CMainWindow::callInfoTab(int fcn, const char *szId, unsigned long nPPID,
  bool toggle)
{
  if(szId == 0 || nPPID == 0) return;

  UserInfoDlg *f = NULL;
#if QT_VERSION < 300
  QListIterator<UserInfoDlg> it(licqUserInfo);
#else
  QPtrListIterator<UserInfoDlg> it(licqUserInfo);
#endif

  for(; it.current(); ++it)
  {
    if(strcmp((*it)->Id(), szId) == 0 && (*it)->PPID() == nPPID)
    {
      f = *it;
      break;
    }
  }

  if (f)
  {
    int tab = UserInfoDlg::WorkInfo;
    switch(fcn) {
    case mnuUserHistory:
      tab = UserInfoDlg::HistoryInfo;
      break;
    case mnuUserGeneral:
      tab = UserInfoDlg::GeneralInfo;
      break;
    case mnuUserMore:
      tab = UserInfoDlg::MoreInfo;
      break;
    case mnuUserWork:
      tab = UserInfoDlg::WorkInfo;
      break;
    case mnuUserAbout:
      tab = UserInfoDlg::AboutInfo;
      break;
    case mnuUserLast:
      tab = UserInfoDlg::LastCountersInfo;
      break;
    }
    if(toggle && f->isTabShown(tab))
    {
      delete f; // will notify us about deletion
      return;
    }
    else {
      f->show();
      f->raise();
    }
  }
  else
  {
    f = new UserInfoDlg(licqDaemon, licqSigMan, this, szId, nPPID);
    connect(f, SIGNAL(finished(unsigned long)), this, SLOT(UserInfoDlg_finished(
unsigned long)));
    f->show();
    licqUserInfo.append(f);
  }

  switch(fcn)
  {
    case mnuUserHistory:
      f->showTab(UserInfoDlg::HistoryInfo);
      break;
    case mnuUserGeneral:
      f->showTab(UserInfoDlg::GeneralInfo);
      break;
    case mnuUserMore:
      f->showTab(UserInfoDlg::MoreInfo);
      break;
    case mnuUserWork:
      f->showTab(UserInfoDlg::WorkInfo);
      break;
    case mnuUserAbout:
      f->showTab(UserInfoDlg::AboutInfo);
      break;
    case mnuUserLast:
      f->showTab(UserInfoDlg::LastCountersInfo);
      break;
  }
  f->show();
  f->raise();
}
#endif

void CMainWindow::callInfoTab(int fcn, unsigned long nUin, bool toggle)
{
  if(nUin == 0) return;

  UserInfoDlg *f = NULL;
#if QT_VERSION < 300
  QListIterator<UserInfoDlg> it(licqUserInfo);
#else
  QPtrListIterator<UserInfoDlg> it(licqUserInfo);
#endif

  for(; it.current(); ++it)
  {
    if((*it)->Uin() == nUin)
    {
      f = *it;
      break;
    }
  }

  if (f)
  {
    int tab = UserInfoDlg::WorkInfo;
    switch(fcn) {
    case mnuUserHistory:
      tab = UserInfoDlg::HistoryInfo;
      break;
    case mnuUserGeneral:
      tab = UserInfoDlg::GeneralInfo;
      break;
    case mnuUserMore:
      tab = UserInfoDlg::MoreInfo;
      break;
    case mnuUserWork:
      tab = UserInfoDlg::WorkInfo;
      break;
    case mnuUserAbout:
      tab = UserInfoDlg::AboutInfo;
      break;
    case mnuUserLast:
      tab = UserInfoDlg::LastCountersInfo;
      break;
    }
    if(toggle && f->isTabShown(tab))
    {
      delete f; // will notify us about deletion
      return;
    }
    else {
      f->show();
      f->raise();
    }
  }
  else
  {
    f = new UserInfoDlg(licqDaemon, licqSigMan, this, nUin);
    connect(f, SIGNAL(finished(unsigned long)), this, SLOT(UserInfoDlg_finished(unsigned long)));
    f->show();
    licqUserInfo.append(f);
  }

  switch(fcn)
  {
    case mnuUserHistory:
      f->showTab(UserInfoDlg::HistoryInfo);
      break;
    case mnuUserGeneral:
      f->showTab(UserInfoDlg::GeneralInfo);
      break;
    case mnuUserMore:
      f->showTab(UserInfoDlg::MoreInfo);
      break;
    case mnuUserWork:
      f->showTab(UserInfoDlg::WorkInfo);
      break;
    case mnuUserAbout:
      f->showTab(UserInfoDlg::AboutInfo);
      break;
    case mnuUserLast:
      f->showTab(UserInfoDlg::LastCountersInfo);
      break;
  }
  f->show();
  f->raise();
}



#ifdef QT_PROTOCOL_PLUGIN
//-----CMainWindow::callICQFunction-------------------------------------------
UserEventCommon *CMainWindow::callFunction(int fcn, const char *szId,
                                           unsigned long nPPID)
{
  if (szId == 0 || nPPID == 0) return NULL;
  
  UserEventCommon *e = NULL;
  
  switch (fcn)
  {
    case mnuUserView:
    {
#if QT_VERSION < 300
      QListIterator<UserViewEvent> it(licqUserView);
#else
      QPtrListIterator<UserViewEvent> it(licqUserView);
#endif

      for (; it.current(); ++it)
        if (strcmp((*it)->Id(), szId) == 0 && (*it)->PPID() == nPPID) {
          e = *it;
          e->show();
          if(!qApp->activeWindow() || !qApp->activeWindow()->inherits("UserEventCommon"))
          {
            e->raise();
#ifdef USE_KDE
            KWin::setActiveWindow(e->winId());
#endif
          }
          return e;
        }
    }
    break;
    case mnuUserSendMsg:
    case mnuUserSendUrl:
    case mnuUserSendChat:
    case mnuUserSendFile:
    case mnuUserSendContact:
    case mnuUserSendSms:
    {
#if QT_VERSION < 300
        QListIterator<UserSendCommon> it(licqUserSend );
#else
        QPtrListIterator<UserSendCommon> it(licqUserSend);
#endif

        if (!m_bMsgChatView) break;

        for (; it.current(); ++it)
          if (strcmp((*it)->Id(), szId) == 0 && (*it)->PPID() == nPPID)
          {
            e = *it;
            e->show();
            if(!qApp->activeWindow() || !qApp->activeWindow()->inherits("UserEventCommon"))
            {
              e->raise();
#ifdef USE_KDE
              KWin::setActiveWindow(e->winId());
#endif
            }
            return e;
          }
    }
  default:
    break;
  }

  switch (fcn)
  {
    case mnuUserView:
    {
      e = new UserViewEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    case mnuUserSendMsg:
    {
      e = new UserSendMsgEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    case mnuUserSendUrl:
    {
      e = new UserSendUrlEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    case mnuUserSendChat:
    {
      e = new UserSendChatEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    case mnuUserSendFile:
    {
      e = new UserSendFileEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    case mnuUserSendContact:
    {
      e = new UserSendContactEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    case mnuUserSendSms:
    {
      e = new UserSendSmsEvent(licqDaemon, licqSigMan, this, szId, nPPID);
      break;
    }
    default:
      gLog.Warn("%sunknown callFunction() fcn: %d\n", L_WARNxSTR, fcn);
  }
  if(e) {
    connect(e, SIGNAL(viewurl(QWidget*, QString)), this, SLOT(slot_viewurl(QWidget *, QString)));
    e->show();
    // there might be more than one send window open
    // make sure we only remember one, or it will get compliated
    if (fcn == mnuUserView)
    {
      //TODO 
      slot_userfinished(strtoul(szId, (char **)NULL, 10));
      connect(e, SIGNAL(finished(unsigned long)), SLOT(slot_userfinished(unsigned long)));
      licqUserView.append(static_cast<UserViewEvent*>(e));
    }
    else
    {
      //TODO
      slot_sendfinished(strtoul(szId, (char **)NULL, 10));
      connect(e, SIGNAL(finished(unsigned long)), SLOT(slot_sendfinished(unsigned long)));
      licqUserSend.append(static_cast<UserSendCommon*>(e));
    }
  }

  return e;
}
#endif

//-----CMainWindow::callICQFunction-------------------------------------------
UserEventCommon *CMainWindow::callFunction(int fcn, unsigned long nUin)
{
  if (nUin == 0) return NULL;

  UserEventCommon *e = NULL;

  switch (fcn)
  {
    case mnuUserView:
    {
#if QT_VERSION < 300
      QListIterator<UserViewEvent> it(licqUserView);
#else
      QPtrListIterator<UserViewEvent> it(licqUserView);
#endif

      for (; it.current(); ++it)
        if ((*it)->Uin() == nUin) {
          e = *it;
          e->show();
          if(!qApp->activeWindow() || !qApp->activeWindow()->inherits("UserEventCommon"))
          {
            e->raise();
#ifdef USE_KDE
            KWin::setActiveWindow(e->winId());
#endif
          }
          return e;
        }
    }
    break;
    case mnuUserSendMsg:
    case mnuUserSendUrl:
    case mnuUserSendChat:
    case mnuUserSendFile:
    case mnuUserSendContact:
    case mnuUserSendSms:
    {
#if QT_VERSION < 300
        QListIterator<UserSendCommon> it(licqUserSend);
#else
        QPtrListIterator<UserSendCommon> it(licqUserSend);
#endif

        if (!m_bMsgChatView) break;

        UserSendCommon *e = NULL;
        for (; it.current(); ++it)
          if ((*it)->Uin() == nUin)
          {
            e = static_cast<UserSendCommon*>(*it);
//            e->changeEventType(fcn - 1);
            break;
          }

        if (e != NULL)
        {
#if QT_VERSION < 300
          QListIterator<UserSendCommon> it(licqUserSend);
#else
          QPtrListIterator<UserSendCommon> it(licqUserSend);
#endif
          for (; it.current(); ++it)
            if ((*it)->Uin() == nUin)
            {
              e = static_cast<UserSendCommon*>(*it);
#if QT_VERSION >= 300
              if (userEventTabDlg && userEventTabDlg->tabExists(e))
              {
                userEventTabDlg->show();
                userEventTabDlg->selectTab(e);
                userEventTabDlg->raise();
#ifdef USE_KDE
                KWin::setActiveWindow(userEventTabDlg->winId());
#endif
              }
              else
#endif
              {
                e->show();
                if (!qApp->activeWindow() || !qApp->activeWindow()->inherits("UserEventCommon"))
                {
                  e->raise();
#ifdef USE_KDE
                  KWin::setActiveWindow(e->winId());
#endif
                }
              }
              return e;
            }
        }
      }
    default:
    break;
  }

  QWidget *parent = NULL;
#if QT_VERSION >= 300
  if (m_bTabbedChatting)
  {
    if (userEventTabDlg != NULL)
      userEventTabDlg->raise();
    else
    {
      // create the tab dialog if it does not exist
      userEventTabDlg = new UserEventTabDlg();
      connect(userEventTabDlg, SIGNAL(signal_done()), this, SLOT(slot_doneUserEventTabDlg()));
    }
    parent = userEventTabDlg;
  }
#endif
  switch (fcn)
  {
    case mnuUserView:
    {
      e = new UserViewEvent(licqDaemon, licqSigMan, this, nUin);
      break;
    }
    case mnuUserSendMsg:
    {
      e = new UserSendMsgEvent(licqDaemon, licqSigMan, this, nUin, parent);
      break;
    }
    case mnuUserSendUrl:
    {
      e = new UserSendUrlEvent(licqDaemon, licqSigMan, this, nUin, parent);
      break;
    }
    case mnuUserSendChat:
    {
      e = new UserSendChatEvent(licqDaemon, licqSigMan, this, nUin, parent);
      break;
    }
    case mnuUserSendFile:
    {
      e = new UserSendFileEvent(licqDaemon, licqSigMan, this, nUin, parent);
      break;
    }
    case mnuUserSendContact:
    {
      e = new UserSendContactEvent(licqDaemon, licqSigMan, this, nUin, parent);
      break;
    }
    case mnuUserSendSms:
    {
      e = new UserSendSmsEvent(licqDaemon, licqSigMan, this, nUin, parent);
      break;
    }
    default:
      gLog.Warn("%sunknown callFunction() fcn: %d\n", L_WARNxSTR, fcn);
  }
  if (e == NULL) return NULL;

  connect(e, SIGNAL(viewurl(QWidget*, QString)), this, SLOT(slot_viewurl(QWidget *, QString)));
#if QT_VERSION >= 300
  if (m_bTabbedChatting && fcn != mnuUserView)
  {
    userEventTabDlg->addTab(e);
    userEventTabDlg->show();
  }
  else
#endif
    e->show();

  // there might be more than one send window open
  // make sure we only remember one, or it will get complicated
  if (fcn == mnuUserView)
  {
    slot_userfinished(nUin);
    connect(e, SIGNAL(finished(unsigned long)), SLOT(slot_userfinished(unsigned long)));
    licqUserView.append(static_cast<UserViewEvent*>(e));
  }
  else
  {
    slot_sendfinished(nUin);
    connect(e, SIGNAL(finished(unsigned long)), SLOT(slot_sendfinished(unsigned long)));
    licqUserSend.append(static_cast<UserSendCommon*>(e));
  }
  return e;
}


// -----------------------------------------------------------------------------

void CMainWindow::UserInfoDlg_finished(unsigned long nUin)
{
#if QT_VERSION < 300
  QListIterator<UserInfoDlg> it(licqUserInfo);
#else
  QPtrListIterator<UserInfoDlg> it(licqUserInfo);
#endif

  for( ; it.current(); ++it){
    if((*it)->Uin() == nUin) {
      licqUserInfo.remove(*it);
      return;
    }
  }

  gLog.Warn("%sUser Info finished signal for user with no window (%ld)!\n",
            L_WARNxSTR, nUin);
}


// -----------------------------------------------------------------------------
void CMainWindow::slot_doneUserEventTabDlg()
{
#if QT_VERSION >= 300
  userEventTabDlg = NULL;
#endif
}

void CMainWindow::slot_userfinished(unsigned long nUin)
{
#if QT_VERSION < 300
  QListIterator<UserViewEvent> it(licqUserView);
#else
  QPtrListIterator<UserViewEvent> it(licqUserView);
#endif

  for ( ; it.current(); ++it)
  {
    if ((*it)->Uin() == nUin)
    {
      licqUserView.remove(*it);
      return;
    }
  }
  //gLog.Warn("%sUser finished signal for user with no window (%ld)!\n",
  //          L_WARNxSTR, nUin);
}

void CMainWindow::slot_sendfinished(unsigned long nUin)
{
#if QT_VERSION < 300
  QListIterator<UserSendCommon> it(licqUserSend);
#else
  QPtrListIterator<UserSendCommon> it(licqUserSend);
#endif
  // go through the whole list, there might be more than
  // one hit
  for ( ; it.current(); ++it)
    if ((*it)->Uin() == nUin)
      licqUserSend.remove(*it);
}


void CMainWindow::slot_shutdown()
{
  licqDaemon->Shutdown();
}

void CMainWindow::slot_aboutToQuit()
{
  // nothing to do
//  qDebug("aboutToQuit!");
}

//-----CMainWindow::slot_logon------------------------------------------------
void CMainWindow::slot_logon()
{
  updateStatus();
  //lblStatus->setEnabled(true);
}


//-----CMainWindow::slot_ui_viewevent-------------------------------------------
void CMainWindow::slot_ui_viewevent(unsigned long nUin)
{
  // Do nothing if there are no events pending
  if (ICQUser::getNumUserEvents() == 0) return;

  if (nUin == 0)
  {
    // Do system messages first
    ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
    unsigned short nNumMsg = o->NewMessages();
    gUserManager.DropOwner();
    if (nNumMsg > 0)
    {
      callOwnerFunction(OwnerMenuView);
      return;
    }

    time_t t = time(NULL);
    FOR_EACH_USER_START(LOCK_R)
    {
      if (pUser->NewMessages() > 0 && pUser->Touched() <= t)
      {
        nUin = pUser->Uin();
        t = pUser->Touched();
      }
    }
    FOR_EACH_USER_END
  }

  if (nUin != 0)
  {
    if (m_bMsgChatView)
    {
      ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
      for (unsigned short i = 0; i < u->NewMessages(); i++)
      {
        if (u->EventPeek(i)->SubCommand() == ICQ_CMDxSUB_MSG)
        {
          gUserManager.DropUser(u);
          callFunction(mnuUserSendMsg, nUin);
          return;
        }
      }

      gUserManager.DropUser(u);
      callFunction(mnuUserView, nUin);
    }
    else
      callFunction(mnuUserView, nUin);
  }
}

//-----CMainWindow::slot_ui_message---------------------------------------------
void CMainWindow::slot_ui_message(unsigned long nUin)
{
  callFunction(mnuUserSendMsg, nUin);
}

#ifdef QT_PROTOCOL_PLUIGN
//-----slot_protocolPlugin------------------------------------------------------
void CMainWindow::slot_protocolPlugin(unsigned long nPPID)
{
  // We can now add the users of this protocol
  FOR_EACH_PROTO_USER_START(nPPID, LOCK_R)
  {
    // Add the user to the list
    (void) new CUserViewItem(pUser, userView);
  }
  FOR_EACH_PROTO_USER_END

  // Menu item for the status of this protocol
  if (m_nProtoNum == 0)
  {
    // Add ICQ status menu
    mnuProtocolStatus[m_nProtoNum] = new QPopupMenu(NULL);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmOnline, tr("&Online"),
      ICQ_STATUS_ONLINE);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmAway, tr("&Away"),
      ICQ_STATUS_AWAY);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmNa, tr("&Not Available"),
      ICQ_STATUS_NA);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmOccupied, tr("O&ccupied"),
      ICQ_STATUS_OCCUPIED);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmDnd, tr("&Do Not Disturb"),
      ICQ_STATUS_DND);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmFFC, tr("Free for C&hat"),
      ICQ_STATUS_FREEFORCHAT);
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmOffline, tr("O&ffline"),
      ICQ_STATUS_OFFLINE);
    mnuProtocolStatus[m_nProtoNum]->insertSeparator();
    mnuProtocolStatus[m_nProtoNum]->insertItem(pmPrivate, tr("&Invisible"),
      ICQ_STATUS_FxPRIVATE);
    mnuStatus->insertItem("ICQ", mnuProtocolStatus[m_nProtoNum], -1, m_nProtoNum);
    m_nProtoNum++;
  }
  else
      mnuStatus->removeItemAt(m_nProtoNum+1); // Move separator

  char *pName = licqDaemon->ProtoPluginName(nPPID);
  mnuProtocolStatus[m_nProtoNum] = new QPopupMenu(NULL);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmOnline, tr("&Online"),
    ICQ_STATUS_ONLINE);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmAway, tr("&Away"),
    ICQ_STATUS_AWAY);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmNa, tr("&Not Available"),
    ICQ_STATUS_NA);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmOccupied, tr("O&ccupied"),
    ICQ_STATUS_OCCUPIED);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmDnd, tr("&Do Not Disturb"),
    ICQ_STATUS_DND);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmFFC, tr("Free for C&hat"),
    ICQ_STATUS_FREEFORCHAT);
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmOffline, tr("O&ffline"),
    ICQ_STATUS_OFFLINE);
  mnuProtocolStatus[m_nProtoNum]->insertSeparator();
  mnuProtocolStatus[m_nProtoNum]->insertItem(pmPrivate, tr("&Invisible"),
    ICQ_STATUS_FxPRIVATE);
  mnuStatus->insertItem(pName ? pName : "(No Name)",
    mnuProtocolStatus[m_nProtoNum], -1, m_nProtoNum);
  mnuStatus->insertSeparator(m_nProtoNum + 1);

  m_nProtoNum++;
}
#endif

//-----slot_doneOwnerFcn--------------------------------------------------------
void CMainWindow::slot_doneOwnerFcn(ICQEvent *e)
{
  updateStatus();
  switch (e->Command())
  {
    case ICQ_CMDxSND_LOGON:
      if (e->Result() != EVENT_SUCCESS)
        WarnUser(this, tr("Logon failed.\nSee network window for details."));
      break;
    case ICQ_CMDxSND_REGISTERxUSER:
      delete registerUserDlg;
      registerUserDlg = NULL;
      if (e->Result() == EVENT_SUCCESS)
      {
        InformUser(this, tr("Successfully registered, your user identification\n"
                            "number (UIN) is %1.\n"
                            "Now set your personal information.").arg(gUserManager.OwnerUin()));
        callInfoTab(mnuUserGeneral, gUserManager.OwnerUin());
      }
      else
      {
        InformUser(this, tr("Registration failed.  See network window for details."));
      }
      break;
    case ICQ_CMDxSND_AUTHORIZE:
       if (e->Result() != EVENT_ACKED)
         WarnUser(this, tr("Error sending authorization."));
       else
         InformUser(this, tr("Authorization granted."));
       break;
    default:
       break;
  }
}


#ifdef QT_PROTOCOL_PLUGIN
bool CMainWindow::RemoveUserFromList(const char *szId, unsigned long nPPID, QWidget *p)
{
  ICQUser *u = gUserManager.FetchUser(szId, nPPID, LOCK_R);
  if (u == NULL) return true;
  QTextCodec *codec = UserCodec::codecForICQUser(u);
  QString warning(tr("Are you sure you want to remove\n%1 (%2)\nfrom your contact list?")
                     .arg(codec->toUnicode(u->GetAlias()))
                     .arg(u->IdString()) );
  gUserManager.DropUser(u);
  if (QueryUser(p, warning, tr("Ok"), tr("Cancel")))
  {
    //TODO
    licqDaemon->RemoveUserFromList(strtoul(szId, (char **)NULL, 10));
    return true;
  }
  return false;
}
#endif

bool CMainWindow::RemoveUserFromList(unsigned long nUin, QWidget *p)
{
  ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
  if (u == NULL) return true;
  QTextCodec *codec = UserCodec::codecForICQUser(u);
  QString warning(tr("Are you sure you want to remove\n%1 (%2)\nfrom your contact list?")
                     .arg(codec->toUnicode(u->GetAlias()))
                     .arg(nUin) );
  gUserManager.DropUser(u);
  if (QueryUser(p, warning, tr("Ok"), tr("Cancel")))
  {
    licqDaemon->RemoveUserFromList(nUin);
    return true;
  }
  return false;
}

void CMainWindow::FillUserGroup()
{
  ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_R);
  if(u == NULL) return;

  mnuGroup->setItemChecked(1000+GROUP_ONLINE_NOTIFY, u->OnlineNotify());
  mnuGroup->setItemChecked(1000+GROUP_INVISIBLE_LIST, u->InvisibleList());
  mnuGroup->setItemChecked(1000+GROUP_VISIBLE_LIST, u->VisibleList());
  mnuGroup->setItemChecked(1000+GROUP_IGNORE_LIST, u->IgnoreList());
  mnuGroup->setItemChecked(1000+GROUP_NEW_USERS, u->NewUser());

  GroupList *g = gUserManager.LockGroupList(LOCK_R);
  for (unsigned short i = 0; i < g->size(); i++)
    mnuGroup->setItemChecked(i+1, u->GetInGroup(GROUPS_USER, i+1));
  gUserManager.UnlockGroupList();
  gUserManager.DropUser(u);
}


void CMainWindow::UserGroupToggled(int id)
{
  if(id >= 0 && id < 1000)
  {
    // User groups
    if(mnuGroup->isItemChecked(id))
      RemoveUserFromGroup(GROUPS_USER, id, m_nUserMenuUin, this);
    else {
      gUserManager.AddUserToGroup(m_nUserMenuUin, id);
      updateUserWin();
    }
  }
  else if(id >= 1000)
  {
    switch(id-1000) {
    case GROUP_NEW_USERS:
    {
      ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_W);
      if (!u) return;
      u->SetNewUser(!u->NewUser());
      gUserManager.DropUser(u);
      updateUserWin();
      break;
    }
    case GROUP_ONLINE_NOTIFY:
    {
      ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_W);
      if (!u) return;
      u->SetOnlineNotify(!u->OnlineNotify());
      gUserManager.DropUser(u);
      if (m_bFontStyles) updateUserWin();
      break;
    }
    case GROUP_VISIBLE_LIST:
    {
      licqDaemon->icqToggleVisibleList(m_nUserMenuUin);
      if (m_bFontStyles)
        updateUserWin();
      break;
    }
    case GROUP_INVISIBLE_LIST:
    {
      licqDaemon->icqToggleInvisibleList(m_nUserMenuUin);
      if (m_bFontStyles)
        updateUserWin();
      break;
    }
    case GROUP_IGNORE_LIST:
    {
      ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_W);
      if (!u) return;
      if(!u->IgnoreList() && !QueryUser(this,
          tr("Do you really want to add\n%1 (%2)\nto your ignore list?")
          .arg(u->GetAlias()).arg(m_nUserMenuUin), tr("&Yes"), tr("&No")))
      {
        gUserManager.DropUser(u);
        break;
      }
      u->SetIgnoreList(!u->IgnoreList());
      gUserManager.DropUser(u);
      licqDaemon->icqToggleIgnoreList(m_nUserMenuUin); // network only
      updateUserWin();
      break;
    }
    }
  }
}


bool CMainWindow::RemoveUserFromGroup(GroupType gtype, unsigned long group, unsigned long nUin, QWidget *p)
{
  if (gtype == GROUPS_USER)
  {
    if (group == 0)
      return RemoveUserFromList(nUin, p);
    else
    {
      ICQUser *u = gUserManager.FetchUser(nUin, LOCK_R);
      if (u == NULL) return true;
      unsigned long nUin = u->Uin();
      GroupList *g = gUserManager.LockGroupList(LOCK_R);
      QString warning(tr("Are you sure you want to remove\n%1 (%2)\nfrom the '%3' group?")
                         .arg(QString::fromLocal8Bit(u->GetAlias()))
                         .arg(nUin).arg(QString::fromLocal8Bit( (*g)[group - 1] )) );
      gUserManager.UnlockGroupList();
      gUserManager.DropUser(u);
      if (QueryUser(p, warning, tr("Ok"), tr("Cancel")))
      {
         gUserManager.RemoveUserFromGroup(nUin, group);
         updateUserWin();
         return true;
      }
    }
  }
  else if (gtype == GROUPS_SYSTEM)
  {
    if (group == 0) return true;
    ICQUser *u = gUserManager.FetchUser(nUin, LOCK_W);
    if (u == NULL) return true;
    u->RemoveFromGroup(GROUPS_SYSTEM, group);
    gUserManager.DropUser(u);
    updateUserWin();
    return true;
  }

  return false;
}

void CMainWindow::FillServerGroup()
{
  ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_R);
  if (u == NULL) return;

  GroupList *g = gUserManager.LockGroupList(LOCK_R);
  for (unsigned short i = 0; i < g->size(); i++)
    mnuServerGroup->setItemChecked(i+1, false);

  for (unsigned short i = 0; i < g->size(); i++)
  {
    if (u->GetSID() && (u->GetGSID() == gUserManager.GetIDFromGroup((*g)[i])))
    {
      mnuServerGroup->setItemChecked(i+1, true);
      break;
    }
  }
  gUserManager.UnlockGroupList();
  gUserManager.DropUser(u);
}

void CMainWindow::ServerGroupChanged(int n)
{
  if (mnuServerGroup->isItemChecked(n)) return;

  ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_R);
  if (u == NULL) return;

  GroupList *g = gUserManager.LockGroupList(LOCK_R);
  for (unsigned int i = 0; i < g->size(); i++)
    mnuServerGroup->setItemChecked(i+1, (int)(i+1) == n);

  gUserManager.UnlockGroupList();
  gUserManager.DropUser(u);

  gUserManager.AddUserToGroup(m_nUserMenuUin, n);
  updateUserWin();
}

//-----CMainWindow::saveAllUsers-----------------------------------------------
void CMainWindow::saveAllUsers()
{
   gUserManager.SaveAllUsers();
}

void CMainWindow::slot_updateContactList()
{
  licqDaemon->icqUpdateContactList();
}

void CMainWindow::slot_updateAllUsers()
{
  licqDaemon->UpdateAllUsers();
}


void CMainWindow::slot_updateAllUsersInGroup()
{
  licqDaemon->UpdateAllUsersInGroup(m_nGroupType, m_nCurrentGroup);
}



//-----CMainWindow::saveOptions-----------------------------------------------
void CMainWindow::saveOptions()
{
  // Tell the daemon to save it's options
  licqDaemon->SaveConf();

  // Save all our options
  char filename[MAX_FILENAME_LEN];
  snprintf(filename, MAX_FILENAME_LEN, "%s/licq_qt-gui.conf", BASE_DIR);
  filename[MAX_FILENAME_LEN - 1] = '\0';
  CIniFile licqConf(INI_FxERROR | INI_FxALLOWxCREATE);
  if (!licqConf.LoadFile(filename)) return;

  licqConf.SetSection("startup");
  licqConf.WriteNum("Logon", m_nAutoLogon);
  licqConf.WriteNum("AutoAway", autoAwayTime);
  licqConf.WriteNum("AutoNA", autoNATime);
  licqConf.WriteNum("AutoOffline", autoOfflineTime);
  licqConf.WriteNum("AutoAwayMess", autoAwayMess);
  licqConf.WriteNum("AutoNAMess", autoNAMess);

  licqConf.SetSection("functions");
  licqConf.WriteBool("AutoClose", m_bAutoClose);
  licqConf.WriteBool("AutoPopup", m_bAutoPopup);
  licqConf.WriteStr("MsgPopupKey", m_MsgAutopopupKey.isEmpty() ? "none" : m_MsgAutopopupKey.latin1());

  licqConf.SetSection("appearance");
  licqConf.WriteStr("Skin", skin->szSkinName);
  licqConf.WriteStr("Icons", m_szIconSet);
  licqConf.WriteStr("ExtendedIcons", m_szExtendedIconSet);
#if QT_VERSION >= 300
  licqConf.WriteStr("Font", qApp->font() == defaultFont ?
                    "default" : qApp->font().toString().latin1());
  licqConf.WriteStr("EditFont",
                    (MLEditWrap::editFont == NULL ||
                     *MLEditWrap::editFont == defaultFont) ?
                     "default" : MLEditWrap::editFont->toString().latin1());
#else
  licqConf.WriteStr("Font", qApp->font() == defaultFont ?
                    "default" : qApp->font().rawName().latin1());
  licqConf.WriteStr("EditFont",
                    (MLEditWrap::editFont == NULL ||
                     *MLEditWrap::editFont == defaultFont) ?
                     "default" : MLEditWrap::editFont->rawName().latin1());
#endif
  licqConf.WriteBool("GridLines", m_bGridLines);
  licqConf.WriteBool("FontStyles", m_bFontStyles);
  licqConf.WriteNum("Flash", (unsigned short)m_nFlash);
  licqConf.WriteBool("ShowHeader", m_bShowHeader);
  licqConf.WriteBool("ShowDividers", m_bShowDividers);
  licqConf.WriteNum("SortByStatus", m_nSortByStatus);
  licqConf.WriteNum("SortColumn", m_nSortColumn);
  licqConf.WriteBool("SortColumnAscending", m_bSortColumnAscending);
  licqConf.WriteBool("ShowGroupIfNoMsg", m_bShowGroupIfNoMsg);
  licqConf.WriteBool("UseThreadView", m_bThreadView);
  licqConf.WriteNum("TVGroupStates", m_nGroupStates);
  licqConf.WriteBool("BoldOnMsg", m_bBoldOnMsg);
  licqConf.WriteBool("ManualNewUser", m_bManualNewUser);
  licqConf.WriteBool("Transparent", skin->frame.transparent);
  licqConf.WriteBool("ScrollBar", m_bScrollBar);
  licqConf.WriteNum("FrameStyle", skin->frame.frameStyle);
  licqConf.WriteBool("ShowOfflineUsers", m_bShowOffline);
  licqConf.WriteBool("AlwaysShowONU", m_bAlwaysShowONU);
  licqConf.WriteBool("AutoRaise", m_bAutoRaise);
  licqConf.WriteBool("Hidden", m_bHidden);
  licqConf.WriteBool("ShowExtIcons", m_bShowExtendedIcons);
  licqConf.WriteBool("SystemBackground", m_bSystemBackground);
  licqConf.WriteBool("SendFromClipboard", m_bSendFromClipboard);
  licqConf.WriteBool("MsgChatView", m_bMsgChatView);
  licqConf.WriteBool("TabbedChatting", m_bTabbedChatting);
  licqConf.WriteBool("AutoPosReplyWin", m_bAutoPosReplyWin);
  licqConf.WriteBool("AutoSendThroughServer", m_bAutoSendThroughServer);
  licqConf.WriteBool("EnableMainwinMouseMovement", m_bEnableMainwinMouseMovement);

  licqConf.WriteBool("showPopEmail",m_bPopEmail);
  licqConf.WriteBool("showPopPhone",m_bPopPhone);
  licqConf.WriteBool("showPopFax",m_bPopFax);
  licqConf.WriteBool("showPopCellular",m_bPopCellular);
  licqConf.WriteBool("showPopIP",m_bPopIP);
  licqConf.WriteBool("showPopLastOnelin",m_bPopLastOnline);
  licqConf.WriteBool("showPopOnlineSince", m_bPopOnlineSince);
  licqConf.WriteBool("showPopIdleTime", m_bPopIdleTime);

  licqConf.WriteNum("UseDock", (unsigned short)m_nDockMode);
#ifndef USE_KDE
  switch(m_nDockMode)
  {
    case DockDefault:
      licqConf.WriteBool("Dock64x48", ((IconManager_Default *)licqIcon)->FortyEight());
      break;
    case DockThemed:
      licqConf.WriteStr("DockTheme", ((IconManager_Themed *)licqIcon)->Theme().latin1());
      break;
    case DockNone:
      break;
  }
#endif

  // save the column info
  licqConf.WriteNum("NumColumns", (unsigned short)colInfo.size());
  char key[32];
  for (unsigned short i = 1; i <= colInfo.size(); i++)
  {
     sprintf(key, "Column%d.Title", i);
     licqConf.WriteStr(key, colInfo[i - 1]->m_sTitle.local8Bit());
     sprintf(key, "Column%d.Format", i);
     licqConf.WriteStr(key, colInfo[i - 1]->m_szFormat);
     sprintf(key, "Column%d.Width", i);
     licqConf.WriteNum(key, colInfo[i - 1]->m_nWidth);
     sprintf(key, "Column%d.Align", i);
     licqConf.WriteNum(key, colInfo[i - 1]->m_nAlign);
  }

  licqConf.SetSection("floaties");
  licqConf.WriteNum("Num", (unsigned short)CUserView::floaties->size());
  for (unsigned short i = 0; i < CUserView::floaties->size(); i++)
  {
    CUserView* iter = CUserView::floaties->at(i);
    sprintf(key, "Floaty%d.Uin", i);
    licqConf.WriteNum(key, static_cast<CUserViewItem*>(iter->firstChild())->ItemUin());
    sprintf(key, "Floaty%d.X", i);
    licqConf.WriteNum(key, (unsigned short)(iter->x() > 0 ? iter->x() : 0));
    sprintf(key, "Floaty%d.Y", i);
    licqConf.WriteNum(key, (unsigned short)(iter->y() > 0 ? iter->y() : 0));
    sprintf(key, "Floaty%d.W", i);
    licqConf.WriteNum(key, (unsigned short)iter->width());
  }

  // save settings relating to localization
  licqConf.SetSection("locale");
  licqConf.WriteStr("DefaultEncoding", m_DefaultEncoding.latin1());
  licqConf.WriteBool("ShowAllEncodings", m_bShowAllEncodings);

  licqConf.FlushFile();
}


//-----CMainWindow::aboutBox--------------------------------------------------
void CMainWindow::aboutBox()
{
  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  QString about(tr("Licq version %1%8.\n"
                   "Qt GUI plugin version %2.\n"
                   "Compiled on: %7\n"
                   "%6\n"
                   "Maintainer: Jon Keating\n"
                   "Contributions by Dirk A. Mueller\n"
                   "Original Author: Graham Roff\n\n"
                   "http://www.licq.org\n"
                   "#licq on irc.freenode.net\n\n"
                   "%3 (%4)\n"
                   "%5 contacts.").arg(licqDaemon->Version())
                   .arg(VERSION).arg(QString::fromLocal8Bit(o->GetAlias()))
                   .arg(o->Uin()).arg(gUserManager.NumUsers())
#ifdef USE_KDE
                   .arg(tr("(with KDE support)\n"))
#else
                   .arg("\n")
#endif
                   .arg(__DATE__).arg(CICQDaemon::CryptoEnabled() ? "/SSL" : ""));
  gUserManager.DropOwner();
  InformUser(this, about);
}


//-----CMainWindow::changeDebug-----------------------------------------------
void CMainWindow::changeDebug(int _nId)
{
  int nLevel = mnuDebug->indexOf(_nId);
  if (nLevel == MNUxITEM_DEBUGxALL)
  {
    gLog.ModifyService(S_STDERR, L_ALL);
    for (int i = 0; i < 5; i++)
      mnuDebug->setItemChecked(mnuDebug->idAt(i), true);
    return;
  }

  if (nLevel == MNUxITEM_DEBUGxNONE)
  {
    gLog.ModifyService(S_STDERR, L_NONE);
    for (int i = 0; i < 5; i++)
      mnuDebug->setItemChecked(mnuDebug->idAt(i), false);
    return;
  }

  // First see if we are setting on or off the value
  if (mnuDebug->isItemChecked(_nId))
  {
    gLog.RemoveLogTypeFromService(S_STDERR, 1 << nLevel);
    mnuDebug->setItemChecked(_nId, false);
  }
  else
  {
    gLog.AddLogTypeToService(S_STDERR, 1 << nLevel);
    mnuDebug->setItemChecked(_nId, true);
  }
}


//-----CMainWindow::slot_utility----------------------------------------------
void CMainWindow::slot_utility(int _nId)
{
  int nUtility = mnuUtilities->indexOf(_nId);
  CUtility *u = gUtilityManager.Utility(nUtility);
  if (u == NULL) return;
  //unsigned long nUin = userView->SelectedItemUin();
  unsigned long nUin = m_nUserMenuUin;
  if (nUin != 0) (void) new CUtilityDlg(u, nUin, licqDaemon);
}


//-----CMainWindow::slot_miscmodes--------------------------------------------
void CMainWindow::slot_miscmodes(int _nId)
{
  int nAwayModes = mnuMiscModes->indexOf(_nId);
  //ICQUser *u = gUserManager.FetchUser(userView->SelectedItemUin(), LOCK_W);
  ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_W);
  if (u == NULL) return;

  switch(nAwayModes)
  {
  case 0:
    u->SetAcceptInAway(!u->AcceptInAway());
    break;
  case 1:
    u->SetAcceptInNA(!u->AcceptInNA());
    break;
  case 2:
    u->SetAcceptInOccupied(!u->AcceptInOccupied());
    break;
  case 3:
    u->SetAcceptInDND(!u->AcceptInDND());
    break;
  case 4:
    u->SetAutoFileAccept(!u->AutoFileAccept() );
    break;
  case 5:
    u->SetAutoChatAccept( !u->AutoChatAccept() );
    break;
  case 6:
    u->SetAutoSecure( !u->AutoSecure() );
    break;
  case 7:
    u->SetSendRealIp( !u->SendRealIp() );
    break;

  case 9:
    if (u->StatusToUser() == ICQ_STATUS_ONLINE)
      u->SetStatusToUser(ICQ_STATUS_OFFLINE);
    else
      u->SetStatusToUser(ICQ_STATUS_ONLINE);
    break;
  case 10:
    if (u->StatusToUser() == ICQ_STATUS_AWAY)
      u->SetStatusToUser(ICQ_STATUS_OFFLINE);
    else
      u->SetStatusToUser(ICQ_STATUS_AWAY);
    break;
  case 11:
    if (u->StatusToUser() == ICQ_STATUS_NA)
      u->SetStatusToUser(ICQ_STATUS_OFFLINE);
    else
      u->SetStatusToUser(ICQ_STATUS_NA);
    break;
  case 12:
    if (u->StatusToUser() == ICQ_STATUS_OCCUPIED)
      u->SetStatusToUser(ICQ_STATUS_OFFLINE);
    else
      u->SetStatusToUser(ICQ_STATUS_OCCUPIED);
    break;
  case 13:
    if (u->StatusToUser() == ICQ_STATUS_DND)
      u->SetStatusToUser(ICQ_STATUS_OFFLINE);
    else
      u->SetStatusToUser(ICQ_STATUS_DND);
    break;
  }
  gUserManager.DropUser(u);
}


//-----ToggleShowOffline------------------------------------------------------
void CMainWindow::ToggleShowOffline()
{
  m_bShowOffline = !m_bShowOffline;
  mnuSystem->setItemChecked(mnuSystem->idAt(MNUxITEM_SHOWxOFFLINE), m_bShowOffline);
  updateUserWin();
}


//-----ToggleThreadedView------------------------------------------------------
void CMainWindow::ToggleThreadView()
{
  m_bThreadView = !m_bThreadView;
  mnuSystem->setItemChecked(mnuSystem->idAt(MNUxITEM_THREADxVIEW), m_bThreadView);
  updateUserWin();
}


//-----CMainWindow::ToggleMiniMode--------------------------------------------------
void CMainWindow::ToggleMiniMode()
{

   if (m_bInMiniMode)
   {
      userView->show();
      setMaximumHeight(4096);
      resize(width(), m_nRealHeight);
      setMinimumHeight(100);
   }
   else
   {
      userView->QWidget::hide();
      m_nRealHeight = height();
      unsigned short newH = skin->frame.border.top + skin->frame.border.bottom;
      setMinimumHeight(newH);
      resize(width(), newH);
      setMaximumHeight(newH);
   }
   m_bInMiniMode = !m_bInMiniMode;
   mnuSystem->setItemChecked(mnuSystem->idAt(MNUxITEM_MINIxMODE), m_bInMiniMode);
}


//-----CMainWindow::autoAway--------------------------------------------------
void CMainWindow::autoAway()
{
#ifdef USE_SCRNSAVER
  static XScreenSaverInfo *mit_info = NULL;
  static bool bAutoAway = false;
  static bool bAutoNA = false;
  static bool bAutoOffline = false;

  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  unsigned short status = o->Status();
  gUserManager.DropOwner();

  if (mit_info == NULL) {
    int event_base, error_base;
    if(XScreenSaverQueryExtension(x11Display(), &event_base, &error_base)) {
      mit_info = XScreenSaverAllocInfo ();
    }
    else {
      gLog.Warn("%sNo XScreenSaver extension found on current XServer, disabling auto-away.\n",
                L_WARNxSTR);
      autoAwayTimer.stop();
      return;
    }
  }

  if (!XScreenSaverQueryInfo(x11Display(), qt_xrootwin(), mit_info)) {
    gLog.Warn("%sXScreenSaverQueryInfo failed, disabling auto-away.\n",
              L_WARNxSTR);
    autoAwayTimer.stop();
    return;
  }
  Time idleTime = mit_info->idle;

  // Check no one changed the status behind our back
  if ( (bAutoOffline && status != ICQ_STATUS_OFFLINE) ||
       (bAutoNA && status != ICQ_STATUS_NA && !bAutoOffline) ||
       (bAutoAway && status != ICQ_STATUS_AWAY && !bAutoNA && !bAutoOffline) )
  {
    bAutoOffline = false;
    bAutoNA = false;
    bAutoAway = false;
    return;
  }

//  gLog.Info("offl %d, n/a %d, away %d idlt %d\n",
//            bAutoOffline, bAutoNA, bAutoAway, idleTime);

  if ( (autoOfflineTime > 0) &&
       (unsigned long)idleTime > (unsigned long)(autoOfflineTime * 60000))
  {
    if (status == ICQ_STATUS_ONLINE || status == ICQ_STATUS_AWAY || status == ICQ_STATUS_NA)
    {
      changeStatus(ICQ_STATUS_OFFLINE);
      bAutoOffline = true;
      bAutoAway = (status == ICQ_STATUS_ONLINE || bAutoAway);
      bAutoNA = ((status == ICQ_STATUS_AWAY && bAutoAway) || bAutoNA);
    }
  }
  else if ( (autoNATime > 0) &&
       (unsigned long)idleTime > (unsigned long)(autoNATime * 60000))
  {
    if (status == ICQ_STATUS_ONLINE || status == ICQ_STATUS_AWAY)
    {
      if (autoNAMess) {
       SARList &sar = gSARManager.Fetch(SAR_NA);
       ICQUser *u = gUserManager.FetchOwner(LOCK_W);
       u->SetAutoResponse(QString(sar[autoNAMess-1]->AutoResponse()).local8Bit());
       gUserManager.DropOwner();
       gSARManager.Drop();
      }

      changeStatus(ICQ_STATUS_NA);
      bAutoNA = true;
      bAutoAway = (status == ICQ_STATUS_ONLINE || bAutoAway);
    }
  }
  else if ( (autoAwayTime > 0) &&
            (unsigned long)idleTime > (unsigned long)(autoAwayTime * 60000))
  {
    if (status == ICQ_STATUS_ONLINE)
    {
      if (autoAwayMess) {
       SARList &sar = gSARManager.Fetch(SAR_AWAY);
       ICQUser *u = gUserManager.FetchOwner(LOCK_W);
       u->SetAutoResponse(QString(sar[autoAwayMess-1]->AutoResponse()).local8Bit());
       gUserManager.DropOwner();
       gSARManager.Drop();
      }

      changeStatus(ICQ_STATUS_AWAY);
      bAutoAway = true;
    }
  }
  else
  {
    if (bAutoOffline)
    {
      if (bAutoNA && bAutoAway)
      {
        changeStatus(ICQ_STATUS_ONLINE);
        bAutoOffline = bAutoNA = bAutoAway = false;
      }
      else if (bAutoNA)
      {
        changeStatus(ICQ_STATUS_AWAY);
        bAutoNA = bAutoOffline = false;
      }
      else
      {
        changeStatus(ICQ_STATUS_NA);
        bAutoOffline = false;
      }
    }
    else if (bAutoNA)
    {
      if (bAutoAway)
      {
        changeStatus(ICQ_STATUS_ONLINE);
        bAutoNA = bAutoAway = false;
      }
      else
      {
        changeStatus(ICQ_STATUS_AWAY);
        bAutoNA = false;
      }
    }
    else if (bAutoAway)
    {
      changeStatus(ICQ_STATUS_ONLINE);
      bAutoAway = false;
    }
  }

#endif // USE_SCRNSAVER
}


void CMainWindow::popupSystemMenu()
{
   mnuSystem->popup(mapToGlobal(QPoint(btnSystem->x(), btnSystem->y())));
}


//-----CMainWindow::loadExtendedIcons-----------------------------------------
void CMainWindow::ApplyExtendedIcons(const char *_sIconSet, bool _bInitial)
{
   char sFilename[MAX_FILENAME_LEN],
        sFilepath[MAX_FILENAME_LEN],
        sIconPath[MAX_FILENAME_LEN];

   if (m_szExtendedIconSet != NULL) free (m_szExtendedIconSet);
   m_szExtendedIconSet = strdup(_sIconSet);
   if (_sIconSet[0] == '/')
   {
     strcpy(sIconPath, _sIconSet);
     if (sIconPath[strlen(sIconPath) - 1] != '/')
       strcat(sIconPath, "/");
   }
   else
   {
     snprintf(sIconPath, MAX_FILENAME_LEN, "%s/%sextended.icons.%s/", BASE_DIR, QTGUI_DIR, _sIconSet);
     sIconPath[MAX_FILENAME_LEN - 1] = '\0';
   }
   snprintf(sFilename, MAX_FILENAME_LEN, "%s%s.icons", sIconPath, _sIconSet);
   sFilename[MAX_FILENAME_LEN - 1] = '\0';
   CIniFile fIconsConf;
   if (!fIconsConf.LoadFile(sFilename))
   {
     snprintf(sIconPath, MAX_FILENAME_LEN, "%s%sextended.icons.%s/", SHARE_DIR, QTGUI_DIR, _sIconSet);
     sIconPath[MAX_FILENAME_LEN - 1] = '\0';
     snprintf(sFilename, MAX_FILENAME_LEN, "%s%s.icons", sIconPath, _sIconSet);
     sFilename[MAX_FILENAME_LEN - 1] = '\0';
     if (!fIconsConf.LoadFile(sFilename))
     {
       if (_bInitial)
         gLog.Warn("%sUnable to open extended icons file %s.\n", L_WARNxSTR, sFilename);
       else
         WarnUser(this, tr("Unable to open extended icons file\n%1.").arg(sFilename));
       return;
     }
   }

   fIconsConf.SetSection("icons");
   fIconsConf.ReadStr("Collapsed", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmCollapsed.load(sFilepath);
   if (pmCollapsed.isNull())
   {
     QPixmap pix(itemCollapsed_xpm);
     pmCollapsed = pix;
   }

   fIconsConf.ReadStr("Expanded", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmExpanded.load(sFilepath);
   if (pmExpanded.isNull())
   {
     QPixmap pix(itemExpanded_xpm);
     pmExpanded = pix;
   }


   fIconsConf.ReadStr("Phone", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmPhone.load(sFilepath);
   if (pmPhone.isNull())
   {
     QPixmap pix(pixPhone_xpm);
     pmPhone = pix;
   }

   fIconsConf.ReadStr("Cellular", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmCellular.load(sFilepath);
   if (pmCellular.isNull())
   {
     QPixmap pix(pixCellular_xpm);
     pmCellular = pix;
   }


   fIconsConf.ReadStr("Birthday", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmBirthday.load(sFilepath);
   if (pmBirthday.isNull())
   {
     QPixmap pix(pixBirthday_xpm);
     pmBirthday = pix;
   }

   fIconsConf.ReadStr("CustomAR", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmCustomAR.load(sFilepath);
   if (pmCustomAR.isNull())
   {
     QPixmap pix(pixCustomAR_xpm);
     pmCustomAR = pix;
   }

   fIconsConf.ReadStr("Invisible", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN, "%s%s", sIconPath, sFilename);
   pmInvisible.load(sFilepath);
   if (pmInvisible.isNull())
   {
     QPixmap pix(pixInvisible_xpm);
     pmInvisible = pix;
   }

   if (!_bInitial)
     updateUserWin();
}

//-----CMainWindow::loadIcons-------------------------------------------------
void CMainWindow::ApplyIcons(const char *_sIconSet, bool _bInitial)
// load the pixmaps
{
   char sFilename[MAX_FILENAME_LEN],
        sFilepath[MAX_FILENAME_LEN],
        sIconPath[MAX_FILENAME_LEN];

   if (m_szIconSet != NULL) free (m_szIconSet);
   m_szIconSet = strdup(_sIconSet);
   if (_sIconSet[0] == '/')
   {
     strcpy(sIconPath, _sIconSet);
     if (sIconPath[strlen(sIconPath) - 1] != '/')
       strcat(sIconPath, "/");
   }
   else
   {
     snprintf(sIconPath, MAX_FILENAME_LEN, "%s/%sicons.%s/", BASE_DIR, QTGUI_DIR, _sIconSet);
     sIconPath[MAX_FILENAME_LEN - 1] = '\0';
   }
   snprintf(sFilename, MAX_FILENAME_LEN, "%s%s.icons", sIconPath, _sIconSet);
   sFilename[MAX_FILENAME_LEN - 1] = '\0';
   CIniFile fIconsConf;
   if (!fIconsConf.LoadFile(sFilename))
   {
     snprintf(sIconPath, MAX_FILENAME_LEN, "%s%sicons.%s/", SHARE_DIR, QTGUI_DIR, _sIconSet);
     sIconPath[MAX_FILENAME_LEN - 1] = '\0';
     snprintf(sFilename, MAX_FILENAME_LEN, "%s%s.icons", sIconPath, _sIconSet);
     sFilename[MAX_FILENAME_LEN - 1] = '\0';
     if (!fIconsConf.LoadFile(sFilename))
     {
       if (_bInitial)
         gLog.Warn("%sUnable to open icons file %s.\n", L_WARNxSTR, sFilename);
        else
         WarnUser(this, tr("Unable to open icons file\n%1.").arg(sFilename));
       return;
     }
   }

   fIconsConf.SetSection("icons");
   fIconsConf.ReadStr("Online", sFilename, "");
   sFilepath[MAX_FILENAME_LEN - 1] = '\0';
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmOnline.load(sFilepath);

   fIconsConf.ReadStr("FFC", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmFFC.load(sFilepath);
   if (pmFFC.isNull()) pmFFC = pmOnline;

   fIconsConf.ReadStr("Offline", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmOffline.load(sFilepath);

   fIconsConf.ReadStr("Away", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmAway.load(sFilepath);

   fIconsConf.ReadStr("NA", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmNa.load(sFilepath);

   fIconsConf.ReadStr("Occupied", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmOccupied.load(sFilepath);

   fIconsConf.ReadStr("DND", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmDnd.load(sFilepath);

   fIconsConf.ReadStr("Private", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmPrivate.load(sFilepath);

   fIconsConf.ReadStr("Message", sFilename, "none");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmMessage.load(sFilepath);

   fIconsConf.ReadStr("Url", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmUrl.load(sFilepath);

   fIconsConf.ReadStr("Chat", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmChat.load(sFilepath);

   fIconsConf.ReadStr("File", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmFile.load(sFilepath);

   fIconsConf.ReadStr("Contact", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmContact.load(sFilepath);
   if(pmContact.isNull()) pmContact = pmMessage;

   fIconsConf.ReadStr("Authorize", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmAuthorize.load(sFilepath);
   if(pmAuthorize.isNull()) pmAuthorize = pmMessage;

   fIconsConf.ReadStr("SMS", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmSMS.load(sFilepath);
   if(pmSMS.isNull()) pmSMS = pmMessage;

   fIconsConf.ReadStr("SecureOff", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmSecureOff.load(sFilepath);
   if(pmSecureOff.isNull()) pmSecureOff = pmMessage;

   fIconsConf.ReadStr("SecureOn", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmSecureOn.load(sFilepath);
   if(pmSecureOn.isNull()) pmSecureOn = pmMessage;

   fIconsConf.ReadStr("History", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmHistory.load(sFilepath);
   if(pmHistory.isNull()) pmHistory = pmMessage;

   fIconsConf.ReadStr("Info", sFilename, "");
   snprintf(sFilepath, MAX_FILENAME_LEN - 1, "%s%s", sIconPath, sFilename);
   pmInfo.load(sFilepath);
   if(pmInfo.isNull()) pmInfo = pmMessage;

   if (!_bInitial)
   {
     mnuStatus->changeItem(pmOnline, tr("&Online"), ICQ_STATUS_ONLINE);
     mnuStatus->changeItem(pmAway, tr("&Away"), ICQ_STATUS_AWAY);
     mnuStatus->changeItem(pmNa, tr("&Not Available"), ICQ_STATUS_NA);
     mnuStatus->changeItem(pmOccupied, tr("O&ccupied"), ICQ_STATUS_OCCUPIED);
     mnuStatus->changeItem(pmDnd, tr("&Do Not Disturb"), ICQ_STATUS_DND);
     mnuStatus->changeItem(pmFFC, tr("Free for C&hat"), ICQ_STATUS_FREEFORCHAT);
     mnuStatus->changeItem(pmOffline, tr("O&ffline"), ICQ_STATUS_OFFLINE);
     mnuStatus->changeItem(pmPrivate, tr("&Invisible"), ICQ_STATUS_FxPRIVATE);
     mnuUser->changeItem(pmMessage, tr("Send &Message"), mnuUserSendMsg);
     mnuUser->changeItem(pmUrl, tr("Send &URL"), mnuUserSendUrl);
     mnuUser->changeItem(pmChat, tr("Send &Chat Request"), mnuUserSendChat);
     mnuUser->changeItem(pmFile, tr("Send &File Transfer"), mnuUserSendFile);
     mnuUser->changeItem(pmContact, tr("Send Contact &List"), mnuUserSendContact);
     mnuUser->changeItem(pmAuthorize, tr("Send &Authorization"), mnuUserAuthorize);
     mnuUser->changeItem(pmAuthorize, tr("Send Authorization Re&quest"), mnuUserAuthorizeRequest);
     mnuUser->changeItem(pmSMS, tr("Send &SMS"), mnuUserSendSms);
     mnuUser->changeItem(pmSecureOff, tr("Request &Secure Channel"), mnuUserSendKey);
     mnuOwnerAdm->changeItem(pmInfo, tr("&Info"), OwnerMenuGeneral);
     mnuOwnerAdm->changeItem(pmHistory, tr("View &History"), OwnerMenuHistory);
     mnuUser->changeItem(pmInfo, tr("&Info"), mnuUserGeneral);
     mnuUser->changeItem(pmHistory, tr("View &History"), mnuUserHistory);
     CUserView::UpdateFloaties();
     updateUserWin();
     updateEvents();
   }
}


//-----CMainWindow::initMenu--------------------------------------------------
void CMainWindow::initMenu()
{
   // Skins without a menubar (frame.hasMenuBar = 0) cannot use
   // QMenuData accelerators, so we need a accel that is available
   // even without a menubar:
   QAccel *a = new QAccel(this, "CMainWindow change Status Accel");
   a->insertItem(ALT + Key_O, ICQ_STATUS_ONLINE);
   a->insertItem(ALT + Key_A, ICQ_STATUS_AWAY);
   a->insertItem(ALT + Key_N, ICQ_STATUS_NA);
   a->insertItem(ALT + Key_C, ICQ_STATUS_OCCUPIED);
   a->insertItem(ALT + Key_D, ICQ_STATUS_DND);
   a->insertItem(ALT + Key_H, ICQ_STATUS_FREEFORCHAT);
   a->insertItem(ALT + Key_F, ICQ_STATUS_OFFLINE);
   a->insertItem(ALT + Key_I, ICQ_STATUS_FxPRIVATE);
   connect(a, SIGNAL(activated(int)), this, SLOT(changeStatusManual(int)));
#if QT_VERSION >= 0x030100
   connect(a, SIGNAL(activatedAmbiguously(int)), this, SLOT(changeStatusManual(int)));
#endif

   mnuStatus = new QPopupMenu(NULL);
   mnuStatus->insertItem(pmOnline, tr("&Online"), ICQ_STATUS_ONLINE);
   mnuStatus->insertItem(pmAway, tr("&Away"), ICQ_STATUS_AWAY);
   mnuStatus->insertItem(pmNa, tr("&Not Available"), ICQ_STATUS_NA);
   mnuStatus->insertItem(pmOccupied, tr("O&ccupied"), ICQ_STATUS_OCCUPIED);
   mnuStatus->insertItem(pmDnd, tr("&Do Not Disturb"), ICQ_STATUS_DND);
   mnuStatus->insertItem(pmFFC, tr("Free for C&hat"), ICQ_STATUS_FREEFORCHAT);
   mnuStatus->insertItem(pmOffline, tr("O&ffline"), ICQ_STATUS_OFFLINE);
   mnuStatus->insertSeparator();
   mnuStatus->insertItem(pmPrivate, tr("&Invisible"), ICQ_STATUS_FxPRIVATE);
   mnuStatus->setAccel(a->key(ICQ_STATUS_ONLINE), ICQ_STATUS_ONLINE);
   mnuStatus->setAccel(a->key(ICQ_STATUS_AWAY), ICQ_STATUS_AWAY);
   mnuStatus->setAccel(a->key(ICQ_STATUS_NA), ICQ_STATUS_NA);
   mnuStatus->setAccel(a->key(ICQ_STATUS_OCCUPIED), ICQ_STATUS_OCCUPIED);
   mnuStatus->setAccel(a->key(ICQ_STATUS_DND), ICQ_STATUS_DND);
   mnuStatus->setAccel(a->key(ICQ_STATUS_FREEFORCHAT), ICQ_STATUS_FREEFORCHAT);
   mnuStatus->setAccel(a->key(ICQ_STATUS_OFFLINE), ICQ_STATUS_OFFLINE);
   mnuStatus->setAccel(a->key(ICQ_STATUS_FxPRIVATE), ICQ_STATUS_FxPRIVATE);

   connect(mnuStatus, SIGNAL(activated(int)), this, SLOT(changeStatusManual(int)));

   mnuUserGroups = new QPopupMenu(NULL);
   connect(mnuUserGroups, SIGNAL(activated(int)), this, SLOT(setCurrentGroupMenu(int)));

   mnuDebug = new QPopupMenu(NULL);
   mnuDebug->insertItem(tr("Status Info"));
   mnuDebug->insertItem(tr("Unknown Packets"));
   mnuDebug->insertItem(tr("Errors"));
   mnuDebug->insertItem(tr("Warnings"));
   mnuDebug->insertItem(tr("Packets"));
   mnuDebug->insertSeparator();
   mnuDebug->insertItem(tr("Set All"));
   mnuDebug->insertItem(tr("Clear All"));
   mnuDebug->setCheckable(true);
   for (int i = 0; i < 5; i++)
     mnuDebug->setItemChecked(mnuDebug->idAt(i), DEBUG_LEVEL & (1 << i));
   connect(mnuDebug, SIGNAL(activated(int)), this, SLOT(changeDebug(int)));

   mnuOwnerAdm = new QPopupMenu(NULL);
   mnuOwnerAdm->insertItem(tr("&View System Messages"), OwnerMenuView);
   mnuOwnerAdm->insertSeparator();
   mnuOwnerAdm->insertItem(pmInfo, tr("&Info"), OwnerMenuGeneral);
   mnuOwnerAdm->insertItem(pmHistory, tr("View &History"), OwnerMenuHistory);
   mnuOwnerAdm->insertSeparator();
   mnuOwnerAdm->insertItem(tr("&Security/Password Options"), OwnerMenuSecurity);
   mnuOwnerAdm->insertItem(tr("&Random Chat Group"), OwnerMenuRandomChat);
   mnuOwnerAdm->insertSeparator();
   mnuOwnerAdm->insertItem(tr("Debug Level"), mnuDebug);
   connect (mnuOwnerAdm, SIGNAL(activated(int)), this, SLOT(callOwnerFunction(int)));

   mnuUserAdm = new QPopupMenu(NULL);
   mnuUserAdm->insertItem(tr("&Add User"), this, SLOT(showAddUserDlg()));
   mnuUserAdm->insertItem(tr("S&earch for User"), this, SLOT(showSearchUserDlg()));
   mnuUserAdm->insertItem(tr("A&uthorize User"), this, SLOT(showAuthUserDlg()));
   mnuUserAdm->insertItem(tr("Re&quest Authorization"), this, SLOT(showReqAuthDlg(int)));
   mnuUserAdm->insertItem(tr("R&andom Chat"), this, SLOT(slot_randomchatsearch()));
   mnuUserAdm->insertSeparator();
   mnuUserAdm->insertItem(tr("&Popup All Messages"), this, SLOT(slot_popupall()));
   mnuUserAdm->insertItem(tr("Edit &Groups"), this, SLOT(showEditGrpDlg()));
   mnuUserAdm->insertSeparator();
   mnuUserAdm->insertItem(tr("Update All Users"), this, SLOT(slot_updateAllUsers()));
   mnuUserAdm->insertItem(tr("Update Current Group"), this, SLOT(slot_updateAllUsersInGroup()));
   mnuUserAdm->insertItem(tr("&Redraw User Window"), this, SLOT(updateUserWin()));
   mnuUserAdm->insertItem(tr("&Save All Users"), this, SLOT(saveAllUsers()));
   mnuUserAdm->insertSeparator();
   mnuUserAdm->insertItem(tr("Reg&ister User"), this, SLOT(slot_register()));

   QPopupMenu *mnuHelp = new QPopupMenu(NULL);
   mnuHelp->insertItem(tr("&Hints"), this, SLOT(slot_hints()));
   mnuHelp->insertItem(tr("&About"), this, SLOT(aboutBox()));
   mnuHelp->insertItem(tr("&Statistics"), this, SLOT(slot_stats()));

   mnuSystem = new QPopupMenu(NULL);
   mnuSystem->setCheckable(true);
   mnuSystem->insertItem(tr("System Functions"), mnuOwnerAdm);
   mnuSystem->insertItem(tr("User Functions"), mnuUserAdm);
   mnuSystem->insertItem(tr("&Status"), mnuStatus);
   mnuSystem->insertItem(tr("&Group"), mnuUserGroups);
   mnuSystem->insertItem(tr("Set &Auto Response..."), this, SLOT(slot_AwayMsgDlg()));
   mnuSystem->insertSeparator();
   mnuSystem->insertItem(tr("&Network Window"), licqLogWindow, SLOT(show()));
   mnuSystem->insertItem(tr("&Mini Mode"), this, SLOT(ToggleMiniMode()));
   mnuSystem->insertItem(tr("Show Offline &Users"), this, SLOT(ToggleShowOffline()));
   mnuSystem->insertItem(tr("&Thread Group View"), this, SLOT(ToggleThreadView()));
   mnuSystem->insertItem(tr("&Options..."), this, SLOT(popupOptionsDlg()));
   mnuSystem->insertItem(tr("S&kin Browser..."), this, SLOT(showSkinBrowser()));
   mnuSystem->insertItem(tr("&Plugin Manager..."), this, SLOT(showPluginDlg()));
   mnuSystem->insertSeparator();
   mnuSystem->insertItem(tr("Sa&ve Settings"), this, SLOT(saveOptions()));
   mnuSystem->insertItem(tr("&Help"), mnuHelp);
   mnuSystem->insertItem(tr("E&xit"), this, SLOT(slot_shutdown()));
   mnuSystem->setItemChecked(mnuSystem->idAt(MNUxITEM_SHOWxOFFLINE), m_bShowOffline);
   mnuSystem->setItemChecked(mnuSystem->idAt(MNUxITEM_THREADxVIEW), m_bThreadView);

   mnuGroup = new QPopupMenu(NULL);
   mnuGroup->setCheckable(true);
   connect(mnuGroup, SIGNAL(activated(int)), this, SLOT(UserGroupToggled(int)));
   connect(mnuGroup, SIGNAL(aboutToShow()), this, SLOT(FillUserGroup()));

   mnuServerGroup = new QPopupMenu(NULL);
   mnuServerGroup->setCheckable(true);
   connect(mnuServerGroup, SIGNAL(activated(int)), this, SLOT(ServerGroupChanged(int)));
   connect(mnuServerGroup, SIGNAL(aboutToShow()), this, SLOT(FillServerGroup()));

   mnuUtilities = new QPopupMenu(NULL);
   for (unsigned short i = 0; i < gUtilityManager.NumUtilities(); i++)
   {
     mnuUtilities->insertItem(gUtilityManager.Utility(i)->Name());
   }
   connect(mnuUtilities, SIGNAL(activated(int)), this, SLOT(slot_utility(int)));

   mnuMiscModes = new QPopupMenu(NULL);
   mnuMiscModes->setCheckable(true);
   mnuMiscModes->insertItem(tr("Accept in Away"));
   mnuMiscModes->insertItem(tr("Accept in Not Available"));
   mnuMiscModes->insertItem(tr("Accept in Occupied"));
   mnuMiscModes->insertItem(tr("Accept in Do Not Disturb"));
   mnuMiscModes->insertItem(tr("Auto Accept Files" ) );
   mnuMiscModes->insertItem(tr("Auto Accept Chats" ) );
   mnuMiscModes->insertItem(tr("Auto Request Secure" ) );
   mnuMiscModes->insertItem(tr("Use Real Ip (LAN)" ) );
   mnuMiscModes->insertSeparator();
   mnuMiscModes->insertItem(tr("Online to User"));
   mnuMiscModes->insertItem(tr("Away to User"));
   mnuMiscModes->insertItem(tr("Not Available to User"));
   mnuMiscModes->insertItem(tr("Occupied to User"));
   mnuMiscModes->insertItem(tr("Do Not Disturb to User"));
   connect(mnuMiscModes, SIGNAL(activated(int)), this, SLOT(slot_miscmodes(int)));

   mnuUser = new QPopupMenu(NULL);
   mnuUser->insertItem(tr("&View Event"), mnuUserView);
   mnuSend = new QPopupMenu(this);
   mnuSend->insertItem(pmMessage, tr("Send &Message"), mnuUserSendMsg);
   mnuSend->insertItem(pmUrl, tr("Send &URL"), mnuUserSendUrl);
   mnuSend->insertItem(pmChat, tr("Send &Chat Request"), mnuUserSendChat);
   mnuSend->insertItem(pmFile, tr("Send &File Transfer"), mnuUserSendFile);
   mnuSend->insertItem(pmContact, tr("Send Contact &List"), mnuUserSendContact);
   mnuSend->insertItem(pmAuthorize, tr("Send &Authorization"), mnuUserAuthorize);
   mnuSend->insertItem(pmAuthorize, tr("Send Authorization Re&quest"), mnuUserAuthorizeRequest);
   mnuSend->insertItem(pmSMS, tr("Send &SMS"), mnuUserSendSms);
   mnuSend->insertSeparator();
   mnuSend->insertItem(pmSecureOff, tr("Request &Secure Channel"), mnuUserSendKey);
   connect (mnuSend, SIGNAL(activated(int)), this, SLOT(callUserFunction(int)));
   mnuUser->insertItem(tr("Send"), mnuSend);
   mnuUser->insertItem(tr("Misc Modes"), mnuMiscModes);
   mnuUser->insertItem(tr("U&tilities"), mnuUtilities);
   mnuUser->insertItem(tr("Check Auto Response"), mnuUserCheckResponse);
   mnuUser->insertItem(tr("Custom Auto Response..."), mnuUserCustomAutoResponse);
   mnuUser->insertSeparator();
   mnuUser->insertItem(pmInfo, tr("&Info"), mnuUserGeneral);
   mnuUser->insertItem(pmHistory, tr("View &History"), mnuUserHistory);
   mnuUser->insertItem(tr("Toggle &Floaty"), mnuUserFloaty);
   mnuUser->insertItem(tr("Edit User Group"), mnuGroup);
   mnuUser->insertSeparator();
   mnuUser->insertItem(tr("Remove From List"), mnuUserRemoveFromList);
   connect (mnuUser, SIGNAL(activated(int)), this, SLOT(callUserFunction(int)));
   connect (mnuUser, SIGNAL(aboutToShow()), this, SLOT(slot_usermenu()));
}


void CMainWindow::slot_usermenu()
{
  //ICQUser *u = gUserManager.FetchUser(userView->SelectedItemUin(), LOCK_R);
  ICQUser *u = gUserManager.FetchUser(m_nUserMenuUin, LOCK_R);

  if (u == NULL)
  {
    mnuUser->changeItem(mnuUserCheckResponse, tr("Check Auto Response"));
    mnuUser->setItemEnabled(mnuUserCheckResponse, false);
    return;
  }

  const char *szStatus = u->StatusStrShort();
  unsigned short status = u->Status();

  if (status == ICQ_STATUS_OFFLINE)
  {
    mnuUser->changeItem(mnuUserCheckResponse, tr("Check Auto Response"));
    mnuUser->setItemEnabled(mnuUserCheckResponse, false);
  }
  else if (status == ICQ_STATUS_ONLINE)
  {
    mnuUser->changeItem(mnuUserCheckResponse, tr("Check Auto Response"));
    mnuUser->setItemEnabled(mnuUserCheckResponse, true);
  }
  else
  {
    mnuUser->changeItem(mnuUserCheckResponse, QString(tr("Check %1 Response")).arg(szStatus));
    mnuUser->setItemEnabled(mnuUserCheckResponse, true);
  }

  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(0), u->AcceptInAway());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(1), u->AcceptInNA());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(2), u->AcceptInOccupied());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(3), u->AcceptInDND());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(4), u->AutoFileAccept());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(5), u->AutoChatAccept());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(6), u->AutoSecure());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(7), u->SendRealIp());
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(9), u->StatusToUser() == ICQ_STATUS_ONLINE);
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(10), u->StatusToUser() == ICQ_STATUS_AWAY);
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(11), u->StatusToUser() == ICQ_STATUS_NA);
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(12), u->StatusToUser() == ICQ_STATUS_OCCUPIED);
  mnuMiscModes->setItemChecked(mnuMiscModes->idAt(13), u->StatusToUser() == ICQ_STATUS_DND);
  mnuMiscModes->setItemEnabled(6, gLicqDaemon->CryptoEnabled());
  mnuUser->setItemChecked(mnuUserCustomAutoResponse, u->CustomAutoResponse()[0] != '\0');
  // Send modes
  mnuSend->setItemEnabled(mnuUserSendChat, !u->StatusOffline());
  mnuSend->setItemEnabled(mnuUserSendFile, !u->StatusOffline());

  if (strlen(u->GetCellularNumber()))
    mnuSend->setItemEnabled(mnuUserSendSms, true);
  else
    mnuSend->setItemEnabled(mnuUserSendSms, false);

  if (u->Secure())
    mnuSend->changeItem(pmSecureOn, tr("Close &Secure Channel"), mnuUserSendKey);
  else
    mnuSend->changeItem(pmSecureOff, tr("Request &Secure Channel"), mnuUserSendKey);

  gUserManager.DropUser(u);
}


void CMainWindow::slot_stats()
{
#ifdef SAVE_STATS
  QString s = tr("Daemon Statistics\n(Today/Total)\n");
  QDateTime t_total, t_today;
  t_today.setTime_t(licqDaemon->StartTime());
  t_total.setTime_t(licqDaemon->ResetTime());
  s += tr("Up since %1\n").arg(t_today.toString());
  s += tr("Last reset %1\n\n").arg(t_total.toString());
  DaemonStatsList::iterator iter;
  for (iter = licqDaemon->AllStats().begin(); iter != licqDaemon->AllStats().end(); iter++)
  {
    s += tr("%1: %2 / %3\n").arg(iter->Name()).arg(iter->Today()).arg(iter->Total());
  }
  if (!QueryUser(this, s, tr("&Ok"), tr("&Reset")))
  {
    licqDaemon->ResetStats();
  }
#else
  QString s = tr("Daemon Statistics\n\n");
  QDateTime t_today;
  t_today.setTime_t(licqDaemon->StartTime());
  s += tr("Up since %1\n\n").arg(t_today.toString());
  DaemonStatsList::iterator iter;
  for (iter = licqDaemon->AllStats().begin(); iter != licqDaemon->AllStats().end(); iter++)
  {
    s += tr("%1: %2\n")
       .arg(iter->Name())
       .arg(iter->Today());
  }
  InformUser(this, s);
#endif
}


void CMainWindow::showSearchUserDlg()
{
  SearchUserDlg *searchUserDlg = new SearchUserDlg(licqDaemon, licqSigMan);
  searchUserDlg->show();
}


void CMainWindow::showAddUserDlg()
{
  AddUserDlg *addUserDlg = new AddUserDlg(licqDaemon);
  addUserDlg->show();
}


void CMainWindow::showAuthUserDlg()
{
  (void) new AuthUserDlg(licqDaemon, 0, true);
}

// Wrapper for the true function, necessary to kill a Qt2 warning
void CMainWindow::showReqAuthDlg(int nId)
{
  showReqAuthDlg((unsigned long)0);
}

void CMainWindow::showReqAuthDlg(unsigned long nUin)
{
  ReqAuthDlg *reqAuthDlg =  new ReqAuthDlg(licqDaemon, nUin);
  reqAuthDlg->show();
}

void CMainWindow::showEditGrpDlg()
{
  EditGrpDlg *d = new EditGrpDlg;
  connect (d, SIGNAL(signal_updateGroups()), this, SLOT(updateGroups()));
  d->show();
}

void CMainWindow::showOptionsDlg(int tab)
{
  if (optionsDlg) {
    optionsDlg->raise();
//    optionsDlg->showTab(tab);
  }
  else {
    optionsDlg = new OptionsDlg(this, (OptionsDlg::tabs) tab);
    connect(optionsDlg, SIGNAL(signal_done()), this, SLOT(slot_doneOptions()));
  }
}

void CMainWindow::showSkinBrowser()
{
  SkinBrowserDlg *d = new SkinBrowserDlg(this);
  d->show();
}

void CMainWindow::showPluginDlg()
{
  (void) new PluginDlg();
}

void CMainWindow::slot_randomchatsearch()
{
  (void) new CRandomChatDlg(this, licqDaemon, licqSigMan);
}


void CMainWindow::slot_popupall()
{
  // Do nothing if there are no events pending
  if (ICQUser::getNumUserEvents() == 0) return;

  // Do system messages first
  ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
  unsigned short nNumMsg = o->NewMessages();
  gUserManager.DropOwner();
  if (nNumMsg > 0)
  {
    callOwnerFunction(OwnerMenuView);
  }

  UinList uins;
  FOR_EACH_USER_START(LOCK_R)
  {
    if (pUser->NewMessages() > 0)
    {
      uins.push_back(pUser->Uin());
    }
  }
  FOR_EACH_USER_END

  for (UinList::iterator iter = uins.begin(); iter != uins.end(); iter++)
  {
    callDefaultFunction(*iter);
  }
}


void CMainWindow::slot_doneOptions()
{
  optionsDlg = NULL;
}

void CMainWindow::slot_doneregister()
{
  registerUserDlg = NULL;
}

void CMainWindow::slot_register()
{
  if (gUserManager.OwnerUin() != 0)
  {
    QString buf = tr("You are currently registered as\n"
                    "UIN: %1\n"
                    "Base Directory: %2\n"
                    "Rerun licq with the -b option to select a new\n"
                    "base directory and then register a new user.")
                    .arg(gUserManager.OwnerUin()).arg(BASE_DIR);
    InformUser(this, buf);
    return;
  }

  if (registerUserDlg != NULL)
    registerUserDlg->raise();
  else
  {
    registerUserDlg = new RegisterUserDlg(licqDaemon);
    connect(registerUserDlg, SIGNAL(signal_done()), this, SLOT(slot_doneregister()));
  }
}


// -----------------------------------------------------------------------------

void CMainWindow::slot_hints()
{
  QString hints = tr(
    "<h2>Hints for Using<br>the Licq Qt-GUI Plugin</h2><br><hr><br>"
    "<ul>"
    "<li>Change your status by right clicking on the status label.</li>"
    "<li>Change your auto response by double-clicking on the status label.</li>"
    "<li>View system messages by double clicking on the message label.</li>"
    "<li>Change groups by right clicking on the message label.</li>"
    "<li>Use the following shortcuts from the contact list:<ul>"
    "<li><tt>Ctrl-M : </tt>Toggle mini-mode</li>"
    "<li><tt>Ctrl-O : </tt>Toggle show offline users</li>"
    "<li><tt>Ctrl-X : </tt>Exit</li>"
    "<li><tt>Ctrl-H : </tt>Hide</li>"
    "<li><tt>Ctrl-I : </tt>View the next message</li>"
    "<li><tt>Ctrl-V : </tt>View message</li>"
    "<li><tt>Ctrl-S : </tt>Send message</li>"
    "<li><tt>Ctrl-U : </tt>Send Url</li>"
    "<li><tt>Ctrl-C : </tt>Send chat request</li>"
    "<li><tt>Ctrl-F : </tt>Send File</li>"
    "<li><tt>Ctrl-A : </tt>Check Auto response</li>"
    "<li><tt>Ctrl-P : </tt>Popup all messages</li>"
    "<li><tt>Ctrl-L : </tt>Redraw user window</li>"
    "<li><tt>Delete : </tt>Delete user from current group</li>"
    "<li><tt>Ctrl-Delete : </tt>Delete user from contact list</li></ul>"
    "<li>Hold control while clicking on close in the function window to remove"
    "   the user from your contact list.</li>"
    "<li>Hit Ctrl-Enter from most text entry fields to select \"Ok\" or \"Accept\"."
    "   For example in the send tab of the user function window.</li>"
    "<li>Here is the complete list of user % options, which can be used in <b>OnEvent</b>"
    "   parameters, <b>auto responses</b>, and <b>utilities</b>:\n") + gMainWindow->usprintfHelp +
                   "</li></ul>" + tr(
    "<hr><p> For more information, see the Licq webpage (<tt>http://www.licq.org</tt>).</p>");

  (void) new HintsDlg(hints);
}


// -----------------------------------------------------------------------------
HintsDlg::HintsDlg(QString &hint)
  : LicqDialog(0, "HintsDlg", false, WDestructiveClose)
{
  setCaption(tr("Licq - Hints"));

  QBoxLayout* topLay = new QVBoxLayout(this, 5);

  txtView = new QTextView(this);
  txtView->setMinimumWidth(370);
  txtView->setMinimumHeight(450);
  txtView->setText(hint);
  txtView->setFocus();
  topLay->addWidget(txtView);

  QBoxLayout* lay = new QHBoxLayout(topLay);
  lay->addStretch(2);
  btnClose = new QPushButton(tr("&Close"), this);
  btnClose->setDefault(true);
  connect(btnClose, SIGNAL(clicked()), this, SLOT(close()));
  lay->addWidget(btnClose);

  show();
}

// -----------------------------------------------------------------------------

void CMainWindow::slot_viewurl(QWidget *q, QString url)
{
#ifdef USE_KDE
  KApplication* app = static_cast<KApplication*>(qApp);
  if (url.startsWith("mailto:"))
    app->invokeMailer( KURL(url) );
  else
  // If no URL viewer is set, use KDE default
  if (licqDaemon && (!licqDaemon->getUrlViewer()))
    app->invokeBrowser( url );
  else
#endif
  {
    if (licqDaemon == NULL)
      WarnUser(q, tr("Licq is unable to find a browser application due to an internal error."));
    else if (!licqDaemon->ViewUrl(url.local8Bit().data()))
      WarnUser(q, tr("Licq is unable to start your browser and open the URL.\nYou will need to start the browser and open the URL manually."));
  }
}

// -----------------------------------------------------------------------------

#include "mainwin.moc"
