/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PRINTING_HEADER
#define LIFEOGRAPH_PRINTING_HEADER


#include <pangomm.h>
#include <gtkmm.h>
#include <vector>

#include "entry.hpp"
#include "entry_parser.hpp"


namespace LIFEO
{

class EntryParserPango : public EntryParser
{
    public:
                                EntryParserPango( void )
        : option_use_theme_font( false ), option_show_comments( false ) {}

        void                    parse( const Entry* );

        Glib::ustring           m_text_pango;
        bool                    option_use_theme_font;
        bool                    option_show_comments;

    protected:
        void                    apply_regular( void );
        void                    apply_markup( const Glib::ustring&, const Glib::ustring&,
                                              int = 0, int = 1 );
        void                    apply_heading_end( void );
        void                    apply_subheading( void );
        void                    apply_subheading_end( void );
        void                    apply_bold( void );
        void                    apply_italic( void );
        void                    apply_strikethrough( void );
        void                    apply_comment( void );
        void                    apply_highlight( void );
        void                    apply_check_ccl( void );
        void                    apply_check_ccl_end( void );
        void                    apply_link( void );
        void                    apply_link_id( void ) { apply_link(); }
        void                    apply_link_date( void ) { apply_link(); }

        gunichar                get_char_at( int );

        const Entry             *m_ptr2entry;
};

class PrintOpr : public Gtk::PrintOperation
{
    public:
        static Glib::RefPtr< PrintOpr >
                                create( void );
        virtual                 ~PrintOpr( void );

        void                    show_page_setup( void );

        // PRINTING
        void                    print_or_preview( Gtk::PrintOperationAction );
        void                    set_show_comments( bool );

        // Printing-related objects:
        Glib::RefPtr< Gtk::PageSetup >
                                m_refPageSetup;
        Glib::RefPtr< Gtk::PrintSettings >
                                m_refSettings;

    protected:
        PrintOpr( void );
        void                    set_entry( void );
        void                    set_diary( void );

        // PrintOperation default signal handler overrides:
        void                    on_status_changed( void );
        void                    on_done( Gtk::PrintOperationResult );
        void                    on_begin_print(
                const Glib::RefPtr< Gtk::PrintContext >& );
        void                    on_draw_page(
                const Glib::RefPtr< Gtk::PrintContext >&, int );
        Gtk::Widget*            on_create_custom_widget( void );
        void                    on_custom_widget_apply( Gtk::Widget* );

        EntryParserPango        m_parser;
        Glib::ustring           m_marked_up_text;
        Glib::RefPtr< Pango::Layout >
                                m_refLayout;
        std::vector< int >      m_PageBreaks; // line numbers where a page break occurs

        Gtk::RadioButton        *m_rbutton_entry;
        Gtk::RadioButton        *m_rbutton_filtered;
        Gtk::RadioButton        *m_rbutton_diary;

        Gtk::FontButton         *m_fontbutton;
        Gtk::CheckButton        *m_check_use_entry_font;

        Pango::FontDescription  m_font;

        bool                    m_flag_entire_diary;   // not filtered
};

}   // end of namespace LIFEO

#endif
