/* lightlab, Copyright (c) 2002 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#ifndef __LIGHTLAB_H__
#define __LIGHTLAB_H__

extern const char *progname;

typedef struct {
  int enabled_p;			/* whether the light is on */
  double x, y, z, w;			/* position of the light */
  struct {
    double r, g, b;			/* various light colors */
  } ambient, diffuse, specular;
} light_info;

typedef struct {
  int render;				/* smooth, facetted, wireframe */
  int solid_p;				/* solid, textured */
  int type;				/* teapot, cube, sphere */

  double shininess;			/* material reflectivity */
  struct {
    double r, g, b;			/* various material colors */
  } ambient, diffuse, specular;

} object_info;

extern void get_light_info (int which, light_info *info_return);
extern void get_object_info (int which, object_info *info_return);

extern void about_dialog (int up_p);
extern void enable_light (int which, int enabled_p);
extern void reset_light (int which);

#endif /* __LIGHTLAB_H__ */
