// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qstring.h>
#include <qmessagebox.h>

    //   StatusByte:
                                // Status - values:
                                // 0 - main loop - no threads
                                // 1 - GetList
                                // 2 - GetMsgs
                                // 3 - Connect script running
                                // 4 - Wait disconnect
                                // 5 - Forward session
                                // 6 - Abort
                                // 7 - Edit Message


struct idx_record
{
   QString number;
   QString flag;
   QString size;
   QString to_a;
   QString at;
   QString from;
   QString date;
   QString time;
   QString subject;
};
 
struct TFormAttrs
{
  QString Color;
  int x;
  int y;
  int height;
  int width;
};

struct TFontAttrs
{
  QString Name;
  int  Size;
  QString Color;
  bool Pitch;
  bool Bold;
  bool Italic;
//  bool Underline;
//  bool Strikeout;
};

struct TAttrs
{
  char Test;
  TFormAttrs FormAttrs;
  TFontAttrs FontAttrs;
  int Color;
};

struct msgrec
{
    int       ok;      /* this record is usable */
    int       send;    /* this record is to be sent */
    int       let;     /* let this message marked as not sent */
    int       num;     /* message number */
    long      offset;  /* starting offset */
    QString   proposal;/* proposal line - FA .... */
    QString   subject; /* message title */
    char*     body;    /* message body */
    int       size;    /* message size */
};



class TUtils
{
public:

   void       IncLastNum();
   QString    Trim(const QString line);
   QString    Get1Word( const QString wrd );
   QString    Get2Word( const QString wrd );
   QString    GetRest( const QString wrd );
   QString    AlgnToRght( const QString inp_string, int sizeofstr );
   QString    AlgnToLeft( const QString inp_string, int sizeofstr );
   QString    Idx2Str( char test, idx_record idx_tmp);
   QString    substring( char idx, char test, QString data );
   QString    FindString(const char test, const QString data);
   int        Look4Idx( char test);
   idx_record idx_load(const char test, int nr );
//   pid_t RunPrg( char* prg, char* arg);
   int        LoadAutoMarkTbl();
   void       GetList();
   char       *dec2hex( long number_dec );
   void       idx_save( char test, idx_record idx_tmp );
   void       SaveConfigFile();
   void       LoadConfigFile();
   QStringList StripHeader( QStringList Msg );
   int        Look4Msgs();
   void       MsgDir( bool UpdateMsgList );
   bool       HeaderLine( QString s );
   bool       AutoMarkChk( QString line, int max );
   void	      CopyFile( QString from, QString to);

   
protected:
   void       SaveAttrs( QString name, int n );
   void       LoadAttrs( QString name, int n );
};




