/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/cfg.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/15 22:39:48 $
 *!!	$Revision: 1.34 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!    This translation unit manages the configuration file for LinCVS.
 *!!    Inherits the library AppConfig.
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

/* Version Control ID */
#ifndef lint
static char vcid[] = "$Id: cfg.cpp,v 1.34 2001/10/15 22:39:48 joseh Exp $";
#endif /* lint */

/*---------------------------------------------------------------------------*
 *  Include Files                                                            *
 *---------------------------------------------------------------------------*/
#include <iostream.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <qfileinfo.h>
#include <qdir.h>
#include <qstring.h>

#include <qtextstream.h>
#include <qmessagebox.h>

#include "cfg.h"

/*---------------------------------------------------------------------------*
 *  Definitions, Macros                                                      *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  typedefs                                                                 *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  global Variables                                                         *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  Prototypes / classes                                                     *
 *---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*/
/*!
\fn			Config::Config(const char* cfgFileName, 
               QStringList *userList,
               QStringList *serverList,
               QStringList *repositoryList,
               QStringList *profileList)
\brief			ctor
          open cfg file and read it and make a safety copy with extention *.bak


\param		cfgFileName		
\param		*userList		
\param		*serverList		
\param		*repositoryList		
\param		*profileList		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

Config::Config(const char* cfgFileName, 
               QStringList *userList,
               QStringList *serverList,
               QStringList *repositoryList,
               QStringList *profileList)
    :AppConfig (cfgFileName)
{

  p_userList       = userList;
  p_serverList     = serverList;
  p_repositoryList = repositoryList;
  p_profileList    = profileList;
  
  
  fname = QDir::homeDirPath() + "/." + cfgFileName;
  
  QFile cfgFile(fname);
  if (!cfgFile.exists(fname))
  {
    QMessageBox::information(this, tr("lincvs"), tr("Configuration file not found!\n")
                             + tr("Start with default values.\n")
                             + tr("New configuration file will be created automatically\n")
                             + tr("when exiting program.")
    );
    fileFound = FALSE;
  }else
  {
    fileFound = TRUE;

/*! make a copy of cfg file */
   QString cmd = "cp -f " + fname + " " + fname + ".bak";
   system (cmd);
  }
  
   getCfgFile();
}




/*---------------------------------------------------------------------------*/
/*!
\fn			Config::~Config()
\brief		dtor. Currently no action.

\param		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

Config::~Config()
{
}


/*---------------------------------------------------------------------------*/
/*!
\fn			int Config::getCfgFile(void)
\brief		Reads the config file ~.lincvs.rc and sets the corresponding 
          variables. If nothing read set default values.
          Uses the library : AppConfig.

\return		dummy
<BR><HR>*/
/*---------------------------------------------------------------------------*/

int Config::getCfgFile(void)
{
//check for old version of rc-file 
//its a hack, but its obsolete soon
   if ( checkForOldFileVersion() ) {
      CHECKSTATUSINTERVALL = 3000L;
      CVSCALLINTERVALL     = 1000L;
      PROGRESSINTERVALL    = 117L;

      CVSSTYLE   = "QPlatinumStyle";
      EDITOR     = "xterm -e vi";
  
      CVSFONT.NAME      = "helvetica";
      CVSFONT.POINTSIZE = 12L;
      CVSFONT.WEIGHT    = 1L;
      CVSFONT.ITALIC    = 0L;
      CVSFONT.CHARSET   = 0L;

      GEOM_X            = 50L;
      GEOM_Y            = 50L;
      GEOM_WIDTH        = 400L;
      GEOM_HEIGHT       = 300L;
      SPLITTER_POS_H    = 150L;
      SPLITTER_POS_V    = 150L;
      WORKBENCH_COLUMN_WIDTH           = 150L;
      CVSLISTVIEW_TABWIDTH_NAME        = 150L;
      CVSLISTVIEW_TABWIDTH_REV         = 40L;
      CVSLISTVIEW_TABWIDTH_STICKY      = 40L;
      CVSLISTVIEW_TABWIDTH_STATE       = 100L;
      CVSLISTVIEW_TABWIDTH_COMMIT      = 120L;
      CVSLISTVIEW_TABWIDTH_MODLOCAL    = 100L;
      CVSLISTVIEW_TABWIDTH_MODUTC      = 100L;
      NONCVSLISTVIEW_TABWIDTH_NAME     = 150L;
      NONCVSLISTVIEW_TABWIDTH_MODLOCAL = 100L;
      NONCVSLISTVIEW_TABWIDTH_MODUTC   = 100L;
      
      COMPRESSION = 3;
      cvsRsh = "";   //use CVS_RSH
      
      terminal = "xterm -geometry 80x10 -T";
      browser = "netscape";
      
      SELECTION_COLOR_OF_LOGDLG[0] = QColor(255, 0, 0);
      SELECTION_COLOR_OF_LOGDLG[1] = QColor(0, 255, 0);

      bUseExternalDiffForSideBySide = false;
      externalDiffProgram = "";

      bAskForQuit = true;

      return 0;
   }
//end of check...   


  char path[255];
  char* p_path;
  p_path = &path[0];


/*! Section TIMER */
  changeCurrentPath("/TIMER");
  CHECKSTATUSINTERVALL = readEntry("CHECKSTATUSINTERVALL", 3000L);
  CVSCALLINTERVALL     = readEntry("CVSCALLINTERVALL"    , 1000L);
  PROGRESSINTERVALL    = readEntry("PROGRESSINTERVALL"   , 117L);

/*! SECTION STYLE */
  changeCurrentPath("/STYLE");
  CVSSTYLE   = readEntry("CVSSTYLE", "QPlatinumStyle");
  EDITOR     = readEntry("EDITORCOMMAND", "xterm -e vi");
  
  CVSFONT.NAME      = readEntry("FONTNAME", "helvetica");
  CVSFONT.POINTSIZE = readEntry("FONTPOINTSIZE", 12L);
  CVSFONT.WEIGHT    = readEntry("FONTWEIGHT", 1L);
  CVSFONT.ITALIC    = readEntry("FONTITALIC", 0L);
  CVSFONT.CHARSET   = readEntry("FONTCHARSET", 0L);


/*! SECTION GEOMETRY */
  changeCurrentPath("/GEOMETRY");
  GEOM_X            = readEntry("X", 50L);
  GEOM_Y            = readEntry("Y", 50L);
  GEOM_WIDTH        = readEntry("WIDTH", 400L);
  GEOM_HEIGHT       = readEntry("HEIGHT", 300L);
  SPLITTER_POS_H    = readEntry("SPLITTER_POS_H", 150L);
  SPLITTER_POS_V    = readEntry("SPLITTER_POS_V", 150L);
  WORKBENCH_COLUMN_WIDTH           = readEntry("WORKBENCH_COLUMN_WIDTH", 150L);
  CVSLISTVIEW_TABWIDTH_NAME        = readEntry("CVSLISTVIEW_TABWIDTH_NAME", 150L);
  CVSLISTVIEW_TABWIDTH_REV         = readEntry("CVSLISTVIEW_TABWIDTH_REV", 40L);
  CVSLISTVIEW_TABWIDTH_STICKY      = readEntry("CVSLISTVIEW_TABWIDTH_STICKY", 40L);
  CVSLISTVIEW_TABWIDTH_STATE       = readEntry("CVSLISTVIEW_TABWIDTH_STATE", 100L);
  CVSLISTVIEW_TABWIDTH_COMMIT      = readEntry("CVSLISTVIEW_TABWIDTH_COMMIT", 120L);
  CVSLISTVIEW_TABWIDTH_MODLOCAL    = readEntry("CVSLISTVIEW_TABWIDTH_MODLOCAL", 100L);
  CVSLISTVIEW_TABWIDTH_MODUTC      = readEntry("CVSLISTVIEW_TABWIDTH_MODUTC", 100L);
  NONCVSLISTVIEW_TABWIDTH_NAME     = readEntry("NONCVSLISTVIEW_TABWIDTH_NAME", 150L);
  NONCVSLISTVIEW_TABWIDTH_MODLOCAL = readEntry("NONCVSLISTVIEW_TABWIDTH_MODLOCAL", 100L);
  NONCVSLISTVIEW_TABWIDTH_MODUTC   = readEntry("NONCVSLISTVIEW_TABWIDTH_MODUTC", 100L);

/*! SECTION COMPRESSION --> only a hack */
  changeCurrentPath("/COMPRESSION");
  COMPRESSION = readEntry("COMPRESSION", 3L);

  if (COMPRESSION < 1)
	  COMPRESSION = 1;

  if (COMPRESSION > 9)
	  COMPRESSION = 9;

  changeCurrentPath("/RSH");
  cvsRsh = readEntry("RSH", "");

/*! SECTION TERMINAL --> only a hack */
  changeCurrentPath("/TERMINAL");
  terminal = readEntry("TERMINAL", "xterm -geometry 80x10 -T");

/*! SECTION BROWSER */
  changeCurrentPath("/BROWSER");
  browser = readEntry("BROWSER", "netscape");

/*! SECTION ASK FOR QUIT */
  changeCurrentPath("/ASKFORQUIT");
  bAskForQuit = readEntry("ASKFORQUIT", 1L);

/*! Section WORKBENCH */
  readList("/WORKBENCH", m_projectNameList );

/*! Section DISABLED */
  readList("/DISABLED", m_projectDisabledList );

/*! Section CVSROOT */
  readList("/CVSROOT", (*p_repositoryList) );

/*! SECTION EXTERNAL DIFF */
  changeCurrentPath("/EXT_DIFF");
  bUseExternalDiffForSideBySide = readEntry("USE_EXT_DIFF", 0L);
  externalDiffProgram = readEntry("EXT_DIFF_PROG", "");

/*! Section LOGDLG */
  int rgbColor = readEntry("REVISION_A", 0x00ff0000L);
  SELECTION_COLOR_OF_LOGDLG[0] = QColor(rgbColor);
  rgbColor = readEntry("REVISION_B", 0x0000ff00L);
  SELECTION_COLOR_OF_LOGDLG[1] = QColor(rgbColor);

/*! Section PROFILE */
  tmpList.clear();
  list.clear();
  readList("/PROFILE", tmpList );

  /*! insert items from qstringlist into a qlist */
  for ( QStringList::Iterator it = tmpList.begin(); it != tmpList.end(); ++it )
  {
//    QString line = (*it).latin1();
    QString line = (*it);
    line.prepend (',');
    line.append  (',');
    
    uint i, idx, oldidx;
    idx = oldidx = 0;
    i = 0; 
    QString lItem[6];
     
    /*! separate items */
    do
    {
      oldidx = idx+1;
      idx = line.find (',', oldidx);
      lItem[i++] = line.mid(oldidx, idx-oldidx);
    }while (idx < line.length());

    /*! add item to qlist */
    list.append( new lincvsProfile(lItem[0].stripWhiteSpace(),
				   lItem[1].stripWhiteSpace().toInt(),
				   lItem[2].stripWhiteSpace(),
                                   lItem[3].stripWhiteSpace(),
				   lItem[4].stripWhiteSpace()));
  }

  lincvsProfile *profile;

  /*! put items into combobox lists of CheckOutAndImportDlg */
  for ( profile=list.first(); profile != 0; profile=list.next() )
  {
    insertEntry(p_profileList,    profile->name().stripWhiteSpace());
    insertEntry(p_userList,       profile->user().stripWhiteSpace());
    insertEntry(p_serverList,     profile->server().stripWhiteSpace());
    insertEntry(p_repositoryList, profile->repository().stripWhiteSpace());
  }
  getDfltEntry();
  
  return 0; 
}




/*---------------------------------------------------------------------------*/
/*!
\fn			int Config::putCfgFile(void)
\brief		Write back the 'static' parts of the cfg file. The dynamic parts 
          as workbench and disabled lists are written online.

\return		dummy
<BR><HR>*/
/*---------------------------------------------------------------------------*/

int Config::putCfgFile(void)
{


/*! Section TIMER */
  setCurrentPath("/TIMER");
  writeEntry("CHECKSTATUSINTERVALL", (long int)CHECKSTATUSINTERVALL);
  writeEntry("CVSCALLINTERVALL"    , (long int)CVSCALLINTERVALL);
  writeEntry("PROGRESSINTERVALL"   , (long int)PROGRESSINTERVALL);
  
  changeCurrentPath("/STYLE");
  writeEntry("CVSSTYLE", CVSSTYLE);
  //!!!writeEntry("INSTALLDIRECTORY", INSTDIR);
  writeEntry("EDITORCOMMAND", EDITOR);

  writeEntry("FONTNAME",      CVSFONT.NAME);
  writeEntry("FONTPOINTSIZE", CVSFONT.POINTSIZE);
  writeEntry("FONTWEIGHT",    CVSFONT.WEIGHT);
  writeEntry("FONTITALIC",    CVSFONT.ITALIC);
  writeEntry("FONTCHARSET",   CVSFONT.CHARSET);

  changeCurrentPath("/GEOMETRY");
  writeEntry("X",      (long int) GEOM_X);
  writeEntry("Y",      (long int) GEOM_Y);
  writeEntry("WIDTH",  (long int) GEOM_WIDTH);
  writeEntry("HEIGHT", (long int) GEOM_HEIGHT);
  writeEntry("SPLITTER_POS_H", (long int) SPLITTER_POS_H);
  writeEntry("SPLITTER_POS_V", (long int) SPLITTER_POS_V);
  writeEntry("WORKBENCH_COLUMN_WIDTH", (long int) WORKBENCH_COLUMN_WIDTH);
  writeEntry("CVSLISTVIEW_TABWIDTH_NAME", (long int) CVSLISTVIEW_TABWIDTH_NAME);
  writeEntry("CVSLISTVIEW_TABWIDTH_REV", (long int) CVSLISTVIEW_TABWIDTH_REV);
  writeEntry("CVSLISTVIEW_TABWIDTH_STICKY", (long int) CVSLISTVIEW_TABWIDTH_STICKY);
  writeEntry("CVSLISTVIEW_TABWIDTH_STATE", (long int) CVSLISTVIEW_TABWIDTH_STATE);
  writeEntry("CVSLISTVIEW_TABWIDTH_COMMIT", (long int) CVSLISTVIEW_TABWIDTH_COMMIT);
  writeEntry("CVSLISTVIEW_TABWIDTH_MODLOCAL", (long int) CVSLISTVIEW_TABWIDTH_MODLOCAL);
  writeEntry("CVSLISTVIEW_TABWIDTH_MODUTC", (long int) CVSLISTVIEW_TABWIDTH_MODUTC);
  writeEntry("NONCVSLISTVIEW_TABWIDTH_NAME", (long int) NONCVSLISTVIEW_TABWIDTH_NAME);
  writeEntry("NONCVSLISTVIEW_TABWIDTH_MODLOCAL", (long int) NONCVSLISTVIEW_TABWIDTH_MODLOCAL);
  writeEntry("NONCVSLISTVIEW_TABWIDTH_MODUTC", (long int) NONCVSLISTVIEW_TABWIDTH_MODUTC);

/*! SECTION COMPRESSION --> only a hack */
  setCurrentPath("/COMPRESSION");
  writeEntry("COMPRESSION", (long int) COMPRESSION);

/*! SECTION TERMINAL --> only a hack */
  setCurrentPath("/TERMINAL");
  writeEntry("TERMINAL", terminal);

/*! SECTION BROWSER */
  changeCurrentPath("/BROWSER");
  writeEntry("BROWSER", browser);

/*! SECTION ASK FOR QUIT */
  changeCurrentPath("/ASKFORQUIT");
  writeEntry("ASKFORQUIT", (long int) bAskForQuit);

/*! SECTION RSH */
  setCurrentPath("/RSH");
  writeEntry("RSH", cvsRsh);

/*! delete dummy entries */
  setCurrentPath("/WORKBENCH");
  deleteEntry("dummy");
  setCurrentPath("/DISABLED");
  deleteEntry("dummy");

  reArrangeSection ("/CVSROOT", (*p_repositoryList));

/*! SECTION EXTERNAL DIFF */
  changeCurrentPath("/EXT_DIFF");
  writeEntry("USE_EXT_DIFF", (long int) bUseExternalDiffForSideBySide);
  writeEntry("EXT_DIFF_PROG", externalDiffProgram);

/*! Section LOGDLG */
  writeEntry("REVISION_A", (long int) SELECTION_COLOR_OF_LOGDLG[0].rgb());
  writeEntry("REVISION_B", (long int) SELECTION_COLOR_OF_LOGDLG[1].rgb());


/*! Section PROFILE */
  setCurrentPath("/PROFILE");

  lincvsProfile  *profile;
  QString         entry;
  QString         mentry;

  /*! put qlist entries into a qstringlist */
  tmpList.clear();
  
  for ( profile=list.first(); profile != NULL; profile=list.next() )
  {
    entry =  profile->name().stripWhiteSpace()  + ", " +
             mentry.sprintf("%d",profile->method()) + ", " +  
             profile->user().stripWhiteSpace() + ", " + 
             profile->server().stripWhiteSpace() + ", " + 
             profile->repository().stripWhiteSpace();
    tmpList.append (entry.stripWhiteSpace());
  }

  reArrangeSection ("/PROFILE", tmpList);

  

/*! do it */
  flush();

/*! remove safety copy of cfg file */
/* in alpha state is better to not remove the copy of cfg file ;-)
  if( QFileInfo( fname+".bak" ).exists() ) {
    QString cmd = "rm ";
    cmd.append (fname+".bak");
    system (cmd);
  }
*/
  return 0;
}



/*---------------------------------------------------------------------------*/
/*!
\fn			void Config::addItem(char* section, char* item)
\brief		Add 'item' to 'section' and construct an enumerated default
          designator.

\param		section		
\param		item		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void Config::addItem(char* section, const char* item)
{
  changeCurrentPath(section);

/*! get number of entries for that section */
  pEnum = enumEntries();
  nEntries = pEnum->Count();
  
  char num[4];
  sprintf(num, "%i", nEntries);

/*! construct designator for path list */
  QString dis; 
  dis = itemDesig((QString) section);
  dis.append((QString)num);
  
/*! and write it ... */
  writeEntry( dis, item );
  flush();

  delete pEnum; 
}




/*---------------------------------------------------------------------------*/
/*!
\fn			void Config::rmItem(char* section, const char* , QStringList& list)
\brief		Remove the item from section in the cfg file.
          Rearrange the elements of the list.
          Delete the entire list and write it again in ascending order. So we 
          always have a sortet list.

\param		section		
\param		char		not used 
\param		list		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void Config::rmItem(char* section, const char* , QStringList& list)
{
  QString sect;
  QString sectNum; 

  setCurrentPath(section);

  pEnum = enumEntries();
  size_t nEntries = pEnum->Count();
 
  sect = itemDesig((QString) section);
  
/*! delete the entire (may be unsortet) list */
  size_t n0;
  for ( n0 = 0; n0 < nEntries; n0++ ) {

/*! we save dummy entry from being deleted to preserve the comments for 
    that section because : no section -> no comment */
    if (strcmp ( (*pEnum)[n0], "dummy") != 0) 
      deleteEntry((*pEnum)[n0]);
  }
  flush();

  delete pEnum;

  int n = 0;
  setCurrentPath(section);

/*! insert the entire list again but now sortet in ascending order */
  for ( QStringList::Iterator it =  list.begin(); it != list.end(); ++it ) {
    n++;
//    writeEntry( sect + sectNum.number(n), (*it).latin1() );  
    writeEntry( sect + sectNum.number(n), (*it) );  
  }
  flush();
}



/*---------------------------------------------------------------------------*/
/*!
\fn			QString Config::itemDesig(QString section)
\brief		construct item designator for path list 

\param		section		Basename of the section

\return		
<BR><HR>*/
/*---------------------------------------------------------------------------*/

QString Config::itemDesig(QString section)
{
  int pos;
  
  section.stripWhiteSpace();

  if ((pos = section.find("/")) != -1) {
    section.remove ( pos, 1 );
  }
  
  return (section.append("_"));
}

//-----------------------------------------------------------------------------

bool Config::checkForOldFileVersion()
{
   QFile f;
   QString line;

   f.setName(fname);
   if(f.open(IO_ReadOnly)) {//file is readable
      QTextStream textStream(&f); 

      while(!textStream.atEnd()) {
         line = textStream.readLine();
         if(line.find("=") >= 0) {
            f.close();
            return false;
         }
      }
      f.close();
   
      QString cmd = "cp -f " + fname + " " + fname + "-0.2.x";
      system (cmd);

      QMessageBox::information(this, "Information", 
                               "I found a configuration file of an old version of LinCVS.\nI converted it and saved old configuration file as ~/.lincvsrc-0.2.x"); 
   
      f.setName(fname + "-0.2.x");
   
      if(f.open(IO_ReadOnly)) {//file is readable
         QTextStream textStream(&f); 

         while(!textStream.atEnd()) {
            line = textStream.readLine();
            m_projectNameList.append(line); 
            addItem("/WORKBENCH", line);
         }
         f.close();
      }
   } else return false;
   
   return true;

}



/*---------------------------------------------------------------------------*/
/*!
\fn			void Config::readList(const char *szPath, QStringList & strList )
\brief		Read the entries from a section into a QStringList.

\internal
\param		*szPath		section name
\param		strList		QStringList

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void Config::readList(const char *szPath, QStringList & strList )
{
  char path[255];
  char* p_path;
  p_path = &path[0];

  changeCurrentPath(szPath);

/*! if last session was not properly terminated */
  deleteEntry("dummy"); 
  pEnum = enumEntries();
  nEntries = pEnum->Count();

  for ( size_t n = 0; n < nEntries; n++ ) {
    p_path = (char*)readEntry((*pEnum)[n], "???");
    strList.append(static_cast<QString>(p_path));
  }
  delete pEnum;

/*! i insert some dummy items to preserve possible comments */
  changeCurrentPath(szPath);
  writeEntry("dummy", "!!!");  
}


/*---------------------------------------------------------------------------*/
/*!
\fn			void Config::reArrangeSection(char* path, QStringList& list)
\brief		New name for rmItem which may be misunderstood. 

\param		path		
\param		list		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void Config::reArrangeSection(char* path, QStringList& list)
{
  const char *item = 0; // currently not used
  rmItem(path, item, list);
  deleteEntry("dummy");
}



/*---------------------------------------------------------------------------*/
/*!
\fn			void cvsEnvSet::insertEntry(QStringlist *list, QString item)
\brief		search item in list and if not found add it to the list otherwise do
          nothing.

\param		*list		list to where the item is to be added
\param		item		item to add

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void Config::insertEntry(QStringList *list, const QString item)
{
  bool found;
  found = false;

 /*! search the entire list for the item */
  for ( QStringList::Iterator it =  list->begin(); it != list->end(); ++it )
  {
    if (item.compare(*it) == 0) 
    {
      found = TRUE;
      break;
    }
  }

  if (!found)
  {
    list->append(item);
  }
}



/*---------------------------------------------------------------------------*/
/*!
\fn			void Config::getDfltEntry()
\brief		If a profile named default doesn't exits, construct it with the 
          settings got by 'analyzeCVSROOT'. If it already exists do nothing.
          Useful for the first time you start LinCVS without any profiles set.
          You get a default profile with the settings of your local machine.

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void Config::getDfltEntry(void)
{
  lincvsProfile *profile;
  QString   connectMethod;
  QString   userName;
  QString   host;
  QString   rootDir;
  const QString dflt  = "default";
  

/*! if default already exists do nothing  */
  for ( profile=list.first(); profile != 0; profile=list.next() )
  {
    if (profile->name().stripWhiteSpace() == dflt )
    {
      return;
    }
  }

  int res = analyzeCVSROOT(connectMethod, userName, host, rootDir);

  if (res == ACCESS_METHOD_ERROR)
  {
    cout << "Cannot get default settings for profile entry" << endl;
    return;
  }
    
  list.append(new lincvsProfile(dflt,
                                0,  
                                userName,
                                host, 
                                rootDir));

  insertEntry(p_profileList, dflt);
}


/*--------- END OF FILE -----------------------------------------------------*/
