/****************************************************************************
**
** $Id: noncvslistview.h,v 1.5 2001/10/23 23:27:29 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#ifndef NONCVSLISTVIEW_H_20010626
#define NONCVSLISTVIEW_H_20010626

#include "config.h"
#include "ac_system_defs.h"

#include <qlistview.h>
class QPopupMenu;
class QListViewItem;


class NonCvsListView : public QListView
{
	Q_OBJECT

public:
	NonCvsListView(QWidget * Parent) ;
	~NonCvsListView();
	void signalState();

signals:
	void itemCount( int count );
	void addFiles();
	void addBinFiles();
	void deleteNonCvsFiles();
	void doubleClickedFile(QString FN);

public slots :
	void selFile(QListViewItem *);

private:
	void viewportMousePressEvent(QMouseEvent * ev);

	QPopupMenu *m_pPopupMenu;
	int m_PrevCount;
};

#endif   //NONCVSLISTVIEW_H_20010626
