import os, re, linda
from linda.debug import dprint

class ConfigFileParser:
    def __init__(self):
        if linda.clparser['config']:
            self.file = linda.clparser['config']
        elif os.path.exists(os.path.expanduser('~/.linda/config')):
            self.file = os.path.expanduser('~/.linda/config')
        else:
            self.file = '/dev/null'
        self.errors = []
        self.data = []
        self.read()
        self.parse()
        self.check_error()
        
    def read(self):
        f = open(self.file)
        for k in f:
            if k.startswith('#') or k == '\n':
                continue
            else:
                self.data.append(k[:-1])

    def parse(self):
        for line in self.data:
            splitted_line = re.split(r'\s', line, 1)
            if splitted_line[0] in ('info', 'informational', 'no-cull', \
                'show-overridden', 'quiet', 'show-tag', 'traceback'):
                linda.clparser[line] = 1
            elif splitted_line[0] in ('debug', 'verbose'):
                if len(splitted_line) > 1:
                    linda.clparser[splitted_line[0]] = int(splitted_line[1])
                else:
                    linda.clparser[splitted_line[0]] += 1
            elif splitted_line[0] in ('checks', 'format', 'lab-root', \
                'more-overrides', 'types'):
                if len(splitted_line) > 1:
                    if splitted_line[0] == 'lab-root':
                        if os.path.isdir(splitted_line[1]):
                            linda.clparser[splitted_line[0]] = splitted_line[1]
                    elif splitted_line[0] == 'types':
                        linda.clparser[splitted_line[0]] = []
                        for type in re.split(r', ?', splitted_line[1]):
                            if type in ('E', 'W', 'X', 'I'):
                                linda.clparser[splitted_line[0]].append(type)
                            else:
                                self.errors.append("'%s' isn't a valid type" % \
                                    type)
                    else:
                        if splitted_line[1]:
                            if not linda.clparser[splitted_line[0]]:
                                linda.clparser[splitted_line[0]] = \
                                    splitted_line[1]
                        else:
                            self.errors.append('Required argument to %s empty' % \
                                splitted_line[0])
                else:
                    self.errors.append('Required argument to %s missing' % \
                        splitted_line[0])
            else:
                self.errors.append('Unknown line in config file: %s' % line)
    
    def check_error(self):
        if self.errors:
            raise ConfigFileParserException, '; '.join(self.errors)
    
class ConfigFileParserException(Exception):
    pass

