import unittest, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class FilesCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/files.py', {'_': __builtins__['_'], 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/source_files.tar.gz' % \
            self.instance.information['dir'])
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])
        
    def test_debian_rules(self):
        "Check debian_rules() method of FilesCheck"
        method = getattr(self.instance, 'debian_rules')
        os.mkdir(os.path.join(self.instance.information['dir'], 'debian'))
        shutil.move(os.path.join(self.instance.information['dir'], \
            'rules.fine'), os.path.join(self.instance.information['dir'], \
            'debian/rules'))
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        os.unlink(os.path.join(self.instance.information['dir'], \
            'debian/rules'))
        shutil.move(os.path.join(self.instance.information['dir'], \
            'rules.notfine'), os.path.join(self.instance.information['dir'], \
            'debian/rules'))
        method()
        expected = Set(('debian-rules-not-makefile', \
            'debian-rules-hashbang-space'))
        self.assertEqual(expected.intersection(self.instance.err_dict.keys()), expected)
        for key in expected:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)
        shutil.rmtree(os.path.join(self.instance.information['dir'], 'debian'))
        
    def test_autoconf_timestamp(self):
        "Check autoconf_timestamp() method of FilesCheck"
        method = getattr(self.instance, 'autoconf_timestamp')
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        os.unlink(os.path.join(self.instance.information['dir'], \
            'config.guess'))
        shutil.move(os.path.join(self.instance.information['dir'], \
            'config.subbroken'), \
            os.path.join(self.instance.information['dir'], 'config.sub'))
        method()
        self.assert_('config-too-old' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'config-too-old'), True)

