#!/bin/sh
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/linesrv
PIDFILE=`grep "pidfile " /etc/linesrv.conf|awk '{ print $2; }'`
USER=linesrv

# The following value is extracted by debstd to figure out how to generate
# the postinst script. Edit the field to change the way the script is
# registered through update-rc.d (see the manpage for update-rc.d!)
FLAGS="defaults 50"

test -f $DAEMON || exit 0

function start() {
  echo -n "Starting LineControl Server: linesrv"
  if start-stop-daemon --chuid $USER --start --verbose --pidfile $PIDFILE --exec $DAEMON > /var/log/linesrv/linesrv.log; then
    touch /var/lib/linesrv/started
    echo "."
  else
    echo " failed."
  fi
}

function stop() {
  if kill -0 `cat $PIDFILE` > /dev/null 2> /dev/null; then
    echo -n "Stopping LineControl Server: linesrv"
    if start-stop-daemon --stop --signal 3 --verbose --pidfile $PIDFILE --exec $DAEMON >> /var/log/linesrv/linesrv.log; then
      if [ -e /var/lib/linesrv/started ]; then
        rm /var/lib/linesrv/started
      fi
      waitkill `cat $PIDFILE`
    else
      echo " failed."
    fi
}
function stopall() {
  allpids=`pidof linesrv`
  if [ -n "$allpids" ]; then
    printstart="yes"
    for pid in $allpids; do
      if [ "$pid" != "$$" ]; then
        if [ "$printstart" == "yes" ]; then
          echo -n "Stopping (kill) LineControl Server: linesrv "
          printstart="no"
        fi
        echo -n "$pid"
        if [ -e /var/lib/linesrv/started ]; then
          rm /var/lib/linesrv/started
        fi
        kill -QUIT $pid
        waitkill $pid
      fi
    done
  fi
}

function waitkill() {
  echo -n "."
  while kill -0 $1 > /dev/null 2> /dev/null; do
    echo -n "."
    sleep 1
    timeout=$((timeout + 1))
    if [ $timeout -gt 15 ]; then
      echo -n " failed."
      break
    fi
  done
  echo
}

case "$1" in
  start)
    start
    ;;
  stop)
    stop
    ;;
  stopall)
    stopall
    ;;
  restart|force-reload)
    stop
    start
    ;;
  *)
    echo "Usage: /etc/init.d/linesrv {start|stop|stopall|restart|force-reload}"
    exit 1
    ;;
esac

exit 0
