#! /usr/bin/perl
#----------------------------------------------------------------------------
# LinPac - packet radio terminal for Linux
#
# delmsg - mark specified message for delete
#
# Version 0.01
#
# (c) Radek Burget OK2JBG <xburge01@stud.fee.vutbr.cz> 1999
#
# Usage: delmsg <BBS_CALL> <message_number>
#----------------------------------------------------------------------------

# Normal settings:
#List path
$LIST_PATH = "/var/ax25/ulistd";

#Temp output file
$TEMP_FILE = "/tmp/killold_temp.$$";

#----------------------------------------------------------------------------
# Bulletin list format
format TEMP =
@ @>>>>> @<<<<<@<<<<<< @<<<<< @<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$binfo[1], $binfo[2], $binfo[3], $binfo[4], $binfo[5], $binfo[6], $subj
.

#----------------------------------------------------------------------------

if (@ARGV != 2)
{
  print "Usage: delmsg <BBS_CALL> <message_number>\n";
  exit 0;
}

$bbsname = uc $ARGV[0];

$deleted = 0;

$list_name = $LIST_PATH . "/" . $bbsname;
open LIST, $list_name or die "Cannot open list file for $bbsname ($list_name)\n";

# Open temp output
open TEMP, ">".$TEMP_FILE or die "Cannot write to $TEMP_FILE\n";

while (<LIST>)
{
  chop;

  # Read and split message info
  @binfo = split /\s+/;
  $num = $binfo[0];    #first entry - message number
  $flag = $binfo[1];   #second entry - flags

  # Split destination to NAME and @FWD
  if ($binfo[3] =~ /@/)
  {
    for ($i = @binfo; $i >= 4; $i--) {$binfo[$i+1] = $binfo[$i];}
    $binfo[4] = substr $binfo[3], index($binfo[3], "@");
    $binfo[3] = substr $binfo[3], 0, index($binfo[3], "@");
  }
  if ($binfo[4] !~ /^@/)
  {
    for ($i = @binfo; $i >= 4; $i--) {$binfo[$i+1] = $binfo[$i];}
    $binfo[4] = "";
  }

  # Extract subject
  if ($flag =~ /#/)
  {
    $subj = "";
  }
  else
  {
    $subj = substr $_, index($_, $binfo[6])+7;
  }

  # Set the DELETE flag
  if (($num == $ARGV[1]) && ($flag =~ /[P,B]/))
  {
    $binfo[1] = "D"; ##FLAG = DELETED
    $deleted = 1;
  }
  print TEMP "$binfo[0]  ";
  write TEMP;
}

close TEMP;
close LIST;
rename ($TEMP_FILE, $list_name) or die "rename: $!\n";
print "Message $ARGV[1] doesn't exist\n" if ($deleted == 0);

#### END OF SCRIPT #########################################################
