/***************************************************************************
                          bpskdemodulator.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "bpskdemodulator.h"

BPskDemodulator::BPskDemodulator():CPskDemodulator()
{
ave1=0.0;
ave2=0.0;
}
BPskDemodulator::~BPskDemodulator(){
}
void BPskDemodulator::DecodeSymbol(double_complex newsamp)

{

bool bit;

char ch =0;
bool GotChar = false;
double angle;


	m_I1 = m_I0;	//form the multi delayed symbol samples
	m_Q1 = m_Q0;
	m_I0 = newsamp.real();
	m_Q0 = newsamp.imag();
// calculates difference angle  BPSK decoding
//create vector whose angle is the difference angle by multiplying the
// current smaple by the complex conjugate of the previous sample.
//swap I and Q axis to keep away from  the +/-Pi discontinuity and
//  add Pi to make make range from 0 to 2Pi.
// 180 deg phase changes center at Pi/4
// 0 deg phase changes center at 3Pi/2
// +90 deg phase changes center at 2Pi or 0
// -90 deg phase changes center at Pi

	angle = M_PI + atan2( (m_I1*m_I0 + m_Q1*m_Q0),
								(m_I1*m_Q0 - m_I0*m_Q1));
	CalcQuality(angle);
	bit = GetBPSKSymb();
	if( (bit==0) && m_LastBitZero )	//if character delimiter
	{
		if(m_BitAcc != 0 )
		{
			m_BitAcc >>= 2;				//get rid of last zero and one
			m_BitAcc &= 0x07FF;
			ch = m_VaricodeDecTbl[m_BitAcc];
			m_BitAcc = 0;
			GotChar = true;
		}
	}
	else
	{
		m_BitAcc <<= 1;
		m_BitAcc |= bit;
		if(bit==0)
			m_LastBitZero = true;
		else
			m_LastBitZero = false;
	}
	if(GotChar && (ch!=0) )
		emit newSymbol(ch);
	if (bit)
		{
		m_OffCount=0;
		if (m_OnCount++ >20)
			emit setFastSquelch(true);

		}
	else
		{
		m_OnCount=0;
		if (m_OffCount++ > 20)
			emit setFastSquelch(false);			
		}	
GotChar = false;

}
bool BPskDemodulator::GetBPSKSymb()
{
double v;
//calc BPSK symbol over 2 chips
	{
		v = m_I1 * m_I0 +  m_Q1 * m_Q0;
		return (v>0.0);
	}
}

//////////////////////////////////////////////////////////////////////
// Calculate signal quality based on the statistics of the phase
//	difference angle.  The more dispersion of the "0" and "180" degree
//  phase shifts, the worse the signal quality.  This information is used
//  to activate the squelch control.  If 20 consecutive "180" degree shifts
//  occur, the squelch is forced on, and if 20 consecutive "0" degree
//  shifts occur, the squelch is forced off quickly.
//////////////////////////////////////////////////////////////////////

void BPskDemodulator::CalcQuality(  double angle )
{

double temp;


ave2=ave1;
ave1=m_DevAve;
angle = angle - M_PI_2;
if (angle < 0.0)
	angle = angle + PI2;
temp = fmod(angle,M_PI);		

if (temp > M_PI_2)
	temp=temp - M_PI;
	
			m_QFreqError = temp;				
			temp = fabs(temp);
			if (temp > M_PI_4)
					temp= M_PI_4;
	
		m_DevAve =0.47 * ave1 + 0.46 * ave2 + 0.03 *temp;	
				
	

		temp=100.-250.0*m_DevAve;
		emit setSquelchValue((int)temp);
}
