/*
 * $Id: support.h,v 1.4 2001/12/15 05:13:08 antona Exp $
 *
 * support.h - Useful definitions and macros. Part of the Linux-NTFS project.
 *
 * Copyright (c) 2000,2001 Anton Altaparmakov.
 *
 * This program/include file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program/include file is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in the main directory of the Linux-NTFS 
 * distribution in the file COPYING); if not, write to the Free Software
 * Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SUPPORT_H
#define SUPPORT_H

#include <stddef.h>

/*
 * These are just to make the code more readable...
 */
typedef enum {
	FALSE = 0,
	NO = 0,
	ZERO = 0,
	TRUE = 1,
	YES = 1,
	ONE = 1,
} BOOL;

/*
 * Generic macro to convert pointers to values for comparison purposes.
 */
#ifndef p2n
#define p2n(p)          ((ptrdiff_t)((ptrdiff_t*)(p)))
#endif

/*
 * The classical min and max macros.
 */
#ifndef min
#define min(a,b)        ((a) <= (b) ? (a) : (b))
#endif

#ifndef max
#define max(a,b)        ((a) >= (b) ? (a) : (b))
#endif

/*
 * Simple bit operation macros.
 */
#define test_bit(bit, var)		((var) & (1 << (bit)))
#define set_bit(bit, var)		(var) |= 1 << (bit)
#define clear_bit(bit, var)		(var) &= ~(1 << (bit))
#define test_and_set_bit(bit, var)	(test_bit(bit, var), set_bit(bit, var))
#define test_and_clear_bit(bit, var)	(test_bit(bit, var), clear_bit(bit, var))

#endif /* defined SUPPORT_H */

