###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
#import threading
from time import time

import utils
from view_song import *
from db_manager import *
from misc_widget import get_scrolled_window
from thread_queue import ThreadQueue

REFRESH_TIME = 250000/3

def make_label(text):
    label = gtk.Label()
    label.set_use_markup(True)
    label.set_markup("<span size=\"large\"><b>"+text+"</b></span>")
    label.set_alignment(0,0.5)
    label.set_size_request(-1,22)
    box = gtk.HBox(False,6)
    box.pack_start(gtk.Arrow(gtk.ARROW_RIGHT,gtk.SHADOW_NONE),False,False)
    box.pack_start(label,True,True)
    return box

class ListenHome(gtk.VBox):
    def __init__(self,media_organizer):
        gtk.VBox.__init__(self,False,6)
        #self.set_border_width(6)
        self.media_organizer = media_organizer

        #LASTEST
        self.lastest_view = DetailSongView(media_organizer)#,"last_played"
        #PREFERED
        self.prefered_song_view = DetailSongView(media_organizer,"playcount")
        #albums
        self.albums_view = AlbumView(media_organizer,True)

        self.make_hbox_item(make_label(_("Last played songs")),make_label(_("Favorite songs")),False)
        self.make_hbox_item(get_scrolled_window(self.lastest_view),get_scrolled_window(self.prefered_song_view),True)
        self.pack_start(make_label(_("Favorite albums")),False,False)
        self.pack_start(get_scrolled_window(self.albums_view),True,True)

        self.thread_id = None

    def make_hbox_item(self,item1,item2,extend=True):
        box = gtk.HBox(True,6)
        box.pack_start(item1,True,True)
        box.pack_start(item2,True,True)
        self.pack_start(box,extend,extend)

    def refresh(self,*data):

        ThreadQueue.remove_task(self.thread_id)
        self.thread_id = ThreadQueue.add_task(self.refresh_cb)

    def refresh_cb(self):

        from media_source import MLBrowserSource
        for source in self.media_organizer.list_source:
            if isinstance(source,MLBrowserSource):
                self.songs_cache = source.widget.songs_cache

        albums = {}
        for song in self.songs_cache:
            album = song.get_property("album")
            if album!="":
                albums.setdefault(album,{"songs":set(),"playcount":0,"artist":song.get_property("artist"),"duration":0,"image":None,"image_default":config.DEFAULT_ALBUM_COVER_PIXBUF})
                albums[album]["songs"].add(song)
                albums[album]["duration"] += song.get_int("duration")
                albums[album]["playcount"] += song.get_int("playcount")
                if albums[album]["image"]==None:
                    filename = song.get_album_cover(False)
                    if filename == config.DEFAULT_ALBUM_COVER:
                        albums[album]["image"]=None
                    else:
                        albums[album]["image"] = gtk.gdk.pixbuf_new_from_file_at_size(filename,40,40)


        albums_prefered = [(info["playcount"], album,info) for album,info in albums.iteritems()]
        albums_prefered.sort()
        albums_prefered.reverse()

        songs_prefered = [(song.get_property("playcount"), song.sort_key, song) for song in self.songs_cache]
        songs_prefered.sort()
        songs_prefered.reverse()
        songs_prefered = [song[2] for song in songs_prefered[:20]]

        songs_lastest = [(song.get_property("last_played"), song.sort_key, song) for song in self.songs_cache]
        songs_lastest.sort()
        songs_lastest.reverse()
        songs_lastest = [song[2] for song in songs_lastest[:20]]

        gobject.idle_add(self.fill_album,albums_prefered[:20])
        gobject.idle_add(self.prefered_song_view.fill,songs_prefered)
        gobject.idle_add(self.lastest_view.fill,songs_lastest)
        gobject.timeout_add(REFRESH_TIME,self.refresh)

    def fill_album(self,albums):
        self.albums_view.model_song.clear()
        for playcount,key,value in albums:
            self.albums_view.model_song.append((key,value))



class ListenInformation(gtk.VBox):
    def __init__(self,media_organizer):
        gtk.VBox.__init__(self,False,6)
        #self.set_border_width(6)
        self.media_organizer = media_organizer
        self.player = media_organizer.player

        self.player.gst_player.connect("new-media",self.new_media_cb)

        self.song = None
        self.albums_label = gtk.Label()
        self.albums_label.set_use_markup(True)
        self.albums_label.set_markup("<span size=\"large\"><b>"+_("Albums")+"</b></span>")
        self.albums_label.set_alignment(0,0.5)
        self.albums_label.set_size_request(-1,22)
        self.albums_view = AlbumView(self.media_organizer)

        self.prefered_label = gtk.Label()
        self.prefered_label.set_use_markup(True)
        self.prefered_label.set_markup("<span size=\"large\"><b>"+_("Favorite songs of")+"</b></span>")
        self.prefered_label.set_alignment(0,0.5)
        self.prefered_label.set_size_request(-1,22)
        self.prefered_view = DetailSongView(self.media_organizer,"playcount",True)

        self.box_song = gtk.VBox(False,6)

        box = gtk.HBox(False,6)
        box.pack_start(gtk.Arrow(gtk.ARROW_RIGHT,gtk.SHADOW_NONE),False,False)
        box.pack_start(self.albums_label,True,True)
        self.box_song.pack_start(box,False,False)
        self.box_song.pack_start(get_scrolled_window(self.albums_view),True,True)

        box = gtk.HBox(False,6)
        box.pack_start(gtk.Arrow(gtk.ARROW_RIGHT,gtk.SHADOW_NONE),False,False)
        box.pack_start(self.prefered_label,True,True)
        self.box_song.pack_start(box,False,False)
        self.box_song.pack_start(get_scrolled_window(self.prefered_view),True,True)

        self.box_song.show_all()
        self.box_song.set_no_show_all(True)

        self.podcast_label = gtk.Label()
        self.podcast_label.set_use_markup(True)
        self.podcast_label.set_markup("<span size=\"large\"><b>"+_("Podcast description")+"</b></span>")
        self.podcast_label.set_alignment(0,0.5)
        self.podcast_label.set_size_request(-1,22)

        self.podcast_description = gtk.Label()
        self.podcast_description.set_alignment(0,0.5)

        box = gtk.HBox(False,6)
        box.pack_start(gtk.Arrow(gtk.ARROW_RIGHT,gtk.SHADOW_NONE),False,False)
        box.pack_start(self.podcast_label,True,True)
        self.box_podcast = gtk.VBox(False,6)
        self.box_podcast.pack_start(box,False,False)
        self.box_podcast.pack_start(self.podcast_description,False,False)
        self.box_podcast.show_all()
        self.box_podcast.set_no_show_all(True)
        self.box_podcast.hide()

        self.pack_start(self.box_song,True,True)
        self.pack_start(self.box_podcast,True,True)

        self.songs_cache = None

        self.thread_id=None

    def new_media_cb(self,widget,song):
        if song==None or (self.song!=None and song.sprint("artist") == self.song.sprint("artist")):
            return
        self.song = song
        if song.podcast:
            self.box_song.hide()
            self.box_podcast.show()
            sep = "\n"
            text = ""
            if song.sprint("podcast_feed_description")!="":
                text += song.sprint("podcast_feed_description")
                sep = "\n\n"
            if song.sprint("description")!="":
                text += sep+song.sprint("description")
            if text == "":
                text = _("No description available")
            self.podcast_description.set_text(text)

        else:
            self.box_podcast.hide()
            self.box_song.show()
            #if self.songs_cache == None:
            from media_source import MLBrowserSource
            for source in self.media_organizer.list_source:
                if isinstance(source,MLBrowserSource):
                    self.songs_cache = source.widget.songs_cache


            artist = self.song.sprint("artist")
            albums = {}
            songs = []
            for song in self.songs_cache:
                if artist == song.get_property("artist"):
                    album = song.get_property("album")
                    albums.setdefault(album,{"songs":set(),"artist":artist,"duration":0,"image":None,"image_default":config.DEFAULT_ALBUM_COVER_PIXBUF})
                    albums[album]["songs"].add(song)
                    albums[album]["duration"] += song.get_int("duration")
                    if albums[album]["image"]==None:
                        filename = song.get_album_cover(False)
                        if filename == config.DEFAULT_ALBUM_COVER:
                            albums[album]["image"]=None
                        else:
                            albums[album]["image"] = gtk.gdk.pixbuf_new_from_file_at_size(filename,40,40)
                    songs.append(song)


            songs = [(song.get_property("playcount"), song.sort_key, song) for song in songs]
            songs.sort()
            songs.reverse()
            songs = [song[2] for song in songs]
            self.prefered_label.set_markup("<span size=\"large\"><b>"+_("Favorite songs of") +" "+ utils.xmlescape(self.song.sprint("artist"))+"</b></span>")


            gobject.idle_add(self.fill_album,albums)
            gobject.idle_add(self.prefered_view.fill,songs)

    def fill_album(self,albums):
        self.albums_label.set_markup("<span size=\"large\"><b>"+_("Albums by") +" "+ utils.xmlescape(self.song.sprint("artist"))+"</b></span>")
        self.albums_view.model_song.clear()
        for key,value in albums.iteritems():
            self.albums_view.model_song.append((key,value))

class DetailSongView(TreeviewSong):
    def __init__(self,media_organizer,info_to_display=None,show_album=True):
        #use the song for menu and drag drop but use only title column for display infomation
        allow_column={"title":True,"album":False,"artist":False,"track":False,"duration":False}
        TreeviewSong.__init__(self,media_organizer,allow_column,False)

        self.show_album = show_album
        self.info_to_display = info_to_display

        self.set_headers_visible(False)
        self.get_column(1).set_cell_data_func(self.renderer_song, self.cell_data_func)

    def get_menu_ui(self):
        return """
            <ui>
                <popup name="SongMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <separator/>
                  <menuitem action="Lyrics"/>
                  <menuitem action="Artist"/>
                  <menuitem action="Album"/>
                </popup>
            </ui>
            """
    def cell_data_func(self, column, cell, model, iter):
        song = model.get_value(iter, 0)
        text = "<span><b>"+utils.xmlescape(song.sprint("title"))+"</b></span><span size=\"small\">"
        if self.info_to_display=="playcount":
            text +=  " <i>"+_("played")+" "+song.sprint("playcount")+" "+_("times")+"</i>"
        elif self.info_to_display=="last_played":
            if song.get_property("last_played")!=None:
                text += " <i>"+_("played")+" "+utils.duration_to_string(int(time())-int(song.get_property("last_played")))+" "+_("ago")+"</i>"

        text += "\n<i>"+utils.xmlescape(song.sprint("artist"))+"</i>"
        if self.show_album:
            text += " - "+utils.xmlescape(song.sprint("album"))
        text += "</span>"
        if config.get("setting","mlib_smallfont")=="true":
            text="<span size=\"small\">"+text+"</span>"

        cell.set_property("markup",text )


class AlbumView(gtk.TreeView):
    def __init__(self,media_organizer,show_artist=False):
        gtk.TreeView.__init__(self)

        self.media_organizer = media_organizer
        self.show_artist = show_artist
        self.model_song = gtk.ListStore(str,object)

        self.renderer_cover = gtk.CellRendererPixbuf()
        self.renderer_cover.set_property("height",50)
        self.renderer_cover.set_property("width",50)
        self.renderer_album = gtk.CellRendererText()
        self.renderer_album.set_property("height",50)
        self.renderer_album.set_property("ellipsize",pango.ELLIPSIZE_END)
        #self.renderer_album.set_property("yalign",0)

        targets = [("text/uri-list", 0, 0)]
        self.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK|gtk.gdk.SHIFT_MASK|gtk.gdk.CONTROL_MASK, targets,
            gtk.gdk.ACTION_COPY)

        self.column_cover = gtk.TreeViewColumn()
        self.column_cover.pack_start(self.renderer_cover,True)
        self.column_cover.set_cell_data_func(self.renderer_cover, self.__cell_data_func_cover)

        self.column_album = gtk.TreeViewColumn()
        self.column_album.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
        self.column_album.pack_start(self.renderer_album,True)
        self.column_album.set_cell_data_func(self.renderer_album, self.__cell_data_func_album)


        self.append_column(self.column_cover)
        self.append_column(self.column_album)
        self.set_headers_visible(False)
        self.set_rules_hint(True)
        self.connect("row-activated", self.on_row_song_activated)
        self.connect("drag-data-get", self.on_song_drag_data_get)

        self.set_model(self.model_song)


    def on_row_song_activated(self, treeview, path, view_column):
        model, rows = self.get_selection().get_selected_rows()
        play = True
        for row in rows:
            info = model.get_value(model.get_iter(row[0]),1)
            songs = [song for song in info["songs"]]
            songs.sort()
            for song in songs:
                self.media_organizer.player.playlist.add_song(song,False,play)
                play = False


    def on_song_drag_data_get(self,treeview, context, selection, info, timestamp):

        model, rows = self.get_selection().get_selected_rows()

        list_uri = []
        list_song = []
        for row in rows:
            info = model.get_value(model.get_iter(row[0]),1)
            songs = [song for song in info["songs"]]
            songs.sort()
            for song in songs:
                list_song.append(song)
                uri = song.get_property("uri")
                uri = utils.convert_to_uri(uri)
                list_uri.append(uri)
                #print uri

        self.get_toplevel().last_drag_drop = list_song
        selection.set_uris(list_uri)


    def __cell_data_func_cover(self, column, cell, model, iter):
        album = model.get_value(iter, 0)
        info = model.get_value(iter, 1)
        if info["image"]==None:
            def set_cover(cell,info):
                for song in info["songs"]:
                    filename = song.get_album_cover()
                    info["image"] = gtk.gdk.pixbuf_new_from_file_at_size(filename,40,40)
                    gobject.idle_add(cell.set_property,"pixbuf",info["image"])
                    break

            self.thread_album_cover = ThreadQueue.add_task(set_cover,cell,info)
            """change image to launch only one thread"""
            info["image"] = info["image_default"]

        cell.set_property("pixbuf",info["image"] )


    def __cell_data_func_album(self, column, cell, model, iter):
        album = model.get_value(iter, 0)
        info = model.get_value(iter, 1)
        if album=="":
            title = _("Unknown")
        else:
            title = utils.xmlescape(album)
        nb_song = len(info["songs"])
        if nb_song<=1:
            value = _("song")
        else:
            value = _("songs")

        duration  = " - "+utils.duration_to_string(int(info["duration"]))

        if self.show_artist:
            if info["artist"]=="":
                title += " - <i>"+_("Unknown")+"</i>"
            else:
                title += " - <i>"+utils.xmlescape(info["artist"])+"</i>"

        #+" - %d"%int(album["playcount"])
        value = "<b>"+title + "</b>\n%d"%nb_song+" "+value+duration

        if config.get("setting","mlib_smallfont")=="true":
            value="<span size=\"small\">"+value+"</span>"
        #print "TITLE: ",title," - VALEUR: ",value
        cell.set_property("markup",value )



