###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import dbus
import dbus.service
import utils
import os
if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
	import dbus.glib

class ListenDBus(dbus.service.Object):
	def __init__(self,player,object_path="/org/freedesktop/Listen"):

		self.player = player
		session_bus = dbus.SessionBus()
		bus_name = dbus.service.BusName("org.freedesktop.listen", bus=session_bus)
		dbus.service.Object.__init__(self, bus_name, object_path)
		#print "DBUS INIT"

	@dbus.service.method("org.freedesktop.listen")
	def hello(self):
		#self.player.get_toplevel().grab_focus()
		if self.player.get_toplevel().get_property('visible'):
		   self.player.get_toplevel().present()
		return "Running"


	@dbus.service.method("org.freedesktop.listen")
	def play(self,uris):
		print "DBUS: play()"
		play = True
		pos = len(self.player.playlist.model)
		for uri in uris:
			if uri.find("://")==-1:
				uri = "file://"+utils.fsdecode(os.path.abspath(uri))
			res = self.player.playlist.add(uri,play)
			if play and res != False:
				play = False
		return "Successful command "

	@dbus.service.signal("org.freedesktop.listen")
	def enqueue(self,uris):
		print "DBUS: enqueue()"
		for uri in uris:
			if uri.find("://")==-1:
				uri = "file://"+utils.fsdecode(os.path.abspath(uri))
			res = self.player.playlist.add(uri)
		return "Successful command "


	@dbus.service.method("org.freedesktop.listen")
	def previous(self):
		self.player.btn_previous.emit("clicked")
		return "Successful command "

	@dbus.service.method("org.freedesktop.listen")
	def next(self):
		self.player.btn_next.emit("clicked")
		return "Successful command "

	@dbus.service.method("org.freedesktop.listen")
	def play_pause(self):
		self.player.btn_play.emit("clicked")
		return "Successful command "

	@dbus.service.method("org.freedesktop.listen")
	def current_playing(self):
		song = self.player.current_song
		if not self.player.gst_player.paused:
			return str( song.sprint("title")+ " - ("+song.sprint("album")+" - "+song.sprint("artist")+")")
		else:
			return ""
		# - %2d:%02d" % (int(res["duration"]/60000), (int(res["duration"]/1000)%60)))

