###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
# Based on quolibet code for read/write metadata
#   (C) Copyright 2004-2005 Joe Wreschnig, Michael Urman
###

import gst
from song import READ_EXTENTIONS,WRITE_EXTENTIONS

def isascii(s): return ((len(s) == 0) or (ord(max(s)) < 128))

def read(song):
    IDS = {
            "TIT2": "title",
            "TPE1": "artist",
            "TALB": "album",
            "TRCK": "tracknr",
            "TCON": "genre",
            "TDRC": "date"
        }
    SDI = dict([(v, k) for k, v in IDS.iteritems()])
    #try:
    mp3 = MP3(song.get_path(),ID3=ID3hack)
    tag = mp3.tags or {}

    """ thx quolibet """
    def distrust_latin1(text, encoding):
        assert isinstance(text, unicode)
        if encoding == 0:
            text = text.encode('iso-8859-1')
            for codec in ['utf-8','iso-8859-1','iso-8559-15']:
                try: text = text.decode(codec)
                except (UnicodeError, LookupError): pass
                else:break
            else: return None
        return text

    for frame in tag.values():

        name = IDS.get(frame.FrameID, "").lower()
        if not name: continue
        if name == "genre":
            if len(frame.genres)>0:
                song.set_property("genre",frame.genres[0])
        else:
            text_decode = distrust_latin1(map(unicode, frame.text)[0],frame.encoding)
            if text_decode!=None:
                song.set_property(name,text_decode.encode("utf-8"))

    song.set_property("bitrate",int(mp3.info.bitrate))
    song.set_property("duration",int(mp3.info.length)*1000)


def write(song):
    IDS = {
            "TIT2": "title",
            "TPE1": "artist",
            "TALB": "album",
            "TRCK": "tracknr",
            "TCON": "genre",
            "TDRC": "date"
        }
    SDI = dict([(v, k) for k, v in IDS.iteritems()])
    try: tag = mutagen.id3.ID3(song.get_path())
    except mutagen.id3.error: tag = mutagen.id3.ID3()
    for key, value in IDS.iteritems():
        tag_value = song.sprint(value)
        tag.delall(key)
        if not isascii(tag_value): enc = 1
        else: enc = 3
        if tag_value!="":
            if key=="genre":
               tag.loaded_frame(mutagen.id3.TCON(encoding=enc, text=tag_value))
            else:
               Kind = mutagen.id3.Frames[key]
               tag.loaded_frame(Kind(encoding=enc, text=tag_value))

    tag.save(song.get_path())


try:
    import mutagen.id3
    from mutagen.mp3 import MP3
except ImportError: pass
else:
    try: gst.element_factory_make('mad')
    except:pass
    else:
        WRITE_EXTENTIONS[".mp3"]= write
        WRITE_EXTENTIONS[".mp2"]= write
        READ_EXTENTIONS[".mp3"]= read
        READ_EXTENTIONS[".mp2"]= read

class ID3hack(mutagen.id3.ID3):
    "Override 'correct' behavior with desired behavior"
    def loaded_frame(self, tag):
        if len(type(tag).__name__) == 3: tag = type(tag).__base__(tag)
        if tag.HashKey in self and tag.FrameID[0] == "T":
            self[tag.HashKey].extend(tag[:])
        else: self[tag.HashKey] = tag


