
def read_from_gst_file(self):
    IDS = {
        "title": "title",
        "artist": "artist",
        "album": "album",
        "bitrate": "bitrate",
        'track-number':"tracknr"
    }
    def make_element(elementkind, elementname):
        factory = gst.element_factory_find(elementkind)
        if factory:
            return factory.create(elementname)
        else:
            return None

    def found_tag(decoder, source=None, taglist=None,arg=None):
        if taglist==None or not isinstance(taglist,gst.TagList):
            #taglist is a error string !!!
            #if minetype different TO extention
            self.stop_find_tag=True
            return False
        if not taglist.has_key('serial') and not self.tagged:#for first ogg tag
            self.tagged=True
            for key in taglist.keys():
                if key=="bitrate":
                    value = int(taglist[key]/100)
                elif isinstance(taglist[key],long):
                    value = int(taglist[key])
                else:
                    value = taglist[key]
                if key in IDS:
                    self.set_property(IDS[key],value)
                #print key,": ",taglist[key]

    def add(element):
        assert self.pipeline.get_state() != gst.STATE_PLAYING
        elements = self.pipeline.get_list()
        self.pipeline.add(element)
        if elements and not elements[-1].link(element):
            raise "GSTREAMER No Link (BUG !?)"

    def on_error ( pipeline, element, error):
        self.stop_find_tag=True
        print error

    def on_eos (self):
        self.stop_find_tag=True

    self.pipeline = gst.parse_launch ("decodebin ! fakesink");
    # Last element of the bin is the sinks
    sink = self.pipeline.get_list ()[-1]

    filesrc = make_element("gnomevfssrc", "src")
    filesrc.set_property("location","file://"+urllib.quote(self.get_path()))#self.get_property("uri"))


    filesrc.link (self.pipeline.get_list ()[0])
    self.pipeline.add(filesrc)

    self.pipeline.connect("found-tag", found_tag)
    self.pipeline.connect("eos", found_tag)
    self.pipeline.connect("error", found_tag)

    self.pipeline.set_state(gst.STATE_PLAYING)

    progress = None
    total = 0
    pos = 0
    self.stop_find_tag = False
    while not ( self.stop_find_tag or (self.tagged and total!=0) ):#
         total = sink.query(gst.QUERY_TOTAL, gst.FORMAT_TIME)
         self.pipeline.iterate()

    total = sink.query(gst.QUERY_TOTAL, gst.FORMAT_TIME)
    total //= gst.MSECOND
    self.set_property("duration",int(total))

    self.pipeline.set_state(gst.STATE_NULL)
    del self.pipeline

    if self.tagged==True:
         return True
    else:
        #self.last_error=self.get_filename()+": an error occur while gstreamer decode tag"
        return False
