###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import sys
import gst
import pango

import config
from db_manager import DBManager
from podcast_manager import PodcastManager
from misc_widget import *
from misc_widget import trayicon
from preference import *
from file_inspector import *
from thread_queue import ThreadQueue

class ListenUI(gtk.Window):
    def __init__(self,player,media_organizer,osd):
        gtk.Window.__init__(self,gtk.WINDOW_TOPLEVEL)

        self.player = player;
        self.media_organizer = media_organizer
        self.osd = osd
        self.last_drag_drop = None

        self.menu_items = (
            ( "/_File", None, None, 0, "<Branch>" ),
            ( "/File/Quit", "<control>Q", self.on_quit, 0, None ),
        )
        self.set_title("Listen")

        self.set_icon_from_file(config.PIXMAP_DIR+"listen.png")
        gtk.window_set_default_icon_from_file(config.PIXMAP_DIR+"listen.png")

        self.global_box = gtk.HBox()
        self.global_box.pack_start(self.player,False,False)
        self.separateur = gtk.VSeparator()

        self.separateur.show_all()
        self.media_organizer.show_all()

        self.global_box.pack_start(self.separateur,False,False)
        self.global_box.pack_start(self.media_organizer,True,True)

        self.global_box.set_spacing(12)
        self.global_box.set_border_width(6)
        vbox1 = gtk.VBox()
        vbox1.pack_start(self.get_main_menu(),False,False)
        vbox1.pack_start(self.global_box,True,True)

        self.add(vbox1)
        self.connect("configure-event",self.on_configure_event)

        self.drag_dest_set(0, [],0)
        
        """self.enable_model_drag_dest([("text/uri-list", 0, 0)], gtk.gdk.ACTION_COPY)
        self.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK|gtk.gdk.SHIFT_MASK|gtk.gdk.CONTROL_MASK, [("text/uri-list", 0, 0)],
            gtk.gdk.ACTION_COPY)
        """
        """self.connect('drag_drop', self.__window_drag_drop)
        self.connect('drag_motion', self.__window_drag_motion)
        self.connect("drag_data_received", self.__window_drag_data_received)
        """

        if config.get("setting","start_trayicon")=="true":
            self.set_no_show_all(True)
            self.hide_all()

        self.tray = trayicon(self)
        self.change_view(int(config.get("window","view")))


        window_state = config.get("window","state")
        if window_state == "maximized" :
            self.maximize()
        if window_state == "normal":
            self.unmaximize()


        if config.get("window","x")=="-1":
            self.set_position(gtk.WIN_POS_CENTER)
        else:
            self.move(int(config.get("window","x")),int(config.get("window","y")))

        try: self.resize(int(config.get("window","width")),int(config.get("window","height")))
        except:pass


    def change_view(self,num_view):

        self.media_organizer.set_no_show_all(True)
        self.separateur.set_no_show_all(True)
        self.player.playlist_box.set_no_show_all(True)
        if num_view == 2:#FULL VIEW
            self.media_organizer.show()
            self.separateur.show()
            self.player.playlist_box.show()
            self.player.set_size_request(300,-1)
            self.set_resizable(True)
            self.global_box.set_child_packing(self.player, False, False, 0, gtk.PACK_START)

        elif num_view == 1:#PLAYER + PLAYLIST  VIEW
            self.media_organizer.hide()
            self.separateur.hide()
            self.player.playlist_box.show()
            self.set_resizable(True)
            self.global_box.set_child_packing(self.player, True, True, 0, gtk.PACK_START)
            #Realize the widget
            self.resize(300,100)
            self.realize()

        elif num_view == 0:#PLAYER  VIEW
            self.media_organizer.hide()
            self.separateur.hide()
            self.player.playlist_box.hide()
            self.player.set_size_request(-1,-1)
            self.set_resizable(False)
            self.global_box.set_child_packing(self.player, False, False, 0, gtk.PACK_START)
            #Realize the widget
            """self.media_organizer.realize()
            self.separateur.realize()
            self.player.playlist_box.realize()
            """
            self.realize()

        config.set("window","view","%d"%num_view)

    def on_configure_event(self,widget=None,event=None):
        #windows property
        if widget.get_property("visible"):
            config.set("window","width","%d"%event.width)
            config.set("window","height","%d"%event.height)
            config.set("window","x","%d"%event.x)
            config.set("window","y","%d"%event.y)

    def on_quit(self,widget=None,event=None):
        PodcastManager.stop()
        ThreadQueue.kill()

        self.tray.cacher()
        if self.tray.tray!=None:
            self.tray.tray.hide_all()
        while gtk.events_pending(): gtk.main_iteration()
        config.set("player","time","%d"%(self.player.time_box.bar_avancement.get_value()*1000))

        self.player.gst_player.stop()
        self.player.time_box.stop()
        self.player.playlist.save_to_db();


        self.media_organizer.save_config()


        """ stop all task in each source """
        for source in self.media_organizer.list_source:
            source.stop()

        DBManager.close()
        config.write(config.CONFIG_FILE)

        """PodcastManager.stop()
        ThreadQueue.kill()"""
        gtk.main_quit()
        print "Exit successful"
        sys.exit(0)


    def about_dialog(self,btn):
        about = gtk.AboutDialog()
        about.set_comments("""A music player for GNOME
        Copyright 2006 Mehdi Abaakouk <theli48@gmail.com>""")
        about.set_website("http://listengnome.free.fr")
        about.set_name("Listen Music Player")
        about.set_authors(["Mehdi Abaakouk <theli48@gmail.com>",
                           "Joe Wreschnig <piman@sacredchao.net>",
                           "Ed Catmur <ed@catmur.co.uk>",
                           "Michael Urman",
                           "Ton van den Heuvel",
                           "Flavio Gargiulo",
                           "Gustavo J. A. M. Carneiro",
                           "Eduardo Gonzalez",
                           "Joshua Kwan <joshk@triplehelix.org>",
                           "Micah Dowty <micah@navi.cx>",
                           "Lee Willis <lee@leewillis.co.uk>",
                           "Mark Pilgrim"
                           ])
        about.set_translator_credits("\n".join([
                                      "FR: Abaakouk mehdi <theli48@gmail.com>, Fraide Hache <fraide@fraide.com>",
                                      "EN_GB: Ed Catmur <ed@catmur.co.uk>",
                                      "DE: Simon A. Langen <sl108@uni-rostock.de>",
                                      "ES: mario <mariodebian@gmail.com>",
                                      "HU: tewe <molnar.emil@gmail.com>",
                                      "IT: claudio Riva <firetux83@gmail.com>",
                                      "PL: Maciej Chojnacki <byte@byte.livenet.pl>",
                                      "PT: Edson A. Santos <gnomosapiens@gmail.com>"
                                      ]))
        about.set_version(config.VERSION)
        about.set_logo(gtk.gdk.pixbuf_new_from_file(config.PIXMAP_DIR+"listen_big.png"))
        about.show_all()

    def __window_drag_motion(self, widget, context, x, y, time):
        context.drag_status(gtk.gdk.ACTION_COPY, time)
        return True

    def __window_drag_drop(self, widget, context, x, y, time):
        widget.drag_get_data(context, 'text/uri-list', time)
        return True

    def __window_drag_data_received(self, widget, context, x, y, selection, targetType, timestamp):
        #Vient de l exterieur
        if context.get_source_widget()==None:
          for uri in selection.get_uris():
             uri = urllib.unquote(uri)
             print uri
             self.player.playlist.add(uri)



    def add_radio(self,btn):
        w = WindowAddRadio(self.media_organizer)
        w.run()

    def add_podcast(self,btn):
        w = WindowAddPodcast()
        w.run()

    def add_directory(self,btn):
        w = WindowAddDirectory(self.media_organizer)
        w.run()


    def reload_db(self,btn):
        self.refresh_db(btn,True)

    def refresh_db(self,btn,parse_tag=False):
        if parse_tag:
            title = _("Reload the library")
        else:
            title = _("Refresh the library")

        dialog_wait = WindowBase(
                         title,
                         config.PIXMAP_DIR+"listen.png",
                         None
                        )
        dialog_wait.connect("delete-event",lambda *args:  True)
        dialog_wait.set_property("skip-taskbar-hint",True)
        dialog_wait.set_property('has-separator',False)
        progress_bar = gtk.ProgressBar()
        box = gtk.HBox()
        box.pack_start(progress_bar,True,True,12)
        label = gtk.Label(_("Reading library..."))
        label.set_alignment(0,0.5)
        label.set_ellipsize(pango.ELLIPSIZE_START)
        dialog_wait.add_widget(label)
        dialog_wait.vbox.pack_start(box,True,True)
        dialog_wait.show_all()
        progress_bar.set_size_request(344,-1)
        file_inspector = FileInspector()
        gobject.idle_add(file_inspector.check_db,parse_tag)
        gobject.timeout_add(500,self.refresh_db_cb,file_inspector,dialog_wait,label,progress_bar)


    def refresh_db_cb(self,file_inspector,dialog_wait,label,progress_bar):
        progress_bar.pulse()
        if file_inspector.is_ready() == False:
            return True
        info = file_inspector.get_info()
        if info == None:
            from media_source import MLBrowserSource
            for source in self.media_organizer.list_source:
                if isinstance(source,MLBrowserSource):
                    source.widget.refresh_song_cache()
                    source.widget.populate_view()

            del file_inspector
            dialog_wait.destroy()
            return False
        else:
            file = info["file"]
            fraction = round(round(info["num"]) / info["total"],2)
            progress_bar.set_fraction(fraction)
            progress_bar.set_text("%d/%d"%(info["num"],info["total"]))
            label.set_text(file)
            return True


    def add_file(self,btn):
        dialog = gtk.FileChooserDialog(_("Choose a file to add in the library"), None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))


        dialog.set_current_folder(os.path.expanduser("~/"))
        file = ''
        response = dialog.run()
        if response == gtk.RESPONSE_OK:
           file = dialog.get_filename()
           dialog.destroy()
           song = DBManager.get_song_by_uri("file://"+file)
        else:
            dialog.destroy()
        #FIXME: refresh library


    def add_uri(self,btn):
        print "open"


    def show_preferences(self,btn):
        pref = PreferenceDialog(self,self.osd)
        pref.show_all()

    """
    def show_plugins(self,btn):
        pref = PluginsDialog(self,self.osd)
        pref.show_all()
    """



    def get_main_menu(self):
        menu = """
        <ui>
          <menubar name="MenuBar">
            <menu action="File">
              <menuitem action="AddFile"/>
              <menuitem action="AddPath"/>
              <menuitem action="AddRadio"/>
              <menuitem action="AddPodcast"/>
              <separator />
              <menuitem action="Refresh"/>
              <menuitem action="Reload"/>
              <separator />
              <menuitem action="Config"/>
              <separator />
              <menuitem action="Quit"/>
            </menu>
            <menu action="View">
              <menuitem action="Player"/>
              <menuitem action="PlayerPlaylist"/>
              <menuitem action="Full"/>
              <separator />
              <menu action="BrowserView">
                  <menuitem action="browserview0"/>
                  <menuitem action="browserview1"/>
                  <menuitem action="browserview2"/>
              </menu>
              <menu action="SongView">
                  <menuitem action="songview_track"/>
                  <menuitem action="songview_album"/>
                  <menuitem action="songview_artist"/>
                  <menuitem action="songview_duration"/>
              </menu>
              <menu action="MediaSource">
                  <menuitem action="mediasource_context"/>
                  <menuitem action="mediasource_current"/>
                  <menuitem action="mediasource_lyrics"/>
                  <menuitem action="mediasource_wikipedia"/>
                  <menuitem action="mediasource_lastfm"/>
                  <menuitem action="mediasource_locallib"/>
                  <menuitem action="mediasource_podcast"/>
                  <menuitem action="mediasource_iradio"/>
                  <menuitem action="mediasource_ipod"/>
              </menu>
            </menu>
            <menu action="Help">
              <menuitem action="About"/>
            </menu>
          </menubar>
        </ui>
        """
        """
              <menuitem action="Plugin"/>
              <menuitem action="AddUri"/>
            <menu action="View">
              <menuitem action="Library"/>
            </menu>
        """
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu)
        accelgroup = self.uimanager.get_accel_group()

        # Create the base ActionGroup
        actiongroup0 = gtk.ActionGroup('Listen')

        actiongroup0.add_actions([('File', None, _('_File')),
                                  ('View', None, _('_View')),
                                  ('Help', None, _('_Help')),
                                  ('BrowserView', None, _('_Browser view')),
                                  ('SongView', None, _('_Song view')),
                                  ('MediaSource', None, _('Middle pane'))
                                  ])
        self.uimanager.insert_action_group(actiongroup0, 0)

        actiongroup = gtk.ActionGroup('Listen')
        self.actiongroup = actiongroup
        # Create a ToggleAction, etc.

        #actiongroup.add_toggle_actions([('Library', None, 'Show _Library', None,
        #                                 'Show/Hide Library', self.show_hide_Library,True)])
        #actiongroup.add_actions([('AddUri', gtk.STOCK_ADD, _('Add a _uri'), None,
        #                                 _('Open a uri'), self.add_uri)])

        actiongroup.add_actions([('AddFile', gtk.STOCK_ADD, _('Import a _file '), None,
                                         _('Import a file in the library'), self.add_file),

                                 ('AddPath', gtk.STOCK_ADD, _('Import a _directory'), None,
                                         _('Import a directory'), self.add_directory),

                                 ('AddRadio', gtk.STOCK_ADD, _('Add a _radio'), None,
                                         _('Import a radio'), self.add_radio),

                                 ('AddPodcast', gtk.STOCK_ADD, _('Add a p_odcast'), None,
                                         _('Import a podcast'), self.add_podcast),

                                 ('Refresh', gtk.STOCK_REFRESH, _('Refresh the Library'), None,
                                         _('Refresh the Library'), self.refresh_db),

                                 ('Reload', gtk.STOCK_REFRESH, _('Reload the Library'), None,
                                         _('Reload the Library'), self.reload_db),

                                 ('About', gtk.STOCK_ABOUT, _('_About'), None,
                                         _('About Listen'), self.about_dialog),

                                 ('Config', gtk.STOCK_PREFERENCES, _('_Preferences'), None,
                                         _('Preferences'), self.show_preferences),


                                 ('Quit', gtk.STOCK_QUIT, _('_Quit'), None,
                                         _('Quit Listen'), self.on_quit)

                                 ])

        """
                                ('Plugin', gtk.STOCK_PREFERENCES, _('_Plugins'), None,
                                         _('Plugins'), self.show_plugins),
        """
        def on_change_view(widget,radiobtn):
            self.change_view(radiobtn.get_current_value())

        def on_change_browser(widget,radiobtn):
            config.set("browser","view","%d"%radiobtn.get_current_value())
            for source in self.media_organizer.list_source:
                if isinstance(source,MLBrowserSource) or \
                    isinstance(source,IPodSource) :
                    source.widget.set_visible_pane()

        view_value = int(config.get("window","view"))

        browser_value = int(config.get("browser","view"))

        actiongroup.add_radio_actions([('Player', None, _('Player'), None,None,0),
                                       ('PlayerPlaylist', None, _('Player + Playlist'), None,None,1),
                                       ('Full', None, _('Player + Playlist + Library'), None,None,2)],view_value, on_change_view)

        actiongroup.add_radio_actions([('browserview0', None, _('Artist and album'), None,None,0),
                                       ('browserview1', None, _('Genre and artist'), None,None,1),
                                       ('browserview2', None, _('Genre, artist and album'), None,None,2)],browser_value, on_change_browser)

        def change(action,*param):
            name = action.get_property("name")
            section = name[:name.index("_")]
            option = name[name.index("_")+1:]
            if action.get_active():
                config.set(section,option,"1")
            else:
                config.set(section,option,"0")
            if section=="songview":
                for source in self.media_organizer.list_source:
                    if isinstance(source,MLBrowserSource) or \
                        isinstance(source,IPodSource) :
                        source.widget.treeviews["songs"].set_visible_column()
                    if isinstance(source,LocalPlaylistSource) or \
                        isinstance(source,IPodPlaylistSource) :
                        source.view.set_visible_column()

            elif section=="mediasource":
                self.media_organizer.populate()

        actiongroup.add_toggle_actions([('songview_track', None, _('Track number'), None,None,change,int(config.get("songview",'track'))),
                                        ('songview_album', None, _('Album'), None,None,change,int(config.get("songview",'album'))),
                                        ('songview_artist', None, _('Artist'), None,None,change,int(config.get("songview",'artist'))),
                                        ('songview_duration', None, _('Duration'), None,None,change,int(config.get("songview",'duration'))),
                                        ('mediasource_iradio', None, _('iRadio'), None,None,change,int(config.get("mediasource",'iradio'))),
                                        ('mediasource_locallib', None, _('Library'), None,None,change,int(config.get("mediasource",'locallib'))),
                                        ('mediasource_ipod', None, _('iPod'), None,None,change,int(config.get("mediasource",'ipod'))),
                                        ('mediasource_lyrics', None, _('Lyrics'), None,None,change,int(config.get("mediasource",'lyrics'))),
                                        ('mediasource_lastfm', None, _('LastFm'), None,None,change,int(config.get("mediasource",'lastfm'))),
                                        ('mediasource_current', None, _('Current'), None,None,change,int(config.get("mediasource",'current'))),
                                        ('mediasource_podcast', None, _('Podcast'), None,None,change,int(config.get("mediasource",'podcast'))),
                                        ('mediasource_wikipedia', None, _('Wikipedia'), None,None,change,int(config.get("mediasource",'wikipedia'))),
                                        ('mediasource_context', None, _('Context'), None,None,change,int(config.get("mediasource",'context'))),
                                        ])
                                       #('PlayerPlaylist', None, 'Player + Playlist', None,None,1),
                                       #('Full', None, 'Player + Playlist + Library', None,None,2)],view_value, self.on_change_view)


        self.uimanager.insert_action_group(actiongroup, 1)

        self.add_accel_group(accelgroup)
        return self.uimanager.get_widget("/MenuBar")



