###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import gobject
import xml.sax.saxutils


from media_source import *
from ipod_manager import *

TIME_BEFORE_AUTOSELECT = 1500

empty_pixbuf = gtk.gdk.pixbuf_new_from_file(config.PIXMAP_DIR+"/none.png")

class MediaOrganizer(gtk.HPaned):
    def __init__(self,player,hal):
        gtk.HPaned.__init__(self)

        self.treeview_organizer = gtk.TreeView()

        self.player = player
        self.hal = hal

        self.ipod_transfert_manager = IPodTransfertManager(self)
        """    Register source     """

        self.list_source = []
        self.list_source.append(ContextSource(self))
        self.list_source.append(ContextCurrentSource(self))
        self.list_source.append(ContextLyricsSource(self))
        self.list_source.append(ContextWikipediaSource(self))
        self.list_source.append(ContextLastFmSource(self))

        self.list_source.append(MLBrowserSource(self))

        self.list_source.append(LocalPlaylistSource(self))
        self.list_source.append(PodcastSource(self))
        self.list_source.append(IRadioSource(self))

        #self.list_source.append(AudioConvertSource(self))


        #Other will added by hal_manager when certain media are found


#        print "All sources are registered"
        """"""""""""""""""""""""""""""



        if self.hal!=None:
            #self.hal.connect("cdrom-added",self.populate_cdrom)
            #self.hal.connect("cdrom-removed",self.remove_cdrom)
            self.hal.connect("ipod-added",self.ipod_added)
            self.hal.connect("ipod-removed",self.ipod_removed)

        self.player.playlist.connect("media-organizer-changed",self.media_organizer_changed_cb)


        self.model = gtk.ListStore(object,object)

        self.renderer = gtk.CellRendererText()
        self.renderer_icon = gtk.CellRendererPixbuf()

        colonne = gtk.TreeViewColumn()
        colonne.set_title("Media")
        colonne.pack_start(self.renderer,True)
        colonne.cell_is_visible()
        colonne.set_expand(True)
        colonne.set_cell_data_func(self.renderer, self.cell_data_func)

        colonne_icon = gtk.TreeViewColumn()
        colonne_icon.set_title("ICONE")
        colonne_icon.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED);
        colonne_icon.set_fixed_width(30)
        colonne_icon.pack_start(self.renderer_icon,True)
        colonne_icon.cell_is_visible()
        colonne_icon.set_cell_data_func(self.renderer_icon, self.cell_data_func_icon)

        self.treeview_organizer.append_column(colonne_icon)
        self.treeview_organizer.append_column(colonne)
        self.treeview_organizer.set_headers_visible(False)
        targets = [("text/uri-list", 0, 0)]
        self.treeview_organizer.enable_model_drag_dest(targets, gtk.gdk.ACTION_COPY)
        self.treeview_organizer.connect("drag-data-get", self.on_media_organizer_drag_data_get)
        self.treeview_organizer.connect("drag-data-received", self.on_media_organizer_drag_data_received)

        self.treeview_organizer.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK, targets,
            gtk.gdk.ACTION_COPY)

        self.treeview_organizer.get_selection().connect("changed", self.on_row_selected)
        self.treeview_organizer.connect("row-activated",self.on_row_activated)

        self.treeview_organizer.connect("key-press-event", self.on_key_press)
        self.treeview_organizer.connect("button_press_event",self.on_button_press_event)

        #Must find a idea to connect this feature for source use the same widget
        #because selection change model of this widget and the drag song are lost
        #(because drag-data-get launched when drop the element)

        #self.treeview_organizer.connect("drag-motion",self.on_drag_motion)


        """ RIGHT PART """


        scroll = get_scrolled_window(self.treeview_organizer)
        scroll.set_size_request(170,-1)

        self.vbox_gene = gtk.VBox(False)
        #self.vbox_gene.pack_start(hbox,False,False)
        for source in self.list_source:
            self.vbox_gene.pack_start(source.get_widget())

        self.vbox_gene.set_spacing(0)
        self.vbox_gene.set_size_request(450,-1)


        vbox_left = gtk.VBox()
        vbox_left.pack_start(scroll)
        vbox_left.pack_start(self.ipod_transfert_manager.get_ipod_transfert_box(),False,False)
        vbox_left.set_spacing(6)
        self.pack1(vbox_left, False, False)
        self.pack2(self.vbox_gene, True, False)
        self.compute_position(-1,0, 450)
        self.set_position(140)

        self.set_position(int(config.get("window","pos_organizer")))


        self.last_selected = config.getint("setting","media_organizer_item")
        self.current_source=None

        #For automatic selection when drag drop (not enabled for now)
        self.id_motion_drag=None
        self.motion_drag_current_path=None

        self.populate()

    def on_button_press_event(self, widget, event):
        if event.button == 3:
            model, iter = self.treeview_organizer.get_selection().get_selected()
            if iter!=None:
               source = self.model.get_value(iter, 1)
               if source.menu!=None:
                  source.menu.popup(None,None,None,event.button,event.time)
                  return True


    def on_key_press(self, widget, event):
        model, iter = self.treeview_organizer.get_selection().get_selected()
        if iter!=None:
           source = self.model.get_value(iter, 1)
           source.on_key_press( widget, event)




    """""""""""""""""""""
        FUNC POPULATE
    """""""""""""""""""""
    def populate_cdrom(self,widget,info):
        if len(info)>0:
            item = {}
            #item["name"] = self.list_label[CDROM]+": "
            item["name"] = info[0]["album"]
            item["info"] = info
            self.model.append((item,CDROM))


    def remove_cdrom(self,widget,info):
        if len(info)<=0:
            for row in self.model:
                iter = row.iter
                if row[1]==CDROM :
                    self.model.remove(iter)

    def ipod_added(self,widget,device_udi,run_source=True):

        try:
            import gpod
        except:
            pass
        else:
            #print "ipod found: "    ,device_udi
            mount_point  = self.hal.get_ipod_mount_point( device_udi )
            size  = self.hal.get_ipod_total_size( device_udi )
            #print "mount point is: "    ,mount_point
            if mount_point!="":
                ipod = IPod(mount_point,device_udi,size)
                if ipod.read():
                    source1 = IPodSource(self,ipod,device_udi)
                    source2 = IPodPlaylistSource(self,ipod,device_udi)
                    self.list_source.append(source1)
                    self.list_source.append(source2)
                    if run_source:
                        self.vbox_gene.pack_start(source1.get_widget())
                        self.vbox_gene.pack_start(source2.get_widget())
                        source1.load()
                        source2.load()
                        source1.run()
                        source2.run()
                        self.populate()
                else:
                    pass

    def ipod_removed(self,widget,device_udi):
        try:
            import gpod
        except:
            pass
        else:
            for source in self.list_source:
                if isinstance(source,IPodSource) and source.device_udi == device_udi:
                    del self.list_source[self.list_source.index(source)]
            for source in self.list_source:
                if isinstance(source,IPodPlaylistSource) and source.device_udi == device_udi:
                    del self.list_source[self.list_source.index(source)]
            self.populate()

    def media_organizer_changed_cb(self,widget,info):
        self.populate()

    def populate(self,row_to_select=None):
        if row_to_select == None:
            row_to_select =  self.last_selected

        self.treeview_organizer.set_model(None)
        self.model.clear()
        first = True
        for source in self.list_source:
            if source.show():
                if not first and ( isinstance(source,MLBrowserSource) or \
                                   isinstance(source,IPodSource)):
                    self.model.append((None,None))
                for element in source.get_elements_source():
                    self.model.append((element,source))
                    first = False
                if not first and ( isinstance(source,LocalPlaylistSource) or \
                                   isinstance(source,IPodPlaylistSource)):
                    self.model.append((None,None))
                    first=True

        self.treeview_organizer.set_model(self.model)

        if row_to_select>len(self.model):
            row_to_select = 0
        gobject.idle_add(self.treeview_organizer.get_selection().select_path,row_to_select)

    """""""""""""""""""""""""""
        FUNC DRAG DROP
    """""""""""""""""""""""""""
    #For automatic selection when drag drop (not enabled for now)
    def on_drag_motion(self,widget, drag_context, x, y, timestamp):
        drop_info = self.treeview_organizer.get_dest_row_at_pos(x, y)
        if drop_info:
            path, position = drop_info
            path = path[0]
            if position == gtk.TREE_VIEW_DROP_AFTER:
                path += 1
            if self.motion_drag_current_path==None or self.motion_drag_current_path!=path:
                self.motion_drag_current_path = path
                if self.id_motion_drag!=None:
                    gobject.source_remove(self.id_motion_drag)
                    self.id_motion_drag=None
                self.id_motion_drag = gobject.timeout_add(TIME_BEFORE_AUTOSELECT,self.treeview_organizer.get_selection().select_path,self.motion_drag_current_path)


    def on_media_organizer_drag_data_received(self,treeview, context, x, y, selection, info, timestamp):
        drop_info = treeview.get_dest_row_at_pos(x, y)
        model = treeview.get_model()
        #print selection.get_uris()
        if drop_info:
            path, position = drop_info
            path = path[0]
            if position == gtk.TREE_VIEW_DROP_AFTER:
                path += 1
        else:
            return

        iter = model.get_iter(path)
        element = self.model.get_value(iter, 0)
        if element== None:
            return
        source = self.model.get_value(iter, 1)

        list_song = []
        if context.get_source_widget()==None :
            for uri in selection.get_uris():
                uri = urllib.unquote(uri)
                song = DBManager.get_song_by_uri(uri)
                if song!=None and not song.iradio:
                   list_song.append(song)
        else:
            tmp = self.get_toplevel().last_drag_drop
            tmp.reverse()
            list_song = []
            for song in tmp:
                if song!=None and not song.iradio:
                    list_song.append(song)


        source.on_drag_song_received(element["arg_element"],list_song)

    def on_media_organizer_drag_data_get(self,treeview, context, selection, info, timestamp):

        #on laisse finir d'afficher lea liste des chansons
        while gtk.events_pending():gtk.main_iteration()
        self.get_toplevel().last_drag_drop = []
        model, iter = self.treeview_organizer.get_selection().get_selected()
        if iter!=None:
            element = self.model.get_value(iter, 0)
            if element== None:
                return False
            source = self.model.get_value(iter, 1)
            return source.on_drag_data_get(selection,element["arg_element"])

        else:
            return False


    """""""""""""""""""""
        SELECTION
    """""""""""""""""""""
    def on_row_activated(self,treeview, path, view_column):
        model, iter = self.treeview_organizer.get_selection().get_selected()
        element = self.model.get_value(iter, 0)
        if element== None:
            return False
        source = self.model.get_value(iter, 1)
        return source.on_activate(element["arg_element"])

    def on_row_selected(self,treeselection):
        model, iter = self.treeview_organizer.get_selection().get_selected()


        if self.id_motion_drag!=None:
            gobject.source_remove(self.id_motion_drag)
            self.id_motion_drag=None
            self.motion_drag_current_path=None

        if iter is None:
            return
            gobject.idle_add(self.treeview_organizer.get_selection().select_path,0)
            return
        source = self.model.get_value(iter, 1)
        if source == None:
            return False

        self.last_selected = model.get_path(iter)[0]
        element_source = self.model.get_value(iter, 0)

        self.show_source(source)

        source.populate(element_source["arg_element"])


    def show_source(self,source):
        if self.current_source!=None:
            self.current_source.get_widget().hide()
        self.current_source = source
        self.current_source.get_widget().show()

    def select_source(self,source):
        #self.show_source(source)
        def select(model, path, iter,source):
            if source == self.model.get_value(iter, 1):
                self.treeview_organizer.get_selection().select_path(path)


        self.model.foreach(select,source)

    def unselect(self):
        self.treeview_organizer.get_selection().unselect_all()

    """""""""""""""""""""""
        CELL RENDER FUNC
    """""""""""""""""""""""
    def cell_data_func(self, column, cell, model, iter):

        element = model.get_value(iter, 0)
        cell.set_property("text", None)
        if element == None:
            cell.set_property("markup", None)
            cell.set_property("height",0)
            cell.set_property("sensitive",0)
        else:
            cell.set_property("markup", element["label"])
            cell.set_property("height",28)
            cell.set_property("sensitive",1)




    def cell_data_func_icon(self, column, cell, model, iter):
        element = model.get_value(iter, 0)
        if element == None:
            cell.set_property("pixbuf",  empty_pixbuf)
            cell.set_property("stock-id", None)
            cell.set_property("sensitive",  0)
        else:
            cell.set_property("height",0)
            cell.set_property("sensitive",  1)
            if element["image"]==None:
                cell.set_property("stock-id", element["stock-id"])
                cell.set_property("stock-size", element["stock-size"])
                cell.set_property("pixbuf", None)
            else:
                cell.set_property("stock-id", None)
                cell.set_property("pixbuf", element["image"])


    def save_config(self):
        if self.ipod_transfert_manager.ipod_update_cover or\
                self.ipod_transfert_manager.ipod_is_in_transfer:
            self.ipod_transfert_manager.cancel_tranfert()


        for source in self.list_source:
            source.save_config()
        config.set("setting","media_organizer_item","%d"%self.last_selected)









