###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk

try: import gpod
except: pass

from context_local import *
from context_web import *
from view_local_library import LocalLibraryBrowserView
from view_playlist import *
from view_ipod import *
from view_iradio import *
#from view_audioconvert import *
from view_podcast import *

from db_manager import DBManager
from misc_widget import WindowBase
from misc_widget import WindowMessage
from thread_queue import ListenThreadQueue

class MediaSource:
    def __init__(self,widget,media_organizer):
        self.media_organizer = media_organizer
        self.widget = widget
        self.widget.show_all()
        self.widget.set_no_show_all(True)
        self.widget.hide()
        self.show_quick_search = True
        self.image = self.get_pixbuf_from_stock(stock.SRC_BIBLIO)

        #listen.py file launches run() for each source loaded
        #begining with high priority, and finishing with low priority
        self.startup_priority = 5
        self.menu = self.get_menu()

    def show(self):
        return True

    def make_element(self):
        info = {}
        info["label"] = "No label"
        info["arg_element"]={}
        info["image"] = self.image
        info["stock-id"] = None
        info["stock-size"] = None
        return info

    def get_elements_source(self):
        return []

    def populate(self, arg_element):
        pass

    def get_widget(self):
        return self.widget

    def run(self):
        pass

    def load(self,DB=DBManager):
        pass

    def stop(self):
        pass

    def save_config(self):
        pass

    def on_drag_song_received(self,arg_element,song):
        return False

    def on_drag_data_get(self,selection,arg_element):
        return False

    def get_menu(self):
        return None

    def on_key_press(self, widget, event):
        pass

    def on_activate(self,arg_element):
        pass

    def get_pixbuf_from_stock(self,stock):
        return self.media_organizer.treeview_organizer.render_icon(stock_id=stock,size=gtk.ICON_SIZE_LARGE_TOOLBAR,detail=None)


class MLBrowserSource(MediaSource):
    def __init__(self,media_organizer):
        widget = LocalLibraryBrowserView(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_BIBLIO)
        self.startup_priority = 20

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["label"] = utils.xmlescape(_("Library"))
        return [info]

    def show(self):
        return config.get("mediasource","locallib")=="1"

    def load(self,DB):
        self.widget.refresh_song_cache(DB)

    def run(self):
        self.widget.populate_view()

        #Fecthing all album covers as a background task

        self.cover_queue = ListenThreadQueue(10)
        for song in self.widget.songs_cache:
            if song.get_album_cover(False) == config.DEFAULT_ALBUM_COVER:
                def get_cover(song):
                    print "Cover fetched: ",song.get_album_cover()
                self.cover_queue.add_task(get_cover,song)
        #self.cover_queue.run()


    def stop(self):
        #self.cover_queue.stop()
        pass

    def save_config(self):
        self.widget.save_config()

        """def get_menu(self):
        menu_ui = "" "
        <ui>
            <popup name="MlMenu">
              <menuitem action="Playlist"/>
              <menuitem action="Refresh"/>
              <separator/>
              <menuitem action="Reload"/>
              <menuitem action="Delete"/>
              <separator/>
              <menuitem action="Burn"/>
              <menuitem action="Export"/>
            </popup>
        </ui>
        "" "
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this playlist'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this playlist'), self.enqueue_selected)])

        actiongroup.add_actions([('Rename', gtk.STOCK_EDIT, _('_Rename'), None,
                                         _('Rename this playlist'), self.rename_selected)])

        actiongroup.add_actions([('Delete', gtk.STOCK_DELETE, _('_Delete'), None,
                          _('Delete this playlist'), self.remove_selected)])

        actiongroup.add_actions([('Export', gtk.STOCK_SAVE_AS, _('_Export'), None,
                                         _('Export this playlist'), self.export_selected)])
        actiongroup.add_actions([('Burn', gtk.STOCK_CDROM, _('_Burn'), None,
                                         _('Burn this playlist'), self.burn)])


        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/MlMenu")
        """
class ContextSource(MediaSource):
    def __init__(self,media_organizer):
        widget = ListenHome(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(gtk.STOCK_HOME)
        self.startup_priority = -10

    def show(self):
        return config.get("mediasource","context")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("Context"))
        return [info]

    def run(self):
        self.widget.refresh()



class ContextCurrentSource(MediaSource):
    def __init__(self,media_organizer):
        widget = ListenInformation(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(gtk.STOCK_INFO)

    def show(self):
        return config.get("mediasource","current")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("Current"))
        return [info]

class ContextLyricsSource(MediaSource):
    def __init__(self,media_organizer):
        widget = ListenLyrics(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_LYRICS)

    def show(self):
        return config.get("mediasource","lyrics")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("Lyrics"))
        return [info]

class ContextWikipediaSource(MediaSource):
    def __init__(self,media_organizer):
        widget = ListenWikiPedia(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_WIKIPEDIA)

    def show(self):
        return config.get("mediasource","wikipedia")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("Wikipedia"))
        return [info]

class ContextLastFmSource(MediaSource):
    def __init__(self,media_organizer):
        widget = ListenLastFmService(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_LASTFM)

    def show(self):
        return config.get("mediasource","lastfm")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("Last.fm"))
        return [info]

"""class AudioConvertSource(MediaSource):
    def __init__(self,media_organizer):
        widget = AudioConvert(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(gtk.STOCK_EDIT)
        self.show_quick_search = False

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("Audio converter"))
        return [info]


    def on_drag_song_received(self,arg_element,list_song):
        for song in list_song:
            self.widget.convert_view.add_song(song)
"""


class LocalPlaylistSource(MediaSource):
    def __init__(self,media_organizer):
        self.view = TreeviewSongPlaylist(media_organizer)
        widget =  get_scrolled_window(self.view)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_PLAYLIST)
        self.current_playlist = None

    def show(self):
        return config.get("mediasource","locallib")=="1"

    def get_elements_source(self):

        playlists = DBManager.get_playlists()
        list_element = []
        for playlist in playlists:
            if playlist["name"]=="__autosaved__":
                continue
            info =  MediaSource.make_element(self)
            info["arg_element"] = {"id":playlist["id"]}
            info["label"] = utils.xmlescape(playlist["name"])
            info["image"] = self.image
            list_element.append(info)

        return list_element

    def populate(self,arg_element):
        self.current_playlist = arg_element["id"]
        self.view.populate(arg_element["id"])


    def on_drag_song_received(self,arg_element,list_song):
        for song in list_song:
            DBManager.add_song_to_playlist(song,arg_element["id"])
        if self.current_playlist == arg_element["id"]:
            self.view.populate(arg_element["id"])



    def on_drag_data_get(self,selection,arg_element):
        list_uri = []
        list_song = []
        for row in self.view.model_song:
            song = row[0]
            list_song.append(song)
            uri = song.get_property("uri")
            uri = utils.convert_to_uri(uri)
            list_uri.append(uri)

        self.media_organizer.get_toplevel().last_drag_drop = list_song
        selection.set_uris(list_uri)


    def on_key_press(self, widget, event):
        if event.keyval == gtk.gdk.keyval_from_name("Delete"):
            self.remove_selected()
            return True

    def on_activate(self,arg_element):
        self.play_selected(None)

    def export_selected(self,btn=None):
        saver = gtk.FileChooserDialog(_("Export playlist"),
                                           None,
                                           gtk.FILE_CHOOSER_ACTION_SAVE,
                                           None)
        saver.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
        saver.add_button(gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE)

        saver.set_current_folder(os.path.expanduser("~"))
        saver.set_current_name("*.m3u")

        ffilter = gtk.FileFilter()
        ffilter.set_name(_("M3U files"))
        ffilter.add_mime_type("audio/mpegurl")
        ffilter.add_mime_type("audio/x-mpegurl")
        ffilter.add_mime_type("audio/m3u")
        ffilter.add_pattern("*.m3u")
        saver.add_filter(ffilter)
        response = saver.run()
        if response ==  gtk.RESPONSE_OK:
            list_song = list ([ item[0] for item in self.view.model_song])
            utils.export_playlist(saver.get_filename(),list_song)
        saver.destroy()



    def remove_selected(self,btn=None):
        DBManager.delete_playlist(self.current_playlist)
        #Repopulate mediaorganizer
        self.media_organizer.populate()


    def play_selected(self,btn):
        #while gtk.events_pending():gtk.main_iteration()
        play = True
        for row in self.view.model_song:
            self.media_organizer.player.playlist.add_song(row[0],False,play)
            play = False

    def enqueue_selected(self,btn):
        for row in self.view.model_song:
            self.media_organizer.player.playlist.add_song(row[0],False,False)


    def rename_selected(self,btn=None):
        info = DBManager.get_playlists("id=%d"%self.current_playlist)
        info = info[0]

        dialog = WindowBase(_("Rename playlist"),config.PIXMAP_DIR+"/playlist_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)
        if info["name"]=="__searchresult__":
            name="playlist"
        else:
            name = info["name"]
        self.entry.set_text(name)
        self.entry.grab_focus()
        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            text = self.entry.get_text()
            if text!="":
                DBManager.rename_playlist(self.current_playlist,text)
                self.media_organizer.populate()

        dialog.destroy()

    def burn(self,widget=None):
        if not utils.iscommand("serpentine"):
            WindowMessage(_("Serpertine not found"),_("You must install serpentine to burn AudioCD"))
            return
        list_song = []
        for row in self.view.model_song:
            list_song.append(row[0])
        utils.export_playlist("/tmp/listen_burn_list.m3u",list_song)
        os.spawnlp(os.P_NOWAIT, "serpentine","serpentine","-o","/tmp/listen_burn_list.m3u")

    def get_menu(self):
        menu_ui = """
        <ui>
            <popup name="PlaylistMenu">
              <menuitem action="Play"/>
              <menuitem action="Queue"/>
              <separator/>
              <menuitem action="Rename"/>
              <menuitem action="Delete"/>
              <separator/>
              <menuitem action="Burn"/>
              <menuitem action="Export"/>
            </popup>
        </ui>
        """
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this playlist'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this playlist'), self.enqueue_selected)])

        actiongroup.add_actions([('Rename', gtk.STOCK_EDIT, _('_Rename'), None,
                                         _('Rename this playlist'), self.rename_selected)])

        actiongroup.add_actions([('Delete', gtk.STOCK_DELETE, _('_Delete'), None,
                          _('Delete this playlist'), self.remove_selected)])

        actiongroup.add_actions([('Export', gtk.STOCK_SAVE_AS, _('_Export'), None,
                                         _('Export this playlist'), self.export_selected)])
        actiongroup.add_actions([('Burn', gtk.STOCK_CDROM, _('_Burn'), None,
                                         _('Burn this playlist'), self.burn)])


        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/PlaylistMenu")


class IRadioSource(MediaSource):
    def __init__(self,media_organizer):
        self.view = TreeviewSongIRadio(media_organizer)
        widget = get_scrolled_window(self.view)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_IRADIO)
        self.startup_priority = 5

    def show(self):
        return config.get("mediasource","iradio")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["image"] = self.image
        info["label"] = utils.xmlescape(_("iRadio"))
        return [info]

    def load(self,DB):
        self.view.refresh_songs_cache(DB)

    def run(self):
        self.view.populate()


class IPodSource(MediaSource):
    def __init__(self,media_organizer,ipod,device_udi):
        self.ipod = ipod
        self.device_udi = device_udi
        widget = IPodBrowserView(media_organizer,ipod)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_IPOD)
        self.startup_priority = 9

    def show(self):
        return config.get("mediasource","ipod")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["label"] = utils.xmlescape(self.ipod.get_ipod_name())
        return [info]

    def load(self,DB=None):

        self.widget.refresh_song_cache()

    def run(self):
        self.widget.populate_view()

    def save_config(self):
        self.widget.save_config()

    def on_drag_song_received(self,arg_element,list_song):

        if not self.media_organizer.ipod_transfert_manager.ipod_update_cover:
            for song in list_song:
                self.media_organizer.ipod_transfert_manager.add_transfert_queue(song,self.ipod,None)
        else:
            WindowMessage(_("<b>Another work in progress on iPod</b>"),\
                           _("Wait for it to finish and try again"))




    def new_playlist(self,btn=None):
        dialog = WindowBase(_("New iPod playlist"),config.PIXMAP_DIR+"/playlist_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)
        self.entry.grab_focus()
        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            text = self.entry.get_text()
            if text!="":
                self.ipod.create_playlist(text)
                self.media_organizer.populate()

        dialog.destroy()

    def rename_ipod(self,btn=None):
        dialog = WindowBase(_("iPod Property"),config.PIXMAP_DIR+"/ipod_big.png")

        dialog.label_heading.set_markup("<span size=\"large\"><b>iPod "+self.ipod.ipod_version+" ("+utils.str_size(self.ipod.size,0,1000)+")</b></span>")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)

        used = utils.du(self.ipod.mount_point)
        free = self.ipod.size - used

        frac = float(used) / float(self.ipod.size)
        print frac
        progress = gtk.ProgressBar()
        progress.set_fraction(frac)
        progress.set_text("%s Free space"%utils.str_size(used,1))
        self.entry.set_text(self.ipod.get_ipod_name())
        self.entry.grab_focus()
        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.add_widget(progress)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            text = self.entry.get_text()
            if text!="":
                self.ipod.set_ipod_name(text)
                self.media_organizer.populate()

        dialog.destroy()

    def update_cover(self,btn):
        if not self.media_organizer.ipod_transfert_manager.ipod_is_in_transfer:
            self.media_organizer.ipod_transfert_manager.start_refresh_cover(self.ipod)
        else:
            WindowMessage(_("<b>Another work in progress on iPod</b>"),\
                       _("Wait for it to finish and try again"))


    def get_menu(self):
        if self.ipod.artwork_support:
            menu_ui = """
            <ui>
                <popup name="IpodMenu">
                  <menuitem action="Property"/>
                  <menuitem action="New"/>
                  <menuitem action="Cover"/>
                </popup>
            </ui>
            """
        else:
            menu_ui = """
            <ui>
                <popup name="IpodMenu">
                  <menuitem action="Property"/>
                  <menuitem action="New"/>
                </popup>
            </ui>
            """
        #<menuitem action="Rename"/>
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('New', gtk.STOCK_NEW, _('New playlist'), None,
                                         _('New playlist'), self.new_playlist)])
        actiongroup.add_actions([('Property', gtk.STOCK_EDIT, _('iPod Property'), None,
                                         _('iPod Property'), self.rename_ipod)])

        if self.ipod.artwork_support:
            actiongroup.add_actions([('Cover', gtk.STOCK_REFRESH, _('Update Cover'), None,
                                         _('Update Cover'), self.update_cover)])



        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/IpodMenu")

class IPodPlaylistSource(MediaSource):
    def __init__(self,media_organizer,ipod,device_udi):
        self.device_udi = device_udi
        self.view = IPodPlaylistSongview(media_organizer,ipod)
        widget = get_scrolled_window(self.view)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_PLAYLIST_IPOD)
        self.image_podcast = self.get_pixbuf_from_stock(stock.SRC_PODCAST_IPOD)
        self.startup_priority = 9
        self.ipod = ipod
        self.current_playlist = None

    def show(self):
        return config.get("mediasource","ipod")=="1"

    def get_elements_source(self):
        list_playlist = self.ipod.get_all_playlist()
        list_item = []
        for playlist in list_playlist:
            info =  MediaSource.make_element(self)
            info["label"] = utils.xmlescape(playlist.name)
            if gpod.itdb_playlist_is_podcasts(playlist):
                info["image"]=self.image_podcast

            info["arg_element"] = {"playlist":playlist}
            list_item.append(info)
        return list_item

    def run(self):
        if self.widget.get_property("visible") and self.current_playlist!=None:
            self.view.populate(self.current_playlist)

    def populate(self,arg_element):
        self.current_playlist = arg_element["playlist"]
        self.view.populate(arg_element["playlist"])

    def on_drag_data_get(self,selection,arg_element):
        list_uri = []
        list_song = []
        for song in self.ipod.get_song_from_playlist(arg_element["playlist"]):
            list_song.append(song)
            uri = song.get_property("uri")
            uri = utils.convert_to_uri(uri)
            list_uri.append(uri)

        self.media_organizer.get_toplevel().last_drag_drop = list_song
        selection.set_uris(list_uri)

    def on_drag_song_received(self,arg_element,list_song):

        if not self.media_organizer.ipod_transfert_manager.ipod_update_cover:
            for song in list_song:
                self.media_organizer.ipod_transfert_manager.add_transfert_queue(song,self.ipod,arg_element["playlist"])
        else:
            WindowMessage(_("<b>Another work in progress on iPod</b>"),\
                       _("Wait for it to finish and try again"))

    def rename_playlist(self,btn=None):
        dialog = WindowBase(_("Rename playlist"),config.PIXMAP_DIR+"/playlist_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)

        self.entry.set_text(self.current_playlist.name)
        self.entry.grab_focus()
        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            text = self.entry.get_text()
            if text!="":
                self.ipod.rename_playlist(self.current_playlist,text)
                self.media_organizer.populate()

        dialog.destroy()

    def new_playlist(self,btn=None):
        dialog = WindowBase(_("New iPod playlist"),config.PIXMAP_DIR+"/playlist_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)
        self.entry.grab_focus()
        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            text = self.entry.get_text()
            if text!="":
                self.ipod.create_playlist(text)
                self.media_organizer.populate()

        dialog.destroy()

    def remove_playlist(self,btn=None):
        self.ipod.remove_playlist(self.current_playlist)
        self.media_organizer.populate()

    def get_menu(self):
        menu_ui = """
            <ui>
                <popup name="IpodMenu">
                  <menuitem action="New"/>
                  <menuitem action="Rename"/>
                  <menuitem action="Delete"/>
                </popup>
            </ui>
            """

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('New', gtk.STOCK_NEW, _('New playlist'), None,
                                         _('New playlist'), self.new_playlist)])
        actiongroup.add_actions([('Rename', gtk.STOCK_EDIT, _('Rename'), None,
                                         _('Rename this playlist'), self.rename_playlist)])
        actiongroup.add_actions([('Delete', gtk.STOCK_EDIT, _('Delete'), None,
                                         _('Delete this playlist'), self.remove_playlist)])



        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/IpodMenu")

class PodcastSource(MediaSource):
    def __init__(self,media_organizer):
        widget = PodcastBrowserView(media_organizer)
        MediaSource.__init__(self,widget,media_organizer)
        self.image = self.get_pixbuf_from_stock(stock.SRC_PODCAST)
        self.startup_priority = 8

    def show(self):
        return config.get("mediasource","podcast")=="1"

    def get_elements_source(self):
        info =  MediaSource.make_element(self)
        info["label"] = utils.xmlescape(_("Podcasts"))
        return [info]

    def load(self,DB):
        self.widget.refresh_cache(DB)

    def run(self):
        self.widget.populate()
        def refresh_cb():
            gobject.idle_add(self.widget.refresh_all)
            gobject.timeout_add(int(float(config.get("podcast","time_refresh")))*60*100,refresh_cb)
            return False
        if config.get("podcast","startup")=="true":
            gobject.idle_add(refresh_cb)
        else:
            gobject.timeout_add(int(float(config.get("podcast","time_refresh")))*60*100,refresh_cb)

    def populate(self,arg_element):
        #self.widget.populate()
        pass
