###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import urllib
from xml.dom import minidom
import time
from datetime import datetime
import locale
import gobject
import os
from mimetools import Message

import utils
from db_manager import DBManager
from thread_queue import *
from song import *

DEBUG = False
WATCHER_TIME = 1500

podcast_path = os.path.expanduser(config.get("podcast","folder")+"/")
if not os.path.isdir(os.path.dirname(podcast_path)):
    os.makedirs(os.path.dirname(podcast_path))

""" A podcast manager class """
class PodcastManager(gobject.GObject):
    __gsignals__ = {
        "podcast-updated" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))
    }
    def __init__(self):
        gobject.GObject.__init__(self)
        self.error = ""

        self.rss = {}
        self.feed_task_pool={}
        self.thread_feed_queue = ListenThreadQueue(5)
        self.id_feed_watcher = None

        self.podcast_uri_pool={}
        self.podcast_task_pool={}
        self.current_podcast_ratio = 1
        self.thread_podcast_queue = ListenThreadQueue(1)
        self.id_podcast_watcher = None


    def debug(self,*param):
        if DEBUG: print "PodcastManager: ",param


    """ Start the podcast Manager """
    def start(self):
        self.thread_feed_queue.run()
        self.thread_podcast_queue.run()
        self.is_running = True
        self.debug("Podcast Manager Started ")

    """ Stop all activity in Podcast manager """
    def stop(self):
        if self.id_podcast_watcher != None:
            gobject.source_remove(self.id_podcast_watcher)
        if self.id_feed_watcher != None:
            gobject.source_remove(self.id_feed_watcher)
        self.is_running = False
        self.thread_podcast_queue.kill()
        self.thread_feed_queue.kill()
        self.debug("Podcast Manager Stopped ")

    """
    Remove a podcast if their are in download queue
    And stop it if it currently download
    """
    def remove_podcast(self,song_to_remove):
        self.debug("Podcast try remove ",song_to_remove.get_property("uri"))

        """ Remove podcast from the uri pool """
        if self.podcast_uri_pool.has_key(song_to_remove.get_property("uri")):
            del self.podcast_uri_pool[song_to_remove.get_property("uri")]
        task_to_delete = []
        """ Remove podcast from the task pool """
        for task, song in self.podcast_task_pool.iteritems():
            if song == song_to_remove:
                if task in self.thread_podcast_queue.current_task:
                    """ stop current task """
                    self.is_running = False
                    while not self.thread_podcast_queue.is_finish(task):
                        pass
                    self.is_running = True
                    self.current_ratio = 1

                self.debug("Removed successfully")

                self.thread_podcast_queue.remove_task(task)
                task_to_delete.append(task)
            else:
                self.debug("Not in queue")

        for task in task_to_delete:
            if self.podcast_task_pool.has_key(task):
                del self.podcast_task_pool[task]
        if len(self.podcast_task_pool)==0 and self.id_podcast_watcher != None:
            gobject.source_remove(self.id_podcast_watcher)
            self.id_podcast_watcher = None

    """ Add a podcast to the download queue """
    def download_podcast(self,song):
        uri = song.get_property("podcast_local_uri")
        """ Check is not already downloaded """
        if uri!=None and uri!="" and os.path.exists(utils.get_path(uri)):
            return
        else:
            """ Check podcast is not already in the pool """
            if self.podcast_uri_pool.has_key(song.get_property("uri")):
                return
            song.set_property("podcast_local_uri",None)
            self.podcast_uri_pool[song.get_property("uri")]=song
            id_task = self.thread_podcast_queue.add_task(self.download_podcast_cb,song)
            self.podcast_task_pool[id_task]=song
            self.debug("Podcast download ",song.get_property("uri"))


            if self.id_podcast_watcher != None: gobject.source_remove(self.id_podcast_watcher)
            self.id_podcast_watcher = gobject.timeout_add(WATCHER_TIME,self.downloader_podcast_watcher)

    """
    Function that check if podcast have been donwload
    Update DB when found own and emit message podcast-updated
    """
    def downloader_podcast_watcher(self):
        self.debug("Podcast watch")
        """ Catch Except if pool modified while check task is finish """
        task_to_delete = []
        try:
            for task, song in self.podcast_task_pool.iteritems():
                if self.thread_podcast_queue.is_finish(task) :
                    self.debug("Podcast watcher catch ",song.get_property("uri"))
                    DBManager.update_song(song)
                    task_to_delete.append(task)
                    self.emit("podcast-updated",[song])
        except RuntimeError: return True
        for task in task_to_delete:
            if self.podcast_task_pool.has_key(task):
                del self.podcast_task_pool[task]

        if len(self.podcast_task_pool)==0:
            return False
        else:
            return True


    """
    Threaded fonction to download the podcast
    """
    def download_podcast_cb(self,song):
        podcast_path = os.path.expanduser(config.get("podcast","folder")+"/")
        podcast_path += song.get_property("podcast_feed_title")+"/"
        if not os.path.isdir(os.path.dirname(podcast_path)):
            os.makedirs(os.path.dirname(podcast_path))
        podcast_path += song.get_filename()

        """ Check not already exist """
        if not os.path.exists(podcast_path):
            """ Download it """
            try: sock = urllib.urlopen(song.get_property("uri"))
            except:print "Podcast load failed, ",song.get_property("uri")
            else:
                BLOCKSIZE = 32*1024
                file = open(podcast_path, "w")
                headers = sock.info()
                size = headers.getheader("Content-Length")
                if size==None:
                    #FIXME :better size
                    size=10000000
                data = sock.read(BLOCKSIZE)
                num_block = 1
                while self.is_running and data:
                    self.current_podcast_ratio = float(num_block*BLOCKSIZE)/float(size)
                    #print self.current_ratio
                    file.write(data)
                    data = sock.read(BLOCKSIZE)
                    num_block +=1
                self.current_podcast_ratio = 1
                file.close()
                sock.close()
        if self.is_running:
            tmp = Song()
            tmp.set_property("uri","file://"+podcast_path)
            tmp.read_from_file()
            song.set_property("duration",tmp.get_property("duration"))
            song.set_property("podcast_local_uri","file://"+podcast_path)
            if self.podcast_uri_pool.has_key(song.get_property("uri")):
                del self.podcast_uri_pool[song.get_property("uri")]
            self.debug("Podcast download finish: ",song.get_property("uri"))
        else:
            os.unlink(podcast_path)


    """
    Download or refresh a podcast feed
    """
    def download_podcast_feed(self,uri):
        for key,value in self.feed_task_pool.iteritems():
            if uri==value:
                return
        id_task = self.thread_feed_queue.add_task(self.download_podcast_feed_cb,uri)
        self.feed_task_pool[id_task] = uri
        self.debug("Feed download ",uri)
        if self.id_feed_watcher != None: gobject.source_remove(self.id_feed_watcher)
        self.id_feed_watcher = gobject.timeout_add(WATCHER_TIME,self.downloader_podcast_feed_watcher)

    """
    Remove a podcast feed if their are in download queue
    """
    def remove_podcast_feed(self,uri_to_remove):
        self.debug("Feed try remove ",uri_to_remove)
        task_to_delete = []
        """ Remove podcast feed from the task pool """
        for task, uri in self.feed_task_pool.iteritems():
            if uri == uri_to_remove:
                if task in self.thread_feed_queue.current_task:
                    """ stop current task """
                    #self.is_running = False
                    while not self.thread_feed_queue.is_finish(task):
                        pass
                    #self.is_running = True
                    self.current_ratio = 1
                    self.debug("Remove succecesful",uri_to_remove)

                self.thread_queue.remove_task(task)
                task_to_delete.append(task)
            else:
                self.debug("Not in queue",uri_to_remove)

        for task in task_to_delete:
            if self.feed_task_pool.has_key(task):
                del self.feed_task_pool[task]

        if len(self.feed_task_pool)==0 and self.id_feed_watcher != None:
            gobject.source_remove(self.id_feed_watcher)
            self.id_feed_watcher = None
    """
    Function that check if podcast feed have been donwload
    Update DB when found own and emit message podcast-updated
    """
    def downloader_podcast_feed_watcher(self):
        self.debug("Feed watch")
        """ Catch Except if pool modified while check task is finish """
        task_to_delete = []
        list_song = []
        try:
            for task, uri in self.feed_task_pool.iteritems():
                if self.thread_feed_queue.is_finish(task) :
                    rss = self.rss[uri]
                    if rss!=None:
                        """ if already exist it will be updated """
                        #flux = DBManager.add_podcast_feed(uri,rss["title"],rss["date"],rss["description"],rss["image"])
                        for item in rss["items"]:
                            song = DBManager.get_podcast_by_uri(item["uri"])
                            for key,value in item.iteritems():
                                song.set_property(key,value)
                            song.set_property("date","%d"%item["date"])
                            song.set_property("podcast_feed_uri",uri)
                            song.set_property("podcast_feed_title",rss["title"])
                            song.set_property("podcast_feed_image",rss["image"])
                            song.set_property("podcast_feed_date",rss["date"])
                            song.set_property("podcast_feed_description",rss["description"])
                            DBManager.update_song(song)
                            list_song.append(song)
                    else:
                        print "Flux invalid"

                    task_to_delete.append(task)
                    self.debug("Feed watcher catch ",uri)
        except RuntimeError:
            return True

        for task in task_to_delete:
            if self.feed_task_pool.has_key(task):
                del self.feed_task_pool[task]
        if len(self.feed_task_pool)==0:
            self.emit("podcast-updated",list_song)
            return False
        else:
            return True


    """ read and download podcast feed to array """
    def download_podcast_feed_cb(self,uri):
        try:
            sock = urllib.urlopen(uri)
            xmldoc = minidom.parse(sock).documentElement
            root_node = xmldoc.getElementsByTagName('channel')[0]
        except:
            print "Podcast feed load failed, ",uri
            self.rss[uri] =  None
            return

        rss = {}
        #root_node = xmldoc.getElementsByTagName('rss')[0]

        rss["title"] = self.get_first_child_value(root_node,"title")
        #rss["uri"] = self.get_first_child_value(root_node,"link")
        rss["description"] = self.get_first_child_value(root_node,"description")
        rss["lastBuildDate"] = utils.strdate_to_time(self.get_first_child_value(root_node,"lastBuildDate"))
        rss["pubDate"] = utils.strdate_to_time(self.get_first_child_value(root_node,"pubDate"))
        """ choose the good date prefer pubDate"""
        if rss["pubDate"]=="":
            rss["date"] = rss["lastBuildDate"]
        else:
            rss["date"] = rss["pubDate"]

        img_node = root_node.getElementsByTagName("image")
        if img_node!=None and len(img_node)>0:
            rss["image"] = self.get_first_child_value(img_node[0],"url")
        else:
            rss["image"] = None

        """ some check """
        if rss["title"]=="" or rss["date"]=="":
            #print rss
            self.rss[uri] =  None
            print "Can't add podcast, no title or date found"
            return


        rss["items"] = []
        items = root_node.getElementsByTagName("item")
        for item in items:
            rss_item = {}
            rss_item["title"] = self.get_first_child_value(item,"title")
            rss_item["link"] = self.get_first_child_value(item,"link")
            rss_item["description"] = self.get_first_child_value(item,"description")
            enclosure_node = self.get_child(item,"enclosure")
            if enclosure_node and len(enclosure_node)>0:
                rss_item["uri"] = enclosure_node[0].getAttribute("url")
                """rss_item["duration"] = enclosure_node[0].getAttribute("length")
                try: rss_item["duration"] = int(rss_item["duration"])
                except: continue"""
            else:
                continue

            rss_item["date"] = utils.strdate_to_time(self.get_first_child_value(item,"pubDate"))

            """ Only feed with tile,date and mp3 uri """
            if rss_item["uri"]!="" and rss_item["title"]!="" and rss_item["date"] !="":
                #Fix me: need see the mimitype because all podcast filename not always finish by the extension
                # and utils.get_ext(rss_item["uri"]) in READ_EXTENTIONS:
                rss["items"].append(rss_item)

        #print rss
        self.rss[uri] = rss
        self.debug("Feed download finish: ",uri);

    """ Some node navigation """
    def get_child(self,node,name):
        return node.getElementsByTagName(name)

    def get_value(self,node):
        if hasattr(node,"firstChild") and node.firstChild!=None:
            return node.firstChild.nodeValue
        else:
            return ""

    def get_first_child_value(self,node,node_name):
        node = self.get_child(node,node_name)
        if node!=None and len(node)>0:
            return self.get_value(node[0])
        else:
            return "";





PodcastManager = PodcastManager()



