###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import gobject
import xml.sax.saxutils
import sre
import os
import threading

import config
from song import Song
from misc_widget import *
from db_manager import *

GEOMETRY= {}
GEOMETRY["advanced"] = (800,600)
GEOMETRY["simple"] = (500,350)

class SongEditor(gtk.Window):
    def __init__(self,win_parent,list_song):
        gtk.Window.__init__(self)

        self.dict_info = {
                      _("Album"): "album",
                      _("File"): "uri",
                      _("Artist"): "artist",
                      "#" : "tracknr",
                      _("Title"):"title",
                      _("Date"):"date",
                      _("Genre"):"genre"
                      }
        self.simple_dict_info = {
                      "title":_("Title"),
                      "album":_("Album") ,
                      "artist":_("Artist") ,
                      "tracknr":_("Track number")  ,
                      "title":_("Title") ,
                      "genre":_("Genre") ,
                      "date":_("Date")
                      }
        self.dict_info_checked = {
                      _("Title"):False,
                      "#" : False,
                      _("Artist"): True,
                      _("Album"): True,
                      _("Genre"): True,
                      _("Date"): True
                      }


        self.win_parent = win_parent
        self.list_song = list_song


        self.tag_have_changed = False

        ##
        #  Advanced view
        ##
        self.model = gtk.ListStore(gobject.TYPE_PYOBJECT)

        self.treeview = gtk.TreeView()
        self.treeview.append_column(self.make_colonne("#"))
        self.treeview.append_column(self.make_colonne(_("Title")))
        self.treeview.append_column(self.make_colonne(_("Artist")))
        self.treeview.append_column(self.make_colonne(_("Album")))
        self.treeview.append_column(self.make_colonne(_("Genre")))
        self.treeview.append_column(self.make_colonne(_("Date")))
        self.treeview.append_column(self.make_colonne(_("File"),False))
        self.treeview.set_model(self.model)

        box_check_btn = self.make_box_check_btn()
        btn_tracknr_fill = gtk.Button(_("Fill track number"))
        btn_tracknr_fill.set_image(gtk.image_new_from_stock(gtk.STOCK_SORT_ASCENDING, gtk.ICON_SIZE_BUTTON))
        btn_tracknr_fill.connect("clicked",self.auto_fill_tracknr)
        #btn_tracknr_fill.add(gtk.image_new_from_icon_name("stock_repeat", gtk.ICON_SIZE_BUTTON))

        right_box = gtk.VBox(False,12)
        right_box.pack_start(box_check_btn,False,False)
        right_box.pack_start(btn_tracknr_fill,False,False)

        hbox = gtk.HBox(False,12)
        hbox.pack_start(get_scrolled_window(self.treeview),True,True)
        hbox.pack_start(right_box,False,False)



        label = gtk.Label(_("Tag by filename"))
        label.set_alignment(0,0.5)

        self.model_completition = gtk.ListStore(gobject.TYPE_STRING)

        btn = gtk.Button(stock=gtk.STOCK_OK)
        btn.connect("clicked",self.on_tag_by_name)

        self.entry_completition = gtk.EntryCompletion()
        self.entry_completition.set_model(self.model_completition)
        self.entry_completition.set_popup_completion(True)
        self.entry_completition.set_match_func(self.entry_match_func)
        self.entry_completition.set_inline_completion(True)
        self.entry_completition.set_text_column(0)
        self.read_tag_completion()

        self.entry = gtk.Entry()
        self.entry.set_size_request(350,-1)
        self.entry.set_completion(self.entry_completition)
        self.entry.connect("activate",self.on_tag_by_name)

        box_tag_name = gtk.HBox(False,12)
        box_tag_name.pack_start(label,False,False)
        box_tag_name.pack_start(self.entry,False,False)
        box_tag_name.pack_start(btn,False,False)

        self.box_advanced = gtk.VBox(False,12)
        self.box_advanced.pack_start(hbox,True,True)
        self.box_advanced.pack_start(box_tag_name,False,False)

        self.box_advanced.show_all()
        self.box_advanced.set_no_show_all(True)
        self.box_advanced.hide()

        ##
        # POPULATE SONG VIEW
        ##
        for song in list_song:
            #Copie de l'instance de la chanson
            tmp_song = Song()
            tmp_song.read_from_song(song)
            self.model.append((tmp_song,))


        ##
        #    Simple view
        ##
        self.simple_entry = {}
        self.simple_label = {}
        self.box_simple = gtk.Table(4,2)
        self.box_simple.set_row_spacings(12)
        self.box_simple.set_col_spacings(6)
        self.threads_completion = []

        i = 0

        for key in ["title","artist","album","tracknr","genre","date"]:
            label = self.simple_dict_info[key]
            simple_entry_text = ""
            tmp = list([song.sprint(key) for song in list_song])
            for value in tmp:
                if simple_entry_text!="" and simple_entry_text!=value:
                    simple_entry_text=""
                    break
                simple_entry_text = value

            self.simple_entry[key] = self.make_simple_entry(simple_entry_text,key)
            self.simple_label[key] = self.make_simple_label(label)
            if len(list_song)>1 and key in ["tracknr","title"]:
                self.simple_entry[key].set_editable(False)
                self.simple_entry[key].set_sensitive(False)
            self.box_simple.attach(self.simple_label[key],0,1,i,i+1,gtk.FILL,gtk.FILL)
            self.box_simple.attach(self.simple_entry[key],1,2,i,i+1,gtk.EXPAND|gtk.FILL,gtk.FILL)
            i +=1

        self.box_simple.show_all()
        self.box_simple.set_no_show_all(True)

        ##
        #    BUTTON
        ##
        self.progress = gtk.ProgressBar()
        self.progress.set_no_show_all(True)


        progress_box = gtk.VBox()
        progress_box.pack_end(self.progress,False,False)

        btn_apply = gtk.Button(stock=gtk.STOCK_APPLY)
        btn_cancel = gtk.Button(stock=gtk.STOCK_CANCEL)
        btn_save = gtk.Button(stock=gtk.STOCK_SAVE)
        btn_apply.connect("clicked",self.on_apply)
        btn_cancel.connect("clicked",self.on_cancel)
        btn_save.connect("clicked",self.on_save)

        btn_box = gtk.HBox(False,12)
        btn_box.pack_end(btn_save,False,False)
        btn_box.pack_end(btn_cancel,False,False)
        btn_box.pack_end(btn_apply,False,False)
        btn_box.pack_start(progress_box,False,False)


        ##
        #    GLOBAL BOX
        ##
        btn_swicth_mode = gtk.ToggleButton("Advanced mode")
        btn_swicth_mode.set_image(gtk.image_new_from_stock(gtk.STOCK_INFO,gtk.ICON_SIZE_BUTTON))
        btn_swicth_mode.connect("toggled",self.on_change_mode)
        title = _("Edit song informations")

        label_heading = gtk.Label("<span size=\"large\"><b>"+title+"</b></span>")
        label_heading.set_alignment(0,0.5)
        label_heading.set_use_markup(True)

        box_titre = gtk.HBox()
        box_titre.pack_end(btn_swicth_mode,False,False)
        box_titre.pack_start(label_heading,True,True)

        box_contenu = gtk.VBox(False,12)
        box_contenu.pack_start(box_titre,False,False)
        box_contenu.pack_start(self.box_simple,True,True)
        box_contenu.pack_start(self.box_advanced,True,True)
        box_contenu.pack_start(gtk.HSeparator(),False,False)
        box_contenu.pack_start(btn_box,False,False)


        ##
        #    WINDOW
        ##
        self.set_title(title)
        self.set_position(gtk.WIN_POS_CENTER)
        self.set_transient_for(self.win_parent)
        self.set_modal(True)
        self.set_property("skip-taskbar-hint",True)
        self.connect("delete-event",self.on_cancel)

        self.add(box_contenu)
        self.set_border_width(12)
        self.set_size_request(500,-1)
        self.show_all()

        #Fill artist album completion list
        for thread in self.threads_completion:
            thread.start()


    def on_change_mode(self,widget):
        self.box_simple.hide()
        self.box_advanced.hide()
        if widget.get_active():
            width,height = GEOMETRY["advanced"]
            self.box_advanced.show()
        else:
            width,height = GEOMETRY["simple"]
            self.box_simple.show()
        self.resize(width,height)
        self.set_size_request(width,height)

        print width,height
        self.move((gtk.gdk.screen_width() - width)/2, (gtk.gdk.screen_height() - height)/2)


    def make_simple_label(self,label):
        label = gtk.Label(label+" :")
        label.set_alignment(1,0.5)
        return label

    def make_simple_entry(self,text,key):
        entry = gtk.Entry()
        entry.set_text(text)
        entry.connect("changed",self.on_simple_entry_change,key)

        if key in ["album","artist","genre"]:
            model_completition = gtk.ListStore(gobject.TYPE_STRING)
            entry_completition = gtk.EntryCompletion()
            entry_completition.set_popup_completion(True)
            entry_completition.set_inline_completion(True)
            entry_completition.set_text_column(0)
            thread = threading.Thread(target=self.thread_populate_completition,args=(entry,key,model_completition,entry_completition))
            self.threads_completion.append(thread)
        return entry

    def thread_populate_completition(self,entry,key,model_completition,entry_completition):
        #Get a db descripteur only for read
        DB = ListenDBManager()
        if key == "album":
            res = DB.get_albums()
        if key == "artist":
            res = DB.get_artists()
        if key == "genre":
            res = DB.get_genres()
        for row in res:
           model_completition.append((row[key],))
        gobject.idle_add(entry_completition.set_model,model_completition)
        gobject.idle_add(entry.set_completion,entry_completition)


    def on_simple_entry_change(self,widget,key):
        if key=="tracknr":
            try: value = int(widget.get_text())
            except:
                widget.set_text("")
                value = 0
        else:
            value = widget.get_text()
        for path in range(0,len(self.model)):
            song = self.model[path][0]
            song.set_property(key,value)
            self.model[path][0] = song


    """
        ELEMENT
    """
    def make_box_check_btn(self):

        box = gtk.VBox()
        self.check_elem = {}
        label = gtk.Label()
        label.set_markup("<b>"+_("Force identical")+" :</b>")
        label.set_alignment(0,0.5)
        box.pack_start(label,False,False)
        for title,checked in self.dict_info_checked.iteritems():
            if title == "#":
                label = _("Track number")
            else:
                label = title
            self.check_elem[title] = self.make_check_btn(label,checked)
            box.pack_start(self.check_elem[title],False,False)
        return box

    def make_check_btn(self,title,checked):
        check = gtk.CheckButton(title)
        check.set_active(checked)
        return check

    def make_colonne(self,title,editable=True):
        renderer = gtk.CellRendererText()
        renderer.set_property("editable",editable)
        renderer.connect("edited",self.on_edit,title)
        colonne = gtk.TreeViewColumn(title)
        colonne.pack_start(renderer,True)
        colonne.set_cell_data_func(renderer, self.__cell_data_func)
        colonne.set_clickable(True)
        colonne.set_reorderable(True)
        colonne.connect("clicked",self.on_header_clicked)
        return colonne

    """
        ACTION
    """
    def on_header_clicked(self,column):
        title = column.get_title()
        list_song = list([self.model[path][0] for path in range(0,len(self.model))])
        def sort_song(a,b):
            if a.sprint(self.dict_info[title])==b.sprint(self.dict_info[title]):
                return 0
            elif a.sprint(self.dict_info[title])<b.sprint(self.dict_info[title]):
                return -1
            else:
                return 1

        list_song.sort(sort_song)

        self.model.clear()
        for song in list_song:
            self.model.append((song,))


    def on_edit(self,cellrenderertext, path, new_text, title):
        if title == "#" and new_text!="":
            try: new_text = int(new_text)
            except: return
        if self.check_elem[title].get_active():
            for path in range(0,len(self.model)):
                song = self.model[path][0]
                song.set_property(self.dict_info[title],new_text)
                self.model[path][0] = song

        else:
            song = self.model[path][0]
            song.set_property(self.dict_info[title],new_text)
            self.model[path][0] = song


    def auto_fill_tracknr(self,btn):
        n = 1
        for path in range(0,len(self.model)):
            song = self.model[path][0]
            song.set_property("tracknr",n)
            self.model[path][0] = song
            n += 1


    def on_apply(self,btn=None):
        self.tag_have_changed = True
        total = len(self.model)
        self.progress.set_no_show_all(False)
        self.progress.show()
        self.progress.set_fraction(0)
        self.progress.set_text("0/%d"%total)
        error = ""
        for path in range(0,total):
            song = self.model[path][0]
            if not song.write_to_file():
                error += song.last_error+"\n"
                #error += song.sprint("uri")
            else:
                DBManager.update_song(song)

                from media_source import MLBrowserSource
                for source in self.win_parent.media_organizer.list_source:
                    if isinstance(source,MLBrowserSource):
                        """ update song in browser cache """
                        source.widget.update_song(None,song)

            self.progress.set_fraction(round(round(path) /total,2))
            self.progress.set_text("%d/%d"%(path,total))
            while gtk.events_pending(): gtk.main_iteration()
        self.progress.hide()
        self.progress.set_no_show_all(False)
        self.write_tag_completion()
        self.read_tag_completion()
        if error!="":
            WindowMessage(_("Some error while writting song metadata"),error)
            return False
        else:
            return True

    def on_cancel(self,widget=None,event=None):
        self.write_tag_completion()
        self.read_tag_completion()

        if self.tag_have_changed:
            from media_source import MLBrowserSource
            for source in self.win_parent.media_organizer.list_source:
                if isinstance(source,MLBrowserSource):
                    source.widget.populate_view()
        self.destroy()


    def on_save(self,btn=None):
        if self.on_apply():
            self.on_cancel()


    def read_tag_completion(self):
        self.model_completition.clear()
        initial = """\
<tracknr> - <title>
<artist> - <title>
<artist>/<tracknr> - <title>
<artist>/<album>/<tracknr> - <title>""".split("\n")
        f = config.TAG_COMPLETITION_FILE
        if f is not None and not hasattr(f, 'readlines'):
            if os.path.exists(f):
                for line in file(f).readlines():
                    self.completition_append_text(line.strip())
        elif f is not None:
            for line in f.readlines():
                self.completition_append_text(line.strip())
        for c in initial: self.completition_append_text(c)

    def get_completition_text(self):
        return [m[0] for m in self.entry_completition.get_model()]

    def completition_append_text(self,text):
        if text not in self.get_completition_text():
           #if len(self.entry_completition.get_model()) < 10:
           self.model_completition.append((text,))

    def write_tag_completion(self):
        f = config.TAG_COMPLETITION_FILE
        try:
            if not hasattr(f, 'read'):
                if ("/" in f and
                    not os.path.isdir(os.path.dirname(f))):
                    os.makedirs(os.path.dirname(f))
                f = file(f, "w")
            f.write("\n".join(self.get_completition_text()) + "\n")
        except EnvironmentError: pass

    def on_tag_by_name(self,widget=None):
	#Function Based on tagsfrompath.py from quodlibet tag editor Copyright 2004-2005 Joe Wreschnig, Michael Urman, Inigo Serna
	#
        headers = []
        pattern = self.entry.get_text()
        sep = os.path.sep
        slashes = len(pattern) - len(pattern.replace(sep,'')) + 1
	# patterns look like <tagname> non regexy stuff <tagname> ...
        pieces = sre.split(r'(<[A-Za-z0-9_]+>)', pattern)
        for i, piece in enumerate(pieces):
            if not piece: continue
            if piece[0]+piece[-1] == '<>' and piece[1:-1].isalnum():
                piece = piece.lower()   # canonicalize to lowercase tag names
                pieces[i] = '(?P%s.+)' % piece
                headers.append(piece[1:-1].encode("ascii", "replace"))
            else:
                pieces[i] = utils.re_esc(piece)

        if pattern.startswith('<'):
            pieces.insert(0, sep)
        if pattern.endswith('>'):
            pieces.append(r'(?:\.\w+)$')
        pattern = sre.compile(''.join(pieces))
        for path in range(0,len(self.model)):
            song = self.model[path][0]
	    # only match on the last n pieces of a filename, dictated by pattern
	    # this means no pattern may effectively cross a /, despite .* doing so
            matchon = sep+sep.join(utils.fsdecode(song.get_path()).split(sep)[-slashes:])
            match = pattern.search(matchon)
            if match!=None:
                dict_res = match.groupdict()
                for key,value in dict_res.iteritems():
                    if key=="tracknr":
                        try: value = int(value)
                        except:continue
                    else:
                        value = value.replace("_"," ").replace("%20", " ")
                    song.set_property(key,value)
                    self.model[path][0] = song
                self.completition_append_text(self.entry.get_text())



    def entry_match_func(self,completion, key, iter):
        model = completion.get_model()
        text = model.get_value(iter, 0)
        if text==None or text.startswith(key):
          return True
        return False

    def __cell_data_func(self, column, cell, model, iter):
        title = column.get_title()
        song = model.get_value(iter, 0)
        if title == _("File") :
             value = song.get_filename()
        elif title == "#" :
             value = song.sprint("tracknr")
        elif title == _("Title"):
             value = song.sprint("title")
        elif title == _("Artist"):
             value = song.sprint("artist")
        elif title == _("Album")  :
             value = song.sprint("album")
        elif title == _("Genre")  :
             value = song.sprint("genre")
        elif title == _("Date")  :
             value = song.sprint("date")
        else:
             value = ""
        value = utils.xmlescape(value)
        cell.set_property("markup",value)

