###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import sys
import gobject
import traceback
import threading
import time
DEBUG = False
NUMTHREAD = 5

gobject.threads_init()
"""
This class manage all thread in listen
Only NUMTHREAD thread can be lauch in the same time
"""
class ListenThreadQueue:
    def __init__(self,nb_thread = NUMTHREAD):
        self.nb_thread = nb_thread
        self.id_task = 0
        self.thread_pool = []
        self.thread_queue = []
        self.current_task = []
        self.is_running = True
        pass

    """ return true is task are terminated """
    def is_finish(self,id_task_check):
        if id_task_check in self.current_task:
            return False
        for index,task in enumerate(self.thread_queue):
            id_task,func,data_func = task
            if id_task==id_task_check:
                return False
        return True

    """ Add task to execute in a thread """
    def add_task(self,func,*data_func):
        self.id_task +=1
        self.debug("add task",self.id_task)
        self.thread_queue.append((self.id_task,func,data_func))

        return self.id_task

    """ Remove a task in the queue if it always exist """
    def remove_task(self,id_task_to_remove):
        self.debug("demand remove task",id_task_to_remove)
        for index,task in enumerate(self.thread_queue):
            id_task,func,data_func = task
            if id_task==id_task_to_remove:
                self.debug("remove task",id_task)
                del self.thread_queue[index]

    """ launch task task in the queue """
    def process_queue(self):
        self.debug("process started")
        while self.is_running:# and len(self.thread_queue)>0:
            if len(self.thread_queue)>0:
                    """
                try:id_task,func,data_func = self.thread_queue.pop(0)
                except: pass
                else:
                    """
                    id_task,func,data_func = self.thread_queue.pop(0)
                    self.current_task.append(id_task)
                    self.debug("launch task",id_task)
                    try: func(*data_func)
                    except Exception,e:
                        print "Error catched in a thread: "
                        print traceback.format_exc()
                    self.debug("task finish",id_task)
                    del self.current_task[self.current_task.index(id_task)]
            else:
                time.sleep(5)
        self.debug("process stopped")

    """ start NUMTHREAD thread to process the queue """
    def run(self):
        for i in range(self.nb_thread):
             thread = threading.Thread(target=self.process_queue)
             thread.setDaemon(True)
             thread.start()
             self.thread_pool.append(thread)
        def test():
            print "nb pending: ",len(self.thread_queue)
            print "nb current: ",len(self.current_task)
            return True

        #gobject.timeout_add(5000,test)

    """ Interupt the queue process and wait all current task are finish """
    def stop(self):
        self.debug("Stop all thread")
        self.is_running = False
        while self.thread_pool:
            time.sleep(0.1)
            self.debug(len(self.thread_pool), "thread pending...")
            for index,the_thread in enumerate(self.thread_pool):
                if the_thread.isAlive():
                    continue
                else:
                    del self.thread_pool[index]
                break

    """ Interupt the queue process but don't wait all current task are finish """
    def kill(self):
        self.debug("Stop all thread")
        self.is_running = False

    def debug(self,*data):
        if DEBUG: print "ListenThreadQueue: ",data


ThreadQueue = ListenThreadQueue()

