###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk,sys
from gtk import gdk
import pango
import gobject
from time import time

import utils
import config
from db_manager import DBManager
from misc_widget import MultiDragTreeview
from misc_widget import get_scrolled_window


class FailedRemoveSong(Exception):
    pass

class BrowserView(gtk.VBox):
    def __init__(self,media_organizer,conf_prefix):
        self.media_organizer = media_organizer
        gtk.VBox.__init__(self)
        self.pane = gtk.VPaned()
        self.conf_prefix = conf_prefix


        self.model = {}
        self.model["genre"] = gtk.ListStore(object,str,int)
        self.model["artist"] = gtk.ListStore(object,str,int,int)
        self.model["album"] = gtk.ListStore(object,str,int,gdk.Pixbuf)

        #self.model["genre"] = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
        class ColumnText(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                r.set_property("ellipsize",pango.ELLIPSIZE_END)
                gtk.TreeViewColumn.__init__(self,name,r,markup=ncol)
                self.set_expand(True)
                self.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)


        class ColumnInt(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                r.set_property("xalign",1)
                gtk.TreeViewColumn.__init__(self,name,r,text=ncol)

        class ColumnPixbuf(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererPixbuf()
                gtk.TreeViewColumn.__init__(self,name,r,pixbuf=ncol)
                #self.set_alignment(1)


        self.preview_album_win = gtk.Window(gtk.WINDOW_POPUP)
        self.preview_album_win.add(gtk.Frame())
        self.preview_album_win.child.set_shadow_type(gtk.SHADOW_IN)
        self.preview_album_win.child.add(gtk.Button())
        self.preview_album_win.child.child.add(gtk.Image())
        self.preview_album_win.child.child.set_relief(gtk.RELIEF_NONE)
        self.preview_album_win.child.child.connect("clicked",self.change_album_cover)
        self.preview_album_win.child.child.connect("enter-notify-event",self.stop_hide_preview_album)
        self.preview_album_win.child.child.connect("leave-notify-event",self.hide_preview_album)

        #self.preview_album_win.set_has_frame(False)
        self.preview_album_win.set_decorated(False)
        self.preview_album_win.set_keep_above(True)
        self.preview_album_win.connect("enter-notify-event",self.stop_hide_preview_album)
        self.preview_album_win.connect("leave-notify-event",self.hide_preview_album)
        self.id_hide_preview = None

        self.treeviews = {}
        self.treeviews["genre"] = MultiDragTreeview()
        self.treeviews["genre"].append_column(ColumnText(_("Genres"),1))
        self.treeviews["genre"].append_column(ColumnInt(_("So."),2))

        self.treeviews["artist"] = MultiDragTreeview()
        self.treeviews["artist"].append_column(ColumnText(_("Artists"),1))
        self.treeviews["artist"].append_column(ColumnInt(_("Al."),2))
        self.treeviews["artist"].append_column(ColumnInt(_("So."),3))

        self.treeviews["album"] = MultiDragTreeview()
        self.treeviews["album"].append_column(ColumnPixbuf(" ",3))
        self.treeviews["album"].append_column(ColumnText(_("Albums"),1))
        self.treeviews["album"].append_column(ColumnInt(_("So."),2))

        self.treeviews["album"].connect("motion-notify-event",self.show_preview_album)
        self.treeviews["album"].connect("leave-notify-event",self.hide_preview_album)



        targets = [("text/uri-list", 0, 0)]
        for type, treeview in self.treeviews.iteritems():
            treeview.set_search_equal_func(self.on_interactive_search,type)
            treeview.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
            treeview.get_selection().connect("changed", self.on_row_selected,type)
            treeview.connect("row-activated",self.on_row_activated,type)
            treeview.drag_source_set(
                gtk.gdk.BUTTON1_MASK, targets,
                gtk.gdk.ACTION_COPY)

            treeview.connect("drag-data-get", self.on_drag_data_get)
            treeview.set_model(self.model[type])

        hbox = gtk.HBox(True,4)
        hbox.pack_start(get_scrolled_window(self.treeviews["genre"]))
        hbox.pack_start(get_scrolled_window(self.treeviews["artist"]))
        hbox.pack_start(get_scrolled_window(self.treeviews["album"]))
        hbox.show_all()
        hbox.set_no_show_all(True)
        self.pane.pack1(hbox,False,True)




        self.expander = gtk.Expander()
        self.expander.connect("notify::expanded",self.on_browser_expand)

        l = gtk.Label(_("Hide browser"))
        l.set_alignment(0,0.5)
        l.set_size_request(-1,22)
        self.expander.set_label_widget(l)

        label_search = gtk.Label(_("Search")+" : ")
        label_search.set_alignment(1,0.5)
        label_search.show()

        self.search_entry = gtk.Entry()
        self.search_entry.connect("changed",self.on_search_changed)
        self.box_search = gtk.HBox(False,6)
        btn_clear = gtk.Button()
        btn_clear.add(gtk.image_new_from_stock(gtk.STOCK_CLEAR, gtk.ICON_SIZE_MENU))
        btn_clear.set_size_request(28,28)
        btn_clear.connect("clicked",lambda widget:self.search_entry.set_text(""))
        self.box_search.pack_start(label_search,False,False)
        self.box_search.pack_start(self.search_entry,True,True)
        self.box_search.pack_start(btn_clear,False,False)


        top_box = gtk.HBox(False,50)
        top_box.pack_start(self.expander,False,False)
        top_box.pack_start(self.box_search,True,True)
        self.pack_start(top_box,False,False)
        self.pack_start(self.pane,True,True)
        self.set_spacing(6)

        self.songs_cache = []
        self.__id_search = None
        self.__id_idle_add = None
        self.__id_idle_fill = {"genre":None,"artist":None,"album":None}

        self.selected = {"genre":[],"artist":[],"album":[]}
        self.cache_model = {"genre":{},"artist":{},"album":{}}
        self.iter_to_select = {"genre":{},"artist":{},"album":{}}

        self.treeviews["songs"] = None

        self.set_visible_pane(False)


        """ LOAD CONF """

        artists = config.get("browser",self.conf_prefix+"_last_selected_artist")
        if artists != "":
            self.selected["artist"] = artists.split("<#>")
        albums = config.get("browser",self.conf_prefix+"_last_selected_album")
        if albums != "":
            self.selected["album"] = albums.split("<#>")
        genres = config.get("browser",self.conf_prefix+"_last_selected_genre")
        if genres != "":
            self.selected["genre"] = genres.split("<#>")

        if config.get("browser",self.conf_prefix) == "true":
            self.expander.set_expanded(True)
        else:
            self.expander.set_expanded(False)
        self.on_browser_expand(self.expander)
        self.search_entry.set_text(config.get("browser",self.conf_prefix+"_last_search"))

    """ save browser configuration """
    def save_config(self):
        config.set("browser",self.conf_prefix+"_last_selected_artist","<#>".join(self.selected["artist"]))
        config.set("browser",self.conf_prefix+"_last_selected_album","<#>".join(self.selected["album"]))
        config.set("browser",self.conf_prefix+"_last_selected_genre","<#>".join(self.selected["genre"]))
        config.set("browser",self.conf_prefix+"_pos","%d"%self.pane.get_position())
        config.set("browser",self.conf_prefix+"_last_search",self.search_entry.get_text())

    """ Need set self.songs_cache with current song in the browser for treeview manipulation """
    def refresh_song_cache(self):
        raise NotImplemented

    """ add the song view to use with the browser """
    def set_song_treeview(self,treeview):
        self.treeviews["songs"] = treeview
        self.pane.pack2(get_scrolled_window(self.treeviews["songs"]),True,False)
        self.pane.compute_position(-1,200,250)
        self.pane.set_position(int(config.get("browser",self.conf_prefix+"_pos")))

    def set_visible_pane(self,refill=True):
        types = self.get_list_type()
        for type, tree in self.treeviews.iteritems():
            if type!="songs":
                if type in types:
                    tree.get_parent().show()
                else:
                    tree.get_parent().hide()
        if refill:
            self.on_search_changed_cb(self.search_entry)

    def get_list_type(self):
        view = int(config.get("browser","view"))
        if view==0:
            return ["artist","album"]
        if view==1:
            return ["genre","artist"]
        if view==2:
            return ["genre","artist","album"]

    def get_next_type(self,previous_type):
        types = self.get_list_type()
        for i,type in enumerate(types):
            if type==previous_type and i+1<len(types):
                return types[i+1]
        return None

    """ Refill all pane and song view"""
    def populate_view(self):
        if self.treeviews["songs"]==None:
            raise "No song treeview set in the browser"

        self.on_search_changed(self.search_entry)

    """ remove a list of song in all treeview """
    def remove_songs(self,songs_to_remove):
        for type in self.get_list_type():
            iter_to_delete =[]
            def remove(model, path, iter,songs_to_remove):

                songs = model[iter][0]
                songs = songs.difference(set(songs_to_remove))

                if len(model[iter][0]) != len(songs):
                    model[iter][0] = songs
                    if len(songs)>0 or path[0]==0:
                        if type=="artist":
                            model[iter][2] = len(set([song.get_property("album") for song in songs]))
                            model[iter][3] = len(songs)
                        else:
                            model[iter][2] = len(songs)
                    else:
                        iter_to_delete.append(iter)
            model = self.model[type]
            model.foreach(remove,songs_to_remove)
            iter_to_delete.reverse()
            for iter in iter_to_delete:
                del model[iter]

        for song_to_remove in songs_to_remove:
            try: self.songs_cache.remove(song_to_remove)
            except: pass


    """ fill the 'type' pane with the songs """
    def fill(self,type,songs):
        self.get_toplevel().window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
        if self.__id_idle_fill[type]!=None: gobject.source_remove(self.__id_idle_fill[type])
        self.treeviews["songs"].stop_fill()
        values = {}
        treeview = self.treeviews[type]
        model = self.model[type]

        for song in songs:
            key = song.get_property(type)
            values.setdefault("<###ALL###>",{"<###songs###>":set()})
            values["<###ALL###>"]["<###songs###>"].add(song)
            if type=="artist":
                key_album = song.get_property("album")
                values["<###ALL###>"].setdefault(key_album,set()).add(song)
            if key:
                if len(key)>1:
                    key = key[:1].upper()+key[1:]
                else:
                    key = key.upper()
                values.setdefault(key,{"<###songs###>":set()})
                values[key]["<###songs###>"].add(song)
                if type=="artist":
                    values[key].setdefault(key_album,set()).add(song)
            else:
                values.setdefault("<###UNKNOWN###>",{"<###songs###>":set()})
                values["<###UNKNOWN###>"]["<###songs###>"].add(song)
                if type=="artist":
                    values["<###UNKNOWN###>"].setdefault(key_album,set()).add(song)

        if values.has_key("<###ALL###>"):
            all = values["<###ALL###>"]
            del values["<###ALL###>"]
        else: all = {"<###songs###>":[]}

        if values.has_key("<###UNKNOWN###>"):
            unknown = values["<###UNKNOWN###>"]
            del values["<###UNKNOWN###>"]
        else: unknown = None

        def sort_key(a,b):
            if a.lower()==b.lower():
                return 0
            elif a.lower()>b.lower():
                return 1
            else:
                return -1
        keys = values.keys()
        keys.sort(sort_key)

        self.iter_to_select[type] = []
        treeview.set_model(None)
        model.clear()
        self.__id_idle_fill[type] = gobject.idle_add(self.idle_fill,model,treeview,type,keys,values,all,unknown)

    def idle_fill(self,model,treeview,type,keys,values,all,unknown):
        if self.__id_idle_fill[type]!=None : gobject.source_remove(self.__id_idle_fill[type])

        def get_tuple(name,value,have_cover=True):
            if type=="artist":
                return (value["<###songs###>"],name,len(value)-1,len(value["<###songs###>"]))
            elif type=="album":
                song = None
                pixbuf=config.DEFAULT_ALBUM_COVER_PIXBUF_MINI
                if have_cover:
                    for song in value["<###songs###>"]:
                        filename = song.get_album_cover(False)
                        if filename != config.DEFAULT_ALBUM_COVER:
                            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename,25,25)
                        break;
                return (value["<###songs###>"],name,len(value["<###songs###>"]),pixbuf)
            else:
                return (value["<###songs###>"],name,len(value["<###songs###>"]))


        for key in keys[:100]:
            iter = model.append(get_tuple(utils.xmlescape(key),values[key]))
            if key in self.selected[type]:
                self.iter_to_select[type].append(iter)

        if len( keys[101:])>0:
            self.__id_idle_fill[type] = gobject.idle_add(self.idle_fill,model,treeview,type, keys[100:],values,all,unknown)
        else:

            if unknown:
                iter_unknown = model.append(get_tuple("<i>"+utils.xmlescape(_("Unknown"))+"</i>",unknown,False))

            iter_all = model.insert(0,get_tuple("<b>"+utils.xmlescape(_("All"))+"</b>",all,False))

            treeview.set_model(model)

            if len(self.iter_to_select[type])==0:
                treeview.get_selection().select_iter(iter_all)
            else:
                first = True
                for iter in self.iter_to_select[type]:
                    if first:
                        treeview.scroll_to_cell(model.get_path(iter))
                        first=False
                    treeview.get_selection().select_iter(iter)



    """ filter browser with text in entry """
    def on_search_changed(self,entry):
        if self.treeviews["songs"]==None:
            return

        if len(self.songs_cache)>0:
            if self.__id_search!=None:  gobject.source_remove(self.__id_search)
            self.__id_search = gobject.timeout_add(500,self.on_search_changed_cb,entry)
        else:
            self.fill(self.get_list_type()[0],[])


    """ filter browser with text in entry """
    def on_search_changed_cb(self,entry):
        filter_search = entry.get_text().replace("  "," ").lower().strip().split(" ")

        if len(filter_search)>0:
            song_to_add = []
            for song in self.songs_cache:
                found = True
                for f in filter_search:
                    if song.get_filter().rfind(f)==-1:
                        found = False
                        break
                if found: song_to_add.append(song)

            self.fill(self.get_list_type()[0],song_to_add)
        else:
            self.fill(self.get_list_type()[0],self.songs_cache)
        return False

    """
    Browser manipulation
    """
    def on_interactive_search(self,model, column, key, iter,type):
        value = model.get_value(iter, 1)
        if value.lower().find( key.lower()) == 0:
          return False
        return True

    def on_row_activated(self,treeview, path, view_column,type):
        model,rows = treeview.get_selection().get_selected_rows()
        if len(rows)<0:
            songs = self.songs_cache
        else:
            setsongs = list([model[row[0]][0] for row in rows])
            songs = []
            for setsong in setsongs:
                songs.extend(list(setsong))

        play = True
        songs.sort()
        for song in songs:
            self.media_organizer.player.playlist.add_song(song,False,play)
            play = False

    def on_row_selected(self,treeselection,type):
        model,rows = treeselection.get_selected_rows()
        if len(rows)<=0:
            return
            songs = self.songs_cache
        else:
            setsongs = list([model[row[0]][0] for row in rows])
            del self.selected[type]
            self.selected[type] = list([model[row[0]][1] for row in rows])

            songs = []
            for setsong in setsongs:
                songs.extend(list(setsong))

        next_type = self.get_next_type(type)
        if next_type!=None:
            self.fill(next_type,songs)
        else:
            self.treeviews["songs"].fill(songs)

    def on_drag_data_get(self,treeview, context, selection, info, timestamp):
        model,rows = treeview.get_selection().get_selected_rows()
        if len(rows)<0:
            return
        else:
            songs = set()
            for row in rows:
                songs = songs.union(model[row[0]][0])

        list_uri = list([ utils.convert_to_uri(song.get_property("uri")) for song in songs])
        self.get_toplevel().last_drag_drop = list(songs)

        selection.set_uris(list_uri)

    def on_browser_expand(self,expander,*param):
        if expander.get_expanded():
            config.set("browser",self.conf_prefix,"true")
        else:
            config.set("browser",self.conf_prefix,"False")

        if expander.get_expanded():
            expander.get_label_widget().set_text(_("Hide browser"))
            self.pane.get_child1().show()
        else:
            expander.get_label_widget().set_text(_("Show browser"))
            self.pane.get_child1().hide()

    def show_preview_album(self,widget,event):
        if self.id_hide_preview!=None: gobject.source_remove(self.id_hide_preview)
        path = widget.get_path_at_pos(int(event.x),int(event.y))
        if path!=None and path[0][0]!=0:
            song = None
            for song in self.model["album"][path[0]][0]:
                break
            if song!=None:
                filename = song.get_album_cover(False)
                if filename != config.DEFAULT_ALBUM_COVER:
                    pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename,75,75)
                else:
                    pixbuf = config.DEFAULT_ALBUM_COVER_PIXBUF_BIG

                self.preview_album_win.child.child.child.set_from_pixbuf(pixbuf)
                rect =  widget.get_cell_area(path[0], path[1])
                tx, ty = widget.window.get_origin()
                width,height = self.preview_album_win.get_size()
                self.preview_album_win.move(tx-width-2,ty+rect.y)
                self.preview_album_win.show_all()
                self.preview_album_win.row_x = int(event.x)
                self.preview_album_win.row_y = int(event.y)
                return

        self.hide_preview_album_real()
        return

    def hide_preview_album(self,*param):
        if self.id_hide_preview!=None: gobject.source_remove(self.id_hide_preview)
        self.id_hide_preview = gobject.timeout_add(500,self.hide_preview_album_real)

    def stop_hide_preview_album(self,*param):
        if self.id_hide_preview!=None: gobject.source_remove(self.id_hide_preview)

    def hide_preview_album_real(self):
        self.stop_hide_preview_album()
        self.preview_album_win.hide_all()

    def change_album_cover(self,btn):
        self.hide_preview_album_real()
        path = self.treeviews["album"].get_path_at_pos(self.preview_album_win.row_x,self.preview_album_win.row_y)
        if path!=None:
            song = None
            for song in self.model["album"][path[0]][0]:
                break
            if song!=None:
                from misc_widget import AmazonWindow
                AmazonWindow(song)
                filename = song.get_album_cover(False)
                self.model["album"][path[0]][3] = gtk.gdk.pixbuf_new_from_file_at_size(filename,25,25)



