###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


try: import gpod
except : pass

from view_browser import *
from view_song import TreeviewSong

class IPodBrowserView(BrowserView):
    def __init__(self,media_organizer,ipod):
        BrowserView.__init__(self,media_organizer,conf_prefix="ipod")

        self.ipod = ipod
        self.songs_cache = self.ipod.songs

        self.set_song_treeview(IPodSongview(media_organizer,ipod))


    def refresh_song_cache(self):
        self.ipod.refresh_cache()
        self.songs_cache = self.ipod.songs
        self.songs_cache.sort()


    def new_playlist(self,widget=None):

        dialog_save = WindowBase(_("New iPod playlist"),config.PIXMAP_DIR+"/playlist_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)

        hbox.pack_start(self.entry)
        dialog_save.add_widget(hbox)
        dialog_save.show_all()
        result = dialog_save.run()
        if result == gtk.RESPONSE_ACCEPT:
            self.ipod.create_playlist(self.entry.get_text(),-1)
            self.media_organizer.populate()

        dialog_save.destroy()

    def rename_ipod(self,widget=None):
        #print dir(self.itdbs_ipod[self.current_mount_point].device)
        pass


class IPodSongview(TreeviewSong):
    def __init__(self,media_organizer,ipod,allow_column={"title":True,"album":True,"artist":True,"track":True,"duration":True},sortable=True):
        self.ipod = ipod
        TreeviewSong.__init__(self,media_organizer,allow_column,sortable)
        self.menu = self.get_menu()

        self.connect("key-press-event", self.on_key_press)

    def on_key_press(self, widget, event):
         if event.keyval == gtk.gdk.keyval_from_name("Delete"):
            self.remove_selected()
            return True

    def remove_selected(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        rows.reverse()
        for row in rows:
            iter = model.get_iter(row[0])
            song = model.get_value(iter,0)
            self.ipod.remove_song(song)
        self.ipod.save_itdb()

        #Refresh song cache
        from media_source import IPodSource
        for source in self.media_organizer.list_source:
            if isinstance(source,IPodSource):
                source.widget.refresh_song_cache()
                source.widget.populate_view()

    def get_menu(self):

        menu_ui = """
            <ui>
                <popup name="SongIpodMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <menuitem action="Remove"/>
                  <separator/>
                  <menuitem action="Artist"/>
                  <menuitem action="Album"/>
                </popup>
            </ui>
            """

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this song'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this song'), self.enqueue_selected)])
        actiongroup.add_actions([('Remove', gtk.STOCK_DELETE, _('_Remove'), None,
                                         _('Remove this song'), self.remove_selected)])

        actiongroup.add_actions([('Artist', gtk.STOCK_ABOUT, _('About _artist'), None,
                                         _('More informations about this artist'), self.info_artist)])
        actiongroup.add_actions([('Album', gtk.STOCK_ABOUT, _('About a_lbum'), None,
                                         _('More informations about this album'), self.info_album)])


        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/SongIpodMenu")

class IPodPlaylistSongview(IPodSongview):
    def __init__(self,media_organizer,ipod):
        IPodSongview.__init__(self,media_organizer,ipod)
        self.current_playlist = None
        self.current_mount_point = None
        self.playlist_menu = self.get_playlist_menu()
        self.ipod = ipod


    def populate(self,playlist):
        if gpod.itdb_playlist_is_podcasts(playlist):
            songs = filter(lambda song:gpod.itdb_playlist_contains_track(playlist, song.ipod_track),self.ipod.podcast_songs)
        else:
            songs = filter(lambda song:gpod.itdb_playlist_contains_track(playlist, song.ipod_track),self.ipod.songs)
        self.fill(songs)
        self.current_playlist = playlist

    def get_playlist_menu(self):
        menu_ui = """
            <ui>
                <popup name="PlaylistMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <separator/>
                  <menuitem action="Rename"/>
                  <menuitem action="Remove"/>
                </popup>
            </ui>
            """

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this playlist'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this playlist'), self.enqueue_selected)])

        actiongroup.add_actions([('Rename', gtk.STOCK_EDIT, _('Rename'), None,
                                         _('Rename this playlist'), self.rename_playlist)])
        actiongroup.add_actions([('Remove', gtk.STOCK_DELETE, _('_Remove'), None,
                                         _('Remove this playlist'), self.remove_playlist)])




        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/PlaylistMenu")


    def rename_playlist(self,widget=None):

        dialog = WindowBase(_("Rename iPod playlist"),config.PIXMAP_DIR+"/playlist_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_text(self.current_playlist.name)
        self.entry.set_activates_default(True)

        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            self.ipod.rename_playlist(self.current_playlist,self.entry.get_text())
            self.media_organizer.populate()

        dialog.destroy()


    def remove_playlist(self,widget=None):
        self.ipod.remove_playlist(self.current_playlist)
        self.media_organizer.populate()


    def remove_selected(self,widget=None):
        model, rows = self.get_selection().get_selected_rows()
        rows.reverse()
        for row in rows:
            iter = model.get_iter(row[0])
            song = model.get_value(iter,0)
            gpod.itdb_playlist_remove_track( self.current_playlist, song.ipod_track)

        self.ipod.save_itdb()
        self.populate(self.current_playlist)

