###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import pango

from db_manager import DBManager
from view_song import TreeviewSong

class TreeviewSongIRadio(TreeviewSong):
    def __init__(self,media_organizer):
        allow_column={"title":True,"album":False,"artist":False,"track":False,"duration":False}
        TreeviewSong.__init__(self,media_organizer,allow_column)

        self.menu = self.get_menu()

        self.renderer_name = gtk.CellRendererText()
        self.renderer_name.set_property("ellipsize",pango.ELLIPSIZE_END)

        self.media_organizer = media_organizer

    def refresh_songs_cache(self,DB=DBManager):
        self.songs_cache = DB.get_iradio()

    def populate(self):
        self.fill(self.songs_cache)

    def get_menu(self):

        menu_ui = """
            <ui>
                <popup name="SongMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <menuitem action="Delete"/>
                </popup>
            </ui>
            """

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this song'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this song'), self.enqueue_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this song'), self.enqueue_selected)])
        actiongroup.add_actions([('Delete', gtk.STOCK_DELETE, _('_Remove from library'), None,
                                         _('Remove this radio from the library'), self.remove_selected)])


        """actiongroup.add_actions([('Artist', gtk.STOCK_ABOUT, _('About _artist'), None,
                                         _('More informations about this artist'), self.info_artist)])
        actiongroup.add_actions([('Album', gtk.STOCK_ABOUT, _('About a_lbum'), None,
                                         _('More informations about this album'), self.info_album)])

        """


        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/SongMenu")

