# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###



import gtk,pango
import gobject
import os
import gnomevfs
import urllib

import stock
import utils
import const
import config

from  _source import Source,SourceItem,PlaylistSourceItem


from widget.song_view import SortableSongView,SongView
from widget.song_menu import SongMenu
from widget.progress import action_progress    
from widget.misc import ScrolledWindow
from helper import helper


from song import Song,VALID_EXTENTIONS,sType



class FileSystemSource(Source):
    display_index = 70    
    def __init__(self,player):
        Source.__init__(self,player)
    
        self.filebrowser = FileBrowser()
        item = FileSystemSourceItem(player,gtk.STOCK_HARDDISK,_("Filesystem"),self.filebrowser,"filebrowser")
        self.items.append(item)
        
    def save(self):
        self.filebrowser.save()
        
class FileSystemSourceItem(SourceItem):
    has_top_separateur = True
    has_bottom_separateur = False
        
class FileBrowser(gtk.VPaned):
    def __init__(self):
        super(FileBrowser,self).__init__()
        
        
        self.view = FileSystemSongView()        
        self.chooser = gtk.FileChooserWidget(gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
        
        uri = config.get("filebrowser","uri")
        self.chooser.set_uri(uri)
        filter = gtk.FileFilter()
        filter.add_mime_type("x-directory/normal")
        filter.add_mime_type("inode/directory")
        #self.chooser.set_filter(filter)
        self.chooser.connect("current-folder-changed",self.on_selection)
        
        """
        self.chooser.get_children()[0].get_children()[0].get_children()[0].get_children()[0].hide()
        self.chooser.get_children()[0].get_children()[0].get_children()[0].get_children()[0].set_no_show_all(True)
        """
        """
        cell = self.chooser.get_children()[0].get_children()[0].get_children()[0].get_children()[1].get_children()[1].get_children()[0].get_children()[0].get_column(0).get_cell_renderers()[1]
        cell.set_property("ellipsize",pango.ELLIPSIZE_END)
        """
        self.pack1(self.chooser)
        self.pack2(ScrolledWindow(self.view))
        self.set_position(int(config.get("filebrowser","pane_pos")))
        #self.connect("event",lambda pane,ev:config.set("filebrowser","pane_pos","%d"%self.get_position()))
        
    def save(self):
        config.set("filebrowser","pane_pos","%d"%self.get_position())
        
    def on_selection(self,filechooser):
        dir  = self.chooser.get_uri()
        config.set("filebrowser","uri",dir)
        added = []
        try:hdir = gnomevfs.DirectoryHandle(dir)
        except: 
            print dir,"Not found"
            gobject.idle_add(self.view.get_model().fill,[])
            return 
        try: fileinfo = hdir.next()
        except StopIteration: 
            gobject.idle_add(self.view.get_model().fill,[])
            return 
        while fileinfo:
            if fileinfo.name[0] in [".",".."] or fileinfo.flags != gnomevfs.FILE_FLAGS_LOCAL: 
                pass
            elif fileinfo.type == gnomevfs.FILE_TYPE_DIRECTORY:
                pass
            else:
                try:
                    uri = gnomevfs.make_uri_canonical(dir+"/"+gnomevfs.escape_string(fileinfo.name))
                    if fileinfo.type == gnomevfs.FILE_TYPE_REGULAR and VALID_EXTENTIONS.has_key(utils.get_ext(uri)):
                       added.append(uri)
                except UnicodeDecodeError:
                    raise "UnicodeDecodeError",uri
            try: fileinfo = hdir.next()
            except StopIteration: break;
            #yield "Reading folder...",False,True
        
        i = 0
        total = len(added)
        songs = []
        for uri in added:
            i += 1    
            song = Song()
            song.set_type(sType.LOCAL_FILE)
            song["uri"] = uri
            if song.read_from_file():
                songs.append(song)
            #yield _("Reading file")+" %d/%d..."%(i,total),float(i)/float(total),False
            
        
        gobject.idle_add(self.view.get_model().fill,songs)
        
class FileSystemSongView(SortableSongView):
    def __init__(self):
        super(FileSystemSongView,self).__init__(None,"filesystem")
        

        self.set_menu(SongMenu(None,True,True,False,True,True,True,True))
        
        helper.connect("changed",self.get_model().change_songs)
        
        
        