# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gst
import gobject

from config import config

from plugins.generic import GenericPlugin
from player import Player
from widget.preference import HelperConfigureDialog

class IcecastDialog(HelperConfigureDialog):
    def __init__(self):
        HelperConfigureDialog.__init__(self, _("Icecast Server"))
        self.add(self.make_lentry(_("Address"), "plugins", "icecast_ip", "127.0.0.1"))
        self.add(self.make_lentry(_("Port"), "plugins", "icecast_port", "8000"))
        self.add(self.make_lentry(_("Username"), "plugins", "icecast_username", "source"))
        self.add(self.make_lentry(_("Password"), "plugins", "icecast_password", "hackme"))
        self.add(self.make_lentry(_("Stream Name"), "plugins", "icecast_name", "Listen Icecast Agent"))
        self.add(self.make_lentry(_("Description"), "plugins", "icecast_description", "Listen Icecast Agent"))
        self.add(self.make_lentry(_("Url"), "plugins", "icecast_url", "http://localhost:8000/"))
        self.add(self.make_lentry(_("Mount point"), "plugins", "icecast_mount", "/listen.ogg"))
        self.show_all()

class IcecastServerPlugin(GenericPlugin):
    PLUGIN_NAME = "Icecast Server Agent"
    PLUGIN_DESC = "Icecast Server Agent plugin"
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "Mehdi ABAAKOUK <theli48@gmail.com>"
    PLUGIN_WEBSITE = ""

    def __init__(self):
        GenericPlugin.__init__(self)

        self.autoconnect(config, "config-changed", self.__on_config_change)

        self.autoconnect(Player.bin, "tee-inserted", self.__on_insert)
        self.autoconnect(Player.bin, "tee-removed", self.__on_remove)

        self.__differed_set = False
        self.__differed_unset = False
        self.__state = "STATE_NULL"
        self.__bin = None
        self.__reload_timeout_id = None

        self.reload_sink()

    def __on_insert(self, bin, tee, element):
        if element != self.__bin: return
        if self.__state == "STATE_READY":
            self.__state = "STATE_PLAYING"

        if self.__differed_unset:
            self.__differed_unset = False
            self.__unset_sink()

    def __on_remove(self, bin, tee, element):
        if element != self.__bin: return
        if self.__state == "STATE_DIRTY":
            self.__bin.set_state(gst.STATE_NULL)
            self.__bin = None
            self.__state = "STATE_NULL"

        if self.__differed_set:
            self.__differed_set = False
            self.__set_sink()

    def __unset_sink(self):
        if self.__state == "STATE_READY":
            self.__differed_unset = True
            return

        if self.__state == "STATE_PLAYING":
            self.__state = "STATE_DIRTY"
            Player.bin.xfade_remove_tee(self.__bin)

    def reload_sink(self):
        self.__reload_timeout_id = None
        if self.__bin:
            self.__unset_sink()
        self.__set_sink()

    def __set_sink(self):
        if self.__state == "STATE_DIRTY":
            self.__differed_set = True
            return

        if self.__state != "STATE_NULL":
            return

        if self.__bin: 
            print "W:Icecast:bin not correctly removed"
    
        encoder = gst.element_factory_make("vorbisenc")
        mux = gst.element_factory_make("oggmux")
        
        self.__sink = gst.element_factory_make("shout2send")
        self.__sink.set_property("sync", True) 
        self.__sink.set_property("async", True) 
        self.__sink.set_property("protocol", 3)
        self.__sink.set_property("preroll-queue-len", 10)
        self.__sink.set_property("port", int(config.get("plugins", "icecast_port", "8000")))
        self.__sink.set_property("ip", config.get("plugins", "icecast_ip", "127.0.0.1"))
        self.__sink.set_property("username", config.get("plugins", "icecast_username", "source"))
        self.__sink.set_property("password", config.get("plugins", "icecast_password", "hackme"))
        self.__sink.set_property("streamname", config.get("plugins", "icecast_name", "Listen icecast agent"))
        self.__sink.set_property("description", config.get("plugins", "icecast_description", "Listen icecast agent"))
        self.__sink.set_property("mount", config.get("plugins", "icecast_mount", "/listen.ogg"))
        self.__sink.set_property("url", config.get("plugins", "icecast_url", "http://localhost:8000/"))

        self.__bin = gst.Bin()
        try: self.__bin.set_property("async-handling", True)
        except: pass
        self.__bin.add(encoder, mux, self.__sink)
        gst.element_link_many(encoder, mux, self.__sink)

        self.__bin.add_pad(gst.GhostPad("sink", encoder.get_pad("sink")))

        self.__state = "STATE_READY"
        self.__bin.set_state(gst.STATE_PAUSED)

        Player.bin.xfade_add_tee(self.__bin)

    def __on_config_change(self, dispacher, section, option, value):
        if section == "plugins" and option.find("icecast") == 0:
            if self.__reload_timeout_id:
                gobject.source_remove(self.__reload_timeout_id)
            self.__reload_timeout_id = gobject.timeout_add(5000, self.reload_sink)

    def delete_thyself(self):
        if self.__bin: Player.bin.xfade_remove_tee(self.__bin)
        super(IcecastServerPlugin, self).delete_thyself()

    @staticmethod   
    def on_configure():
        IcecastDialog()

