# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gtk
import urllib

import utils
from config import config
import stock

from helper import Dispatcher, SignalCollector
from player import Player
from web_threading import WebFetchThread

from source import Source,SourceItem
from widget.song_menu import SongMenuManager
from widget.htmlview import HtmlView, get_template
from logger import Logger

not_enough_info_msg = _("Not enough information about this media for this action")

def dic_to_querystring(d):
    return '&'.join(map(lambda x: urllib.quote(x)+'='+urllib.quote(d[x]), d))

class YooookBox(gtk.VBox, Logger):

    actions = "Answer liberation poll", "New ad hoc liberation poll"
    action_targets = "Song", "Album"

    def __init__(self):
        gtk.VBox.__init__(self,False,6)
        self.song = None

        self.embed = HtmlView()
       
        self.text = gtk.TextView(gtk.TextBuffer())
        self.text.set_editable(False)
        padding = 5
        self.text.set_property("pixels-above-lines",padding)
        self.text.set_property("pixels-below-lines",padding)
        self.text.set_property("right_margin",padding)
        self.text.set_property("left_margin",padding)
        
        self.auto_update = gtk.CheckButton("Auto-updating")
        self.auto_update.set_property("active",True)

        self.entry_artist = gtk.Entry()
        self.entry_title = gtk.Entry()
        self.entry_album = gtk.Entry()

        self.entry_artist.connect("activate",self.on_action_changed)
        self.entry_title.connect("activate",self.on_action_changed)
        self.entry_album.connect("activate",self.on_action_changed)

        self.entry_artist.set_sensitive(False)
        self.entry_title.set_sensitive(False)
        self.entry_album.set_sensitive(False)

        self.dropdown_action = gtk.combo_box_new_text()
        self.dropdown_action.connect("changed",self.on_change_yooook_actions)
        self.dropdown_action.set_tooltip_text(_("Change action"))

        self.dropdown_action_target = gtk.combo_box_new_text()
        self.dropdown_action_target.connect("changed",self.on_change_yooook_actions)
        self.dropdown_action_target.set_tooltip_text(_("Change target"))

        self.box_search = gtk.HBox(False,6)
        l = gtk.Label(_("Action"))
        l.set_alignment(0,0.5)
        l_target = gtk.Label(_("on"))
        l_target.set_alignment(0,0.5)
        self.box_search.pack_start(l,False,False)
        self.box_search.pack_start(self.dropdown_action,False,False)
        self.box_search.pack_start(l_target,False,False)
        self.box_search.pack_start(self.dropdown_action_target,False,False)
        self.box_search.pack_end(self.auto_update,False,False)

        self.pack_start(self.box_search,False,False)
        self.pack_start(self.embed,True,True)

        SignalCollector.connect("yooook",Player,"new-song",self.new_media_cb)
        
        self.download_thread = WebFetchThread(1024,self.fail_fetch)
        
        self.is_realize = False   
        self.current_html = None

        self.reload_plugin()

    def on_change_yooook_actions(self,*arg):
        self.action = self.dropdown_action.get_active_text()
        self.action_target = self.dropdown_action_target.get_active_text()
#        config.set("yooook","action",self.action)
        self.on_action_changed()

    def reload_plugin(self,*args):
        self.fill_drop_down()

    def fill_drop_down(self):

        self.action = ""
        self.dropdown_action.get_model().clear()
        for a in self.actions: self.dropdown_action.append_text(a)
        self.dropdown_action.set_active(0)

        self.action_target = ""
        self.dropdown_action_target.get_model().clear()
        for a in self.action_targets: self.dropdown_action_target.append_text(a)
        self.dropdown_action_target.set_active(0)

    def fail_fetch(self):
        self.render_data(get_template()%(_("Server did not respond.")))

    def set_text(self,text):
        buffer = self.text.get_buffer()
        buffer.set_text(text)

    def force_select(self,song):
        self.new_media_cb(None,song)

    def new_media_cb(self,widget,song):
        if not self.auto_update.get_property("active"): return 

        if song.get("artist"):
            if not song.get("title") and song.get("album"):
                self.dropdown_action_target.set_active(1)
            elif not song.get("album") and song.get("title"):
                self.dropdown_action_target.set_active(0)

        self.song = song

        if config.get("setting","offline") == "true" :
            self.entry_artist.set_sensitive(False)
            self.entry_title.set_sensitive(False)
            self.entry_album.set_sensitive(False)
            HTML = get_template()%("<h3>"+_("Offline mode")+"</h3>")
            self.render_data(HTML)
            return

        self.entry_artist.set_sensitive(True)
        self.entry_title.set_sensitive(True)
        self.entry_album.set_sensitive(True)
        self.entry_artist.set_text(self.song.get_str("artist"))
        self.entry_album.set_text(self.song.get_str("album"))

        title = self.song.get_str("title")
        self.entry_title.set_text(title)

        self.on_action_changed()

    def on_action_changed(self):
        if not self.song: return
        if not self.action:
            self.render_data(get_template()% ("<h3>"+_("Invalid action")+"</h3>") )
            return 

        if not self.action_target:
            self.render_data(get_template()% ("<h3>"+_("Invalid action target")+"</h3>") )
            return 

        enough_info = True
        if not self.song.get("artist"): enough_info = False

        form = {'display_mode':         'minimal',
                'group':                'audiovisual',
                'author':               utils.filter_info_song(self.song.get_str("artist")),
                'rallying_entity':      'listen',
                'cc-by-nc-nd-question': '3',
                'cc-by-nc-sa-question': '6',
                'cc-by-sa-question':    '12'}

        if self.action_target == self.action_targets[0]:
            title = utils.filter_info_song(self.song.get_str("title"))
            form['group_category'] = 'track'
            if not self.song.get("title"): enough_info = False

        elif self.action_target == self.action_targets[1]:
            title = utils.filter_info_song(self.song.get_str("album"))
            form['group_category']       = 'album'
            form['cc-by-nc-nd-question'] = '10'
            form['cc-by-nc-sa-question'] = '20'
            form['cc-by-sa-question']    = '40'
            if not self.song.get("album"): enough_info = False

        if not enough_info and self.action == self.actions[0]:
            self.render_data(get_template()%(""+not_enough_info_msg+""))
            return

        form['title'] = title
        #form['rallying_url'] = 'http://www.listen-project.org/yooook_poll/?'+dic_to_querystring(form)

        url = "https://yooook.net/site/liberation_poll/"
        if self.action == self.actions[1]: url += 'adhoc/'
        url += "?"+dic_to_querystring(form)

        self.embed.open(url)

        return 

    def render_data(self, html ):
        self.embed.load_html_string(html,"file://")


class YooookItem(SourceItem):
    widget_klass = YooookBox
    config_code = "yooook"
    label = _("Liberate copyright")
    stock = stock.SRC_YOOOOK
    source_id = "yooook"

class YooookSource(Source):
    PLUGIN_NAME = "yooook"
    PLUGIN_DESC = _("Liberate copyright and fund Listen")
    PLUGIN_VERSION = "1.0"
    PLUGIN_AUTHOR = "Mammique"
    PLUGIN_WEBSITE = "http://yooook.net/"

    categorie = "info"
    display_index = 2
    signal_collector_id = "yooook"

    def __init__(self):
        Source.__init__(self)
        item =  YooookItem()
        self.items = [ item ]

        def song_menu_action(song_menu_manager,id_menu,songs):
            if id_menu == "yooook":
                Dispatcher.select_source_id("yooook")
                item.widget.force_select(songs[0])
 
        self.autoconnect(SongMenuManager,"action",song_menu_action)
        SongMenuManager.register_item("yooook",80,stock.YOOOOK)
        for type in [ "local","unknown_local"]:
            SongMenuManager.allow_item_for_type("yooook",type)

    def delete_thyself(self):
        SongMenuManager.unregister_item("yooook")
        Source.delete_thyself(self)
