/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandBegin: public LWParityCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	(void) args;
	
	g_return_val_if_fail (argc == 0, NULL);
	
	return NULL;
}

gchar *getName ()
{
	return "begin";
}	

gchar *getHint ()
{
	return _("Open logical block");
}

gboolean isOpen ()
{
	return TRUE;
}

void matchWith (LWCommand *cmd)
{
	if (g_strcasecmp (cmd->getName(), "end"))
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	match();
}

gboolean matchAsLastOne ()
{
	return TRUE;
}

};

LWSymbol *new_LWCommandBegin()
{
	return new LWCommandBegin();
}
