/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file symbol.h
	\brief Zarządzanie symbolami
*/

#ifndef __LW_SYMBOL_H
#define __LW_SYMBOL_H

class LWPiece;

/*! \class LWSymbol
	\brief Zarządzanie symbol

	Symbol to klasa z której dziedziczą polecenia oraz zmienne, które
	są przypisane klockom znajdującym się na planszy
*/

class LWSymbol {
private:
guint id;
GQuark quark;
static GData *datalist_symbols;
static GData *datalist_symbols_with_id;
public:
LWSymbol();
virtual ~LWSymbol();
LWSymbol *clone ();
guint getId ();
virtual gboolean canClone () = 0;
virtual gchar *getHint () = 0;
virtual const gchar *getName () = 0;
virtual gboolean isCommand ();
virtual gboolean isValue ();
virtual void onDndCopy (LWPiece *sourcepiece, LWPiece *destpiece);
virtual void onDndMove (LWPiece *sourcepiece, LWPiece *destpiece);
virtual void onAttach (LWPiece *piece);
static LWSymbol *factory (const gchar *name);
static LWSymbol *factoryId (const gchar *name, guint id);
static void destroyAll ();
};

#endif
