/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandRand: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;	

	g_return_val_if_fail (argc == 1, NULL);
	
	gint end = args[0]->toInt();

	if (end < 0)
		end = 0;
	
	guint randv = g_random_int_range (0, end);

	return new LWValue(randv);
}	

const gchar *getName (void) 
{
	return "rand";
}	

gchar *getHint ()
{
	return _("Random number from 0 to the value specified as argument minus one");
}

guint getPriority ()
{
	return 15;
}

LWLink getLinkType ()
{
	return LW_LINK_RIGHT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgument (guint n, LWValue *value)
{
	(void) n;
	
	if (FALSE == value->isVariable() && FALSE == value->checkRange())
			throw new LWMessage (LW_ERROR_NumberOutOfRange);
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandRand()
{
	return new LWCommandRand();
}
