; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji -verify-machineinstrs < %s | FileCheck --check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii -verify-machineinstrs < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s

define amdgpu_ps void @insertelement_s_v2i16_s_s(<2 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_and_b32 s1, s5, 1
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_and_b32 s3, s4, s2
; GFX9-NEXT:    s_lshl_b32 s3, s3, s1
; GFX9-NEXT:    s_lshl_b32 s1, s2, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_andn2_b32 s0, s0, s1
; GFX9-NEXT:    s_or_b32 s0, s0, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    s_and_b32 s1, s5, 1
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_and_b32 s3, s4, s2
; GFX8-NEXT:    s_lshl_b32 s3, s3, s1
; GFX8-NEXT:    s_lshl_b32 s1, s2, s1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    s_or_b32 s0, s0, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_and_b32 s1, s5, 1
; GFX7-NEXT:    s_mov_b32 s2, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    s_and_b32 s3, s4, s2
; GFX7-NEXT:    s_lshl_b32 s3, s3, s1
; GFX7-NEXT:    s_lshl_b32 s1, s2, s1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    s_or_b32 s0, s0, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_and_b32 s1, s5, 1
; GFX10-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-NEXT:    s_lshl_b32 s1, s1, 4
; GFX10-NEXT:    s_and_b32 s3, s4, s2
; GFX10-NEXT:    s_lshl_b32 s2, s2, s1
; GFX10-NEXT:    s_lshl_b32 s1, s3, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_andn2_b32 s0, s0, s2
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i16_s_s(<2 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v2, v[0:1], off
; GFX9-NEXT:    s_and_b32 s0, s3, 1
; GFX9-NEXT:    s_mov_b32 s1, 0xffff
; GFX9-NEXT:    s_lshl_b32 s0, s0, 4
; GFX9-NEXT:    s_and_b32 s2, s2, s1
; GFX9-NEXT:    s_lshl_b32 s2, s2, s0
; GFX9-NEXT:    s_lshl_b32 s0, s1, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_not_b32 s0, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v2, s0, v3
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s3, 1
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dword v0, v[0:1]
; GFX7-NEXT:    s_and_b32 s1, s3, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    s_and_b32 s2, s2, s0
; GFX7-NEXT:    s_lshl_b32 s0, s0, s1
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    s_lshl_b32 s2, s2, s1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v2, v[0:1], off
; GFX10-NEXT:    s_and_b32 s0, s3, 1
; GFX10-NEXT:    s_mov_b32 s1, 0xffff
; GFX10-NEXT:    s_lshl_b32 s0, s0, 4
; GFX10-NEXT:    s_and_b32 s2, s2, s1
; GFX10-NEXT:    s_lshl_b32 s1, s1, s0
; GFX10-NEXT:    s_lshl_b32 s0, s2, s0
; GFX10-NEXT:    s_not_b32 s1, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v2, s1, s0
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(1 )* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i16_v_s(<2 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_and_b32 s1, s4, 1
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX9-NEXT:    s_lshl_b32 s2, s2, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_andn2_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_lshl_or_b32 v2, v2, s1, v3
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    s_and_b32 s1, s4, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b32 s1, s2, s1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, s0, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_and_b32 s1, s4, 1
; GFX7-NEXT:    s_mov_b32 s2, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, s1, v0
; GFX7-NEXT:    s_lshl_b32 s1, s2, s1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, s0, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_and_b32 s1, s4, 1
; GFX10-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-NEXT:    s_lshl_b32 s1, s1, 4
; GFX10-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX10-NEXT:    s_lshl_b32 s2, s2, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_andn2_b32 s0, s0, s2
; GFX10-NEXT:    v_lshl_or_b32 v2, v2, s1, s0
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i16_s_v(<2 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_mov_b32 s1, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    s_and_b32 s2, s4, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s2
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_mov_b32 s1, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX8-NEXT:    s_and_b32 s2, s4, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s2
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    s_mov_b32 s1, 0xffff
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX7-NEXT:    s_and_b32 s2, s4, s1
; GFX7-NEXT:    v_lshl_b32_e32 v2, s2, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 s1, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, s1
; GFX10-NEXT:    s_and_b32 s1, s4, s1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, s1
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i16_v_v(<2 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    s_mov_b32 s1, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v1, s1
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    s_mov_b32 s1, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v1, s1
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    s_mov_b32 s1, 0xffff
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s1, v1
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 s1, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, s0, v2, v3
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i16_s_v(<2 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v2
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    s_and_b32 s1, s2, s0
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX9-NEXT:    v_xor_b32_e32 v4, -1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v3, v4, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dword v0, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_and_b32 s1, s2, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, s1, v1
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v2
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, s0
; GFX10-NEXT:    s_and_b32 s0, s2, s0
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, s0
; GFX10-NEXT:    v_xor_b32_e32 v4, -1, v1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v3, v4, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i16_v_s(<2 x i16> addrspace(1)* %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_and_b32 s0, s2, 1
; GFX9-NEXT:    s_lshl_b32 s0, s0, 4
; GFX9-NEXT:    s_mov_b32 s1, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    s_lshl_b32 s0, s1, s0
; GFX9-NEXT:    s_not_b32 s0, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v3, s0, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s2, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dword v0, v[0:1]
; GFX7-NEXT:    s_and_b32 s1, s2, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, s1
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, s1, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    s_and_b32 s0, s2, 1
; GFX10-NEXT:    s_mov_b32 s1, 0xffff
; GFX10-NEXT:    s_lshl_b32 s0, s0, 4
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    s_lshl_b32 s0, s1, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v3, s0, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i16_v_v(<2 x i16> addrspace(1)* %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dword v0, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v3
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, s0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %ptr
  %insert = insertelement <2 x i16> %vec, i16 %val, i32 %idx
  store <2 x i16> %insert, <2 x i16> addrspace(1)* null
  ret void
}

; FIXME: 3 element load/store legalization
; define amdgpu_ps void @insertelement_s_v3i16_s_s(<3 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(4)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i16_s_s(<3 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(1 )* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i16_v_s(<3 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 inreg %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(4)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i16_s_v(<3 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(4)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i16_v_v(<3 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(4)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i16_s_v(<3 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(1)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i16_v_s(<3 x i16> addrspace(1)* %ptr, i16 %val, i32 inreg %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(1)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i16_v_v(<3 x i16> addrspace(1)* %ptr, i16 %val, i32 %idx) {
;   %vec = load <3 x i16>, <3 x i16> addrspace(1)* %ptr
;   %insert = insertelement <3 x i16> %vec, i16 %val, i32 %idx
;   store <3 x i16> %insert, <3 x i16> addrspace(1)* null
;   ret void
; }

define amdgpu_ps void @insertelement_v_v4i16_s_s(<4 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_lshr_b32 s1, s3, 1
; GFX9-NEXT:    s_and_b32 s3, s3, 1
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_and_b32 s2, s2, s0
; GFX9-NEXT:    s_lshl_b32 s3, s3, 4
; GFX9-NEXT:    s_lshl_b32 s0, s0, s3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX9-NEXT:    s_not_b32 s0, s0
; GFX9-NEXT:    v_mov_b32_e32 v4, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v4, v5, s0, v4
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_lshr_b32 s1, s3, 1
; GFX8-NEXT:    s_and_b32 s3, s3, 1
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s3, s3, 4
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s3
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v4, s0, v4
; GFX8-NEXT:    v_or_b32_e32 v4, s2, v4
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX7-NEXT:    s_lshr_b32 s1, s3, 1
; GFX7-NEXT:    s_and_b32 s3, s3, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s3, s3, 4
; GFX7-NEXT:    s_and_b32 s2, s2, s0
; GFX7-NEXT:    s_lshl_b32 s0, s0, s3
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    s_lshl_b32 s2, s2, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v4, s0, v4
; GFX7-NEXT:    v_or_b32_e32 v4, s2, v4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s1, s3, 1
; GFX10-NEXT:    s_and_b32 s3, s3, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s1, 1
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    s_lshl_b32 s3, s3, 4
; GFX10-NEXT:    s_and_b32 s2, s2, s0
; GFX10-NEXT:    s_lshl_b32 s0, s0, s3
; GFX10-NEXT:    s_lshl_b32 s2, s2, s3
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v2, s0, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(1 )* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i16_v_s(<4 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v4i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s2, s4, 1
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_mov_b32 s5, 0xffff
; GFX9-NEXT:    v_and_b32_e32 v0, s5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s3, s1, s0
; GFX9-NEXT:    s_and_b32 s4, s4, 1
; GFX9-NEXT:    s_lshl_b32 s4, s4, 4
; GFX9-NEXT:    s_lshl_b32 s5, s5, s4
; GFX9-NEXT:    s_andn2_b32 s3, s3, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_lshl_or_b32 v4, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s2, s4, 1
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_mov_b32 s5, 0xffff
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s4, s4, 1
; GFX8-NEXT:    s_lshl_b32 s4, s4, 4
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, s5, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_andn2_b32 s3, s3, s4
; GFX8-NEXT:    v_or_b32_e32 v4, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s2, s4, 1
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_mov_b32 s5, 0xffff
; GFX7-NEXT:    v_and_b32_e32 v0, s5, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s3, s1, s0
; GFX7-NEXT:    s_and_b32 s4, s4, 1
; GFX7-NEXT:    s_lshl_b32 s4, s4, 4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, s5, s4
; GFX7-NEXT:    s_andn2_b32 s3, s3, s4
; GFX7-NEXT:    v_or_b32_e32 v4, s3, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s2, s4, 1
; GFX10-NEXT:    s_mov_b32 s5, 0xffff
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    v_and_b32_e32 v2, s5, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s3, s1, s0
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_lshl_b32 s4, s4, 4
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_lshl_b32 s5, s5, s4
; GFX10-NEXT:    s_andn2_b32 s3, s3, s5
; GFX10-NEXT:    v_lshl_or_b32 v4, v2, s4, s3
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(4)* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i16_s_v(<4 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    s_and_b32 s3, s4, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v0, s3
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s2
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v4, v1, v0, v3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX8-NEXT:    s_and_b32 s3, s4, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v0, s3
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s2
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v4, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    s_mov_b32 s2, 0xffff
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX7-NEXT:    s_and_b32 s3, s4, s2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_lshl_b32_e32 v3, s3, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s2, v0
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v4, v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v1, 1, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 1, v0
; GFX10-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-NEXT:    s_and_b32 s3, s4, s2
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, s2
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v1, s3
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s1
; GFX10-NEXT:    v_cndmask_b32_e32 v5, s0, v0, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v4
; GFX10-NEXT:    v_and_or_b32 v5, v5, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(4)* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i16_v_v(<4 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 1, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v4, v3, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v4, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    s_mov_b32 s2, 0xffff
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, s2, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-NEXT:    v_mov_b32_e32 v4, s1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v2, 1, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 1, v1
; GFX10-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v2, s2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cndmask_b32_e32 v5, s0, v1, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v4
; GFX10-NEXT:    v_and_or_b32 v5, v5, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(4)* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i16_s_v(<4 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 1, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_and_b32 s1, s2, s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX9-NEXT:    v_lshlrev_b32_e64 v6, v2, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v5
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v7, v2, v6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    global_store_dwordx2 v[3:4], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v6, v2, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX8-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v5
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 1, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_and_b32 s1, s2, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX7-NEXT:    v_lshl_b32_e32 v6, s1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX7-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v5
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v3, 1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 1, v2
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 4, v3
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v5
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX10-NEXT:    s_and_b32 s0, s2, s0
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v3, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v5
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v4, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(1)* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i16_v_s(<4 x i16> addrspace(1)* %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_lshr_b32 s1, s2, 1
; GFX9-NEXT:    s_and_b32 s2, s2, 1
; GFX9-NEXT:    s_lshl_b32 s2, s2, 4
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    s_not_b32 s0, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v5, s0, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    global_store_dwordx2 v[3:4], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_lshr_b32 s1, s2, 1
; GFX8-NEXT:    s_and_b32 s2, s2, 1
; GFX8-NEXT:    s_lshl_b32 s2, s2, 4
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    v_mov_b32_e32 v5, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, s0, v5
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX7-NEXT:    s_lshr_b32 s1, s2, 1
; GFX7-NEXT:    s_and_b32 s2, s2, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s2, s2, 4
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, s2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, s2, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v5, s0, v5
; GFX7-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s1, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_and_b32 s0, s2, 1
; GFX10-NEXT:    s_lshr_b32 s2, s2, 1
; GFX10-NEXT:    s_lshl_b32 s0, s0, 4
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX10-NEXT:    s_mov_b32 s1, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    s_lshl_b32 s0, s1, s0
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v3, s0, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s2, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(1)* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i16_v_v(<4 x i16> addrspace(1)* %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 1, v3
; GFX9-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 4, v3
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v7, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    global_store_dwordx2 v[4:5], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 4, v3
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX8-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, v7, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 1, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, s0, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX7-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX7-NEXT:    v_mov_b32_e32 v5, 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, v7, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v4, 1, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 1, v3
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 4, v4
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v6
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v5
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v4, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i16>, <4 x i16> addrspace(1)* %ptr
  %insert = insertelement <4 x i16> %vec, i16 %val, i32 %idx
  store <4 x i16> %insert, <4 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i16_s_s(<8 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s6, s5, 1
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_mov_b32 s8, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s7, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s7, s2, s7
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s7, s3, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 1
; GFX9-NEXT:    s_lshl_b32 s5, s5, 4
; GFX9-NEXT:    s_and_b32 s4, s4, s8
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, s8, s5
; GFX9-NEXT:    s_andn2_b32 s5, s7, s5
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_cmp_eq_u32 s6, 0
; GFX9-NEXT:    s_cselect_b32 s0, s4, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s1, s4, s1
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s2, s4, s2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s3, s4, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s6, s5, 1
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_mov_b32 s8, 0xffff
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s7, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s7, s2, s7
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s7, s3, s7
; GFX8-NEXT:    s_and_b32 s5, s5, 1
; GFX8-NEXT:    s_lshl_b32 s5, s5, 4
; GFX8-NEXT:    s_and_b32 s4, s4, s8
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, s8, s5
; GFX8-NEXT:    s_andn2_b32 s5, s7, s5
; GFX8-NEXT:    s_or_b32 s4, s5, s4
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    s_cselect_b32 s0, s4, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_cselect_b32 s1, s4, s1
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s2, s4, s2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s3, s4, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s6, s5, 1
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_mov_b32 s8, 0xffff
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s7, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s7, s2, s7
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s7, s3, s7
; GFX7-NEXT:    s_and_b32 s5, s5, 1
; GFX7-NEXT:    s_lshl_b32 s5, s5, 4
; GFX7-NEXT:    s_and_b32 s4, s4, s8
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, s8, s5
; GFX7-NEXT:    s_andn2_b32 s5, s7, s5
; GFX7-NEXT:    s_or_b32 s4, s5, s4
; GFX7-NEXT:    s_cmp_eq_u32 s6, 0
; GFX7-NEXT:    s_cselect_b32 s0, s4, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_cselect_b32 s1, s4, s1
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s2, s4, s2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s3, s4, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s6, s5, 1
; GFX10-NEXT:    s_mov_b32 s8, 0xffff
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s7, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 2
; GFX10-NEXT:    s_cselect_b32 s7, s2, s7
; GFX10-NEXT:    s_cmp_eq_u32 s6, 3
; GFX10-NEXT:    s_cselect_b32 s7, s3, s7
; GFX10-NEXT:    s_and_b32 s5, s5, 1
; GFX10-NEXT:    s_and_b32 s4, s4, s8
; GFX10-NEXT:    s_lshl_b32 s5, s5, 4
; GFX10-NEXT:    s_lshl_b32 s8, s8, s5
; GFX10-NEXT:    s_lshl_b32 s4, s4, s5
; GFX10-NEXT:    s_andn2_b32 s5, s7, s8
; GFX10-NEXT:    s_or_b32 s4, s5, s4
; GFX10-NEXT:    s_cmp_eq_u32 s6, 0
; GFX10-NEXT:    s_cselect_b32 s0, s4, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    s_cselect_b32 s1, s4, s1
; GFX10-NEXT:    s_cmp_eq_u32 s6, 2
; GFX10-NEXT:    s_cselect_b32 s2, s4, s2
; GFX10-NEXT:    s_cmp_eq_u32 s6, 3
; GFX10-NEXT:    s_cselect_b32 s3, s4, s3
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(4)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i16_s_s(<8 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_and_b32 s1, s3, 1
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_lshr_b32 s4, s3, 1
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_and_b32 s2, s2, s0
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_lshl_b32 s2, s2, s1
; GFX9-NEXT:    s_not_b32 s5, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v3, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v6, v7, s5, v6
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s3, 1
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshr_b32 s4, s3, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_lshl_b32 s5, s2, s1
; GFX8-NEXT:    s_not_b32 s6, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v3, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX8-NEXT:    v_or_b32_e32 v6, s5, v6
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_and_b32 s1, s3, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshr_b32 s4, s3, 1
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    s_and_b32 s2, s2, s0
; GFX7-NEXT:    s_lshl_b32 s0, s0, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_lshl_b32 s5, s2, s1
; GFX7-NEXT:    s_not_b32 s6, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_or_b32_e32 v4, s5, v4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s4, s3, 1
; GFX10-NEXT:    s_and_b32 s1, s3, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s4, 2
; GFX10-NEXT:    s_lshl_b32 s3, s1, 4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s4, 3
; GFX10-NEXT:    s_mov_b32 s5, 0xffff
; GFX10-NEXT:    s_and_b32 s2, s2, s5
; GFX10-NEXT:    s_lshl_b32 s5, s5, s3
; GFX10-NEXT:    s_lshl_b32 s2, s2, s3
; GFX10-NEXT:    s_not_b32 s3, s5
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s1
; GFX10-NEXT:    v_and_or_b32 v6, v4, s3, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s1
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(1 )* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i16_v_s(<8 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s5, s4, 1
; GFX9-NEXT:    s_cmp_eq_u32 s5, 1
; GFX9-NEXT:    s_mov_b32 s7, 0xffff
; GFX9-NEXT:    v_and_b32_e32 v0, s7, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s6, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 2
; GFX9-NEXT:    s_cselect_b32 s6, s2, s6
; GFX9-NEXT:    s_cmp_eq_u32 s5, 3
; GFX9-NEXT:    s_cselect_b32 s6, s3, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 1
; GFX9-NEXT:    s_lshl_b32 s4, s4, 4
; GFX9-NEXT:    s_lshl_b32 s7, s7, s4
; GFX9-NEXT:    s_andn2_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_lshl_or_b32 v6, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s5, s4, 1
; GFX8-NEXT:    s_cmp_eq_u32 s5, 1
; GFX8-NEXT:    s_mov_b32 s7, 0xffff
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s6, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s5, 2
; GFX8-NEXT:    s_cselect_b32 s6, s2, s6
; GFX8-NEXT:    s_cmp_eq_u32 s5, 3
; GFX8-NEXT:    s_cselect_b32 s6, s3, s6
; GFX8-NEXT:    s_and_b32 s4, s4, 1
; GFX8-NEXT:    s_lshl_b32 s4, s4, 4
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, s7, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_andn2_b32 s4, s6, s4
; GFX8-NEXT:    v_or_b32_e32 v6, s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s5, s4, 1
; GFX7-NEXT:    s_cmp_eq_u32 s5, 1
; GFX7-NEXT:    s_mov_b32 s7, 0xffff
; GFX7-NEXT:    v_and_b32_e32 v0, s7, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s6, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s5, 2
; GFX7-NEXT:    s_cselect_b32 s6, s2, s6
; GFX7-NEXT:    s_cmp_eq_u32 s5, 3
; GFX7-NEXT:    s_cselect_b32 s6, s3, s6
; GFX7-NEXT:    s_and_b32 s4, s4, 1
; GFX7-NEXT:    s_lshl_b32 s4, s4, 4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, s7, s4
; GFX7-NEXT:    s_andn2_b32 s4, s6, s4
; GFX7-NEXT:    v_or_b32_e32 v4, s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s5, s4, 1
; GFX10-NEXT:    s_mov_b32 s7, 0xffff
; GFX10-NEXT:    s_cmp_eq_u32 s5, 1
; GFX10-NEXT:    v_and_b32_e32 v4, s7, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s6, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s5, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_cselect_b32 s6, s2, s6
; GFX10-NEXT:    s_cmp_eq_u32 s5, 3
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_cselect_b32 s6, s3, s6
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    s_lshl_b32 s4, s4, 4
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_lshl_b32 s7, s7, s4
; GFX10-NEXT:    s_andn2_b32 s6, s6, s7
; GFX10-NEXT:    v_lshl_or_b32 v6, v4, s4, s6
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 3
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc_lo
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(4)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i16_s_v(<8 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 1, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_mov_b32 s5, 0xffff
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    s_and_b32 s4, s4, s5
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v6, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_mov_b32 s5, 0xffff
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NEXT:    v_mov_b32_e32 v3, s10
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX8-NEXT:    s_and_b32 s4, s4, s5
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v6, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    s_mov_b32 s5, 0xffff
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s8
; GFX7-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-NEXT:    v_mov_b32_e32 v3, s10
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX7-NEXT:    s_and_b32 s4, s4, s5
; GFX7-NEXT:    v_lshl_b32_e32 v2, s4, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v5, v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v1, 1, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 1, v0
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    s_and_b32 s1, s4, s0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v6
; GFX10-NEXT:    v_xor_b32_e32 v5, -1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s9
; GFX10-NEXT:    v_cndmask_b32_e32 v0, s8, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, s10, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v0, s11, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_mov_b32_e32 v2, s10
; GFX10-NEXT:    v_mov_b32_e32 v3, s11
; GFX10-NEXT:    v_and_or_b32 v7, v7, v5, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(4)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i16_v_v(<8 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 1, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    s_mov_b32 s8, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v6, s7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v6, v2, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_mov_b32_e32 v5, s6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    s_mov_b32 s8, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v6, s7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v6, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    s_mov_b32 s8, 0xffff
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    v_mov_b32_e32 v5, s6
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s8, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, s8, v1
; GFX7-NEXT:    v_mov_b32_e32 v6, s7
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_or_b32_e32 v5, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 1, v1
; GFX10-NEXT:    v_and_b32_e32 v2, 1, v1
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v2, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_xor_b32_e32 v5, -1, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_cndmask_b32_e32 v1, s4, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v1, s7, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-NEXT:    v_mov_b32_e32 v3, s7
; GFX10-NEXT:    v_and_or_b32 v7, v7, v5, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(4)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i16_s_v(<8 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_and_b32 s1, s2, s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v3, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v9, v9, v1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v3, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v9, v9, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v9, v9, v6, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v1, v9, v1
; GFX8-NEXT:    v_or_b32_e32 v9, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_and_b32 s1, s2, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v2, s1, v1
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v7, v3, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v7, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v7, v6, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v1, v7, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v1, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v3, v7, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v7, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v5, v7, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v6, v7, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 1, v2
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    s_and_b32 s1, s2, s0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v7, v0, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v1
; GFX10-NEXT:    v_xor_b32_e32 v7, -1, v7
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s1
; GFX10-NEXT:    v_and_or_b32 v9, v2, v7, v0
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s1
; GFX10-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(1)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i16_v_s(<8 x i16> addrspace(1)* %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_and_b32 s1, s2, 1
; GFX9-NEXT:    s_lshr_b32 s4, s2, 1
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    s_not_b32 s5, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v9, v1, s5, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s2, 1
; GFX8-NEXT:    s_lshr_b32 s4, s2, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    s_not_b32 s5, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_mov_b32_e32 v7, 0
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX8-NEXT:    v_or_b32_e32 v9, v1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_and_b32 s1, s2, 1
; GFX7-NEXT:    s_lshr_b32 s4, s2, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s1, v0
; GFX7-NEXT:    s_not_b32 s5, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v3, v7, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v7, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v5, v7, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v6, v7, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s3, s2, 1
; GFX10-NEXT:    s_and_b32 s1, s2, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s3, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s3, 2
; GFX10-NEXT:    s_lshl_b32 s2, s1, 4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s3, 3
; GFX10-NEXT:    s_mov_b32 s4, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    s_lshl_b32 s2, s4, s2
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    s_not_b32 s2, s2
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s1
; GFX10-NEXT:    v_and_or_b32 v9, v0, s2, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s1
; GFX10-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(1)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i16_v_v(<8 x i16> addrspace(1)* %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v3, v3, v1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[4:7], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v1, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 1, v3
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v3
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v8, v0, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v8
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX10-NEXT:    v_and_or_b32 v3, v3, v2, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s1
; GFX10-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i16>, <8 x i16> addrspace(1)* %ptr
  %insert = insertelement <8 x i16> %vec, i16 %val, i32 %idx
  store <8 x i16> %insert, <8 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i16_s_s(<16 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s7, s5, 1
; GFX9-NEXT:    s_cmp_eq_u32 s7, 1
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s0, s9, s8
; GFX9-NEXT:    s_cmp_eq_u32 s7, 2
; GFX9-NEXT:    s_cselect_b32 s0, s10, s0
; GFX9-NEXT:    s_cmp_eq_u32 s7, 3
; GFX9-NEXT:    s_cselect_b32 s0, s11, s0
; GFX9-NEXT:    s_cmp_eq_u32 s7, 4
; GFX9-NEXT:    s_cselect_b32 s0, s12, s0
; GFX9-NEXT:    s_cmp_eq_u32 s7, 5
; GFX9-NEXT:    s_cselect_b32 s0, s13, s0
; GFX9-NEXT:    s_cmp_eq_u32 s7, 6
; GFX9-NEXT:    s_cselect_b32 s0, s14, s0
; GFX9-NEXT:    s_cmp_eq_u32 s7, 7
; GFX9-NEXT:    s_cselect_b32 s0, s15, s0
; GFX9-NEXT:    s_and_b32 s1, s5, 1
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_and_b32 s3, s4, s2
; GFX9-NEXT:    s_lshl_b32 s3, s3, s1
; GFX9-NEXT:    s_lshl_b32 s1, s2, s1
; GFX9-NEXT:    s_andn2_b32 s0, s0, s1
; GFX9-NEXT:    s_or_b32 s16, s0, s3
; GFX9-NEXT:    s_cmp_eq_u32 s7, 0
; GFX9-NEXT:    s_cselect_b32 s0, s16, s8
; GFX9-NEXT:    s_cmp_eq_u32 s7, 1
; GFX9-NEXT:    s_cselect_b32 s1, s16, s9
; GFX9-NEXT:    s_cmp_eq_u32 s7, 2
; GFX9-NEXT:    s_cselect_b32 s2, s16, s10
; GFX9-NEXT:    s_cmp_eq_u32 s7, 3
; GFX9-NEXT:    s_cselect_b32 s3, s16, s11
; GFX9-NEXT:    s_cmp_eq_u32 s7, 4
; GFX9-NEXT:    s_cselect_b32 s4, s16, s12
; GFX9-NEXT:    s_cmp_eq_u32 s7, 5
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_cselect_b32 s5, s16, s13
; GFX9-NEXT:    s_cmp_eq_u32 s7, 6
; GFX9-NEXT:    s_cselect_b32 s6, s16, s14
; GFX9-NEXT:    s_cmp_eq_u32 s7, 7
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_cselect_b32 s7, s16, s15
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s7, s5, 1
; GFX8-NEXT:    s_cmp_eq_u32 s7, 1
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s0, s9, s8
; GFX8-NEXT:    s_cmp_eq_u32 s7, 2
; GFX8-NEXT:    s_cselect_b32 s0, s10, s0
; GFX8-NEXT:    s_cmp_eq_u32 s7, 3
; GFX8-NEXT:    s_cselect_b32 s0, s11, s0
; GFX8-NEXT:    s_cmp_eq_u32 s7, 4
; GFX8-NEXT:    s_cselect_b32 s0, s12, s0
; GFX8-NEXT:    s_cmp_eq_u32 s7, 5
; GFX8-NEXT:    s_cselect_b32 s0, s13, s0
; GFX8-NEXT:    s_cmp_eq_u32 s7, 6
; GFX8-NEXT:    s_cselect_b32 s0, s14, s0
; GFX8-NEXT:    s_cmp_eq_u32 s7, 7
; GFX8-NEXT:    s_cselect_b32 s0, s15, s0
; GFX8-NEXT:    s_and_b32 s1, s5, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_and_b32 s3, s4, s2
; GFX8-NEXT:    s_lshl_b32 s3, s3, s1
; GFX8-NEXT:    s_lshl_b32 s1, s2, s1
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    s_or_b32 s16, s0, s3
; GFX8-NEXT:    s_cmp_eq_u32 s7, 0
; GFX8-NEXT:    s_cselect_b32 s0, s16, s8
; GFX8-NEXT:    s_cmp_eq_u32 s7, 1
; GFX8-NEXT:    s_cselect_b32 s1, s16, s9
; GFX8-NEXT:    s_cmp_eq_u32 s7, 2
; GFX8-NEXT:    s_cselect_b32 s2, s16, s10
; GFX8-NEXT:    s_cmp_eq_u32 s7, 3
; GFX8-NEXT:    s_cselect_b32 s3, s16, s11
; GFX8-NEXT:    s_cmp_eq_u32 s7, 4
; GFX8-NEXT:    s_cselect_b32 s4, s16, s12
; GFX8-NEXT:    s_cmp_eq_u32 s7, 5
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_cselect_b32 s5, s16, s13
; GFX8-NEXT:    s_cmp_eq_u32 s7, 6
; GFX8-NEXT:    s_cselect_b32 s6, s16, s14
; GFX8-NEXT:    s_cmp_eq_u32 s7, 7
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_cselect_b32 s7, s16, s15
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v4, 16
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s7, s5, 1
; GFX7-NEXT:    s_cmp_eq_u32 s7, 1
; GFX7-NEXT:    s_mov_b32 s2, 0xffff
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s0, s9, s8
; GFX7-NEXT:    s_cmp_eq_u32 s7, 2
; GFX7-NEXT:    s_cselect_b32 s0, s10, s0
; GFX7-NEXT:    s_cmp_eq_u32 s7, 3
; GFX7-NEXT:    s_cselect_b32 s0, s11, s0
; GFX7-NEXT:    s_cmp_eq_u32 s7, 4
; GFX7-NEXT:    s_cselect_b32 s0, s12, s0
; GFX7-NEXT:    s_cmp_eq_u32 s7, 5
; GFX7-NEXT:    s_cselect_b32 s0, s13, s0
; GFX7-NEXT:    s_cmp_eq_u32 s7, 6
; GFX7-NEXT:    s_cselect_b32 s0, s14, s0
; GFX7-NEXT:    s_cmp_eq_u32 s7, 7
; GFX7-NEXT:    s_cselect_b32 s0, s15, s0
; GFX7-NEXT:    s_and_b32 s1, s5, 1
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    s_and_b32 s3, s4, s2
; GFX7-NEXT:    s_lshl_b32 s3, s3, s1
; GFX7-NEXT:    s_lshl_b32 s1, s2, s1
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    s_or_b32 s16, s0, s3
; GFX7-NEXT:    s_cmp_eq_u32 s7, 0
; GFX7-NEXT:    s_cselect_b32 s0, s16, s8
; GFX7-NEXT:    s_cmp_eq_u32 s7, 1
; GFX7-NEXT:    s_cselect_b32 s1, s16, s9
; GFX7-NEXT:    s_cmp_eq_u32 s7, 2
; GFX7-NEXT:    s_cselect_b32 s2, s16, s10
; GFX7-NEXT:    s_cmp_eq_u32 s7, 3
; GFX7-NEXT:    s_cselect_b32 s3, s16, s11
; GFX7-NEXT:    s_cmp_eq_u32 s7, 4
; GFX7-NEXT:    s_cselect_b32 s4, s16, s12
; GFX7-NEXT:    s_cmp_eq_u32 s7, 5
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    s_cselect_b32 s5, s16, s13
; GFX7-NEXT:    s_cmp_eq_u32 s7, 6
; GFX7-NEXT:    s_cselect_b32 s6, s16, s14
; GFX7-NEXT:    s_cmp_eq_u32 s7, 7
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_cselect_b32 s7, s16, s15
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_mov_b64 s[8:9], 16
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s7, s5, 1
; GFX10-NEXT:    s_mov_b32 s2, 0xffff
; GFX10-NEXT:    s_cmp_eq_u32 s7, 1
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    v_mov_b32_e32 v10, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s0, s9, s8
; GFX10-NEXT:    s_cmp_eq_u32 s7, 2
; GFX10-NEXT:    s_cselect_b32 s0, s10, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 3
; GFX10-NEXT:    s_cselect_b32 s0, s11, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 4
; GFX10-NEXT:    s_cselect_b32 s0, s12, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 5
; GFX10-NEXT:    s_cselect_b32 s0, s13, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 6
; GFX10-NEXT:    s_cselect_b32 s0, s14, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 7
; GFX10-NEXT:    s_cselect_b32 s0, s15, s0
; GFX10-NEXT:    s_and_b32 s1, s5, 1
; GFX10-NEXT:    s_and_b32 s3, s4, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 4
; GFX10-NEXT:    s_lshl_b32 s2, s2, s1
; GFX10-NEXT:    s_lshl_b32 s1, s3, s1
; GFX10-NEXT:    s_andn2_b32 s0, s0, s2
; GFX10-NEXT:    s_or_b32 s16, s0, s1
; GFX10-NEXT:    s_cmp_eq_u32 s7, 0
; GFX10-NEXT:    s_cselect_b32 s0, s16, s8
; GFX10-NEXT:    s_cmp_eq_u32 s7, 1
; GFX10-NEXT:    s_cselect_b32 s1, s16, s9
; GFX10-NEXT:    s_cmp_eq_u32 s7, 2
; GFX10-NEXT:    s_cselect_b32 s2, s16, s10
; GFX10-NEXT:    s_cmp_eq_u32 s7, 3
; GFX10-NEXT:    s_cselect_b32 s3, s16, s11
; GFX10-NEXT:    s_cmp_eq_u32 s7, 4
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_cselect_b32 s4, s16, s12
; GFX10-NEXT:    s_cmp_eq_u32 s7, 5
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_cselect_b32 s5, s16, s13
; GFX10-NEXT:    s_cmp_eq_u32 s7, 6
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    s_cselect_b32 s6, s16, s14
; GFX10-NEXT:    s_cmp_eq_u32 s7, 7
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_cselect_b32 s7, s16, s15
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    v_mov_b32_e32 v5, s5
; GFX10-NEXT:    v_mov_b32_e32 v6, s6
; GFX10-NEXT:    v_mov_b32_e32 v7, s7
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(4)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i16_s_s(<16 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[0:1], off
; GFX9-NEXT:    global_load_dwordx4 v[6:9], v[0:1], off offset:16
; GFX9-NEXT:    s_and_b32 s1, s3, 1
; GFX9-NEXT:    s_lshr_b32 s12, s3, 1
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_and_b32 s2, s2, s0
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s12, 1
; GFX9-NEXT:    s_lshl_b32 s2, s2, s1
; GFX9-NEXT:    s_not_b32 s13, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s12, 2
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s12, 3
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s12, 4
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], s12, 5
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[8:9], s12, 6
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[10:11], s12, 7
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v8, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[10:11]
; GFX9-NEXT:    v_and_or_b32 v10, v1, s13, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[12:13], s12, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, v10, s[12:13]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v4, v10, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v5, v10, s[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v6, v10, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v7, v10, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v8, v10, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v9, v10, s[10:11]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 16, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GFX8-NEXT:    s_and_b32 s1, s3, 1
; GFX8-NEXT:    s_lshr_b32 s12, s3, 1
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_and_b32 s2, s2, s0
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s12, 1
; GFX8-NEXT:    s_lshl_b32 s13, s2, s1
; GFX8-NEXT:    s_not_b32 s14, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s12, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s12, 3
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s12, 4
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[6:7], s12, 5
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[8:9], s12, 6
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[10:11], s12, 7
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v0, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v3, s[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v4, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v5, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v6, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v7, s[10:11]
; GFX8-NEXT:    v_and_b32_e32 v8, s14, v8
; GFX8-NEXT:    v_or_b32_e32 v8, s13, v8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[12:13], s12, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v8, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v8, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v8, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v8, s[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v8, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v8, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v8, s[10:11]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i16_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s18, 0
; GFX7-NEXT:    s_mov_b32 s19, 0xf000
; GFX7-NEXT:    s_mov_b64 s[16:17], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[2:5], v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    buffer_load_dwordx4 v[6:9], v[0:1], s[16:19], 0 addr64 offset:16
; GFX7-NEXT:    s_and_b32 s1, s3, 1
; GFX7-NEXT:    s_lshr_b32 s12, s3, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    s_and_b32 s2, s2, s0
; GFX7-NEXT:    s_lshl_b32 s0, s0, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s12, 1
; GFX7-NEXT:    s_lshl_b32 s13, s2, s1
; GFX7-NEXT:    s_not_b32 s14, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s12, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s12, 3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s12, 4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[6:7], s12, 5
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[8:9], s12, 6
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[10:11], s12, 7
; GFX7-NEXT:    s_mov_b32 s18, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v8, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[10:11]
; GFX7-NEXT:    v_and_b32_e32 v0, s14, v0
; GFX7-NEXT:    v_or_b32_e32 v10, s13, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[12:13], s12, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, v10, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v4, v10, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v5, v10, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v6, v10, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v7, v10, s[6:7]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v8, v10, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v9, v10, s[10:11]
; GFX7-NEXT:    s_mov_b64 s[16:17], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[16:19], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[2:5], v[0:1], off
; GFX10-NEXT:    global_load_dwordx4 v[6:9], v[0:1], off offset:16
; GFX10-NEXT:    s_lshr_b32 s7, s3, 1
; GFX10-NEXT:    s_mov_b32 s8, 0xffff
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s7, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s7, 2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s7, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, s7, 4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s5, s7, 5
; GFX10-NEXT:    v_cmp_eq_u32_e64 s6, s7, 6
; GFX10-NEXT:    s_and_b32 s9, s2, s8
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s7, 7
; GFX10-NEXT:    s_and_b32 s3, s3, 1
; GFX10-NEXT:    v_mov_b32_e32 v10, 0
; GFX10-NEXT:    s_lshl_b32 s3, s3, 4
; GFX10-NEXT:    v_mov_b32_e32 v11, 0
; GFX10-NEXT:    s_lshl_b32 s8, s8, s3
; GFX10-NEXT:    s_lshl_b32 s3, s9, s3
; GFX10-NEXT:    s_not_b32 s8, s8
; GFX10-NEXT:    v_mov_b32_e32 v13, 0
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v8, s6
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s2
; GFX10-NEXT:    v_and_or_b32 v12, v0, s8, s3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s3, s7, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v12, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, v12, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v4, v12, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v5, v12, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v6, v12, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v7, v12, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v8, v12, s6
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v9, v12, s2
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[10:11], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v13, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(1 )* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i16_v_s(<16 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s2, s4, 1
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_mov_b32 s3, 0xffff
; GFX9-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s0, s9, s8
; GFX9-NEXT:    s_cmp_eq_u32 s2, 2
; GFX9-NEXT:    s_cselect_b32 s0, s10, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 3
; GFX9-NEXT:    s_cselect_b32 s0, s11, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 4
; GFX9-NEXT:    s_cselect_b32 s0, s12, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 5
; GFX9-NEXT:    s_cselect_b32 s0, s13, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 6
; GFX9-NEXT:    s_cselect_b32 s0, s14, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 7
; GFX9-NEXT:    s_cselect_b32 s0, s15, s0
; GFX9-NEXT:    s_and_b32 s1, s4, 1
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_lshl_b32 s3, s3, s1
; GFX9-NEXT:    s_andn2_b32 s0, s0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_lshl_or_b32 v8, v0, s1, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v5, s13
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v5, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v6, s14
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v4, s12
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, 4
; GFX9-NEXT:    v_mov_b32_e32 v7, s15
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 7
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v4, v8, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_store_dwordx4 v0, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s2, s4, 1
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_mov_b32 s3, 0xffff
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s0, s9, s8
; GFX8-NEXT:    s_cmp_eq_u32 s2, 2
; GFX8-NEXT:    s_cselect_b32 s0, s10, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 3
; GFX8-NEXT:    s_cselect_b32 s0, s11, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 4
; GFX8-NEXT:    s_cselect_b32 s0, s12, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 5
; GFX8-NEXT:    s_cselect_b32 s0, s13, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 6
; GFX8-NEXT:    s_cselect_b32 s0, s14, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 7
; GFX8-NEXT:    s_cselect_b32 s0, s15, s0
; GFX8-NEXT:    s_and_b32 s1, s4, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b32 s1, s3, s1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    v_or_b32_e32 v8, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v6, s14
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, 4
; GFX8-NEXT:    v_mov_b32_e32 v7, s15
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 7
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v8, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s2, s4, 1
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_mov_b32 s3, 0xffff
; GFX7-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s0, s9, s8
; GFX7-NEXT:    s_cmp_eq_u32 s2, 2
; GFX7-NEXT:    s_cselect_b32 s0, s10, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 3
; GFX7-NEXT:    s_cselect_b32 s0, s11, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 4
; GFX7-NEXT:    s_cselect_b32 s0, s12, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 5
; GFX7-NEXT:    s_cselect_b32 s0, s13, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 6
; GFX7-NEXT:    s_cselect_b32 s0, s14, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 7
; GFX7-NEXT:    s_cselect_b32 s0, s15, s0
; GFX7-NEXT:    s_and_b32 s1, s4, 1
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s1, v0
; GFX7-NEXT:    s_lshl_b32 s1, s3, s1
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    v_or_b32_e32 v8, s0, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX7-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v8, vcc
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v8, vcc
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 3
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v8, vcc
; GFX7-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 5
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v5, v8, vcc
; GFX7-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, 4
; GFX7-NEXT:    v_mov_b32_e32 v6, s14
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 6
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v8, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v6, v6, v8, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 7
; GFX7-NEXT:    v_mov_b32_e32 v7, s15
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s0, s4, 1
; GFX10-NEXT:    s_mov_b32 s3, 0xffff
; GFX10-NEXT:    s_cmp_eq_u32 s0, 1
; GFX10-NEXT:    v_and_b32_e32 v8, s3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 0
; GFX10-NEXT:    v_mov_b32_e32 v11, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s1, s9, s8
; GFX10-NEXT:    s_cmp_eq_u32 s0, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    s_cselect_b32 s1, s10, s1
; GFX10-NEXT:    s_cmp_eq_u32 s0, 3
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    s_cselect_b32 s1, s11, s1
; GFX10-NEXT:    s_cmp_eq_u32 s0, 4
; GFX10-NEXT:    v_mov_b32_e32 v2, s10
; GFX10-NEXT:    s_cselect_b32 s1, s12, s1
; GFX10-NEXT:    s_cmp_eq_u32 s0, 5
; GFX10-NEXT:    v_mov_b32_e32 v3, s11
; GFX10-NEXT:    s_cselect_b32 s1, s13, s1
; GFX10-NEXT:    s_cmp_eq_u32 s0, 6
; GFX10-NEXT:    v_mov_b32_e32 v4, s12
; GFX10-NEXT:    s_cselect_b32 s1, s14, s1
; GFX10-NEXT:    s_cmp_eq_u32 s0, 7
; GFX10-NEXT:    v_mov_b32_e32 v5, s13
; GFX10-NEXT:    s_cselect_b32 s1, s15, s1
; GFX10-NEXT:    s_and_b32 s2, s4, 1
; GFX10-NEXT:    v_mov_b32_e32 v6, s14
; GFX10-NEXT:    s_lshl_b32 s2, s2, 4
; GFX10-NEXT:    v_mov_b32_e32 v7, s15
; GFX10-NEXT:    s_lshl_b32 s3, s3, s2
; GFX10-NEXT:    s_andn2_b32 s1, s1, s3
; GFX10-NEXT:    v_lshl_or_b32 v10, v8, s2, s1
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 3
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 6
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 7
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v10, vcc_lo
; GFX10-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v11, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(4)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i16_s_v(<16 x i16> addrspace(4)* inreg %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[16:23], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-NEXT:    v_mov_b32_e32 v2, s17
; GFX9-NEXT:    v_mov_b32_e32 v3, s18
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v4, s19
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v5, s20
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[14:15], 4, v8
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_mov_b32 s5, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v6, s21
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[14:15]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v8
; GFX9-NEXT:    v_mov_b32_e32 v7, s22
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[6:7]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-NEXT:    s_and_b32 s4, s4, s5
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[8:9]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[10:11]
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v9, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[12:13]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v4, v9, s[14:15]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v9, s[10:11]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_store_dwordx4 v0, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx8 s[16:23], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s16
; GFX8-NEXT:    v_mov_b32_e32 v2, s17
; GFX8-NEXT:    v_mov_b32_e32 v3, s18
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v4, s19
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v5, s20
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[14:15], 4, v8
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_mov_b32 s5, 0xffff
; GFX8-NEXT:    v_mov_b32_e32 v6, s21
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[14:15]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v8
; GFX8-NEXT:    v_mov_b32_e32 v7, s22
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[6:7]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX8-NEXT:    s_and_b32 s4, s4, s5
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX8-NEXT:    v_mov_b32_e32 v9, s23
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[8:9]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[10:11]
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v9, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NEXT:    v_mov_b32_e32 v2, s18
; GFX8-NEXT:    v_mov_b32_e32 v3, s19
; GFX8-NEXT:    v_mov_b32_e32 v4, s20
; GFX8-NEXT:    v_mov_b32_e32 v5, s21
; GFX8-NEXT:    v_mov_b32_e32 v6, s22
; GFX8-NEXT:    v_mov_b32_e32 v7, s23
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v9, s[14:15]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v9, s[10:11]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx8 s[16:23], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s16
; GFX7-NEXT:    v_mov_b32_e32 v2, s17
; GFX7-NEXT:    v_mov_b32_e32 v3, s18
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_mov_b32_e32 v4, s19
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v5, s20
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[2:3]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[14:15], 4, v8
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    s_mov_b32 s5, 0xffff
; GFX7-NEXT:    v_mov_b32_e32 v6, s21
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[14:15]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v8
; GFX7-NEXT:    v_mov_b32_e32 v7, s22
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[6:7]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX7-NEXT:    s_and_b32 s4, s4, s5
; GFX7-NEXT:    v_lshl_b32_e32 v2, s4, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_mov_b32_e32 v9, s23
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[8:9]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v8
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[10:11]
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v9, v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s16
; GFX7-NEXT:    v_mov_b32_e32 v1, s17
; GFX7-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-NEXT:    v_mov_b32_e32 v3, s19
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v8
; GFX7-NEXT:    v_mov_b32_e32 v4, s20
; GFX7-NEXT:    v_mov_b32_e32 v5, s21
; GFX7-NEXT:    v_mov_b32_e32 v6, s22
; GFX7-NEXT:    v_mov_b32_e32 v7, s23
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v9, s[14:15]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v7, v9, s[10:11]
; GFX7-NEXT:    s_mov_b64 s[0:1], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 1, v0
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_mov_b32 s5, 0xffff
; GFX10-NEXT:    v_mov_b32_e32 v12, 0
; GFX10-NEXT:    s_and_b32 s6, s4, s5
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 4, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s3, 5, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, 6, v10
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, s5
; GFX10-NEXT:    v_cmp_eq_u32_e64 s5, 7, v10
; GFX10-NEXT:    v_lshlrev_b32_e64 v8, v0, s6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s6, 0, v10
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_xor_b32_e32 v9, -1, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, s8, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s10, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s11, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s12, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s13, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s14, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v11, v1, s15, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_mov_b32_e32 v2, s10
; GFX10-NEXT:    v_mov_b32_e32 v3, s11
; GFX10-NEXT:    v_and_or_b32 v11, v11, v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v4, s12
; GFX10-NEXT:    v_mov_b32_e32 v5, s13
; GFX10-NEXT:    v_mov_b32_e32 v6, s14
; GFX10-NEXT:    v_mov_b32_e32 v7, s15
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v11, s6
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v11, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v11, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, v11, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v5, v11, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v6, v11, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v7, v11, s5
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v12, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(4)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i16_v_v(<16 x i16> addrspace(4)* inreg %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[12:19], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 1, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s12
; GFX9-NEXT:    v_mov_b32_e32 v3, s13
; GFX9-NEXT:    v_mov_b32_e32 v4, s14
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_mov_b32_e32 v5, s15
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v6, s16
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v8
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_mov_b32_e32 v7, s17
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[4:5]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_mov_b32_e32 v9, s18
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s[6:7]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v8
; GFX9-NEXT:    s_mov_b32 s20, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s20
; GFX9-NEXT:    v_mov_b32_e32 v10, s19
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[8:9]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v10, s[10:11]
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v9, v2, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-NEXT:    v_mov_b32_e32 v3, s15
; GFX9-NEXT:    v_mov_b32_e32 v4, s16
; GFX9-NEXT:    v_mov_b32_e32 v5, s17
; GFX9-NEXT:    v_mov_b32_e32 v6, s18
; GFX9-NEXT:    v_mov_b32_e32 v7, s19
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[12:13]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v4, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v9, s[10:11]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_store_dwordx4 v0, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx8 s[12:19], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 1, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s12
; GFX8-NEXT:    v_mov_b32_e32 v3, s13
; GFX8-NEXT:    v_mov_b32_e32 v4, s14
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_mov_b32_e32 v5, s15
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v6, s16
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v8
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, s17
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[4:5]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, s18
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s[6:7]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v8
; GFX8-NEXT:    s_mov_b32 s20, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s20
; GFX8-NEXT:    v_mov_b32_e32 v10, s19
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[8:9]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v10, s[10:11]
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v9, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NEXT:    v_mov_b32_e32 v2, s14
; GFX8-NEXT:    v_mov_b32_e32 v3, s15
; GFX8-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NEXT:    v_mov_b32_e32 v6, s18
; GFX8-NEXT:    v_mov_b32_e32 v7, s19
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, v9, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v9, s[10:11]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx8 s[12:19], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s12
; GFX7-NEXT:    v_mov_b32_e32 v3, s13
; GFX7-NEXT:    v_mov_b32_e32 v4, s14
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX7-NEXT:    v_mov_b32_e32 v5, s15
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v6, s16
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[2:3]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v8
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    s_mov_b32 s20, 0xffff
; GFX7-NEXT:    v_mov_b32_e32 v7, s17
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[4:5]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v8
; GFX7-NEXT:    v_mov_b32_e32 v9, s18
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s[6:7]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s20, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, s20, v1
; GFX7-NEXT:    v_mov_b32_e32 v10, s19
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[8:9]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v8
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v10, s[10:11]
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_or_b32_e32 v9, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-NEXT:    v_mov_b32_e32 v2, s14
; GFX7-NEXT:    v_mov_b32_e32 v3, s15
; GFX7-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-NEXT:    v_mov_b32_e32 v6, s18
; GFX7-NEXT:    v_mov_b32_e32 v7, s19
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v8
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v9, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v7, v9, s[10:11]
; GFX7-NEXT:    s_mov_b64 s[0:1], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx8 s[8:15], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 1, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX10-NEXT:    s_mov_b32 s4, 0xffff
; GFX10-NEXT:    v_mov_b32_e32 v12, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 4, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s3, 5, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s5, 7, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s6, 0, v10
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v1, s4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, 6, v10
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, s9
; GFX10-NEXT:    v_xor_b32_e32 v9, -1, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, s8, v2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s10, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s11, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s12, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s13, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s14, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v11, v2, s15, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_mov_b32_e32 v2, s10
; GFX10-NEXT:    v_mov_b32_e32 v3, s11
; GFX10-NEXT:    v_and_or_b32 v11, v11, v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v4, s12
; GFX10-NEXT:    v_mov_b32_e32 v5, s13
; GFX10-NEXT:    v_mov_b32_e32 v6, s14
; GFX10-NEXT:    v_mov_b32_e32 v7, s15
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v11, s6
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v11, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v11, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, v11, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v5, v11, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v6, v11, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v7, v11, s5
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v12, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(4)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i16_s_v(<16 x i16> addrspace(1)* %ptr, i16 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off offset:16
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_and_b32 s1, s2, s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v0
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cndmask_b32_e32 v11, v3, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v6, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v7, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v8, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v9, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v10, s[10:11]
; GFX9-NEXT:    v_and_or_b32 v11, v11, v1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v5, v11, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v11, s[12:13]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v6, v11, s[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v8, v11, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v9, v11, s[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v11, vcc
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v7, v11, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v10, v11, s[10:11]
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 16, v0
; GFX8-NEXT:    v_addc_u32_e32 v8, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    flat_load_dwordx4 v[7:10], v[7:8]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_and_b32 s1, s2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v0
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v3, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v11, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v11, v6, s[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v11, v7, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v11, v8, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v11, v9, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v11, v10, s[10:11]
; GFX8-NEXT:    v_and_b32_e32 v1, v11, v1
; GFX8-NEXT:    v_or_b32_e32 v11, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v11, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v11, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v11, s[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v8, v11, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v9, v11, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v11, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v7, v11, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v10, v11, s[10:11]
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i16_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s18, 0
; GFX7-NEXT:    s_mov_b32 s19, 0xf000
; GFX7-NEXT:    s_mov_b64 s[16:17], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    buffer_load_dwordx4 v[7:10], v[0:1], s[16:19], 0 addr64 offset:16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v2
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_and_b32 s1, s2, s0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v2, s1, v1
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v0
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v0
; GFX7-NEXT:    s_mov_b32 s18, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_cndmask_b32_e32 v11, v3, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v11, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v11, v6, s[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v11, v7, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v11, v8, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v11, v9, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v11, v10, s[10:11]
; GFX7-NEXT:    v_and_b32_e32 v1, v11, v1
; GFX7-NEXT:    v_or_b32_e32 v11, v1, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v3, v11, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v11, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v5, v11, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v6, v11, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v7, v11, s[4:5]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v8, v11, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v9, v11, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v10, v11, s[10:11]
; GFX7-NEXT:    s_mov_b64 s[16:17], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[16:19], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off offset:16
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 1, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX10-NEXT:    s_mov_b32 s5, 0xffff
; GFX10-NEXT:    v_mov_b32_e32 v14, 0
; GFX10-NEXT:    s_and_b32 s6, s2, s5
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s3, 4, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, 5, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 6, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v11, v2, s5
; GFX10-NEXT:    v_cmp_eq_u32_e64 s5, 7, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v2, s6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s6, 0, v0
; GFX10-NEXT:    v_xor_b32_e32 v11, -1, v11
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v8, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v10, s5
; GFX10-NEXT:    v_and_or_b32 v13, v1, v11, v2
; GFX10-NEXT:    v_mov_b32_e32 v11, 0
; GFX10-NEXT:    v_mov_b32_e32 v12, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v3, v13, s6
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v13, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v5, v13, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v6, v13, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v7, v13, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v8, v13, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v9, v13, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v10, v13, s5
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[11:12], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v14, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(1)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i16_v_s(<16 x i16> addrspace(1)* %ptr, i16 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off offset:16
; GFX9-NEXT:    s_and_b32 s1, s2, 1
; GFX9-NEXT:    s_lshr_b32 s12, s2, 1
; GFX9-NEXT:    s_lshl_b32 s1, s1, 4
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s12, 1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    s_not_b32 s13, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s12, 2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s12, 3
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s12, 4
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], s12, 5
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[8:9], s12, 6
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[10:11], s12, 7
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v8, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v10, s[10:11]
; GFX9-NEXT:    v_and_or_b32 v11, v1, s13, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[12:13], s12, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v5, v11, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v11, s[12:13]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v6, v11, s[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v8, v11, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v9, v11, s[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v11, vcc
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v7, v11, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v10, v11, s[10:11]
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 16, v0
; GFX8-NEXT:    v_addc_u32_e32 v8, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    flat_load_dwordx4 v[7:10], v[7:8]
; GFX8-NEXT:    s_and_b32 s1, s2, 1
; GFX8-NEXT:    s_lshr_b32 s12, s2, 1
; GFX8-NEXT:    s_lshl_b32 s1, s1, 4
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s12, 1
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    s_not_b32 s13, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s12, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s12, 3
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s12, 4
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[6:7], s12, 5
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[8:9], s12, 6
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[10:11], s12, 7
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v8, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v10, s[10:11]
; GFX8-NEXT:    v_and_b32_e32 v1, s13, v1
; GFX8-NEXT:    v_or_b32_e32 v11, v1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[12:13], s12, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v11, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v11, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v11, s[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v8, v11, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v9, v11, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v11, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v7, v11, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v10, v11, s[10:11]
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i16_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s18, 0
; GFX7-NEXT:    s_mov_b32 s19, 0xf000
; GFX7-NEXT:    s_mov_b64 s[16:17], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    buffer_load_dwordx4 v[7:10], v[0:1], s[16:19], 0 addr64 offset:16
; GFX7-NEXT:    s_and_b32 s1, s2, 1
; GFX7-NEXT:    s_lshr_b32 s12, s2, 1
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 4
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s12, 1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s1, v0
; GFX7-NEXT:    s_not_b32 s13, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s12, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s12, 3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s12, 4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[6:7], s12, 5
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[8:9], s12, 6
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[10:11], s12, 7
; GFX7-NEXT:    s_mov_b32 s18, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v8, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v10, s[10:11]
; GFX7-NEXT:    v_and_b32_e32 v1, s13, v1
; GFX7-NEXT:    v_or_b32_e32 v11, v1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[12:13], s12, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v3, v11, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v11, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v5, v11, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v6, v11, s[2:3]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v7, v11, s[4:5]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v8, v11, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v9, v11, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v10, v11, s[10:11]
; GFX7-NEXT:    s_mov_b64 s[16:17], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[16:19], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off offset:16
; GFX10-NEXT:    s_lshr_b32 s6, s2, 1
; GFX10-NEXT:    s_and_b32 s5, s2, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s6, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s6, 2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s6, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s3, s6, 4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, s6, 5
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s6, 6
; GFX10-NEXT:    s_lshl_b32 s7, s5, 4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s5, s6, 7
; GFX10-NEXT:    s_mov_b32 s8, 0xffff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    s_lshl_b32 s7, s8, s7
; GFX10-NEXT:    v_cmp_eq_u32_e64 s6, s6, 0
; GFX10-NEXT:    s_not_b32 s7, s7
; GFX10-NEXT:    v_mov_b32_e32 v11, 0
; GFX10-NEXT:    v_mov_b32_e32 v12, 0
; GFX10-NEXT:    v_mov_b32_e32 v14, 0
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v8, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v10, s5
; GFX10-NEXT:    v_and_or_b32 v13, v0, s7, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v3, v13, s6
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v13, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v5, v13, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v6, v13, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v7, v13, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v8, v13, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v9, v13, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v10, v13, s5
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[11:12], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v14, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(1)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i16_v_v(<16 x i16> addrspace(1)* %ptr, i16 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i16_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX9-NEXT:    global_load_dwordx4 v[8:11], v[0:1], off offset:16
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v0
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v8, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v10, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s[10:11]
; GFX9-NEXT:    v_and_or_b32 v12, v3, v1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v4, v12, s[12:13]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v12, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v8, v12, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v9, v12, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, v12, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v7, v12, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v10, v12, s[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v11, v12, s[10:11]
; GFX9-NEXT:    s_mov_b64 s[0:1], 16
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i16_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 16, v0
; GFX8-NEXT:    v_addc_u32_e32 v9, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GFX8-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX8-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    s_mov_b32 s0, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v0
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v8, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v10, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s[10:11]
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v12, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v4, v12, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v12, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v8, v12, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v9, v12, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, v12, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v12, s[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v10, v12, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v11, v12, s[10:11]
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    v_mov_b32_e32 v11, 0
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i16_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s18, 0
; GFX7-NEXT:    s_mov_b32 s19, 0xf000
; GFX7-NEXT:    s_mov_b64 s[16:17], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[4:7], v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    buffer_load_dwordx4 v[8:11], v[0:1], s[16:19], 0 addr64 offset:16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v3
; GFX7-NEXT:    s_mov_b32 s0, 0xffff
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[6:7], 5, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[8:9], 6, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[10:11], 7, v0
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[12:13], 0, v0
; GFX7-NEXT:    s_mov_b32 s18, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v8, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v10, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s[10:11]
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v12, v1, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v4, v12, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v12, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v6, v12, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v7, v12, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v8, v12, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v9, v12, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v10, v12, s[8:9]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v11, v12, s[10:11]
; GFX7-NEXT:    s_mov_b64 s[16:17], 16
; GFX7-NEXT:    buffer_store_dwordx4 v[4:7], off, s[16:19], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i16_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX10-NEXT:    global_load_dwordx4 v[8:11], v[0:1], off offset:16
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 1, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX10-NEXT:    s_mov_b32 s4, 0xffff
; GFX10-NEXT:    v_mov_b32_e32 v15, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 4, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 4, v3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s3, 5, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s5, 7, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s6, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v12, v3, s4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, 6, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v12
; GFX10-NEXT:    v_mov_b32_e32 v12, 0
; GFX10-NEXT:    v_mov_b32_e32 v13, 0
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v8, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v10, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, v11, s5
; GFX10-NEXT:    v_and_or_b32 v14, v1, v3, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v4, v14, s6
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v5, v14, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v14, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v14, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v8, v14, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v9, v14, s3
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v10, v14, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v11, v14, s5
; GFX10-NEXT:    s_mov_b64 s[0:1], 16
; GFX10-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off
; GFX10-NEXT:    global_store_dwordx4 v15, v[4:7], s[0:1]
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i16>, <16 x i16> addrspace(1)* %ptr
  %insert = insertelement <16 x i16> %vec, i16 %val, i32 %idx
  store <16 x i16> %insert, <16 x i16> addrspace(1)* null
  ret void
}
