; This test ensures that "strength reduction" of conditional expressions are
; working.  Basically this boils down to converting setlt,gt,le,ge instructions
; into equivalent setne,eq instructions.
;
; RUN: llvm-upgrade < %s | llvm-as | opt -instcombine | llvm-dis | \
; RUN:    grep -v {icmp eq} | grep -v {icmp ne} | not grep icmp
; END.

bool %test1(uint %A) {
	%B = setge uint %A, 1   ; setne %A, 0
	ret bool %B
}

bool %test2(uint %A) {
	%B = setgt uint %A, 0   ; setne %A, 0
	ret bool %B
}

bool %test3(sbyte %A) {
	%B = setge sbyte %A, -127   ; setne %A, -128
	ret bool %B
}

bool %test4(sbyte %A) {
	%B = setle sbyte %A, 126  ; setne %A, 127
	ret bool %B
}

bool %test5(sbyte %A) {
	%B = setlt sbyte %A, 127 ; setne %A, 127
	ret bool %B
}
