/*lockvc 4.0.4 (c) 1994 1995 1997 Matthias Straub */
/* screensaver daemon (c) 1999 2001... Lawson Whitney */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <features.h>
#include <string.h>
#include <linux/vt.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <linux/kd.h>
#include <asm/io.h>
#include <syslog.h>
#include <stdlib.h>
#include <signal.h>
/* stall until keyboard and mouse have been idle for  idol
 * minutes (/etc/maxlock:maxlock idol mouse) then change to the 
 * userid of the active console and tty63 and return to 
 * lockvc.
 *
 * if /dev/vc exists, we have devfs, I think, and should use /dev/vc/<n>
 * instead of /dev/tty<n> so we don't confuse svgalib with symbolic links.
 */
int stall(time_t idol, int mouse, uid_t * who)
{
	long long kint, lkint = 0;
	int getty = 0, idle = 0, No = 0;
	time_t kt = 0;
	char titty[16];
	char splint[16];
	struct stat us;
	struct timeval toad;
	struct vt_stat vat;
	struct vt_mode mow;
	time_t laps, dead, twitch = 0;
	FILE * pi;
	char * temp;
	int ok, sonof = 0, bee = 0, koff, fd;
	laps = idol * 60;
	temp = (char *) malloc(1024);
	ok = open("/proc/interrupts", O_RDONLY);
	read(ok, temp, 1024);
	koff = memmem(temp, 1024, "1:", 2) - (int) temp + 2;
	close(ok);
	free(temp);
	ok = stat("/dev/vc", &us);
	if (!(ok) && S_ISDIR(us.st_mode))
	{   strcpy(splint, "/dev/vc/%d");
	}   else 
	{   strcpy(splint, "/dev/tty%d");
	}
	   
	for (;;) {
		sleep(1);
		gettimeofday(&toad, NULL);
		dead = toad.tv_sec - laps;
		pi = fopen("/proc/interrupts","r");
		fseek(pi, koff, SEEK_SET);
		fscanf(pi, "%qd",&kint);
		fclose(pi);
		if (kint != lkint) kt = toad.tv_sec;
		lkint = kint;
		sprintf(titty, splint, 0);
		fd = open(titty, O_RDONLY);
		ok = ioctl(fd, VT_GETSTATE, &vat);
		ioctl(fd, VT_GETMODE, &mow);
		close (fd);
		if ((mow.mode == VT_PROCESS)&&((mow.acqsig == SIGUSR2)
			|| (mow.acqsig == SIGSYS))) continue;
			/* already locked, VT_WAITACTIVE will hang */
			/* discretion is the safer part of valor */
		bee = vat.v_active;
		if (bee != sonof) {
			twitch = toad.tv_sec;
			if ((getty) && (idle)) No = 1;}
		sonof = bee;
		sprintf(titty, splint, sonof);
		stat(titty, &us);
		if ((No) && (us.st_gid)) break;
		getty = !us.st_gid;
		if (us.st_gid) No = idle = 0;
		if (us.st_atime > dead) continue;
		if (twitch > dead) continue;
		if (kt > dead) continue;
		if (mouse) {
			stat("/dev/mouse", &us);
			if (us.st_atime > dead) continue;}
#ifndef GETTYS_TOO
		idle = 1;
		if (getty) continue;
#endif  /* GETTYS_TOO  */
		break;}	
	sprintf(titty, splint, 63);
	fd = open(titty, O_RDWR);
	if (fd == -1) syslog(LOG_ERR | LOG_AUTHPRIV,
		"lockvc open %s %m", titty);
	if (ioctl(fd, VT_ACTIVATE,63)) syslog(LOG_ERR | LOG_AUTHPRIV,
		"lockvc vt_activate %m");
	ioctl(fd, VT_WAITACTIVE, 63);
	sprintf(titty, splint, 0);
	freopen(titty, "r", stdin);
	freopen(titty, "w", stdout);
	freopen(titty, "w", stderr);
	sprintf(titty, splint, sonof);
	stat(titty, &us);
	*who = us.st_uid;	
	return bee;
}
