/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <netdb.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "lopster.h"
#include "support.h"
#include "global.h"
#include "splash.h"
#include "interface.h"
#include "server.h"
#include "search.h"
#include "handler.h"
#include "callbacks.h"
#include "connection.h"
#include "preferences.h"
#include "dirselect.h"
#include "share.h"
#include "chat.h"
#include "transfer.h"
#include "commands.h"
#include "hotlist.h"
#include "browse.h"
#include "scheme.h"
#include "log.h"
#include "dialog.h"
#include "resume.h"
#include "wizard.h"
#include "statistic.h"
#include "whois.h"
#include "about.h"
#include "filetips.h"
#include "string_list.h"
#include "subscription.h"
#include "userinfo.h"

///////////////////////////
// CONNECTION
///////////////////////////

void on_connect_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GList *combo4_items = NULL;
  GtkWidget *combo;
  char server_str[1024];
  server_t *server;
  GList *dlist;

  if (global.connect_win)
    return;

  global.connect_win = create_connection_win();

  temp = lookup_widget(global.connect_win, "button84");
  set_up_button(temp, "pix11", "pix12", "frame58");
  set_button_state(temp, global.connect_button);

  temp = lookup_widget(global.connect_win, "checkbutton42");
  if (global.options.login_mode & L_NOT_JOIN)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);

  temp = lookup_widget(global.connect_win, "checkbutton43");
  if (global.options.login_mode & L_NOT_SHARE)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);

  combo = lookup_widget(global.connect_win, "combo4");
  if (global.servers) {
    dlist = g_list_first(global.servers);
    while (dlist) {
      server = (server_t *) (dlist->data);
      sprintf(server_str, "%s %d", server->description, server->port);
      combo4_items = g_list_append(combo4_items, l_strdup(server_str));
      dlist = g_list_next(dlist);
    }
  }

  if (global.last_server) {
    combo4_items =
	g_list_insert(combo4_items, l_strdup(_("Last Server")), 0);
  }

  gtk_combo_set_popdown_strings(GTK_COMBO(combo), combo4_items);
  for (dlist = combo4_items; dlist; dlist = dlist->next)
    l_free(dlist->data);
  g_list_free(combo4_items);

  gtk_widget_show(global.connect_win);
}

void on_connect3_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			  gpointer user_data ATTR_UNUSED)
{
  server_t *server;
  GtkCTree *ctree;
  GtkCTreeNode *node;

  if (global.status.connection == 1)
    return;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node)
    return;

  server = create_server_from_napigator(ctree, node);
  if (!server)
    return;

  if (strlen(server->nick) < 1) {
    client_message(_("Message"),
		   _("No username specified in preferences"));
    server_destroy(server);
    return;
  }
  if (strchr(server->nick, ' ')) {
    client_message(_("Message"), _("No spaces allowed in nickname"));
    server_destroy(server);
    return;
  }
  if (strlen(server->passwd) < 1) {
    client_message(_("Message"),
		   _("No password specified in preferences"));
    server_destroy(server);
    return;
  }
  if (strlen(server->passwd) < 1) {
    client_message(_("Message"), _("No spaces allowed in password"));
    server_destroy(server);
    return;
  }
  // this should disconnect
  if (global.status.connection) {
    socket_end(global.napster, 0);
  }

  napster_connect(server);
}

void on_disconnect_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			    gpointer user_data ATTR_UNUSED)
{
  napster_disconnect(NULL);
}

void on_connection_ok_clicked(GtkButton * button ATTR_UNUSED,
			      gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkStatusbar *status;
  GtkWidget *entry;
  server_t *server;
  int row;

  if (!global.connect_win)
    return;
  if (global.status.connection == 1)
    return;

  server = search_server();
  if (!server)
    return;

  entry = lookup_widget(global.connect_win, "connection_name");
  server_set_nick(server, gtk_entry_get_text(GTK_ENTRY(entry)));

  if (strlen(server->nick) < 1) {
    status =
	GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("Enter a Nickname"));

    temp = lookup_widget(global.connect_win, "button84");
    set_button_state(temp, 1);
    return;
  }
  if (strchr(server->nick, ' ')) {
    status =
	GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("No spaces in nick allowed"));
    return;
  }
  // updating nick in selected server clist
  temp = lookup_widget(global.win, "clist11");
  row = gtk_clist_find_row_from_data(GTK_CLIST(temp), server);
  if (row >= 0)
    gtk_clist_set_text(GTK_CLIST(temp), row, 4, server->nick);

  entry = lookup_widget(global.connect_win, "connection_pass");
  server_set_passwd(server, gtk_entry_get_text(GTK_ENTRY(entry)));

  if (strlen(server->passwd) < 1) {
    status =
	GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("Enter a Password"));

    temp = lookup_widget(global.connect_win, "button84");
    set_button_state(temp, 1);
    return;
  }
  if (strchr(server->passwd, ' ')) {
    status =
	GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("No spaces in password"));
    return;
  }
  // this should disconnect
  if (global.status.connection) {
    socket_end(global.napster, 0);
  }

  temp = lookup_widget(global.connect_win, "checkbutton42");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    global.options.login_mode |= L_NOT_JOIN;
  } else {
    global.options.login_mode &= (0xff ^ L_NOT_JOIN);
  }
  temp = lookup_widget(global.connect_win, "checkbutton43");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    global.options.login_mode |= L_NOT_SHARE;
  } else {
    global.options.login_mode &= (0xff ^ L_NOT_SHARE);
  }

  napster_connect(server_copy(server));
}

void on_connection_cancel_clicked(GtkButton * button ATTR_UNUSED,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = global.connect_win;
  if (global.status.connection == 1) {
    napster_disconnect(NULL);
  } else {
    if (global.status.connection == 0)
      napster_disconnect(NULL);
    gtk_widget_hide(win);
    gtk_widget_destroy(win);
    global.connect_win = NULL;
  }
}

void on_connection_win_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = GTK_WIDGET(object);
  if (global.status.connection == 1) {
    socket_destroy(global.napster, 0);
  }

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
  global.connect_win = NULL;
}


void on_preferences_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			     gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (global.options_win) {
    if (global.options_win->window)
      gdk_window_raise(global.options_win->window);
    return;
  } else {
    global.options_win = create_options_win();
    temp = lookup_widget(global.options_win, "ctree2");
    gtk_clist_set_column_auto_resize(GTK_CLIST(temp), 0, TRUE);
  }
  temp = lookup_widget(global.options_win, "text8");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);
  gtk_widget_set_style(temp, global.style[2]);
  temp = lookup_widget(global.options_win, "text9");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);

  setup_preferences(P_TREE);
  setup_preferences(P_ALL);

  gtk_my_widget_show(global.options_win);
}


void on_exit_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
		      gpointer user_data ATTR_UNUSED)
{
  on_window_delete_event(NULL, NULL, NULL);
}


void on_join_chatrooms_activate(GtkMenuItem * menuitem ATTR_UNUSED,
				gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkWidget *temp2;
  int num;

  if (global.status.connection < 2)
    return;

  switch_to_page(1);

  temp = lookup_widget(global.win, "notebook3");
  temp2 = lookup_widget(global.win, "scrolledwindow50");
  num = gtk_notebook_page_num(GTK_NOTEBOOK(temp), temp2);
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), num);

  temp = lookup_widget(global.win, "channel_list");
  if (GTK_CLIST(temp)->rows == 0) {
    on_hidden1_activate(NULL, NULL);
  }

}


void on_dir_select29(gchar * dir)
{
  GtkWidget *temp;

  if (!global.options_win)
    return;
  temp = lookup_widget(global.options_win, "entry14");
  if (dir) {
    if (dir[strlen(dir) - 1] == '/')
      dir[strlen(dir) - 1] = 0;
    gtk_entry_set_text(GTK_ENTRY(temp), dir);
  }
}

void on_button29_clicked(GtkButton * button ATTR_UNUSED, 
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser(_("Select Directory"), g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_dir_select29);
  gtk_widget_show(win);
}

void on_button30_clicked(GtkButton * button ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.options_win);
  apply_preferences();
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void on_button31_clicked(GtkButton * button ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}

void on_button33_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void on_refresh1_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			  gpointer user_data ATTR_UNUSED)
{
  lib_refresh();
}

void on_button24_clicked(GtkButton * button ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = chat_page_get_current_main();
  if (!page)
    return;

  chat_page_leave(page);
}

void on_chat_entry_activate(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
#define MAX_HISTORY   1000
  GtkEntry *entry;
  char *text;
  char *pos;

  entry = GTK_ENTRY(editable);
  text = l_strdup(gtk_entry_get_text(entry));
  if (strlen(text) <= 0) {
    l_free(text);
    return;
  }

  global.chat_history = g_list_append(global.chat_history, l_strdup(text));

  // updating history
  while (g_list_length(global.chat_history) > MAX_HISTORY)
  {
    pos = g_list_nth_data(global.chat_history, 0);
    l_free(pos);
    global.chat_history = g_list_remove(global.chat_history, pos);
  }
  global.history_pos = g_list_length(global.chat_history);

  if (text[0] == '/') {
    handle_lopster_command(text);
  } else {
    if (!global.current_page->active) {
      client_message("Error", "This page is not active");
    } else {
      if (global.current_page->type == P_PUBLIC) {
	lopster_public(text);
      } else if (global.current_page->type == P_PRIVATE) {
	send_private(global.current_page->name, text, 1);
      } else if (!strcmp("Wallop", global.current_page->name)) {
	send_wallop(text);
      } else if (!strcmp("Global", global.current_page->name)) {
	send_global(text);
      }
    }
  }
  gtk_entry_set_text(entry, "");
  l_free(text);
}


void
on_notebook3_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page,
			 gint page_num ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  chat_page_t *page2;

  temp = page->tab_label;
  page2 = gtk_object_get_data(GTK_OBJECT(page->tab_label), "page");

  if (!page2)
    return;

  highlight(page2, 0);

  temp = lookup_widget(global.win, "button24");

  if (page2->type == P_FIX)
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);

  temp = lookup_widget(global.win, "chat_entry");
  gtk_widget_grab_focus(temp);

  if (global.current_page->window)
    return;
  global.current_page = page2;
}


gboolean
on_search_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  file_t *file;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    file = (file_t *) gtk_clist_get_row_data(GTK_CLIST(widget),
					     global.popup_row);
    if (file->local)
      on_play_file3_activate(NULL, NULL);
    else
      on_download_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    //    if (row == -1) return FALSE;
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    file = (file_t *) gtk_clist_get_row_data(GTK_CLIST(widget),
					     global.popup_row);

    pop = create_search_list_popup(file);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

//////////////////////////////////////////
// download stuff
void
on_download_selected_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			      gpointer user_data)
{
  GtkCList *clist;
  GList *row_list;
  file_t *file;
  int row;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;

  while (row_list) {
    row = (int) row_list->data;
    file = (file_t *) gtk_clist_get_row_data(clist, row);
    if (!file->local)
      download_file(file, (int) user_data);
    row_list = row_list->next;
  }

}

void
on_download_resume_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			    gpointer user_data)
{
  GtkCList *list;
  file_t *file;
  socket_t *socket;

  list = GTK_CLIST(global.popup_list);
  file = (file_t *) gtk_clist_get_row_data(list, global.popup_row);
  if (!file->local) {
    socket = download_create(file, 0, user_data);
    if (socket) download_start(socket, FALSE);
  }

}

void on_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCList *list;
  file_t *file;

  list = GTK_CLIST(global.popup_list);
  file = (file_t *) gtk_clist_get_row_data(list, global.popup_row);
  if (!file->local)
    download_file(file, (int) user_data);
}


// end download stuff
/////////////////////////////////

//////////////////////////////////////////
// hotlist stuff

void set_prefix(char *prefix, int num)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;

  if (!global.options_win)
    return;
  if (!prefix)
    return;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  switch (num) {
  case 0:
    if (scheme->server_prefix)
      l_free(scheme->server_prefix);
    scheme->server_prefix = l_strdup(prefix);
    break;
  case 1:
    if (scheme->client_prefix)
      l_free(scheme->client_prefix);
    scheme->client_prefix = l_strdup(prefix);
    break;
  case 2:
    if (scheme->join_prefix)
      l_free(scheme->join_prefix);
    scheme->join_prefix = l_strdup(prefix);
    break;
  case 3:
    if (scheme->part_prefix)
      l_free(scheme->part_prefix);
    scheme->part_prefix = l_strdup(prefix);
    break;
  }
  scheme_draw(scheme);
}

void on_button32_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char text[200];
  void *pointer;

  temp = lookup_widget(GTK_WIDGET(button), "entry16");
  strcpy(text, gtk_entry_get_text(GTK_ENTRY(temp)));

  if (strlen(text) == 0)
    return;

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "ref");
  if (pointer == (void *) 1) {
    hotlist_add(text, NULL, 1);
  }
  if (pointer == (void *) 2) {
    whois_request(text, WHOIS_SHOW);
  }
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void
on_add_to_hot_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_add_user_win();
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void *) 1);
  gtk_window_set_title(GTK_WINDOW(win), _("Add User To Hotlist"));
  gtk_widget_show(win);
}

gboolean
on_online_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  if (row == -1)
    return FALSE;
  global.popup_row = row;
  global.popup_list = widget;

  if (event->type == GDK_2BUTTON_PRESS) {
    on_whois_user_activate(NULL, (gpointer) M_ONLINE);
    return FALSE;
  }

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);

    pop = create_online_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

// end hotlist stuff
/////////////////////////////////

/////////////////////////////////
// list stuff
void
on_list_click_column(GtkCList * clist, gint column, gpointer user_data ATTR_UNUSED)
{
  if (column == clist->sort_column) {
    if (clist->sort_type == GTK_SORT_ASCENDING)
      gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
    else
      gtk_clist_set_sort_type(clist, GTK_SORT_ASCENDING);
  } else {
    gtk_clist_set_sort_column(clist, column);
    gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
  }

  gtk_clist_sort(clist);
}

// end list stuff
/////////////////////////////////

void
on_cancel_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t *socket;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent != NULL) {
      socket = (socket_t *) gtk_ctree_node_get_row_data(ctree, node);
      socket_end(socket, &(SocketStatus[S_CANCELED]));
    }
  }
}

void
on_delete_upload_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;
  socket_t *socket;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    socket = (socket_t *) gtk_clist_get_row_data(clist, row);
    socket_end(socket, &(SocketStatus[S_DELETE]));
  }
}

void on_allow_upload_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;
  socket_t *socket;
  transfer_t *transfer;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    socket = (socket_t *) gtk_clist_get_row_data(clist, row);
    transfer = (transfer_t *) (socket->data);
    if (!transfer)
      continue;
    if (transfer_in_progress(transfer))
      continue;
    if (transfer->status == S_FINISHED)
      continue;
    upload_start(socket, 1);
  }
}

void on_retry_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t* socket;
  transfer_t* transfer;
  GList* work = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) continue;

    socket = gtk_ctree_node_get_row_data(ctree, node);
    transfer = socket->data;
    if (transfer->resume->status != R_ACTIVE) continue;
    work = g_list_append(work, socket);
  }
  for (dlist = work; dlist; dlist = dlist->next) {
    socket = dlist->data;
    transfer = socket->data;
    if (transfer->resume->socket == socket) {
      socket_end(socket, &(SocketStatus[S_INACTIVE]));
    }
    download_start(socket, 0);
  }
  g_list_free(work);
}

void on_force_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t* socket;
  transfer_t* transfer;
  GList* work = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) continue;

    socket = gtk_ctree_node_get_row_data(ctree, node);
    transfer = socket->data;
    if (transfer->resume->status != R_ACTIVE) continue;
    work = g_list_append(work, socket);
  }
  for (dlist = work; dlist; dlist = dlist->next) {
    socket = dlist->data;
    transfer = socket->data;
    if (transfer->resume->socket) {
      socket_end(transfer->resume->socket, &(SocketStatus[S_INACTIVE]));
    }
    download_start(socket, 1);
  }
  g_list_free(work);
}

void on_button64_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *list;
  int i1;
  socket_t *socket;
  transfer_t *transfer;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t *) (socket->data);
    if (transfer->status == S_FINISHED) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t *) (socket->data);
    if ((!transfer_in_progress(transfer))
	|| (transfer->status == S_QUEUED)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
}

void on_search_artist_activate(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "activate");
  send_search_request(FALSE);
}


void on_search_results_activate(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  send_search_request(FALSE);
}



gboolean
on_chat_entry_key_press_event(GtkWidget * widget,
			      GdkEventKey * event, gpointer user_data ATTR_UNUSED)
{
  GtkEntry *entry;
  char *text;
  char *text2;
  char comm[2048];
  char t[2048];
  GList *c_list;
  int i1;
  command_t *command;
  static int cnt = 0;

  entry = GTK_ENTRY(widget);
  if (event->type == GDK_KEY_PRESS) {
    if ((event->keyval == GDK_r) && (event->state == 4) && (global.reply)) {
      text = l_strdup_printf("/msg %s ", global.reply);
      gtk_entry_set_text(entry, text);
      l_free(text);
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
      return TRUE;
    } else if (event->keyval == 65289) {	// tab
      cnt++;
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");

      text = l_strdup(gtk_entry_get_text(entry));

      if (strlen(text) <= 0) {
	l_free(text);
	return TRUE;
      }
      text2 = strrchr(text, ' ');
      if ((text[0] != '/') || (text2)) {
	if (text2) text2++;
	else text2 = text;

	if (text2[0] == '@')
	  text2++;
	c_list = user_search(text2);

	switch (g_list_length(c_list)) {
	case 0:
	  client_message(_("Error"), _("no matching user found"));
	  cnt = 0;
	  break;
	case 1:
	  text2[0] = 0;
	  strcpy(t, text);
	  strcat(t, c_list->data);
	  if (!strchr(t, ' '))
	    strcat(t, ": ");
	  gtk_entry_set_text(entry, t);
	  cnt = 0;
	  break;
	default:
	  i1 = calc_list_prefix(c_list);
	  text2[0] = 0;
	  strcpy(t, text);
	  strncat(t, c_list->data, i1);
	  gtk_entry_set_text(entry, t);

	  if (cnt > 1) {
	    client_message(NULL, _("Available Users:"));
	    *t = 0;
	    for (i1 = 0; i1 < (int)g_list_length(c_list); i1++) {
	      if (i1 > 0)
		strcat(t, ", ");
	      strcat(t, g_list_nth(c_list, i1)->data);
	    }
	    chat_print_ln("message", t);
	    cnt = 0;
	  }
	  break;
	}
      } else {
	text2 = l_strdup(text + 1);
	c_list = command_search(text2);

	switch (g_list_length(c_list)) {
	case 0:
	  client_message(_("Error"), _("no matching command found"));
	  cnt = 0;
	  break;
	case 1:
	  command = (command_t *) (c_list->data);
	  sprintf(comm, "/%s ", command->name);
	  gtk_entry_set_text(entry, comm);
	  cnt = 0;
	  break;
	default:
	  i1 = calc_command_prefix(c_list);
	  command = (command_t *) (c_list->data);
	  comm[0] = '/';
	  comm[1] = 0;
	  strncat(comm, command->name, i1);
	  gtk_entry_set_text(entry, comm);

	  if (cnt > 1) {
	    client_message(NULL, _("Available Commands:"));
	    *t = 0;
	    for (i1 = 0; i1 < (int)g_list_length(c_list); i1++) {
	      if (i1 > 0)
		strcat(t, ", /");
	      else
		strcat(t, "/");
	      command = (command_t *) (g_list_nth(c_list, i1)->data);
	      strcat(t, command->name);
	    }
	    chat_print_ln("message", t);
	    cnt = 0;
	  }
	  break;
	}
	l_free(text2);
      }
      l_free(text);
    } else if ((event->keyval == 65362) || (event->keyval == 65364)) {
      cnt = 0;
      if (event->keyval == 65362) {	// Up
	if (global.history_pos > 0)
	  global.history_pos--;
	else
	  global.history_pos = 0;
      }
      if (event->keyval == 65364) {	// Down
	if (global.history_pos < (int)g_list_length(global.chat_history))
	  global.history_pos++;
	else
	  global.history_pos = g_list_length(global.chat_history);
      }
      c_list = g_list_nth(global.chat_history, global.history_pos);
      if (c_list) {
	text = c_list->data;
	if (text)
	  gtk_entry_set_text(GTK_ENTRY(widget), text);
      } else {
	gtk_entry_set_text(GTK_ENTRY(widget), "");
      }
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    } else {
      cnt = 0;
    }
  }

  text = gtk_entry_get_text(entry);
  if (!l_strcasecmp(text, "/reply") && (event->keyval == 32)) {
    if (global.reply)
      sprintf(t, "/msg %s", global.reply);
    else
      sprintf(t, "/msg");
    gtk_entry_set_text(GTK_ENTRY(widget), t);
  }
  if (!l_strcasecmp(text, "/reply ")) {
    if (global.reply)
      sprintf(t, "/msg %s ", global.reply);
    else
      sprintf(t, "/msg ");
    gtk_entry_set_text(GTK_ENTRY(widget), t);
  }

  return 1;
}


void on_whois_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_destroy(global.whois_win);
  global.whois_win = NULL;
}


void on_button82_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.whois_win);
}


gboolean
on_transfer_up_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  GtkCList *clist;
  transfer_t *transfer = NULL;
  socket_t *socket;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_play_file_activate(NULL, NULL);
    return FALSE;
  }

  if (event->button == global.options.popup_create) {
    clist = GTK_CLIST(global.popup_list);
    socket = (socket_t *) gtk_clist_get_row_data(clist, global.popup_row);
    if (socket) {
      transfer = (transfer_t *) (socket->data);
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    }
    pop = create_upload_popup(transfer);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

void on_entry34_activate(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char user[200];

  temp = lookup_widget(GTK_WIDGET(editable), "entry34");
  strcpy(user, gtk_entry_get_text(GTK_ENTRY(temp)));
  whois_request(user, WHOIS_SHOW);
}


void on_entry16_activate(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char text[200];
  void *pointer;

  temp = lookup_widget(GTK_WIDGET(editable), "entry16");
  strcpy(text, gtk_entry_get_text(GTK_ENTRY(temp)));

  if (strlen(text) == 0)
    return;

  temp = lookup_widget(GTK_WIDGET(editable), "add_user_win");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "ref");
  if (pointer == (void *) 1) {
    hotlist_add(text, NULL, 1);
  }
  if (pointer == (void *) 2) {
    whois_request(text, WHOIS_SHOW);
  }
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_togglebutton2_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkWidget *temp2;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "label125");
  temp2 = lookup_widget(GTK_WIDGET(togglebutton), "entry35");

  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
  }

}


void on_button84_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  global.connect_button = toggle_button_state(GTK_WIDGET(button));
}


void on_button90_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{

  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


void on_add_to_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  hotlist_add(user, NULL, 1);
}

void on_whois_user_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  whois_request(user, WHOIS_SHOW);
}


void on_ignore_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);

  if (string_list_search(LIST_IGNORE, user)) {
    ignore_remove(user);
  } else {
    ignore_add(user);
  }
}

void on_subscribe_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char *user;
  subscription_t* sub;
  int mode = (int) user_data;

  user = get_popup_user(mode);

  sub = subscription_user_search(user);
  
  if (sub) {
    subscription_user_delete(sub);
  } else {
    subscription_user_add(user);
  }
}

void
on_refresh_users_files_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  char *user;

  if (global.popup_row == -1)
    return;

  clist = GTK_CLIST(global.popup_list);

  gtk_clist_get_pixtext(clist, global.popup_row, 0, &user, &space,
			&pixmap, &bitmap);
  browse_user_files(user, 0);
}


void
on_remove_user_from_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED,
				     gpointer user_data ATTR_UNUSED ATTR_UNUSED)
{
  GtkCList *clist;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  char *user;

  if (global.popup_row == -1)
    return;

  clist = GTK_CLIST(global.popup_list);

  gtk_clist_get_pixtext(clist, global.popup_row, 0, &user, &space,
			&pixmap, &bitmap);
  hotlist_remove(user, 1);
}

void
on_remove_from_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{

  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  hotlist_remove(user, 1);
}

void rec_download_file(GtkCTree * ctree, GtkCTreeNode * node, char *data ATTR_UNUSED)
{
  file_t *file;

  file = (file_t *) gtk_ctree_node_get_row_data(ctree, node);
  if (file)
    download_file(file, 1);
}

void
on_download_folder_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);

  gtk_ctree_post_recursive(ctree, node,
			   (GtkCTreeFunc) rec_download_file, NULL);
}

void on_download2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  file_t *file;
  GtkCTreeNode *node;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    file = (file_t *) gtk_ctree_node_get_row_data(ctree, node);
    if (file)
      download_file(file, (int) user_data);
    row_list = row_list->next;
  }
}

void on_remove_browse_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkObject *ctree;
  user_t *userinfo;

  ctree = GTK_OBJECT(global.popup_list);

  userinfo = (user_t *) gtk_object_get_data(ctree, "userinfo");
  browse_remove(userinfo);
}

void on_remove_browse_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkObject *ctree;
  user_t *userinfo;

  ctree = GTK_OBJECT(user_data);

  userinfo = (user_t *) gtk_object_get_data(ctree, "userinfo");
  browse_remove(userinfo);
}


gboolean
on_hot_tree_button_press_event(GtkWidget * widget,
			       GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  if (row == -1)
    return FALSE;
  global.popup_row = row;
  global.popup_list = widget;

  if (event->type == GDK_2BUTTON_PRESS) {
    on_refresh_users_files_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_hotlist_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}



void on_combo_entry14_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkEntry *entry;
  GtkEntry *entry2;
  GtkText *des;
  GtkEntry *alias;
  char *text;
  command_t *command;
  char t[2048];

  entry = GTK_ENTRY(lookup_widget(global.options_win, "combo_entry14"));
  entry2 = GTK_ENTRY(lookup_widget(global.options_win, "entry40"));
  des = GTK_TEXT(lookup_widget(global.options_win, "text9"));
  alias = GTK_ENTRY(lookup_widget(global.options_win, "entry41"));

  text = gtk_entry_get_text(entry);
  command = command_is_command(text);
  if (!command) {
    g_warning("could not get command, CRITICAL!");
    return;
  }
  // syntax
  gtk_entry_set_text(entry2, command->syntax);

  // description
  gtk_text_backward_delete(des, gtk_text_get_length(des));
  sprintf(t, "%s\n", command->description);
  gtk_text_insert(des, NULL, NULL, NULL, t, strlen(t));

  // alias
  text = command_get_alias_string(command->id);
  gtk_entry_set_text(alias, text);
}



void on_button101_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkEntry *entry1;
  GtkEntry *entry2;
  char *text;
  char *pos;

  command_t *command;

  entry1 = GTK_ENTRY(lookup_widget(global.options_win, "combo_entry14"));
  entry2 = GTK_ENTRY(lookup_widget(global.options_win, "entry41"));

  text = gtk_entry_get_text(entry1);
  command = command_is_command(text);
  if (!command) {
    g_warning("chat command does not exists");
    return;
  }
  command_delete_alias_for(command->id);

  text = l_strdup(gtk_entry_get_text(entry2));

  pos = strtok(text, " \t");
  while (pos) {
    if (strlen(pos) > 0)
      command_make_alias(command->name, pos);
    pos = strtok(NULL, " \t");
  }
  l_free(text);

  text = command_get_alias_string(command->id);
  gtk_entry_set_text(entry2, text);
}



void on_button96_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  apply_preferences();
}


void on_combo_entry15_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *temp;
  GtkWidget *temp2;
  scheme_t *scheme1;
  scheme_t *scheme2;
  char *text;
  GList *list2;
  GList *dlist;
  style_t *style;

  win = global.options_win;
  temp = lookup_widget(win, "combo_entry15");

  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp = lookup_widget(global.options_win, "button98");
  temp2 = lookup_widget(global.options_win, "button99");

  scheme1 = gtk_object_get_data(GTK_OBJECT(win), "scheme");

  if ((scheme2 = scheme_load(text)) != NULL) {
    scheme_draw(scheme2);
    if (scheme1) scheme_destroy(scheme1);
    gtk_object_set_data(GTK_OBJECT(win), "scheme", scheme2);
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
    return;
  }

  list2 = NULL;
  temp = lookup_widget(win, "combo5");
  for (dlist = scheme2->colors; dlist; dlist = dlist->next) {
    style = dlist->data;
    list2 = g_list_append(list2, style->name);
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(temp), list2);
  g_list_free(list2);
}

void on_options_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void on_ban_win_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *data;

  temp = lookup_widget(global.ban_win, "clist3");
  data = gtk_object_get_data(object, "channel");
  if (data)
    l_free(data);

  gtk_widget_hide(global.ban_win);
  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


int hex_to_int(char ch)
{
  if ((ch <= '9') && (ch >= '0'))
    return ch - '0';
  else if ((ch <= 'f') && (ch >= 'a'))
    return ch - 'a' + 10;
  else if ((ch <= 'F') && (ch >= 'A'))
    return ch - 'A' + 10;
  else
    return 0;
}

void convert_color(char *text, gdouble * color)
{
  int temp;

  temp = hex_to_int(text[1]) * 16 + hex_to_int(text[2]);
  color[0] = (gdouble) temp / 255.0;
  temp = hex_to_int(text[3]) * 16 + hex_to_int(text[4]);
  color[1] = (gdouble) temp / 255.0;
  temp = hex_to_int(text[5]) * 16 + hex_to_int(text[6]);
  color[2] = (gdouble) temp / 255.0;
}

void on_button94_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *colorsel;
  GtkWidget *temp;
  gdouble color[3];
  char *text;
  scheme_t *scheme;
  style_t *style;

  win = create_colorselectiondialog1();
  gtk_object_set_data(GTK_OBJECT(win), "foreground", (gpointer) 1);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no scheme found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_fore, color);

  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void on_button106_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *colorsel;
  GtkWidget *temp;
  gdouble color[3];
  char *text;
  scheme_t *scheme;
  style_t *style;

  win = create_colorselectiondialog1();
  gtk_object_set_data_full(GTK_OBJECT(win),
			   "foreground", (gpointer) 2, NULL);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_back, color);

  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void on_button107_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *fontsel;
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;
  style_t *style;

  win = create_fontselectiondialog1();

  temp = lookup_widget(win, "NULL_button1");
  gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		     GTK_SIGNAL_FUNC(on_NULL_button1_clicked), NULL);
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));

  temp = lookup_widget(win, "cancel_button3");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  temp = lookup_widget(win, "ok_button3");
  gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		     GTK_SIGNAL_FUNC(on_ok_button3_clicked), NULL);


  // setting up font
  fontsel = GTK_FONT_SELECTION_DIALOG(win)->fontsel;
  temp = lookup_widget(global.options_win, "combo_entry13");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }

  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(fontsel),
				   style->n_font);

  gtk_widget_show(win);
}


void
on_colorselectiondialog1_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);
}


void
on_fontselectiondialog1_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);

}


void on_cancel_button3_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  gtk_widget_destroy(temp);

}


void set_color(gdouble * color, int fore)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;
  char color_str[20];
  char hex[17] = "0123456789abcdef";
  int int_val;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (!color) {
    if (fore)
      style_update(scheme, text, "NULL", NULL, NULL);
    else
      style_update(scheme, text, NULL, "NULL", NULL);
    scheme_draw(scheme);
    return;
  }

  color_str[0] = '#';
  int_val = (int) (color[0] * 255);
  color_str[1] = hex[int_val / 16];
  color_str[2] = hex[int_val % 16];
  int_val = (int) (color[1] * 255);
  color_str[3] = hex[int_val / 16];
  color_str[4] = hex[int_val % 16];
  int_val = (int) (color[2] * 255);
  color_str[5] = hex[int_val / 16];
  color_str[6] = hex[int_val % 16];
  color_str[7] = 0;
  if (fore)
    style_update(scheme, text, color_str, NULL, NULL);
  else
    style_update(scheme, text, NULL, color_str, NULL);

  scheme_draw(scheme);
}

void on_ok_button2_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *colorsel;
  GtkWidget *temp;
  static gdouble color[3];
  gpointer *pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  colorsel = GTK_COLOR_SELECTION_DIALOG(temp)->colorsel;
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }

  gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_destroy(temp);

  switch ((int) pointer) {
  case 1:
    set_color(color, 1);
    break;
  case 2:
    set_color(color, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }
}


void on_button100_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;

  temp = lookup_widget(global.options_win, "combo_entry15");

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no temp colors found!");
    return;
  }

  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) == 0) return;

  if (scheme->name)
    l_free(scheme->name);
  scheme->name = l_strdup(text);
  scheme_save(scheme);

  //  scheme_load(global.colors, text, 0);
}

void set_font(char *font)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (font)
    style_update(scheme, text, NULL, NULL, font);
  else
    style_update(scheme, text, NULL, NULL, "NULL");

  scheme_draw(scheme);
}


void on_ok_button3_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkWidget *fontsel;
  char *font;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  fontsel = GTK_FONT_SELECTION_DIALOG(temp)->fontsel;

  if (gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel))) {
    font =
	strdup(gtk_font_selection_get_font_name
	       (GTK_FONT_SELECTION(fontsel)));
    set_font(font);
  }
  gtk_widget_destroy(temp);
}

void on_button114_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}

void on_button_users_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_checkbutton7_toggled(GtkToggleButton * togglebutton, gpointer user_data ATTR_UNUSED)
{

  global.options.show_joins =
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));

  setup_preferences(P_SHOW_JOIN);
}


void on_button115_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}

void on_spinbutton5_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  global.limit.max_downloads =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_D_LIMIT);
}


void on_spinbutton6_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  global.limit.max_uploads =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_U_LIMIT);
}

void on_button98_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme1;
  scheme_t *scheme2;

  temp = lookup_widget(global.options_win, "combo_entry15");

  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme1 = scheme_load(text);
  if (!scheme1) {
    l_free(text);
    return;
  }

  scheme2 = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  scheme_destroy(scheme2);
  gtk_object_set_data(GTK_OBJECT(global.options_win), "scheme", scheme1);

  l_free(text);
  scheme_draw(scheme1);
}


void on_button99_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;

  temp = lookup_widget(global.options_win, "combo_entry15");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme_delete(text);
  l_free(text);
}


void
on_checkbutton9_toggled(GtkToggleButton * togglebutton, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;

  temp = lookup_widget(global.win, "entry50");
  if (gtk_toggle_button_get_active(togglebutton)) {
    temp = lookup_widget(global.win, "button125");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "entry50");
    gtk_widget_set_sensitive(temp, TRUE);
    text = gtk_entry_get_text(GTK_ENTRY(temp));

    if (global.afk.message)
      l_free(global.afk.message);
    global.afk.message = l_strdup(text);
    global.afk.since = global.current_time;
  } else {
    temp = lookup_widget(global.win, "entry50");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "button125");
    gtk_widget_set_sensitive(temp, FALSE);
    if (global.afk.message) {
      l_free(global.afk.message);
      global.afk.message = NULL;
    }
  }
  if (global.afk.message)
    client_message("AFK", global.afk.message);
  else
    client_message("AFK", _("deactivated"));
}


void
on_checkbutton10_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{

  global.options.public_ignore =
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));

  setup_preferences(P_IGNORE);
}


void on_entry50_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "button125");
  gtk_widget_set_sensitive(temp, TRUE);
}


void on_play_file2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  file_t *file = NULL;
  GtkCTreeNode *node;
  char *dir = NULL;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node)
    return;

  if (GTK_CTREE_ROW(node)->is_leaf) {
    file = (file_t *) gtk_ctree_node_get_row_data(ctree, node);
  } else {
    dir = (char *) gtk_ctree_node_get_row_data(ctree, node);
  }

  if (file) {
    play_file(file->longname);
  } else {
    play_file(dir);
  }
}


void on_play_file_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *list;
  transfer_t *transfer;
  socket_t *socket;

  list = GTK_CLIST(global.popup_list);

  socket = (socket_t *) gtk_clist_get_row_data(list, global.popup_row);
  transfer = (transfer_t *) (socket->data);
  if (transfer) {
    if (transfer->type == T_UPLOAD)
      play_file(transfer->longname);
    else {
      if (transfer->resume)
	play_file(transfer->resume->filename);
      else
	play_file(transfer->longname);
    }
  }
}

void on_play_file3_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *list;
  file_t *file;

  list = GTK_CLIST(global.popup_list);
  file = (file_t *) gtk_clist_get_row_data(list, global.popup_row);
  play_file(file->longname);
}


void on_cancel_button2_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  gtk_widget_destroy(temp);
}

void on_NULL_button2_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  gpointer *pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }
  // color = NULL
  gtk_widget_destroy(temp);

  switch ((int) pointer) {
  case 1:
    set_color(NULL, 1);
    break;
  case 2:
    set_color(NULL, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }

}


void on_NULL_button1_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  set_font(NULL);

  gtk_widget_destroy(temp);

}


void on_button125_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  temp = lookup_widget(global.win, "button125");
  if (!GTK_WIDGET_IS_SENSITIVE(temp)) {
    return;
  }
  temp = lookup_widget(global.win, "entry50");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  set_afk(text);
  l_free(text);
}


void on_entry50_activate(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  on_button125_clicked(NULL, NULL);
}


gboolean
on_entry49_key_press_event(GtkWidget * widget,
			   GdkEventKey * event, gpointer user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return 1;
}

gboolean
on_entry46_key_press_event(GtkWidget * widget,
			   GdkEventKey * event, gpointer user_data ATTR_UNUSED)
{
  GtkEntry *entry;
  char *text;
  char *text2;
  char t[2048];
  GList *c_list;
  int i1;
  static int cnt = 0;
  GList* dlist;

  if (in_private())
    return FALSE;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if ((event->type == GDK_KEY_PRESS) && (event->keyval == 65289)) {	// tab
    entry = GTK_ENTRY(widget);
    gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    text = l_strdup(gtk_entry_get_text(entry));

    if (strlen(text) <= 0)
      return TRUE;
    text2 = strrchr(text, ' ');
    if (text2)
      text2++;
    else
      text2 = text;
    c_list = user_search(text2);

    switch (g_list_length(c_list)) {
    case 0:
      //          client_message("Error", "no matching user found");
      break;
    case 1:
      text2[0] = 0;
      strcpy(t, text);
      strcat(t, c_list->data);
      gtk_entry_set_text(entry, t);
      break;
    default:
      cnt++;
      i1 = calc_list_prefix(c_list);
      text2[0] = 0;
      strcpy(t, text);
      strncat(t, c_list->data, i1);
      gtk_entry_set_text(entry, t);

      if (cnt > 1) {
	strcpy(t, _("******** Available Users:\n"));
	for (dlist = c_list; dlist; dlist = dlist->next) {
	  if (dlist != c_list) strcat(t, ", ");
	  strcat(t, dlist->data);
	}
	chat_print_ln("message", t);
	cnt = 0;
      }
      break;
    }
  }

  return 1;
}


void on_delete_file_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *temp;

  win = create_delete_win();
  temp = lookup_widget(win, "button170");

  gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		     GTK_SIGNAL_FUNC(on_button170_clicked), (gpointer) 1);
  gtk_widget_show(win);
}

void on_private_mode_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);

  create_private_page(user);
}

void on_whisper_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;
  char *str;
  GtkWidget *temp;

  user = get_popup_user(mode);

  switch_to_page(1);

  temp = lookup_widget(global.win, "chat_entry");
  str = l_strdup_printf("/msg %s ", user);
  gtk_entry_set_text(GTK_ENTRY(temp), str);
  gtk_widget_grab_focus(temp);
  l_free(str);
}

void on_button133_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *list;
  int i1;
  transfer_t *transfer;
  socket_t *socket;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t *) (socket->data);
    if (!transfer_in_progress(transfer)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t *) (socket->data);
    if ((!transfer_in_progress(transfer))
	|| (transfer->status == S_QUEUED)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
}


void on_friend_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  toggle_friend(user);
}


void on_enemy_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  toggle_enemy(user);
}

void on_nodownload_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  toggle_nodownload(user);
}


gboolean
on_entry55_key_press_event(GtkWidget * widget,
			   GdkEventKey * event, gpointer user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return FALSE;
}


void
on_remove_subtree1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  if (global.popup_row == -1)
    return;

  ctree = GTK_CTREE(global.popup_list);

  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (node) {
    lib_set_flag(FLAG_TO_REMOVE, node);
    lib_apply_node(node);
    gtk_ctree_remove_node(ctree, node);
  }
}


void
on_delete_subtree1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *temp;

  win = create_delete_win();
  temp = lookup_widget(win, "button170");

  gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		     GTK_SIGNAL_FUNC(on_button170_clicked), (gpointer) 2);
  gtk_widget_show(win);
}


gboolean
on_lib_tree_button_press_event(GtkWidget * widget,
			       GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  gtk_clist_get_pixtext(GTK_CLIST(widget), row, 0,
			&text, &space, &pixmap, &bitmap);

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    if (!pixmap) {
      on_play_file2_activate(NULL, NULL);
      return FALSE;
    }
  }
  if (event->button == global.options.popup_create) {
    if (pixmap == NULL) {
      pop = create_lib_popup2();
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    } else {
      pop = create_lib_popup1();
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    }
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


void on_remove_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  file_t *file;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  
  file = gtk_ctree_node_get_row_data(ctree, node);
  file->flags |= FLAG_TO_REMOVE;
  lib_apply_file(file);
  gtk_ctree_remove_node(ctree, node);
}


void on_join_channel1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  char *text;

  if (global.popup_row == -1)
    return;

  clist = GTK_CLIST(global.popup_list);
  gtk_clist_get_text(clist, global.popup_row, 0, &text);
  join_channel(text);
}

void on_normal1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_clear(GTK_CLIST(temp));
  gtk_clist_freeze(GTK_CLIST(temp));

  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 2, FALSE);
  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 3, FALSE);
  send_command(CMD_CLIENT_LIST_CHANNELS, "");
}

void on_hidden1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_clear(GTK_CLIST(temp));
  gtk_clist_freeze(GTK_CLIST(temp));

  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 2, TRUE);
  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 3, TRUE);
  send_command(CMD_CLIENT_FULL_CHANNEL_LIST, "");
}


gboolean
on_channel_list_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_join_channel1_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_channel_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


void
on_checkbutton21_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{

  global.options.parse_color =
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));

  setup_preferences(P_PARSE_COLOR);
}

GtkWidget* get_sub_notebook() {
  switch (notebook_page_current()) {
  case 1:
    return lookup_widget(global.win, "notebook3");
  case 2:
    return lookup_widget(global.win, "notebook5");
  case 4:
    return lookup_widget(global.win, "notebook6");
  case 5:
    return lookup_widget(global.win, "notebook9");
  default:
    return NULL;
  }
  return NULL;
}

gboolean
on_window_key_press_event(GtkWidget * widget ATTR_UNUSED,
			  GdkEventKey * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if (event->type == GDK_KEY_PRESS) {
    if ((event->keyval >= 49) &&	// Alt 1-9
	(event->keyval <= 57) && (event->state == 8)) {
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval - 49));
    } else if ((event->keyval >= 49) &&	// CTRL 1-9
	       (event->keyval <= 57) && (event->state == 4)) {
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval - 49));
    } else if ((event->keyval == 97) &&  	// ALT a
	       (event->state == 8)) {
      temp = get_sub_notebook();
      if (temp) gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 115) &&	// ALT s
	       (event->state == 8)) {
      temp = get_sub_notebook();
      if (temp) gtk_notebook_next_page(GTK_NOTEBOOK(temp));
      temp = lookup_widget(global.win, "notebook3");
    } else if ((event->keyval == 113) &&	// ALT q
	       (event->state == 8)) {
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 119) &&	// ALT w
	       (event->state == 8)) {
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    } else if (event->keyval == GDK_Page_Up) {	// page up
      chat_page_up(global.current_page);
    } else if (event->keyval == GDK_Page_Down) {	// page down
      chat_page_down(global.current_page);
    }
  }
  return 1;
}

void on_about_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = GTK_WIDGET(object);

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button145_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "about_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_about1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  about_show();
}


void
on_transfer_resize_column(GtkCList * clist,
			  gint column ATTR_UNUSED, gint width ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int i1;
  socket_t *socket;

  i1 = 0;
  while (1) {
    if (i1 >= clist->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(clist, i1);
    transfer_update(socket, 0);
    i1++;
  }
}

void on_clear_selected_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;
  file_t *file;
  search_t *search;

  clist = GTK_CLIST(global.popup_list);
  search = (search_t *) gtk_object_get_data(GTK_OBJECT(clist), "search");
  gtk_clist_freeze(clist);
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    file = (file_t *) gtk_clist_get_row_data(clist, row);
    gtk_clist_remove(clist, row);
    if (search) {
      search->results = g_list_remove(search->results, file);
      destroy_file_row(file);
    }
  }
  gtk_clist_thaw(clist);
  search_update_stats(search, 1);
}


void
on_clear_users_files_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  file_t *file;
  char *user;
  int i1;
  search_t *search;

  search = (search_t *)
    gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  clist = GTK_CLIST(global.popup_list);
  file = (file_t *) gtk_clist_get_row_data(clist, global.popup_row);
  user = l_strdup(file->user);

  gtk_clist_thaw(clist);
  i1 = 0;
  while (i1 < clist->rows) {
    file = (file_t *) gtk_clist_get_row_data(clist, i1);
    if (!strcmp(user, file->user)) {
      gtk_clist_remove(clist, i1);
      if (search) {
	search->results = g_list_remove(search->results, file);
	destroy_file_row(file);
      }
    } else {
      i1++;
    }
  }
  gtk_clist_thaw(clist);
  l_free(user);
  search_update_stats(search, 1);
}


void on_clear_all_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;

  search = (search_t *)
      gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  search_remove(search);
}

void on_clear_all_searches_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;
  GList* dlist;
  GList* to_remove = NULL;

  for (dlist = global.searches; dlist; dlist = dlist->next) {
    search = dlist->data;
    if (!search) continue;
    if (search->resume) continue;
    to_remove = g_list_prepend(to_remove, search);
  }
  for (dlist = to_remove; dlist; dlist = dlist->next) {
    search = dlist->data;
    search_remove(search);
  }
  g_list_free(to_remove);
}

void on_search_again_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;

  search = (search_t *)
    gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  if (!search) return;
  send_search_again(search);
}

void on_search_all_again_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;
  GList* dlist;

  for (dlist = global.searches; dlist; dlist = dlist->next) {
    search = dlist->data;
    if (!search) continue;
    if (search->resume) continue;
    if (search->status != SEARCH_FINISHED) continue;
    send_search_again(search);
  }
}

void on_client_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.client_win);
  gtk_widget_destroy(global.client_win);
  global.client_win = NULL;
}


void on_button149_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GList *dlist;
  client_t *client;

  dlist = g_list_first(global.client_list);
  while (dlist) {
    client = (client_t *) (dlist->data);
    l_free(client->info);
    l_free(client);
    dlist = dlist->next;
  }
  g_list_free(global.client_list);
  global.client_list = NULL;

  temp = lookup_widget(global.client_win, "clist8");
  gtk_clist_clear(GTK_CLIST(temp));
  send_command(CMD_CLIENT_VERSION_STATS, "");
}


void on_button150_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.client_win)
    gtk_widget_hide(global.client_win);
}


void on_customize_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkWidget *win;

  clist = GTK_CLIST(global.popup_list);
  win = create_customize_win(clist);
  gtk_widget_show(win);
}


void on_customize_win_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = GTK_WIDGET(object);
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button1x_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  int i1;
  GtkCList *clist;
  GtkWidget *win;
  GtkToggleButton *tbutton;
  char text[1024];

  win = lookup_widget(GTK_WIDGET(button), "customize_win");
  clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(win), "ref_clist"));

  for (i1 = 0; i1 < clist->columns; i1++) {
    sprintf(text, "check%d", i1);
    tbutton = GTK_TOGGLE_BUTTON(lookup_widget(win, text));
    if (gtk_toggle_button_get_active(tbutton))
      gtk_clist_set_column_visibility(clist, i1, TRUE);
    else
      gtk_clist_set_column_visibility(clist, i1, FALSE);
  }
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button2x_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "customize_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}

void on_banned_users_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  show_bans(NULL);
}


void on_linked_servers_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  lopster_links("");
}


void
on_client_statistic_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  show_clients();
}


void on_whois_user1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_add_user_win();
  gtk_window_set_title(GTK_WINDOW(win), _("Whois User"));
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void *) 2);
  gtk_widget_show(win);
}


void on_server1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  switch_to_page(0);

  temp = lookup_widget(global.win, "server_ctree");

  if (GTK_CLIST(temp)->rows == 0) {
    napigator_get_list();
  }
}

void on_refresh_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "server_ctree");
  gtk_clist_clear(GTK_CLIST(temp));

  napigator_get_list();
}

void on_add_servers_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkWidget *temp1;
  GtkCTreeNode *node;
  server_t *server;
  char t[1024];

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    server = create_server_from_napigator(ctree, node);
    row_list = row_list->next;
    if (!server)
      continue;
    if (!add_server_to_list(server)) {
      // already in list, do not insert
      sprintf(t, _("Server [%s] [%s] already in list\n"),
	      server->address, server->description);
      temp1 = lookup_widget(global.win, "text14");
      gtk_text_insert(GTK_TEXT(temp1), NULL, NULL, NULL, t, strlen(t));
      server_destroy(server);
    }
  }
}

void on_button158_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  add_server(0);
}

void on_connect2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkCList *clist;
  server_t *server;
  char t[1024];

  on_connect_activate(NULL, NULL);

  clist = GTK_CLIST(global.popup_list);
  server = (server_t *) gtk_clist_get_row_data(clist, global.popup_row);

  temp = lookup_widget(global.connect_win, "combo_entry12");
  sprintf(t, "%s %d", server->description, server->port);
  gtk_entry_set_text(GTK_ENTRY(temp), t);

  on_connection_ok_clicked(NULL, NULL);
}

void
on_delete_selected_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;
  server_t *server;

  clist = GTK_CLIST(lookup_widget(global.win, "clist11"));

  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    server = (server_t *) gtk_clist_get_row_data(clist, row);
    gtk_clist_remove(clist, row);
    global.servers = g_list_remove(global.servers, server);
    // delete server, missing
  }
}

gboolean
on_clist11_button_press_event(GtkWidget * widget,
			      GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_connect2_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    if (row != -1)
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_server_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}



void on_button159_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  add_server(1);
}


void on_combo_entry12_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  server_t *server;

  temp = lookup_widget(global.connect_win, "combo_entry12");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  server = search_server(text);
  l_free(text);

  if (!server || !server->nick || !server->passwd ||
      strlen(server->nick) < 1 || strlen(server->passwd) < 1) {
    temp = lookup_widget(global.connect_win, "connection_name");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.username);
    temp = lookup_widget(global.connect_win, "connection_pass");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.password);
  } else {
    temp = lookup_widget(global.connect_win, "connection_name");
    gtk_entry_set_text(GTK_ENTRY(temp), server->nick);
    temp = lookup_widget(global.connect_win, "connection_pass");
    gtk_entry_set_text(GTK_ENTRY(temp), server->passwd);
  }
}


void on_button162_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "information_win");
  gtk_widget_destroy(temp);
}

void on_resume_search_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;

  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = (resume_t *) gtk_ctree_node_get_row_data(ctree, node);
      resume_search(resume, 1);
    }
  }
}

void on_resume_play_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t *resume;

  ctree = GTK_CTREE(global.popup_list);

  node = gtk_ctree_node_nth(ctree, global.popup_row);
  resume = (resume_t *) gtk_ctree_node_get_row_data(ctree, node);

  play_file(resume->filename);
}

void on_resume_delete_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  resume_delete_dialog(_("Really delete these incomplete files?"));
}

void on_resume_cancel_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* to_cancel = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      to_cancel = g_list_append(to_cancel, gtk_ctree_node_get_row_data(ctree, node));
    }
  }
  
  for (dlist = to_cancel; dlist; dlist = dlist->next) {
    resume = dlist->data;
    resume_cancel(resume);
    resume_show(resume, 2);
  }
  if (to_cancel) g_list_free(to_cancel);
}

void on_resume_dont_search(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;

  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = (resume_t *) gtk_ctree_node_get_row_data(ctree, node);
      resume_dont_search(resume);
    }
  }
  resume_save();
}

void on_resume_allow_search(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;

  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = (resume_t *) gtk_ctree_node_get_row_data(ctree, node);
      resume_allow_search(resume);
    }
  }
  resume_save();
}

void on_resume_freeze_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* candidates = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);
  if (!ctree) return;

  for (dlist = GTK_CLIST(ctree)->selection; dlist; dlist = dlist->next) {
    node = GTK_CTREE_NODE(dlist->data);
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = gtk_ctree_node_get_row_data(ctree, node);
      candidates = g_list_append(candidates, resume);
    }
  }

  for (dlist = candidates; dlist; dlist = dlist->next) {
    resume = dlist->data;
    resume_freeze(resume);
  }
  g_list_free(candidates);
  resume_save();
}

void on_resume_thaw_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* candidates = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);
  if (!ctree) return;

  for (dlist = GTK_CLIST(ctree)->selection; dlist; dlist = dlist->next) {
    node = GTK_CTREE_NODE(dlist->data);
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = gtk_ctree_node_get_row_data(ctree, node);
      candidates = g_list_append(candidates, resume);
    }
  }

  for (dlist = candidates; dlist; dlist = dlist->next) {
    resume = dlist->data;
    resume_thaw(resume);
  }
  g_list_free(candidates);
  resume_save();
}

void on_refresh_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (!in_channel()) {
    g_warning("ops: not in channel!");
    return;
  }
  send_command(CMD_CLIENT_NAMES_LIST, global.current_page->name);
}


gboolean
on_clist12_button_press_event(GtkWidget * widget,
			      GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;
    if (row == -1)
      return FALSE;

    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_user_popup(M_GLOBAL);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

void on_global_users_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.user_win)
    gtk_widget_show(global.user_win);
  show_global_users(NULL, FALSE);
}


void on_user_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_destroy(global.user_win);
  global.user_win = NULL;
}


void on_button164_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char* args;
  GtkWidget *temp;
  char *text;
  char mode[20];
  int pos = 0;

  temp = lookup_widget(global.user_win, "entry74");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  *mode = 0;

  temp = lookup_widget(global.user_win, "checkbutton23");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'e';
  temp = lookup_widget(global.user_win, "checkbutton24");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'a';
  temp = lookup_widget(global.user_win, "checkbutton25");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'm';
  temp = lookup_widget(global.user_win, "checkbutton26");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'l';
  temp = lookup_widget(global.user_win, "checkbutton27");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'z';
  temp = lookup_widget(global.user_win, "checkbutton28");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'c';
  
  if (text && *text) {
    if (*mode) args = l_strdup_printf("%s %s", text, mode);
    else args = l_strdup_printf("%s", text);
  } else {
    if (*mode) args = l_strdup_printf("* %s", mode);
    else args = l_strdup_printf("*");
  }
  show_global_users(args, TRUE);
  l_free(args);
}


void on_button165_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.user_win);
}


void on_entry74_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  /*
  GtkWidget *temp;
  char *text;
  int val;

  temp = lookup_widget(global.user_win, "entry74");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) > 0)
    val = TRUE;
  else
    val = FALSE;

  temp = lookup_widget(global.user_win, "checkbutton23");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton24");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton25");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton26");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton27");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton28");
  gtk_widget_set_sensitive(temp, val);
  */
}

void on_spinbutton15_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  int val;
  user_info_t* userinfo;

  temp = lookup_widget(global.win, "spinbutton15");
  userinfo = gtk_object_get_data(GTK_OBJECT(temp), "userinfo");
  if (!userinfo) return;
  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  userinfo->max[0] = val;
}

void on_online_save_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkPaned *paned;
  int i1;

  clist = GTK_CLIST(global.current_page->online);
  for (i1 = 0; i1 < 3; i1++) {
    global.online_width[i1] = clist->column[i1].width;
    global.online_show[i1] = clist->column[i1].visible;
  }

  paned = GTK_PANED(global.current_page->toplevel);
  global.paned_pos = paned->child1_size;

  paned = GTK_PANED(global.current_page->paned);
  global.paned_pos2 = paned->child1_size;
}

void
on_ctree2_tree_select_row(GtkCTree * ctree,
			  GtkCTreeNode * node,
			  gint column, gpointer user_data ATTR_UNUSED)
{
  int row;
  GtkNotebook *notebook;
  GtkWidget *temp;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!global.options_win)
    return;

  notebook = GTK_NOTEBOOK(lookup_widget(global.options_win, "notebook2"));
  row = (int) gtk_ctree_node_get_row_data(ctree, node) - 1;
  if (gtk_notebook_get_current_page(notebook) != row) {
    gtk_notebook_set_page(notebook, row);
    temp = lookup_widget(global.options_win, "label780");
    gtk_ctree_node_get_pixtext(ctree, node, column,
			       &text, &space, &pixmap, &bitmap);

    gtk_label_set_text(GTK_LABEL(temp), text);
  }
}


void
on_notebook2_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page ATTR_UNUSED,
			 gint page_num, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  return;
  if (!global.options_win)
    return;

  page_num++;
  ctree = GTK_CTREE(lookup_widget(global.options_win, "ctree2"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, (void *) (page_num));
  gtk_ctree_select(ctree, node);

}


void on_dir_select167(gchar * dir)
{
  GtkWidget *temp;
  GtkWidget *entry;
  char *text;

  if (!global.options_win)
    return;
  temp = lookup_widget(global.options_win, "clist19");
  entry = lookup_widget(global.options_win, "entry81");
  text = gtk_entry_get_text(GTK_ENTRY(entry));

  if (dir && (strlen(dir) > 0)) {
    if (dir[strlen(dir) - 1] == '/')
      dir[strlen(dir) - 1] = 0;
    strcpy(tstr[0], text);
    strcpy(tstr[1], dir);
    gtk_clist_append(GTK_CLIST(temp), list);
  }
}


void on_button167_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser(_("Select Directory"), g_get_home_dir(),
			   GTK_SELECTION_EXTENDED, on_dir_select167);
  gtk_widget_show(win);
}


void on_button169_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist19"));
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}

void on_dir_select166(gchar * dir)
{
  GtkWidget *temp;

  if (!global.options_win)
    return;
  temp = lookup_widget(global.options_win, "entry75");
  if (dir) {
    if (dir[strlen(dir) - 1] == '/')
      dir[strlen(dir) - 1] = 0;
    gtk_entry_set_text(GTK_ENTRY(temp), dir);
  }
}

void on_button166_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser(_("Select Directory"), g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_dir_select166);
  gtk_widget_show(win);
}


void on_button140_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://lopster.sourceforge.net");
}


void on_button139_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://sourceforge.net/project/showfiles.php?group_id=8472");
}


void on_button143_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://sourceforge.net/mail/?group_id=8472");
}


void on_button141_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://sourceforge.net/projects/lopster");
}


void on_button142_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://sourceforge.net/forum/?group_id=8472");
}


void on_button144_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url
      ("http://sourceforge.net/tracker/?atid=108472&group_id=8472&func=browse");
}

void on_delete_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
}


void delete_file(file_t * file)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  file_t *file1;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  
  if (node) {
    file1 = gtk_ctree_node_get_row_data(ctree, node);
    if (file1 != file) return;
    file->flags |= FLAG_TO_DELETE;
    lib_apply_node(node);
    gtk_ctree_remove_node(ctree, node);
  }
}


void delete_subtree()
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (node) {
    lib_set_flag(FLAG_TO_DELETE, node);
    lib_apply_node(node);
    gtk_ctree_remove_node(ctree, node);
  }
}

void on_button170_clicked(GtkButton * button, gpointer user_data)
{
  GtkCList *clist;
  file_t *file;

  if (global.popup_row == -1)
    return;
  clist = GTK_CLIST(global.popup_list);

  file = (file_t *) gtk_clist_get_row_data(clist, global.popup_row);
  if (user_data == (gpointer) 1)
    delete_file(file);
  else
    delete_subtree();

  on_button171_clicked(button, user_data);
}


void on_button171_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "delete_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_notebook1_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page ATTR_UNUSED,
			 gint page_num, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (page_num == 1) {
    temp = lookup_widget(global.win, "chat_entry");
    gtk_widget_grab_focus(temp);
    temp = lookup_widget(global.win, "label274");
    gtk_widget_set_style(temp, global.style[0]);
  }
}


void on_log_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
}


void on_button172_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "clist15"));
  row_list = clist->selection;
  if (row_list) {
    row = (int) row_list->data;
    log_delete(GTK_WIDGET(button), row);
  }
}


void on_button173_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "log_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void on_logfiles_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  log_show_init();
}


void
on_clist14_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  log_show_section(clist, row);
}


void
on_clist15_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  log_show_file(clist, row);
}


void
on_checkbutton30_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.client_win, "spinbutton19");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

void on_combo_entry19_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  setup_sensitive(1);
}


void
on_checkbutton4_toggled(GtkToggleButton * togglebutton, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.options_win, "spinbutton2");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);
}

void
on_checkbutton33_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.options_win, "spinbutton32");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

gboolean
on_browse_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  gtk_clist_get_pixtext(GTK_CLIST(widget), row, 0,
			&text, &space, &pixmap, &bitmap);
  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_download2_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_browse_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


gboolean
on_clist16_button_press_event(GtkWidget * widget,
			      GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_refresh_users_files_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_hotlist_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


void
on_checkbutton36_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "spinbutton33");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}


void on_button176_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  on_entry79_activate(NULL, NULL);
}


void on_entry79_activate(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  int max = 0;

  temp = lookup_widget(global.win, "entry79");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp = lookup_widget(global.win, "checkbutton36");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(global.win, "spinbutton33");
    max = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  }

  if (strlen(text) > 0)
    browse_user_files(text, max);
}

void on_browse_files_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);

  browse_user_files(user, 0);
}

void on_sync_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  user_t* userinfo = user_data;

  if (!userinfo) return;
  lib_compare_with_browse(userinfo);
}

void on_dir_select182(gchar * dir)
{
  GtkCList *clist;
  GtkWidget *entry;
  char *mime;
  char *text;
  int i1;

  if (!global.options_win)
    return;
  clist = GTK_CLIST(lookup_widget(global.options_win, "clist18"));
  entry = lookup_widget(global.options_win, "combo_entry21");
  mime = gtk_entry_get_text(GTK_ENTRY(entry));
  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_text(clist, i1, 0, &text);
    if (!l_strcasecmp(text, mime))
      break;
  }
  if (i1 == clist->rows)
    return;
  if (dir && (strlen(dir) > 0)) {
    if (dir[strlen(dir) - 1] == '/')
      dir[strlen(dir) - 1] = 0;
    gtk_clist_set_text(clist, i1, 1, dir);
  }
}

void on_button182_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser(_("Select Download Folder"), g_get_home_dir(),
			   GTK_SELECTION_EXTENDED, on_dir_select182);
  gtk_widget_show(win);
}


void on_button180_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkWidget *entry;
  char *all_suff;
  char *suff;
  char *mime;
  char *app;
  char *text;
  int i1;

  if (!global.options_win)
    return;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));

  entry = lookup_widget(global.options_win, "combo_entry20");
  mime = gtk_entry_get_text(GTK_ENTRY(entry));
  if (!mime || !(*mime))
    return;
  strcpy(tstr[1], mime);

  entry = lookup_widget(global.options_win, "entry80");
  all_suff = l_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));

  entry = lookup_widget(global.options_win, "entry82");
  app = gtk_entry_get_text(GTK_ENTRY(entry));
  strcpy(tstr[2], app);

  entry = lookup_widget(global.options_win, "checkbutton55");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(entry)) ||
      !l_strcasecmp(_("mp3"), mime))
    strcpy(tstr[3], _("Yes"));
  else
    strcpy(tstr[3], _("No"));

  suff = arg(all_suff, 0);
  while (suff) {
    if (*suff == '.') suff++;
    for (i1 = 0; i1 < clist->rows; i1++) {
      gtk_clist_get_text(clist, i1, 0, &text);
      if (!l_strcasecmp(text, suff))
	break;
    }
    if (i1 == clist->rows) {
      // new entry
      strcpy(tstr[0], suff);
      gtk_clist_append(clist, list);
    } else {
      // update entry
      gtk_clist_set_text(clist, i1, 1, tstr[1]);
      gtk_clist_set_text(clist, i1, 2, tstr[2]);
      gtk_clist_set_text(clist, i1, 3, tstr[3]);
    }
    suff = arg(NULL, 0);
  }
}



void
on_clist17_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *entry;
  char *text;

  if (!global.options_win)
    return;
  gtk_clist_get_text(clist, row, 1, &text);
  entry = lookup_widget(global.options_win, "combo_entry20");
  gtk_entry_set_text(GTK_ENTRY(entry), text);

  gtk_clist_get_text(clist, row, 0, &text);
  entry = lookup_widget(global.options_win, "entry80");
  gtk_entry_set_text(GTK_ENTRY(entry), text);

  gtk_clist_get_text(clist, row, 2, &text);
  entry = lookup_widget(global.options_win, "entry82");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
}

void on_button183_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}


void on_combo_entry17_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  setup_sensitive(2);
}

void on_changes_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  changes_dialog(_("Changes since Lopster 0.9.9"));
}


void
on_clist18_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *entry;
  char *text;

  if (!global.options_win)
    return;
  gtk_clist_get_text(clist, row, 0, &text);
  entry = lookup_widget(global.options_win, "combo_entry21");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
}


void popup_position(GtkMenu * menu, gint * x, gint * y, gpointer user_data)
{
  GtkRequisition requisition;
  GtkWidget *widget;
  gint screen_width;
  gint screen_height;
      

  if (!user_data)
    return;

  widget = GTK_WIDGET(user_data);

  gdk_window_get_origin(GTK_WIDGET(widget)->window, x, y);
  *x -= 2;
  *y -= 2;

  gtk_widget_size_request(GTK_WIDGET(menu), &requisition);
  screen_width = gdk_screen_width ();
  screen_height = gdk_screen_height ();
  *y -= requisition.height;

  *x = CLAMP (*x, 0, MAX (0, screen_width - requisition.width));
  *y = CLAMP (*y, 0, MAX (0, screen_height - requisition.height));

}


void on_button185_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  GtkWidget *temp;

  temp = lookup_widget(global.win, "frame119");

  pop = create_mode_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}


void toggle_mode(char *mode)
{
  char *data;

  if ((data = is_string_in_list(global.usermode, mode)) != NULL)
  {
    global.usermode = g_list_remove(global.usermode, data);
    l_free(data);
  } else {
    global.usermode = g_list_append(global.usermode, l_strdup(mode));
  }
  send_command(CMD_CLIENT_USER_MODE, "NONE");
  data = make_string_from_list(global.usermode, " ");
  send_command(CMD_CLIENT_USER_MODE, data);
  client_message(NULL, _("User mode was set to [%s]"), data);
}


void on_mode_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  int mode = (int) user_data;

  if (mode < 0)
    return;
  if (mode >= NO_MODES)
    return;

  toggle_mode(Mode[mode]);
}

void on_button186_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  char *channel;
  GList *row_list;
  char *user;
  char *command;
  int row;

  if (!global.ban_win)
    return;
  clist = GTK_CLIST(lookup_widget(global.ban_win, "clist3"));
  channel = gtk_object_get_data(GTK_OBJECT(global.ban_win), "channel");

  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_get_text(clist, row, 0, &user);

    if (channel) {
      command = l_strdup_printf("%s %s", channel, user);
      send_command(CMD_CLIENT_CHANNEL_UNBAN, command);
      l_free(command);
    } else {
      send_command(CMD_CLIENT_UNBAN, user);
    }
    gtk_clist_remove(clist, row);
  }
}


void on_button187_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  GtkWidget *temp;

  temp = lookup_widget(global.win, "frame123");

  pop = create_server2_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}

void
on_checkbutton39_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    log_show_type(GTK_WIDGET(togglebutton), LOG_CHANNEL);
  } else {
    log_hide_type(GTK_WIDGET(togglebutton), LOG_CHANNEL);
  }
}


void
on_checkbutton40_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    log_show_type(GTK_WIDGET(togglebutton), LOG_PRIVATE);
  } else {
    log_hide_type(GTK_WIDGET(togglebutton), LOG_PRIVATE);
  }
}


void
on_checkbutton41_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    log_show_type(GTK_WIDGET(togglebutton), LOG_OTHER);
  } else {
    log_hide_type(GTK_WIDGET(togglebutton), LOG_OTHER);
  }
}


void
on_checkbutton16_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.options_win, "spinbutton34");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

void on_kill_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user)
    send_command(CMD_CLIENT_KILL, user);
}

void on_ban_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user)
    send_command(CMD_CLIENT_BAN, user);
}

void on_locate_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user)
    send_command(CMD_CLIENT_WHICH_SERVER, user);
}

void on_send_file_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user)
    dcc_select_file(user);
}

void on_nuke_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user)
    send_command(CMD_CLIENT_NUKE, user);
}

void on_muzzle_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user)
    send_command(CMD_CLIENT_MUZZLE, user);
}

void on_chmuzzle_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;
  char *command;

  user = get_popup_user(mode);
  if (user) {
    command = l_strdup_printf("%s %s", global.current_page->name, user);
    send_command(CMD_CLIENT_CHANNEL_MUZZLE, command);
    l_free(command);
  }
}

void on_chban_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;
  char *command;

  user = get_popup_user(mode);
  if (user) {
    command = l_strdup_printf("%s %s", global.current_page->name, user);
    send_command(CMD_CLIENT_CHANNEL_BAN, command);
    l_free(command);
  }
}

void on_kick_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;
  char *command;

  user = get_popup_user(mode);
  if (user) {
    command = l_strdup_printf("%s %s", global.current_page->name, user);
    send_command(CMD_CLIENT_KICK, command);
    l_free(command);
  }
}


void popup_position2(GtkMenu * menu, gint * x,
		     gint * y, gpointer user_data)
{
  GtkRequisition requisition;
  GtkWidget *widget;
  gint screen_width;
  gint screen_height;

  if (!user_data)
    return;

  widget = GTK_WIDGET(user_data);

  gdk_window_get_origin(GTK_WIDGET(widget)->window, x, y);

  *y += widget->allocation.height;

  gtk_widget_size_request(GTK_WIDGET(menu), &requisition);
  screen_width = gdk_screen_width();
  screen_height = gdk_screen_height();

  *x = CLAMP(*x, 0, MAX(0, screen_width - requisition.width));
  *y = CLAMP(*y, 0, MAX(0, screen_height - requisition.height));
}

void on_button189_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  global.popup_list = lookup_widget(global.whois_win, "label527");

  pop = create_user_popup(M_WHOIS);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void on_safe_exit_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.status.exiting = E_SAFE;
  if (global.limit.cur_uploads + global.limit.cur_downloads > 0) {

    send_command(CMD_CLIENT_UNSHARE_ALL, "");
    lib_del_flag(FLAG_SHARED, NULL);
    lib_del_flag(FLAG_TO_SHARE, NULL);
    global.user.unshared = global.user.shared;
    lib_apply_node(NULL);

    client_message(_("Safe exit"),
		   _("Waiting for transfers to be finished"));
    client_message(_("Safe exit"), _("%d downloads, %d uploads"),
		   global.limit.cur_downloads, global.limit.cur_uploads);
  }
}


gboolean
on_window_focus_in_event(GtkWidget * widget,
			 GdkEventFocus * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = (chat_page_t *) gtk_object_get_data(GTK_OBJECT(widget),
					     "channel");
  global.current_page = page;
  return FALSE;
}


gboolean
on_window_focus_out_event(GtkWidget * widget ATTR_UNUSED,
			  GdkEventFocus * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = chat_page_get_current_main();
  if (!page)
    return FALSE;
  global.current_page = page;
  return FALSE;
}

void on_chat_destroy(GtkWidget * window ATTR_UNUSED, gpointer user_data)
{
  chat_page_t *page;

  page = gtk_object_get_data(GTK_OBJECT(user_data), "channel");

  if (page)
    chat_page_attach_to_main(page);
}

void on_chat_leave_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  chat_page_t *page = (chat_page_t *) user_data;

  chat_page_leave(page);
}

void on_chat_attach_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  chat_page_t *page = (chat_page_t *) user_data;

  gtk_widget_destroy(page->window);
}

void on_button191_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = chat_page_get_current_main();
  if (!page)
    return;
  chat_page_attach_to_new(page);
}

GtkWidget *create_tab_label(int no)
{
  GtkWidget *hbox;
  GtkWidget *temp;

  switch (no) {
  case 0:
    hbox = lookup_widget(global.win, "hbox216");
    temp = lookup_widget(global.win, "detach_server");
    break;
  case 1:
    hbox = lookup_widget(global.win, "hbox1");
    temp = lookup_widget(global.win, "detach_chat");
    break;
  case 2:
    hbox = lookup_widget(global.win, "hbox7");
    temp = lookup_widget(global.win, "detach_library");
    break;
  case 3:
    hbox = lookup_widget(global.win, "hbox18");
    temp = lookup_widget(global.win, "detach_search");
    break;
  case 4:
    hbox = lookup_widget(global.win, "hbox294");
    temp = lookup_widget(global.win, "detach_hotlist");
    break;
  case 5:
    hbox = lookup_widget(global.win, "hbox22");
    temp = lookup_widget(global.win, "detach_downloads");
    break;
  case 6:
    hbox = lookup_widget(global.win, "hbox419");
    temp = lookup_widget(global.win, "detach_uploads");
    break;
  case 7:
  default:
    hbox = lookup_widget(global.win, "hbox657");
    temp = lookup_widget(global.win, "detach_statistic");
    break;
  }

  if (temp)
    gtk_widget_set_sensitive(temp, TRUE);

  return hbox;
}

gboolean
on_extra_win_delete(GtkWidget * widget,
		    GdkEvent * event ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *win;
  GtkWidget *temp;
  GtkWidget *tab_label;
  GtkNotebook *notebook;
  int no;
  int i1;
  int pos;

  win = widget;
  no = (int) user_data;

  // getting geometry
  if (win->window) {
    gdk_window_get_origin(win->window,
			  &global.geometry[no].x, &global.geometry[no].y);
  }
  global.geometry[no].width = win->allocation.width;
  global.geometry[no].height = win->allocation.height;

  temp = GTK_BIN(win)->child;
  if (!temp)
    return FALSE;

  gtk_widget_ref(temp);
  gtk_container_remove(GTK_CONTAINER(win), temp);

  pos = 0;
  for (i1 = 0; i1 < no; i1++)
    if ((global.extra_win & (1 << i1)) == 0)
      pos++;
  global.extra_win &= (0xFF) ^ (1 << no);

  tab_label = create_tab_label(no);
  gtk_widget_show(tab_label);

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook1"));
  gtk_notebook_insert_page(notebook, temp, tab_label, pos);
  gtk_widget_unref(temp);

  return FALSE;
}

gboolean
on_text_button_press_event(GtkWidget * widget,
			   GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  if (event->button == global.options.popup_create) {
    global.popup_row = GTK_TEXT(widget)->cursor_mark.index;
    if (!get_word(GTK_TEXT(widget), 0))
      return FALSE;
    global.popup_list = widget;
    gtk_grab_remove(widget);
    pop = create_user_popup(M_TEXT);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


void on_button203_clicked(GtkButton * button, gpointer user_data)
{
  GtkLabel *label;

  label = GTK_LABEL(lookup_widget(GTK_WIDGET(button), "label529"));

  send_command(CMD_CLIENT_KILL_SERVER, label->label);
  on_button204_clicked(button, user_data);
}


void on_button204_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "shutdown_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void on_known_problems_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  problems_get();
}

void on_spinbutton35_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  global.limit.default_downloads =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_D_ULIMIT);
}


void on_spinbutton36_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{

  global.limit.default_uploads =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_U_ULIMIT);
  return;
}


gboolean
on_drawingarea1_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  draw_band_width(&global.down_width, 1);
  return TRUE;
}


gboolean
on_drawingarea2_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  draw_band_width(&global.up_width, 1);
  return TRUE;
}


void on_button206_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.down_width.maxval >= (1 << 30))
    return;
  global.down_width.maxval *= 2;
  draw_band_width(&global.down_width, 1);
}


void on_button207_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.down_width.maxval <= 1024)
    return;

  global.down_width.maxval /= 2;
  draw_band_width(&global.down_width, 1);
}


void on_button208_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.up_width.maxval >= (1 << 30))
    return;
  global.up_width.maxval *= 2;
  draw_band_width(&global.up_width, 1);
}


void on_button209_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.up_width.maxval <= 1024)
    return;

  global.up_width.maxval /= 2;
  draw_band_width(&global.up_width, 1);
}


gboolean
on_drawingarea1_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int height = widget->allocation.height - 19;
  int x = (int) event->x - 8;
  int y = (int) event->y - 17;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;
  global.down_width.limit = (int) ((double) global.down_width.maxval /
				   (double)width * (double)x);
  draw_band_width(&global.down_width, 1);
  return FALSE;
}


gboolean
on_drawingarea2_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int height = widget->allocation.height - 19;
  int x = (int) event->x - 8;
  int y = (int) event->y - 17;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;
  global.up_width.limit = (int) ((double) global.up_width.maxval /
				 (double)width * (double)x);
  draw_band_width(&global.up_width, 1);

  return FALSE;
}

void on_button214_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  pop = create_dl_remove_popup(global.options.dl_autoremove);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void on_button215_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  pop = create_retry_popup(global.options.auto_retry);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void on_button216_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  pop = create_ul_remove_popup(global.options.ul_autoremove);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


gboolean
on_window_delete_event(GtkWidget * widget ATTR_UNUSED,
		       GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global_exit();

  return FALSE;
}

void on_show_sockets_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList* clist;
  if (global.socket_win) return;

  global.socket_win = create_socket_win();
  gtk_widget_show(global.socket_win);
  clist = GTK_CLIST(lookup_widget(global.socket_win, "clist20"));
  gtk_clist_set_compare_func(clist, socket_compare);
}


gboolean
on_socket_win_delete_event(GtkWidget * widget ATTR_UNUSED,
			   GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.socket_win = NULL;
  return FALSE;
}

void
on_notebook5_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page,
			 gint page_num ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;
  GtkObject *clist;
  GtkWidget *temp;

  if (page) {
    temp = lookup_widget(global.win, "button274");
    gtk_widget_set_sensitive(temp, TRUE);
    temp = lookup_widget(global.win, "button219");
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    temp = lookup_widget(global.win, "button274");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "button219");
    gtk_widget_set_sensitive(temp, FALSE);
    return;
  }
  clist = gtk_object_get_data(GTK_OBJECT(page->child), "clist");
  if (clist) {
    search = (search_t *) gtk_object_get_data(clist, "search");
    search_update_stats(search, 0);
    search_pattern_show(search->pattern);
  }
  
}


void on_button218_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_fields_detach();
}

gboolean
on_drawingarea1_motion_notify_event(GtkWidget * widget,
				    GdkEventMotion * event,
				    gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int x = (int) event->x - 8;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;
  global.down_width.limit = (int) ((double) global.down_width.maxval /
				   (double)width * (double)x);
  draw_band_width(&global.down_width, 1);
  return FALSE;
}


gboolean
on_drawingarea2_motion_notify_event(GtkWidget * widget,
				    GdkEventMotion * event,
				    gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int x = (int) event->x - 8;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;
  global.up_width.limit = (int) ((double) global.up_width.maxval /
				 (double)width * (double)x);
  draw_band_width(&global.up_width, 1);

  return FALSE;
}


void on_button219_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int num;
  GtkWidget *temp;
  GtkCList *clist;

  temp = lookup_widget(global.win, "notebook5");
  num = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
  if (num < 0) return;

  temp = gtk_notebook_get_nth_page(GTK_NOTEBOOK(temp), num);
  if (temp) {
    clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(temp), "clist"));
    if (clist) {
      global.search_width[0] = clist->column[0].width;
      global.search_show[0] = clist->column[0].visible;
      global.search_width[1] = clist->column[1].width;
      global.search_show[1] = clist->column[1].visible;
      global.search_width[2] = clist->column[2].width;
      global.search_show[2] = clist->column[2].visible;
      global.search_width[3] = clist->column[3].width;
      global.search_show[3] = clist->column[3].visible;
      global.search_width[4] = clist->column[4].width;
      global.search_show[4] = clist->column[4].visible;
      global.search_width[5] = clist->column[5].width;
      global.search_show[5] = clist->column[5].visible;
      global.search_width[6] = clist->column[5].width;
      global.search_show[6] = clist->column[5].visible;
    }
  }
}


void on_button217_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.socket_win)
    gtk_widget_destroy(global.socket_win);
}


void on_socket_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.socket_win = NULL;
}


void
on_clist20_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  socket_t *socket;

  socket = (socket_t *) gtk_clist_get_row_data(clist, row);
  socket_show_clist(socket);
}


void on_window_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{

}


void on_detach_server_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(0);
}


void on_detach_chat_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(1);
}


void on_detach_library_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(2);
}


void on_detach_search_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(3);
}


void on_detach_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(4);
}


void
on_detach_downloads_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(5);
}


void on_detach_uploads_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(6);
}


void on_button229_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *temp;
  scheme_t *scheme;

  win = create_prefix_win();
  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme) {
    temp = lookup_widget(win, "entry122");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->server_prefix);
    temp = lookup_widget(win, "entry123");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->client_prefix);
    temp = lookup_widget(win, "entry124");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->join_prefix);
    temp = lookup_widget(win, "entry125");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->part_prefix);
  }

  gtk_widget_show(win);
}


gboolean
on_ignore_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;
    if (row == -1)
      return FALSE;

    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_user_popup(M_IGNORE);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


void on_button232_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  lib_refresh();
}


void on_ok_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void on_button231_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  GtkSignalFunc func[2];
  char *buttons[2];

  temp = lookup_widget(global.win, "entry84");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) <= 0) {
    func[0] = (GtkSignalFunc) on_ok_clicked;
    func[1] = NULL;
    buttons[0] = l_strdup(_("Ok"));
    buttons[1] = NULL;

    temp = create_info_win(_("No filename specified!"), buttons, func);
    gtk_widget_show(temp);

    l_free(buttons[0]);
    return;
  }
  lib_save(text);
}


void on_button230_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  pop = create_files_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}


void on_unshare_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  file_t *file;

  if (global.popup_row == -1)
    return;

  clist = GTK_CLIST(global.popup_list);

  file = (file_t *) gtk_clist_get_row_data(clist, global.popup_row);
  if (file->flags & FLAG_SHARED) {
    file->flags |= FLAG_TO_UNSHARE;
  } else {
    file->flags |= FLAG_TO_SHARE;
  }
  lib_apply_file(file);
  lib_tree_update_file(file, NULL);
}


void
on_unshare_subtree_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  if (global.popup_row == -1)
    return;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (node) {
    lib_replace_flag(FLAG_SHARED, FLAG_TO_UNSHARE, node);
    lib_apply_node(node);
  }
}


void on_share_subtree_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  if (global.popup_row == -1)
    return;

  ctree = GTK_CTREE(global.popup_list);

  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (node) {
    lib_xor_flag(FLAG_SHARED, FLAG_TO_SHARE, node);
    lib_apply_node(node);
  }
}


void on_button236_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int num;
  GtkWidget *temp;
  GtkCList *clist;

  temp = lookup_widget(global.win, "notebook6");
  num = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
  if (num < 0)
    return;


  temp = gtk_notebook_get_nth_page(GTK_NOTEBOOK(temp), num);
  if (temp) {
    clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(temp), "clist"));
    if (clist) {
      global.browse_width[0] = clist->column[0].width;
      global.browse_show[0] = clist->column[0].visible;
      global.browse_width[1] = clist->column[1].width;
      global.browse_show[1] = clist->column[1].visible;
      global.browse_width[2] = clist->column[2].width;
      global.browse_show[2] = clist->column[2].visible;
      global.browse_width[3] = clist->column[3].width;
      global.browse_show[3] = clist->column[3].visible;
      global.browse_width[4] = clist->column[4].width;
      global.browse_show[4] = clist->column[4].visible;
    }
  }
}


void on_spinbutton42_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  global.limit.max_searches =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
  global.limit.max_searches_real = global.limit.max_searches;
  setup_preferences(P_NSEARCH);
}

void
on_search_select_row(GtkCList * clist ATTR_UNUSED,
		     gint row ATTR_UNUSED,
		     gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  //  file_t* file;

  //  file = (file_t*)gtk_clist_get_row_data(clist, row);
  //  if (file) printf("ping: %d\n", file->ping);
}

void on_button237_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *widget;

  win = lookup_widget(GTK_WIDGET(button), "retry_win");
  widget = lookup_widget(win, "spinbutton43");
  global.options.retry_timeout[0] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton44");
  global.options.retry_timeout[1] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton45");
  global.options.retry_timeout[2] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton46");
  global.options.retry_timeout[3] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton47");
  global.options.retry_timeout[4] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton58");
  global.options.retry_timeout[5] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button238_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "retry_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button243_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  resume_t* resume;
  GList* dlist;

  // remove finished downloads
  dlist = global.incomplete;
  while (dlist) {
    resume = dlist->data;
    dlist = dlist->next;
    if (resume && (resume->status == R_FINISHED)) {
      resume_remove(resume);
    }
  }
}


void on_button244_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t* resume;

  // remove aborted downloads

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree4"));
  gtk_clist_freeze(GTK_CLIST(ctree));

  node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);
  
  while (node) {
    resume = gtk_ctree_node_get_row_data(ctree, node);
    node = GTK_CTREE_ROW (node)->sibling;
    if (resume && (resume->status != R_FINISHED) &&
	!resume->socket && !resume_has_potentials(resume)) {
      resume_show(resume, 2);
    }
  }
  gtk_clist_thaw(GTK_CLIST(ctree));
}


void on_button241_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *s = NULL;
  GList *dlist;
  socket_t *socket;
  transfer_t *transfer;
  int i1;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  gtk_clist_freeze(clist);

  for (i1 = 0; i1 < clist->rows; i1++) {
    socket = gtk_clist_get_row_data(clist, i1);
    if (!socket) continue;
    transfer = socket->data;
    if (!transfer) continue;
    if (transfer->status == S_FINISHED)
      s = g_list_append(s, socket);
  }

  for (dlist = s; dlist; dlist = dlist->next) {
    socket = dlist->data;
    socket_end(socket, &(SocketStatus[S_DELETE]));
  }
  g_list_free(s);
  gtk_clist_thaw(clist);
}


void on_button242_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  int i1;
  GList *s = NULL;
  GList *dlist;
  socket_t *socket;
  transfer_t *transfer;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  gtk_clist_freeze(clist);
  for (i1 = 0; i1 < clist->rows; i1++) {
    socket = gtk_clist_get_row_data(clist, i1);
    if (!socket) continue;
    transfer = socket->data;
    if (!transfer) continue;
    if (transfer->status == S_FINISHED)
      continue;
    if (transfer->status == S_QUEUED)
      continue;
    if (transfer_in_progress(transfer))
      continue;
    s = g_list_append(s, socket);
  }

  for (dlist = s; dlist; dlist = dlist->next) {
    socket = (socket_t *) (dlist->data);
    socket_end(socket, &(SocketStatus[S_DELETE]));
  }
  g_list_free(s);
  gtk_clist_thaw(clist);
}


void on_button245_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  resume_search_all(1);
}


void
on_checkbutton46_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "spinbutton48");

  if (gtk_toggle_button_get_active(togglebutton)) {
    global.options.auto_search = 1;
  } else {
    global.options.auto_search = 0;
  }

  setup_preferences(P_RSEARCH);
}


void on_spinbutton48_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "spinbutton48");
  global.options.resume_timeout =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  setup_preferences(P_RSEARCH);
}


void on_spinbutton49_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  int val;
  user_info_t* userinfo;

  temp = lookup_widget(global.win, "spinbutton49");
  userinfo = gtk_object_get_data(GTK_OBJECT(temp), "userinfo");
  if (!userinfo) return;
  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  userinfo->max[1] = val;
}


void
on_transfer_up_select_row(GtkCList * clist,
			  gint row,
			  gint column ATTR_UNUSED,
			  GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  transfer_t *transfer;
  socket_t *socket;

  socket = (socket_t *) gtk_clist_get_row_data(clist, row);
  transfer = (transfer_t *) (socket->data);
  if (!transfer) return;

  user_info_show(transfer->user_info, 0, 0);
}


void
on_checkbutton48_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (!global.options_win)
    return;

  temp = lookup_widget(global.options_win, "spinbutton51");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }

}


void
on_checkbutton49_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (!global.options_win)
    return;

  temp = lookup_widget(global.options_win, "entry85");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}


void
on_checkbutton45_toggled(GtkToggleButton * togglebutton ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  setup_preferences(P_PINGS);
}


void on_spinbutton53_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  global.limit.max_large =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
}


void on_spinbutton54_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  int i1;
  socket_t *socket;
  transfer_t *transfer;

  global.limit.large_size =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));

  global.limit.cur_large = 0;

  for (i1 = 0; i1 < clist->rows; i1++) {
    socket = (socket_t *) gtk_clist_get_row_data(clist, i1);
    transfer = (transfer_t *) (socket->data);
    if (!transfer)
      continue;
    if (transfer_in_progress(transfer))
      if (transfer->size >= (unsigned long) (global.limit.large_size) *1024 * 1024)
	global.limit.cur_large++;
  }
}


void on_combo_entry22_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!l_strcasecmp(text, _("None")))
    global.options.show_parts = 0;
  else if (!l_strcasecmp(text, _("Recent Users")))
    global.options.show_parts = 1;
  else
    global.options.show_parts = 2;

  temp = lookup_widget(global.win, "spinbutton55");
  if (global.options.show_parts == 1)
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);

  setup_preferences(P_SHOW_JOIN);
}


void on_combo_entry23_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!l_strcasecmp(text, _("None")))
    global.options.show_joins = 0;
  else
    global.options.show_joins = 1;

  setup_preferences(P_SHOW_JOIN);
}


void on_spinbutton55_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  global.options.recent_timeout =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_SHOW_JOIN);
}


void on_combo_entry25_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  temp = lookup_widget(global.options_win, "spinbutton56");

  if (!l_strcasecmp(text, _("Recent Users")))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}


void on_wizard_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_destroy(GTK_WIDGET(object));
}


void on_button_browse_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  wizard_browse((int) user_data);
}


void on_button262_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  pop = create_wizard_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}


void on_button263_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  wizard_clear_selected();
}


void on_button247_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  wizard_next();
}


void on_button246_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  wizard_previous();
}


void on_button264_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  wizard_help();
}

void on_button272_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_expand_recursive(ctree, NULL);
}


void on_button273_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_collapse_recursive(ctree, NULL);
}


void on_combo_entry26_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  global.options.timestamps = timestamp2int(text);

  setup_preferences(P_TIMESTAMPS);
}


void
on_detach_statistic_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(7);
}


void on_button274_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int num;
  GtkWidget *temp;
  GtkCList *clist;
  search_t *search;

  temp = lookup_widget(global.win, "notebook5");
  num = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
  if (num < 0) return;

  temp = gtk_notebook_get_nth_page(GTK_NOTEBOOK(temp), num);
  if (temp) {
    clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(temp), "clist"));
    if (clist) {
      search = (search_t *)
	  gtk_object_get_data(GTK_OBJECT(clist), "search");
      search_remove(search);
    }
  }
}


gboolean
on_drawingarea5_motion_notify_event(GtkWidget * widget ATTR_UNUSED,
				    GdkEventMotion * event,
				    gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  int width, height;
  int x1 = 0;
  int x2 = 0;
  int i1, number;
  char str[1024];

  if (global.statistic.no_download[S_NUMBER] == 0)
    return FALSE;

  temp = lookup_widget(global.win, "drawingarea5");
  width = temp->allocation.width;
  height = temp->allocation.height;

  number = 0;
  for (i1 = 0; i1 < S_NUMBER; i1++) {
    number += global.statistic.no_download[i1];
    x2 = width * number / global.statistic.no_download[S_NUMBER];
    if ((event->x >= x1) && (event->x < x2))
      break;
    x1 = x2;
  }

  global.statistic.cur_down = i1;

  temp = lookup_widget(global.win, "label792");
  sprintf(str, _("[Downloads] %s: %d - Total: %d"), status_names(i1),
	  global.statistic.no_download[i1],
	  global.statistic.no_download[S_NUMBER]);
  gtk_label_set_text(GTK_LABEL(temp), str);

  return FALSE;
}


gboolean
on_drawingarea6_motion_notify_event(GtkWidget * widget ATTR_UNUSED,
				    GdkEventMotion * event,
				    gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  int width, height;
  int x1 = 0;
  int x2 = 0;
  int i1, number;
  char str[1024];

  if (global.statistic.no_upload[S_NUMBER] == 0)
    return FALSE;

  temp = lookup_widget(global.win, "drawingarea6");
  width = temp->allocation.width;
  height = temp->allocation.height;

  number = 0;
  for (i1 = 0; i1 < S_NUMBER; i1++) {
    number += global.statistic.no_upload[i1];
    x2 = width * number / global.statistic.no_upload[S_NUMBER];
    if ((event->x >= x1) && (event->x < x2))
      break;
    x1 = x2;
  }

  global.statistic.cur_up = i1;

  temp = lookup_widget(global.win, "label793");
  sprintf(str, _("[Uploads] %s: %d - Total: %d"), status_names(i1),
	  global.statistic.no_upload[i1], global.statistic.no_upload[S_NUMBER]);
  gtk_label_set_text(GTK_LABEL(temp), str);

  return FALSE;
}


void
on_clist16_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  hot_t *hot;

  hot = gtk_clist_get_row_data(clist, row);
  hotlist_show_description(hot);
}

gboolean
on_drawingarea3_expose_event(GtkWidget * widget,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int new_size;
  int *new_band;
  int pos1, pos2;

  new_size = widget->allocation.width+10;
  //  printf("w1 %d/%d\n", global.statistic.band_size[0], new_size);

  if (new_size != global.statistic.band_size[0]) {
    new_band = (int *) l_malloc(sizeof(int) * new_size);
    memset(new_band, 0, sizeof(int) * new_size);
    pos1 = global.statistic.band_pos[0];
    pos2 = new_size - 1;
    while (1) {
      new_band[pos2] = global.statistic.download_band[pos1];
      pos1--;
      pos2--;
      if (pos2 < 0)
	break;
      if (pos1 < 0)
	pos1 = global.statistic.band_size[0] - 1;
      if (pos1 == global.statistic.band_pos[0])
	break;
    }
    global.statistic.band_pos[0] = new_size - 1;
    global.statistic.band_size[0] = new_size;
    l_free(global.statistic.download_band);
    global.statistic.download_band = new_band;
  }

  statistic_draw_download(&global.statistic);
  return FALSE;
}


gboolean
on_drawingarea4_expose_event(GtkWidget * widget,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int new_size;
  int *new_band;
  int pos1, pos2;

  new_size = widget->allocation.width+10;

  if (new_size != global.statistic.band_size[1]) {
    new_band = (int *) l_malloc(sizeof(int) * new_size);
    memset(new_band, 0, sizeof(int) * new_size);
    pos1 = global.statistic.band_pos[1];
    pos2 = new_size - 1;
    while (1) {
      new_band[pos2] = global.statistic.upload_band[pos1];
      pos1--;
      pos2--;
      if (pos2 < 0)
	break;
      if (pos1 < 0)
	pos1 = global.statistic.band_size[1] - 1;
      if (pos1 == global.statistic.band_pos[1])
	break;
    }
    global.statistic.band_pos[1] = new_size - 1;
    global.statistic.band_size[1] = new_size;
    l_free(global.statistic.upload_band);
    global.statistic.upload_band = new_band;
  }

  statistic_draw_upload(&global.statistic);

  return FALSE;
}

void on_button275_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  resume_t *resume;
  GtkWidget *win;
  GtkWidget *temp;
  char *text;
  off_t size;
  off_t val1, val2;
  struct stat st;
  int full = 0;

  win = lookup_widget(GTK_WIDGET(button), "resume_options_win");
  resume = gtk_object_get_data(GTK_OBJECT(win), "resume");

  if (!g_list_find(global.incomplete, resume))
  {
    gtk_widget_destroy(win);
    return;
  }

  temp = lookup_widget(win, "checkbutton53");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "entry107");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (resume->dirname)
      l_free(resume->dirname);
    resume->dirname = NULL;
    if (*text)
      resume->dirname = l_strdup(text);
  }
  temp = lookup_widget(win, "checkbutton51");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "entry106");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (resume->search_string)
      l_free(resume->search_string);
    resume->search_string = NULL;
    if (*text)
      resume->search_string = l_strdup(text);
  }
  temp = lookup_widget(win, "checkbutton52");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "spinbutton59");
    val1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    temp = lookup_widget(win, "spinbutton60");
    val2 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    if (stat(resume->filename, &st) >= 0) {
      size = st.st_size - val1 * 1024 - val2;
      if (size <= 0) {
	unlink(resume->filename);
      } else {
	truncate(resume->filename, size);
      }
    }
  }
  temp = lookup_widget(win, "checkbutton61");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    if (resume->user)
      l_free(resume->user);
    resume->user = NULL;
    if (resume->org_file)
      l_free(resume->org_file);
    resume->org_file = NULL;
    full = 1;
  }

  resume_update(resume);
  resume_save();
  gtk_widget_destroy(win);
}


void on_button276_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "resume_options_win");
  gtk_widget_destroy(temp);
}

void on_resume_configure(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *win;
  GtkWidget *temp;
  resume_t *resume;
  int download = 0;
  char *pos;

  resume = (resume_t *) user_data;
  if (!resume)
    return;
  if (resume->socket)
    download = 1;

  win = create_resume_options_win();
  gtk_object_set_data(GTK_OBJECT(win), "resume", resume);
  if (download) {
    temp = lookup_widget(win, "checkbutton52");
    gtk_widget_set_sensitive(temp, FALSE);
  }

  if (resume->dirname) {
    temp = lookup_widget(win, "entry107");
    gtk_entry_set_text(GTK_ENTRY(temp), resume->dirname);
  }

  temp = lookup_widget(win, "entry106");
  if (resume->search_string) {
    gtk_entry_set_text(GTK_ENTRY(temp), resume->search_string);
  } else {
    pos = extract_filename(resume->filename);
    gtk_entry_set_text(GTK_ENTRY(temp), get_search_string(pos));
  }

  gtk_widget_show(win);
}


void
on_checkbutton51_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "entry106");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);

}


void
on_checkbutton52_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (gtk_toggle_button_get_active(togglebutton)) {
    temp = lookup_widget(GTK_WIDGET(togglebutton), "spinbutton59");
    gtk_widget_set_sensitive(temp, TRUE);
    temp = lookup_widget(GTK_WIDGET(togglebutton), "spinbutton60");
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    temp = lookup_widget(GTK_WIDGET(togglebutton), "spinbutton59");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(GTK_WIDGET(togglebutton), "spinbutton60");
    gtk_widget_set_sensitive(temp, FALSE);
  }
}


void
on_checkbutton53_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "entry107");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);

}

void on_combo_entry13_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  temp = lookup_widget(GTK_WIDGET(editable), "button107");
  if (!l_strcasecmp(text, "transfer_running") ||
      !l_strcasecmp(text, "transfer_waiting") ||
      !l_strcasecmp(text, "transfer_bar1") ||
      !l_strcasecmp(text, "transfer_bar2") ||
      !l_strcasecmp(text, "library_unshared")) {
    gtk_widget_set_sensitive(temp, FALSE);
  } else {
    gtk_widget_set_sensitive(temp, TRUE);
  }
}


void on_entry80_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkCList *clist;
  int row;
  char *suff;
  char *text;
  int mime;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));
  suff = gtk_entry_get_text(GTK_ENTRY(editable));
  for (row = 0; row < clist->rows; row++) {
    gtk_clist_get_text(clist, row, 0, &text);
    if (!l_strcasecmp(text, suff))
      break;
  }
  temp = lookup_widget(global.options_win, "button180");
  temp = GTK_BIN(temp)->child;
  if (row == clist->rows) {
    gtk_label_set_text(GTK_LABEL(temp), _("Add Suffix"));
    temp = lookup_widget(global.options_win, "entry82");
    gtk_entry_set_text(GTK_ENTRY(temp), "");
    temp = lookup_widget(global.options_win, "combo_entry20");
    mime = guess_mime(suff);
    if (mime >= 0)
      gtk_entry_set_text(GTK_ENTRY(temp), MimeNames(mime));
    temp = lookup_widget(global.options_win, "checkbutton55");
    if (mime == MIME_MP3)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  } else {
    gtk_label_set_text(GTK_LABEL(temp), _("Update Suffix"));

    gtk_clist_get_text(clist, row, 1, &text);
    temp = lookup_widget(global.options_win, "combo_entry20");
    gtk_entry_set_text(GTK_ENTRY(temp), text);

    gtk_clist_get_text(clist, row, 2, &text);
    temp = lookup_widget(global.options_win, "entry82");
    gtk_entry_set_text(GTK_ENTRY(temp), text);

    gtk_clist_get_text(clist, row, 3, &text);
    temp = lookup_widget(global.options_win, "checkbutton55");
    if (!l_strcasecmp(text, _("Yes")))
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  }
}

void on_combo_entry20_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  temp = lookup_widget(global.options_win, "checkbutton55");
  if (!l_strcasecmp(_("mp3"), text)) {
    gtk_widget_set_sensitive(temp, FALSE);
  } else {
    gtk_widget_set_sensitive(temp, TRUE);
  }
}


gboolean
on_drawingarea10_expose_event(GtkWidget * widget,
			      GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int width, height;

  width = widget->allocation.width;
  height = widget->allocation.height;
  gdk_draw_rectangle(widget->window, widget->style->black_gc, TRUE,
		     0, 0, width, height);

  return FALSE;
}


gboolean
on_lib_tree_motion_notify_event(GtkWidget * widget,
				GdkEventMotion * event, gpointer user_data ATTR_UNUSED)
{
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  file_t *file;



  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column)) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }

  if (column != 1) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }

  gtk_clist_get_pixtext(GTK_CLIST(widget), row, 0,
			&text, &space, &pixmap, &bitmap);

  if (row < 0) return FALSE;

  if (pixmap) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }
  file = (file_t *) gtk_clist_get_row_data(GTK_CLIST(widget), row);

  if (row >= 0) filetips_show(widget, row, column, file);
  return FALSE;
}

gboolean
on_search_motion_notify_event(GtkWidget * widget,
			      GdkEventMotion * event, gpointer user_data ATTR_UNUSED)
{
  int row, column;
  file_t *file;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column)) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }

  if (column != 1) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }

  if (row < 0) return FALSE;

  file = (file_t *) gtk_clist_get_row_data(GTK_CLIST(widget), row);
  if (!file)
    return FALSE;

  filetips_show(widget, row, column, file);
  return FALSE;
}

gboolean
on_browse_motion_notify_event(GtkWidget * widget,
			      GdkEventMotion * event, gpointer user_data ATTR_UNUSED)
{
  int row, column;
  file_t *file;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column)) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }

  if (column != 1) {
    filetips_show(NULL, -1, -1, NULL);
    return FALSE;
  }

  if (row < 0) return FALSE;

  file = (file_t *) gtk_clist_get_row_data(GTK_CLIST(widget), row);
  if (!file)
    return FALSE;

  filetips_show(widget, row, column, file);
  return FALSE;
}


gboolean
on_list_leave_notify_event(GtkWidget * widget ATTR_UNUSED,
			   GdkEventCrossing * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  filetips_show(NULL, -1, -1, NULL);
  return FALSE;
}


void on_remove_all_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  send_command(CMD_CLIENT_UNSHARE_ALL, "");
  lib_del_flag(FLAG_SHARED, NULL);
  lib_del_flag(FLAG_TO_SHARE, NULL);
  lib_set_flag(FLAG_TO_REMOVE, NULL);
  global.user.unshared = global.user.shared;
  lib_apply();
}


void on_unshare_all_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  send_command(CMD_CLIENT_UNSHARE_ALL, "");
  lib_del_flag(FLAG_SHARED, NULL);
  lib_del_flag(FLAG_TO_SHARE, NULL);
  global.user.unshared = global.user.shared;
  lib_apply_node(NULL);
}


void on_share_all_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  lib_xor_flag(FLAG_SHARED, FLAG_TO_SHARE, NULL);
  lib_apply_node(NULL);
}


void on_spinbutton61_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp1;
  GtkWidget *temp2;
  GtkWidget *temp3;

  temp1 = lookup_widget(global.win, "spinbutton61");
  temp2 = lookup_widget(global.win, "spinbutton62");
  temp3 = lookup_widget(global.win, "checkbutton64");
  global.options.access_timeout =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp1)) * 24 +
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp2));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp3))) {
    if (global.options.access_timeout < 0)
      global.options.access_timeout = -global.options.access_timeout;
  } else {
    if (global.options.access_timeout > 0)
      global.options.access_timeout = -global.options.access_timeout;
  }
}

void
on_checkbutton63_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton))
    global.options.access_save = 0;
  else
    global.options.access_save = 1;
}


void
on_checkbutton64_toggled(GtkToggleButton * togglebutton ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp1;
  GtkWidget *temp2;
  GtkWidget *temp3;

  temp1 = lookup_widget(global.win, "spinbutton61");
  temp2 = lookup_widget(global.win, "spinbutton62");
  temp3 = lookup_widget(global.win, "checkbutton64");
  global.options.access_timeout =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp1)) * 24 +
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp2));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp3))) {
    if (global.options.access_timeout < 0)
      global.options.access_timeout = -global.options.access_timeout;
  } else {
    if (global.options.access_timeout > 0)
      global.options.access_timeout = -global.options.access_timeout;
  }
}


void on_spinbutton62_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp1;
  GtkWidget *temp2;
  GtkWidget *temp3;

  temp1 = lookup_widget(global.win, "spinbutton61");
  temp2 = lookup_widget(global.win, "spinbutton62");
  temp3 = lookup_widget(global.win, "checkbutton64");
  global.options.access_timeout =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp1)) * 24 +
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp2));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp3))) {
    if (global.options.access_timeout < 0)
      global.options.access_timeout = -global.options.access_timeout;
  } else {
    if (global.options.access_timeout > 0)
      global.options.access_timeout = -global.options.access_timeout;
  }
}

gboolean
on_ctree3_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;

    global.popup_row = row;
    global.popup_list = widget;

    if (row != -1) {
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
      pop = create_access_popup();
      if (pop) {
	gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		       event->button, event->time);
      }
    }
  }

  return FALSE;
}

gboolean
on_drawingarea7_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_bars(&global.statistic, 1);
  return FALSE;
}


gboolean
on_drawingarea8_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_bars(&global.statistic, 1);

  return FALSE;
}


gboolean
on_drawingarea9_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_bars(&global.statistic, 1);

  return FALSE;
}

gboolean
on_drawingarea5_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_bars(&global.statistic, 0);

  return FALSE;
}


gboolean
on_drawingarea6_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_bars(&global.statistic, 0);

  return FALSE;
}


void on_latest_version_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  latest_version_get(1);
}


void on_button308_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  global.options.time_display++;
  if (global.options.time_display > 3) {
    global.options.time_display = 0;
  }
  print_topright_corner();

  gtk_widget_queue_resize(GTK_WIDGET(button));
}


void on_button309_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t* resume;

  // remove queued downloads

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree4"));
  gtk_clist_freeze(GTK_CLIST(ctree));

  node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);
  
  while (node) {
    resume = gtk_ctree_node_get_row_data(ctree, node);
    node = GTK_CTREE_ROW (node)->sibling;
    if (resume && (resume->status != R_FINISHED) &&
	!resume->socket && (resume_has_potentials(resume) & 5)) {
      resume_cancel(resume);
      resume_show(resume, 2);
    }
  }
  gtk_clist_thaw(GTK_CLIST(ctree));
}


void on_button310_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  int i1;
  GList *s = NULL;
  GList *dlist;
  socket_t *socket;
  transfer_t *transfer;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  gtk_clist_freeze(clist);
  for (i1 = 0; i1 < clist->rows; i1++) {
    socket = gtk_clist_get_row_data(clist, i1);
    if (!socket) continue;
    transfer = socket->data;
    if (!transfer) continue;
    if (transfer->status != S_QUEUED)
      continue;
    s = g_list_append(s, socket);
  }

  for (dlist = s; dlist; dlist = dlist->next) {
    socket = (socket_t *) (dlist->data);
    socket_end(socket, &(SocketStatus[S_DELETE]));
  }
  g_list_free(s);
  gtk_clist_thaw(clist);
}

void on_ok1_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *temp;
  char *filename;

  temp = GTK_WIDGET(user_data);
  if (!temp)
    return;

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(temp));
  if (filename && (*filename))
    resume_load(filename, 1);
  gtk_widget_destroy(temp);
}

void on_cancel1_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(user_data);
  if (temp)
    gtk_widget_destroy(temp);
}

void on_button311_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *filesel;
  GtkWidget *temp;

  filesel = gtk_file_selection_new(_("Import incomplete list"));
  gtk_widget_show(filesel);

  temp = GTK_FILE_SELECTION(filesel)->ok_button;
  if (temp)
    gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		       GTK_SIGNAL_FUNC(on_ok1_clicked), filesel);
  temp = GTK_FILE_SELECTION(filesel)->cancel_button;
  if (temp)
    gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		       GTK_SIGNAL_FUNC(on_cancel1_clicked), filesel);
}


void on_button312_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  int value;
  GtkWidget *pop;

  value = (int) gtk_object_get_data(GTK_OBJECT(button), "value");

  pop = create_pipe_popup(value);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}

void on_button313_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkNotebook *notebook;
  GtkWidget *current;
  int no;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  current = notebook->cur_page->child;
  no = gtk_notebook_page_num(notebook, current);
  if (no > 0)
    gtk_notebook_reorder_child(notebook, current, no - 1);
}


void on_button314_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkNotebook *notebook;
  GtkWidget *current;
  int no;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  current = notebook->cur_page->child;
  no = gtk_notebook_page_num(notebook, current);
  if (no < (int)g_list_length(notebook->children) - 1)
    gtk_notebook_reorder_child(notebook, current, no + 1);
}


void
on_checkbutton67_toggled(GtkToggleButton * togglebutton ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "spinbutton57");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);
}

void on_user_list_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.string_win);
  gtk_widget_destroy(global.string_win);
  global.string_win = NULL;
}

void on_button315_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.string_win);
}


gboolean
on_string_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data)
{
  int slist = (int) user_data;
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  if (row < 0)
    return FALSE;

  global.popup_row = row;
  global.popup_list = widget;

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_string_list_popup(slist);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

void
on_string_list_entry_activate(GtkEditable * editable, gpointer user_data)
{
  char *text;
  int slist = (int) user_data;
  char *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!text)
    return;
  temp = l_strdup(text);
  text = arg(temp, 0);
  while (text) {
    string_list_add(slist, text);
    text = arg(NULL, 0);
  }
  l_free(temp);
  gtk_entry_set_text(GTK_ENTRY(editable), "");
}

void on_user_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkEntry *entry;
  int i1;
  GList *dlist;
  int row;

  if (global.string_win) {
    if (global.string_win->window)
      gdk_window_raise(global.string_win->window);
    gtk_widget_show(global.string_win);
    return;
  }

  global.string_win = create_string_list_win();
  gtk_widget_show(global.string_win);

  // now insert list items and adding signal handler
  for (i1 = 0; i1 < STRING_LIST_NO; i1++) {
    clist = string_list_get_clist(i1);
    for (dlist = global.string_list[i1]; dlist; dlist = dlist->next) {
      strcpy(tstr[0], (char *) (dlist->data));
      row = gtk_clist_append(clist, list);
      gtk_clist_set_row_data(clist, row, dlist->data);
    }
    gtk_signal_connect(GTK_OBJECT(clist), "button_press_event",
		       GTK_SIGNAL_FUNC(on_string_list_button_press_event),
		       (gpointer) i1);
    entry = string_list_get_entry(i1);
    gtk_signal_connect(GTK_OBJECT(entry), "activate",
		       GTK_SIGNAL_FUNC(on_string_list_entry_activate),
		       (gpointer) i1);
  }
}

void
on_add_to_autojoin_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  char *text;

  if (global.popup_row == -1)
    return;

  clist = GTK_CLIST(global.popup_list);
  gtk_clist_get_text(clist, global.popup_row, 0, &text);
  autojoin_add(text);
}


void
on_checkbutton18_toggled(GtkToggleButton * togglebutton ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  user_t *userinfo;
  GList *dlist;
  file_t *file;
  GtkCTree *ctree;
  GtkNotebook *notebook;
  GtkObject *temp;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook6"));
  if (!notebook->cur_page)
    return;
  temp = GTK_OBJECT(notebook->cur_page->child);
  if (!temp)
    return;
  ctree = GTK_CTREE(gtk_object_get_data(temp, "tree"));

  userinfo = (user_t *) gtk_object_get_data(GTK_OBJECT(ctree), "userinfo");
  if (!userinfo || (userinfo->link != (void *) ctree))
    return;

  gtk_clist_clear(GTK_CLIST(ctree));
  gtk_clist_freeze(GTK_CLIST(ctree));
  for (dlist = userinfo->files; dlist; dlist = dlist->next) {
    file = (file_t *) (dlist->data);
    browse_insert_file_real(file, ctree);
  }
  gtk_clist_thaw(GTK_CLIST(ctree));
  gtk_ctree_sort_recursive(ctree, NULL);
}


void on_button316_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  pop = create_advanced_popup(global.options.advanced_upload);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}

gboolean
on_ctree4_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    /// missing
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_download_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


gboolean
on_server_ctree_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_connect3_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_napigator_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

void
on_checkbutton35_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton))
    global.options.auto_resume = 1;
  else
    global.options.auto_resume = 0;

  setup_preferences(P_AUTORESUME);
}

gboolean
on_ctree5_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    /// missing
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_download_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


void
on_button317_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  int value;
  GtkWidget *pop;

  value = (int) gtk_object_get_data(GTK_OBJECT(button), "value");

  pop = create_pipe2_popup(value);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}

void
on_enter_bandwidth1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user) create_bandwidth_win(user, 1);
}

void
on_enter_bandwidth2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *user;
  int mode = (int) user_data;

  user = get_popup_user(mode);
  if (user) create_bandwidth_win(user, 0);
}

void
on_download_man_activate               (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  create_bandman_win(1);
}


void
on_upload_man_activate                 (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  create_bandman_win(0);
}


void
on_button318_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkObject* win;
  GtkAdjustment* adj;
  GtkToggleButton* temp;

  if (!user_data) return;
  win = user_data;

  adj = gtk_object_get_data(win, "adj1");
  if (adj) {
    global.options.resume_abort[0] = (int)(adj->value*100);
  }
  temp = gtk_object_get_data(win, "check");
  if (temp && gtk_toggle_button_get_active(temp)) {
    global.options.resume_abort[1] = 1;
  } else {
    global.options.resume_abort[1] = 0;
  }

  adj = gtk_object_get_data(win, "adj2");
  if (adj) {
    global.options.resume_abort[2] = (int)(adj->value);
  }
  adj = gtk_object_get_data(win, "adj3");
  if (adj) {
    global.options.resume_abort[3] = (int)(adj->value);
  }
  on_button319_clicked(button, user_data);

  {
    GtkCTree* ctree;
    GtkCTreeNode* node;
    resume_t *resume;
    
    ctree = GTK_CTREE(lookup_widget(global.win, "ctree5"));
    gtk_clist_freeze(GTK_CLIST(ctree));
    node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);
    while (node) {
      resume = (resume_t *) gtk_ctree_node_get_row_data(ctree, node);
      node = GTK_CTREE_ROW (node)->sibling;
      resume_update_resume2(resume);
    }
    gtk_clist_thaw(GTK_CLIST(ctree));
  }
}


void
on_button319_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data)
{
  if (user_data)
    gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_button320_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkNotebook* note;

  note = GTK_NOTEBOOK(lookup_widget(global.win, "notebook9"));
  gtk_notebook_set_page(note, 1);
}


void
on_button321_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkNotebook* note;

  note = GTK_NOTEBOOK(lookup_widget(global.win, "notebook9"));
  gtk_notebook_set_page(note, 0);
}


void
on_ctree4_tree_select_row              (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  socket_t *socket;
  transfer_t* transfer;
  resume_t *resume;

  if (GTK_CTREE_ROW(node)->parent != NULL) {
    socket = gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node));
  } else {
    resume = gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node));
    socket = resume->socket;
  }
  if (!socket) return;
  transfer = socket->data;
  if (!transfer) return;

  user_info_show(transfer->user_info, 1, 0);
}


gboolean
on_drawingarea12_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 1, 0);
  return FALSE;
}


gboolean
on_drawingarea12_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int height = widget->allocation.height-1;
  int x = (int) event->x;
  int y = (int) event->y;
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;

  userinfo->limit[0] = (int) ((double) global.down_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 1, 1);
  
  return FALSE;
}


gboolean
on_drawingarea12_leave_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 1, 0);

  return FALSE;
}


gboolean
on_drawingarea12_enter_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 1, 1);

  return FALSE;
}

gboolean
on_drawingarea12_motion_notify_event   (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 1;
  int x = (int) event->x;
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;

  userinfo->limit[0] = (int) ((double) global.down_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 1, 1);

  return FALSE;
}

gboolean
on_drawingarea11_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 0, 0);
  return FALSE;

  return FALSE;
}


gboolean
on_drawingarea11_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int height = widget->allocation.height-1;
  int x = (int) event->x;
  int y = (int) event->y;
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;

  userinfo->limit[1] = (int) ((double) global.up_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 0, 1);
  
  return FALSE;
}


gboolean
on_drawingarea11_enter_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 0, 1);

  return FALSE;
}


gboolean
on_drawingarea11_motion_notify_event   (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 1;
  int x = (int) event->x;
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0)
    return FALSE;
  if (x > width)
    return FALSE;

  userinfo->limit[1] = (int) ((double) global.up_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 0, 1);

  return FALSE;
}

gboolean
on_drawingarea11_leave_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 0, 0);

  return FALSE;
}

void
on_button322_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* win;

  win = create_abort_win();
  gtk_widget_show(win);
}


void
on_queue_win_destroy                   (GtkObject       *object,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* win = GTK_WIDGET(object);

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
  global.queue_win = NULL;
}


void
on_button323_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;
  file_t* file;

  ctree = GTK_CTREE(lookup_widget(global.queue_win, "ctree6"));
  node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);

  while (node) {
    file = gtk_ctree_node_get_row_data(ctree, node);
    if (file)
      download_file_without_check(file, file->flags);
    node = GTK_CTREE_ROW (node)->sibling;
  }
  on_button324_clicked(button, user_data);
}


void
on_button325_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;
  file_t* file;
  GList* row_list;

  ctree = GTK_CTREE(lookup_widget(global.queue_win, "ctree6"));
  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    file = gtk_ctree_node_get_row_data(ctree, node);
    if (file)
      download_file_without_check(file, file->flags);
    row_list = row_list->next;
  }
  on_button324_clicked(button, user_data);
}

void
on_button324_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCTree* ctree;

  if (!global.queue_win) return;

  ctree = GTK_CTREE(lookup_widget(global.queue_win, "ctree6"));
  gtk_clist_clear(GTK_CLIST(ctree));
  gtk_widget_hide(global.queue_win);
}


void
on_checkbutton19_toggled               (GtkToggleButton *togglebutton ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  lib_show();
}

void
on_checkbutton70_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton))
    global.options.autoresume_download = 0;
  else
    global.options.autoresume_download = 1;
}


void
on_button326_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(GTK_WIDGET(button), "entry122");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 0);
  temp = lookup_widget(GTK_WIDGET(button), "entry123");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 1);
  temp = lookup_widget(GTK_WIDGET(button), "entry124");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 2);
  temp = lookup_widget(GTK_WIDGET(button), "entry125");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 3);

  on_button327_clicked(button, user_data);
}


void
on_button327_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "prefix_win");
  if (temp) gtk_widget_destroy(temp);
}

void
on_clist34_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column ATTR_UNUSED,
                                        GdkEvent        *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  search_pattern_t* pattern;

  pattern = gtk_clist_get_row_data(clist, row);
  if (pattern) search_pattern_show(pattern);
}


gboolean
on_clist34_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  search_pattern_t *pattern;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if (row >= 0)
    pattern = gtk_clist_get_row_data(GTK_CLIST(widget), row);
  else pattern = NULL;
  if (!pattern) return FALSE;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    search_pattern_search(pattern);
    return TRUE;
  }

  if (event->button == global.options.popup_create) {
    if (row >= 0) gtk_clist_select_row(GTK_CLIST(widget), row, 0);

    pop = create_search_pattern_popup(pattern);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
    return TRUE;
  }

  /*
  if ((event->button == 1) && (row >= 0) && (column == 0)) {
    clist_row = g_list_nth(GTK_CLIST(widget)->row_list, row)->data;
    if (clist_row->state == GTK_STATE_SELECTED) {
      search_pattern_rename(pattern);
      return TRUE;
    }
  }
  */
  return FALSE;
}


gboolean
on_clist34_key_press_event             (GtkWidget       *widget ATTR_UNUSED,
                                        GdkEventKey     *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  return FALSE;
}

void
on_button328_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  send_search_request(FALSE);
}


void
on_button329_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  search_pattern_show(NULL);
}


void
on_button330_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_button331_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_button332_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  char* data = NULL;

  if (global.ban_win) {
    data = gtk_object_get_data(GTK_OBJECT(global.ban_win), "channel");
  }
  show_bans(data);
}

void
on_mime_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkObject *ctree;
  user_t* user;

  ctree = GTK_OBJECT(global.popup_list);
  user = (user_t *) gtk_object_get_data(ctree, "userinfo");
  browse_show(user, (int)user_data);
}

void on_button_files_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *popup;
  GtkWidget *item;
  user_t* user;
  int i1;
  char str[1024];
  char str2[1024];
  GtkObject *ctree;
  int cnt = 0;

  ctree = GTK_OBJECT(user_data);
  global.popup_list = GTK_WIDGET(ctree);

  user = (user_t *) gtk_object_get_data(ctree, "userinfo");
  if (!user || user->shared == 0) return;

  popup = gtk_menu_new();
  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (user->filecount_info[i1] == 0) continue;

    print_size(str2, user->filesize_info[i1]);
    sprintf(str, "%s: %d (%.1f%%) %s (%.1f%%)", 
	    MimeNames(i1),  user->filecount_info[i1],
	    (double)(user->filecount_info[i1])/(double)(user->shared)*100.,
	    str2, user->filesize_info[i1]/user->bytes*100.);

    item = gtk_menu_item_new_with_label(str);
    gtk_widget_show(item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_mime_activate),
		       (void *) i1);
    gtk_container_add(GTK_CONTAINER(popup), item);
    cnt++;
  }
  if (cnt > 1) {
    item = gtk_menu_item_new_with_label("Show all");
    gtk_widget_show(item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_mime_activate),
		       (void *) MIME_SIZE);
    gtk_container_add(GTK_CONTAINER(popup), item);
  }
  
  gtk_menu_popup(GTK_MENU(popup), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
  
}
void
on_button334_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *widget;

  win = lookup_widget(GTK_WIDGET(button), "priority_win");
  widget = lookup_widget(win, "spinbutton63");
  global.options.upload_priority[PRI_FRIEND] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton64");
  global.options.upload_priority[PRI_DOWNLOAD] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton65");
  global.options.upload_priority[PRI_SHARE] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton66");
  global.options.upload_priority[PRI_NONE] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_button335_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "priority_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


static void
drag_source_info_destroy (gpointer data)
{
  GtkCListCellInfo *info = data;

  g_free (info);
}

void
on_lib_tree_drag_begin                 (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkCListCellInfo *info;
  
  clist = GTK_CLIST (widget);

  info = g_dataset_get_data (drag_context, "lib-drag-source");
  if (!info) {
    info = g_new (GtkCListCellInfo, 1);
    
    if (clist->click_cell.row < 0)
      clist->click_cell.row = 0;
    else if (clist->click_cell.row >= clist->rows)
      clist->click_cell.row = clist->rows - 1;
    info->row = clist->click_cell.row;
    info->column = clist->click_cell.column;
    
    g_dataset_set_data_full (drag_context, "lib-drag-source",
			     info, drag_source_info_destroy);
  }

}

void
on_show_subscriptions_activate         (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GList* dlist;
  subscription_t* sub;
  GtkWidget* temp;

  if (global.subscription_win) {
    if (global.subscription_win->window)
      gdk_window_raise(global.subscription_win->window);
    gtk_widget_show(global.subscription_win);
    return;
  }

  global.subscription_win = create_subscription_win();
  gtk_widget_show(global.subscription_win);

  temp = lookup_widget(global.subscription_win, "ctree7");
  gtk_drag_dest_set(temp, GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
		    lib_target_table, 1, GDK_ACTION_COPY);

  for (dlist = global.subscriptions; dlist; dlist = dlist->next) {
    sub = dlist->data;
    subscription_user_add_ctree(sub);
  }
}


void
on_subscription_win_destroy            (GtkObject       *object ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  global.subscription_win = NULL;
  return;
}


gboolean
on_ctree7_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  if (row == -1) return FALSE;

  global.popup_row = row;
  global.popup_list = widget;

  gtk_clist_get_pixtext(GTK_CLIST(widget), row, 0,
			&text, &space, &pixmap, &bitmap);
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_subscription_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


#define ROW_FROM_YPIXEL(clist, y)  (((y) - (clist)->voffset) / \
                                    ((clist)->row_height + 1))

int drag_dest_row (GtkCList         *clist,
		   gint              y)
{
  GtkWidget *widget;
  int row;

  widget = GTK_WIDGET (clist);

  y -= (GTK_CONTAINER (clist)->border_width +
        widget->style->klass->ythickness +
        clist->column_title_area.height);

  row = ROW_FROM_YPIXEL (clist, y);
  if (row >= clist->rows) row = clist->rows - 1;
  if (row < -1) row = -1;
  return row;
}

void
on_ctree7_drag_data_received           (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x ATTR_UNUSED,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info ATTR_UNUSED,
                                        guint            time ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCListCellInfo *source_info;
  GtkCTree* ctree;
  GtkCTreeNode* node;
  GtkCTreeNode* node2;
  file_t* file;
  char* folder;
  subscription_t* sub;
  GtkCList* clist = GTK_CLIST(widget);
  int row;

  source_info = (GtkCListCellInfo *)(data->data);
  if (!source_info) return;
  
  row = drag_dest_row (clist, y);

  ctree = GTK_CTREE(gtk_drag_get_source_widget (drag_context));
  if (!ctree) return;
  node = gtk_ctree_node_nth(ctree, source_info->row);
  if (!node) return;

  node2 = gtk_ctree_node_nth(GTK_CTREE(clist), row);
  while (GTK_CTREE_ROW(node2)->parent)
    node2 = GTK_CTREE_ROW(node2)->parent;

  sub = gtk_ctree_node_get_row_data(GTK_CTREE(clist), node2);
  if (GTK_CTREE_ROW(node)->is_leaf) {
    file = gtk_ctree_node_get_row_data(ctree, node);
    subscription_file_add(sub, file->longname);
  } else {
    folder = gtk_ctree_node_get_row_data(ctree, node);
    subscription_folder_add(sub, ctree, node);
  }
}

void
on_button336_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  if (global.subscription_win) gtk_widget_hide(global.subscription_win);

  return;
}


void
on_lib_tree_drag_data_get              (GtkWidget       *widget ATTR_UNUSED,
                                        GdkDragContext  *drag_context,
                                        GtkSelectionData *data,
                                        guint            info ATTR_UNUSED,
                                        guint            time ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCListCellInfo *info1;
  
  info1 = g_dataset_get_data (drag_context, "lib-drag-source");
  
  if (info1) {
    GtkCListCellInfo ret_info;
    
    ret_info.row = info1->row;
    ret_info.column = info1->column;
    
    gtk_selection_data_set (data, data->target,
			    GTK_TYPE_POINTER, (guchar *) &ret_info,
			    sizeof (GtkCListCellInfo));
  } else
    gtk_selection_data_set (data, data->target,
			    GTK_TYPE_POINTER, NULL, 0);
  return;
}


void
on_entry131_activate                   (GtkEditable     *editable,
                                        gpointer         user_data ATTR_UNUSED)
{
  char *text;
  char *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!text) return;
  temp = l_strdup(text);
  text = arg(temp, 0);
  while (text) {
    subscription_user_add(text);
    text = arg(NULL, 0);
  }
  l_free(temp);
  gtk_entry_set_text(GTK_ENTRY(editable), "");
}

void on_sub_remove_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *filename = (char*)user_data;
  subscription_t* sub;

  sub = subscription_data_search(filename);
  if (sub) subscription_file_remove(sub, filename);
}

void on_add_subscription_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;
  socket_t *socket;
  transfer_t *transfer;
  subscription_t* sub;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    socket = gtk_clist_get_row_data(clist, row);
    transfer = socket->data;
    if (!transfer) continue;
    if (transfer->status == S_FINISHED) continue;
    sub = subscription_user_search(transfer->user_info->user);
    if (!sub) sub = subscription_user_add(transfer->user_info->user);
    subscription_file_add(sub, transfer->longname);
  }
}


void
on_button337_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  search_fields_detach2();
}


void
on_button338_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  remove_dead_downloads();
}


void
on_button339_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  remove_dead_uploads();
}

