/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/utsname.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"
#include "log.h"
#include "statistic.h"

#define ACCESS_HASH_LENGTH    16

GtkCTreeNode* access_ctree_insert_access(access_t* parent, access_t * access, int depth);
void access_ctree_mark_access(access_t * access);

int hash_key (char *name) {
  unsigned long h = 0;
  
  if (!name) return 0;

  for (; *name; name++) {
    h = h + tolower (*name);
  }
  return (h%ACCESS_HASH_LENGTH);
}

void statistic_init(statistic_t * stat)
{
  int i1;
  GtkWidget *temp;

  stat->incomplete[0] = .0;
  stat->incomplete[1] = .0;
  stat->download[0] = .0;
  stat->download[1] = .0;
  stat->upload[0] = .0;
  stat->upload[1] = .0;
  stat->total[0] = .0;
  stat->total[1] = .0;
  /*
     stat->size_down[0] = 0;
     stat->size_down[1] = 100;
     stat->download_band = (int*)malloc(stat->size_down[1]*sizezof(int));
     stat->size_up[0] = 0;
     stat->size_up[1] = 100;
     stat->upload_band = (int*)malloc(stat->size_up[1]*siezof(int));
   */
  for (i1 = 0; i1 <= S_NUMBER; i1++) {
    stat->no_download[i1] = 0;
    stat->no_upload[i1] = 0;
  }
  stat->cur_down = 0;
  stat->cur_up = 0;

  temp = lookup_widget(global.win, "drawingarea3");
  i1 = temp->allocation.width;
  stat->download_band = (int *) l_malloc(sizeof(int) * i1);
  stat->band_size[0] = i1;
  stat->band_pos[0] = 0;
  memset(stat->download_band, 0, sizeof(int) * i1);

  temp = lookup_widget(global.win, "drawingarea4");
  i1 = temp->allocation.width;
  stat->upload_band = (int *) l_malloc(sizeof(int) * i1);
  stat->band_size[1] = i1;
  stat->band_pos[1] = 0;
  memset(stat->upload_band, 0, sizeof(int) * i1);
  //  printf("size %d %d\n", stat->band_size[0], stat->band_size[1]);

  access_load();
#ifdef TRAFFIC_DEBUG
  for (i1 = 0; i1 < 10302 + 1; i1++) {
    stat->traffic[0][i1].cnt = 0;
    stat->traffic[0][i1].bytes = 0;
    stat->traffic[1][i1].cnt = 0;
    stat->traffic[1][i1].bytes = 0;
  }
#endif
}

void statistic_update(statistic_t * stat)
{
  GList *dlist;
  resume_t *resume;
  socket_t *socket;
  transfer_t *transfer;

  // calcing incomplete
  stat->incomplete[0] = .0;
  stat->incomplete[1] = .0;
  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume = (resume_t *) (dlist->data);
    if (resume->local_size > 0)
      stat->incomplete[0] += resume->local_size;
    stat->incomplete[1] += resume->size;
  }

  stat->download[0] = .0;
  stat->download[1] = .0;
  stat->upload[0] = .0;
  stat->upload[1] = .0;
  for (dlist = global.sockets; dlist; dlist = dlist->next) {
    socket = (socket_t *) (dlist->data);
    if (!socket)
      continue;
    if (socket->type != S_TRANSFER)
      continue;
    transfer = (transfer_t *) (socket->data);
    if (!transfer)
      continue;
    if ((transfer->status != S_DOWNLOADING) &&
	(transfer->status != S_UPLOADING))
      continue;
    if (transfer->type == T_DOWNLOAD) {
      stat->download[0] += transfer->progress;
      stat->download[1] += transfer->size;
    } else if (transfer->type == T_UPLOAD) {
      stat->upload[0] += transfer->progress;
      stat->upload[1] += transfer->size;
    }
  }

  // calcing download and upload
  stat->download_band[stat->band_pos[0]] = global.down_width.bytes;
  stat->band_pos[0]++;
  if (stat->band_pos[0] >= stat->band_size[0])
    stat->band_pos[0] = 0;

  stat->upload_band[stat->band_pos[1]] = global.up_width.bytes;
  stat->band_pos[1]++;
  if (stat->band_pos[1] >= stat->band_size[1])
    stat->band_pos[1] = 0;

}

void statistic_draw_bars(statistic_t * stat, int full)
{
  GtkWidget *temp;
  int width, height;
  int posx, posy;
  char str[1024];
  char str2[1024];
  GdkColor colors[S_NUMBER] = {
    {0, 0x0000, 0x0000, 0x0000},	// 0
    {0, 0x0000, 0x0000, 0x0000},
    {0, 0x0000, 0x0000, 0x0000},
    {0, 0xbbbb, 0xbbbb, 0xffee},
    {0, 0x9999, 0x9999, 0xffee},	// 4
    {0, 0x9999, 0x9999, 0xffee},
    {0, 0xbbbb, 0x6666, 0x4444},
    {0, 0xbbbb, 0x4444, 0x6666},
    {0, 0xbbbb, 0x6666, 0x6666},	// 8
    {0, 0xbbbb, 0x4444, 0x4444},
    {0, 0x0000, 0x0000, 0x0000},
    {0, 0x0000, 0x0000, 0x0000},
    {0, 0x0000, 0x0000, 0x0000},	// 12
    {0, 0x0000, 0x0000, 0x0000},
    {0, 0xbbbb, 0x6666, 0x8888},
    {0, 0xbbbb, 0x8888, 0x8888},
    {0, 0x0000, 0x0000, 0x0000},	// 16
    {0, 0xbbbb, 0x9999, 0x8888},
    {0, 0xbbbb, 0x8888, 0x9999},
    {0, 0xbbbb, 0xaaaa, 0x9999},
    {0, 0xbbbb, 0xaaaa, 0xaaaa},	// 20
    {0, 0xbbbb, 0xBBBB, 0xbbbb}
  };
  static GdkGC *gc = NULL;
  int number, i1;
  int old_x = 0;
  int new_x = 0;

  temp = lookup_widget(global.win, "drawingarea5");
  if (!temp->window)
    return;
  temp = lookup_widget(global.win, "drawingarea6");
  if (!temp->window)
    return;
  temp = lookup_widget(global.win, "drawingarea7");
  if (!temp->window)
    return;
  temp = lookup_widget(global.win, "drawingarea8");
  if (!temp->window)
    return;
  temp = lookup_widget(global.win, "drawingarea9");
  if (!temp->window)
    return;


  temp = lookup_widget(global.win, "drawingarea7");
  width = temp->allocation.width;
  height = temp->allocation.height;
  if (full) {
    gtk_paint_box(temp->style, temp->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_IN,
		  NULL, temp, "trough", 0, 0, width, height);
    gtk_paint_flat_box(temp->style, temp->window,
		       GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		       NULL, temp, "entry_bg",
		       2, 2, width - 4, height - 4);
  }
  if (stat->incomplete[1] > 0) {
    posx = (width - 4) * stat->incomplete[0] / stat->incomplete[1];
    if (posx > 0)
      gtk_paint_box(temp->style, temp->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, temp, "bar", 2, 2, posx, height - 4);
    if (posx < width - 4)
      gtk_paint_flat_box(temp->style, temp->window,
			 GTK_STATE_NORMAL, GTK_SHADOW_NONE,
			 NULL, temp, "entry_bg",
			 posx + 2, 2, width - posx - 4, height - 4);
    print_size(str2, stat->incomplete[1]);
    sprintf(str, _("%.1f%% of %s"),
	    stat->incomplete[0] / stat->incomplete[1] * 100, str2);
    if (posx + 20 + gdk_string_width(temp->style->font, str) > width) {
      posx -= (10 + gdk_string_width(temp->style->font, str));
    } else {
      posx += 10;
    }
    posy = (height + gdk_string_height(temp->style->font, str)) / 2;
    //    posy = (height + temp->style->font->ascent)/2;
    gtk_paint_string(temp->style, temp->window,
		     GTK_STATE_PRELIGHT, NULL, temp, "label",
		     posx, posy, str);
  }

  temp = lookup_widget(global.win, "drawingarea8");
  width = temp->allocation.width;
  height = temp->allocation.height;
  if (full) {
    gtk_paint_box(temp->style, temp->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_IN,
		  NULL, temp, "trough", 0, 0, width, height);
    gtk_paint_flat_box(temp->style, temp->window,
		       GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		       NULL, temp, "entry_bg",
		       2, 2, width - 4, height - 4);
  }
  if (stat->download[1] > 0) {
    posx = width * stat->download[0] / stat->download[1];
    if (posx > 0)
      gtk_paint_box(temp->style, temp->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, temp, "bar", 2, 2, posx, height - 4);
    if (posx < width - 4)
      gtk_paint_flat_box(temp->style, temp->window,
			 GTK_STATE_NORMAL, GTK_SHADOW_NONE,
			 NULL, temp, "entry_bg",
			 posx + 2, 2, width - posx - 4, height - 4);
    print_size(str2, stat->download[1]);
    sprintf(str, _("%.1f%% of %s"),
	    stat->download[0] / stat->download[1] * 100, str2);
    if (posx + 20 + gdk_string_width(temp->style->font, str) > width) {
      posx -= (10 + gdk_string_width(temp->style->font, str));
    } else {
      posx += 10;
    }
    posy = (height + gdk_string_height(temp->style->font, str)) / 2;
    gtk_paint_string(temp->style, temp->window,
		     GTK_STATE_PRELIGHT, NULL, temp, "label",
		     posx, posy, str);
  }

  temp = lookup_widget(global.win, "drawingarea9");
  width = temp->allocation.width;
  height = temp->allocation.height;
  if (full) {
    gtk_paint_box(temp->style, temp->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_IN,
		  NULL, temp, "trough", 0, 0, width, height);
    gtk_paint_flat_box(temp->style, temp->window,
		       GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		       NULL, temp, "entry_bg",
		       2, 2, width - 4, height - 4);
  }
  if (stat->upload[1] > 0) {
    posx = width * stat->upload[0] / stat->upload[1];
    if (posx > 0)
      gtk_paint_box(temp->style, temp->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, temp, "bar", 2, 2, posx, height - 4);
    if (posx < width - 4)
      gtk_paint_flat_box(temp->style, temp->window,
			 GTK_STATE_NORMAL, GTK_SHADOW_NONE,
			 NULL, temp, "entry_bg",
			 posx + 2, 2, width - posx - 4, height - 4);
    print_size(str2, stat->upload[1]);
    sprintf(str, _("%.1f%% of %s"),
	    stat->upload[0] / stat->upload[1] * 100, str2);
    if (posx + 20 + gdk_string_width(temp->style->font, str) > width) {
      posx -= (10 + gdk_string_width(temp->style->font, str));
    } else {
      posx += 10;
    }
    posy = (height + gdk_string_height(temp->style->font, str)) / 2;
    gtk_paint_string(temp->style, temp->window,
		     GTK_STATE_PRELIGHT, NULL, temp, "label",
		     posx, posy, str);
  }

  for (number = 0; number < S_NUMBER; number++) {
    gdk_color_alloc(gtk_widget_get_colormap(global.win), &colors[number]);
  }

  if (!gc)
    gc = gdk_gc_new(global.win->window);

  temp = lookup_widget(global.win, "drawingarea5");
  width = temp->allocation.width;
  height = temp->allocation.height;

  number = 0;
  old_x = 0;
  if (stat->no_download[S_NUMBER] > 0) {
    gdk_gc_copy(gc, GTK_WIDGET(global.win)->style->black_gc);
    for (i1 = 0; i1 < S_NUMBER; i1++) {
      number += stat->no_download[i1];
      new_x = width * number / stat->no_download[S_NUMBER] - old_x;

      gdk_gc_set_foreground(gc, &colors[i1]);
      gdk_draw_rectangle(temp->window, gc, TRUE, old_x, 0, new_x, height);
      gdk_gc_set_foreground(gc, &colors[0]);
      gdk_draw_line(temp->window, gc, old_x, 0, old_x, height);
      old_x += new_x;
    }
  }

  temp = lookup_widget(global.win, "drawingarea6");
  width = temp->allocation.width;
  height = temp->allocation.height;

  number = 0;
  old_x = 0;
  if (stat->no_upload[S_NUMBER] > 0) {
    gdk_gc_copy(gc, GTK_WIDGET(global.win)->style->black_gc);
    for (i1 = 0; i1 < S_NUMBER; i1++) {
      number += stat->no_upload[i1];
      // draw the background (unfilled progress)
      new_x = width * number / stat->no_upload[S_NUMBER] - old_x;

      gdk_gc_set_foreground(gc, &colors[i1]);
      gdk_draw_rectangle(temp->window, gc, TRUE, old_x, 0, new_x, height);
      gdk_gc_set_foreground(gc, &colors[0]);
      gdk_draw_line(temp->window, gc, old_x, 0, old_x, height);
      old_x += new_x;
    }
  }
}

void statistic_output(statistic_t * stat)
{
  GtkWidget *temp;
  char str[1024];
  char str2[1024];
  char *text;
  time_t tim;

  statistic_draw_bars(stat, 0);

  temp = lookup_widget(global.win, "label792");
  if (stat->cur_down)
    sprintf(str, _("[Downloads] %s: %d - Total: %d"),
	    status_names(stat->cur_down),
	    global.statistic.no_download[stat->cur_down],
	    global.statistic.no_download[S_NUMBER]);
  else
    sprintf(str, _("Total downloads: %d"), stat->no_download[S_NUMBER]);
  gtk_label_set_text(GTK_LABEL(temp), str);

  temp = lookup_widget(global.win, "label793");
  if (stat->cur_up)
    sprintf(str, _("[Uploads] %s: %d - Total: %d"),
	    status_names(stat->cur_up),
	    global.statistic.no_upload[stat->cur_up],
	    global.statistic.no_upload[S_NUMBER]);
  else
    sprintf(str, _("Total uploads: %d"), stat->no_upload[S_NUMBER]);
  gtk_label_set_text(GTK_LABEL(temp), str);

  if (global.current_time <= global.start_time)
    tim = global.start_time + 1;
  else tim = global.current_time;

  temp = lookup_widget(global.win, "label790");
  print_size(str, stat->total[0]);
  print_speed(str2, stat->total[0] / (tim - global.start_time), 1);
  text = l_strdup_printf("%s (%s)", str, str2);
  gtk_label_set_text(GTK_LABEL(temp), text);
  l_free(text);

  temp = lookup_widget(global.win, "label791");
  print_size(str, stat->total[1]);
  print_speed(str2, stat->total[1] / (tim - global.start_time), 1);
  text = l_strdup_printf("%s (%s)", str, str2);
  gtk_label_set_text(GTK_LABEL(temp), text);
  l_free(text);

  statistic_draw_download(stat);
  statistic_draw_upload(stat);

  access_ctree_remove_old();
}

void statistic_draw_download(statistic_t * stat)
{
  int i1, i2, i3, i4, i5;
  int width, height;
  int max = 0;
  GdkColor color = { 0, 0x8888, 0x8888, 0x9999 };
  GdkColor color2 = { 0, 0x0000, 0x0000, 0x0000 };
  GdkColor color3 = { 0, 0xcccc, 0x4444, 0x4444 };
  GdkColor color4 = { 0, 0x0000, 0xcccc, 0x0000 };
  static GdkGC *gc = NULL;
  static GdkGC *gc2 = NULL;
  static GdkGC *gc3 = NULL;
  static GdkGC *gc4 = NULL;
  GtkWidget *temp;
  int pos;
  GdkFont *font;
  char str[1024];
  long bytes;
  long av_bytes;
  int add;
  int theight;
  int old_val[5] = {0, 0, 0, 0, 0};
  
  if (!global.win->window)
    return;

  for (i1 = 0; i1 < stat->band_size[0]; i1++) {
    old_val[i1%5] = stat->download_band[i1];
    i2 = old_val[0] + old_val[1] + old_val[2] + old_val[3] + old_val[4];
    i2 /= 5;
    if (i2 > max) max = i2;
  }
  max = (int) (max * 1.1);
  if (max == 0)
    max = 1;

  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color2);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color3);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color4);
  if (!gc)
    gc = gdk_gc_new(global.win->window);
  if (!gc2)
    gc2 = gdk_gc_new(global.win->window);
  if (!gc3)
    gc3 = gdk_gc_new(global.win->window);
  if (!gc4)
    gc4 = gdk_gc_new(global.win->window);
  gdk_gc_set_foreground(gc, &color);
  gdk_gc_set_foreground(gc2, &color2);
  gdk_gc_set_foreground(gc3, &color3);
  gdk_gc_set_foreground(gc4, &color4);
  font = gdk_font_load
    ("-Adobe-Helvetica-medium-R-Normal--*-100-*-*-*-*-iso8859-*");

  temp = lookup_widget(global.win, "drawingarea3");
  if (!temp->window)
    return;

  width = temp->allocation.width;
  height = temp->allocation.height;
  if (width > stat->band_size[0])
    width = stat->band_size[0];

  i3 = 32;
  while (height * i3 < 25 * max) i3 *= 2;

  bytes = 0;
  pos = stat->band_pos[0]-4;
  if (stat->band_pos[0] >= 1) old_val[0] = stat->download_band[stat->band_pos[0]-1];
  else old_val[0] = stat->download_band[stat->band_size[0]-1];
  if (stat->band_pos[0] >= 2) old_val[1] = stat->download_band[stat->band_pos[0]-2];
  else old_val[1] = stat->download_band[stat->band_size[0]-2];
  if (stat->band_pos[0] >= 3) old_val[2] = stat->download_band[stat->band_pos[0]-3];
  else old_val[2] = stat->download_band[stat->band_size[0]-3];
  if (stat->band_pos[0] >= 4) old_val[3] = stat->download_band[stat->band_pos[0]-4];
  else old_val[3] = stat->download_band[stat->band_size[0]-4];

  for (i1 = width - 1; i1 >= 0; i1--) {
    pos--;
    if (pos < 0) pos += stat->band_size[0];

    i2 = height * (stat->download_band[pos]+old_val[0]+old_val[1]+old_val[2]+old_val[3]) / max / 5;

    gdk_draw_line(temp->window, gc2, i1, 0, i1, height - i2);
    gdk_draw_line(temp->window, gc, i1, height - i2, i1, height - 1);
    if ((width - i1) % 60 == 0) {
      i4 = (width - i1) / 60;
      gdk_draw_line(temp->window, gc3, i1, height - 15, i1, height - 1);
      sprintf(str, "%d min", i4);
      gdk_draw_string(temp->window, font, gc3, i1 + 2, height - 3, str);
      add = i3 / 4;
    } else {
      add = i3;
    }

    i4 = 0;
    while (1) {
      i4 += add;
      i5 = height * i4 / max;
      if (i5 > height)
	break;
      if ((i5 > i2) || (i1 % 8 == 0) || (add != i3))
	gdk_draw_point(temp->window, gc3, i1, height - i5);
    }
    bytes += old_val[0];
    old_val[0] = old_val[1];
    old_val[1] = old_val[2];
    old_val[2] = old_val[3];
    old_val[3] = stat->download_band[pos];

    av_bytes = (long) ((double) bytes / (double) (width - i1));
    i4 = height * av_bytes / max;
    gdk_draw_point(temp->window, gc4, i1, height - i4);
  }

  theight = gdk_string_height(font, "1,23KB");
  i4 = 0;
  while (1) {
    i4 += i3;
    i5 = height * i4 / max;
    if (height - i5 < theight + 5)
      break;
    print_size(str, i4);
    gdk_draw_string(temp->window, font, gc3, 5, height - i5 + theight + 2,
		    str);
  }
  if (height - i5 > 0)
    gdk_draw_string(temp->window, font, gc3, 2, height - i5 + theight + 2,
		    _("Download"));
  else
    gdk_draw_string(temp->window, font, gc3, 2, theight + 2,
		    _("Download"));
}

void statistic_draw_upload(statistic_t * stat)
{
  int i1, i2, i3, i4, i5;
  int width, height;
  int max = 0;
  GdkColor color = { 0, 0x8888, 0x8888, 0x9999 };
  GdkColor color2 = { 0, 0x0000, 0x0000, 0x0000 };
  GdkColor color3 = { 0, 0xcccc, 0x4444, 0x4444 };
  GdkColor color4 = { 0, 0x0000, 0xcccc, 0x0000 };
  static GdkGC *gc = NULL;
  static GdkGC *gc2 = NULL;
  static GdkGC *gc3 = NULL;
  static GdkGC *gc4 = NULL;
  GtkWidget *temp;
  int pos;
  GdkFont *font;
  char str[1024];
  long bytes;
  long av_bytes;
  int add;
  int theight;
  int old_val[5] = {0, 0, 0, 0, 0};

  if (!global.win->window)
    return;

  for (i1 = 0; i1 < stat->band_size[1]; i1++) {
    old_val[i1%5] = stat->upload_band[i1];
    i2 = old_val[0] + old_val[1] + old_val[2] + old_val[3] + old_val[4];
    i2 /= 5;
    if (i2 > max) max = i2;
  }
  max = (int) (max * 1.1);
  if (max == 0)
    max = 1;

  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color2);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color3);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color4);
  if (!gc)
    gc = gdk_gc_new(global.win->window);
  if (!gc2)
    gc2 = gdk_gc_new(global.win->window);
  if (!gc3)
    gc3 = gdk_gc_new(global.win->window);
  if (!gc4)
    gc4 = gdk_gc_new(global.win->window);
  gdk_gc_set_foreground(gc, &color);
  gdk_gc_set_foreground(gc2, &color2);
  gdk_gc_set_foreground(gc3, &color3);
  gdk_gc_set_foreground(gc4, &color4);
  font =
      gdk_font_load
      ("-Adobe-Helvetica-medium-R-Normal--*-100-*-*-*-*-iso8859-*");

  temp = lookup_widget(global.win, "drawingarea4");
  if (!temp->window)
    return;

  width = temp->allocation.width;
  height = temp->allocation.height;
  if (width > stat->band_size[1])
    width = stat->band_size[1];

  i3 = 32;
  while (height * i3 < 25 * max) i3 *= 2;

  bytes = 0;
  pos = stat->band_pos[1]-4;
  if (stat->band_pos[1] >= 1) old_val[0] = stat->upload_band[stat->band_pos[1]-1];
  else old_val[0] = stat->upload_band[stat->band_size[1]-1];
  if (stat->band_pos[1] >= 2) old_val[1] = stat->upload_band[stat->band_pos[1]-2];
  else old_val[1] = stat->upload_band[stat->band_size[1]-2];
  if (stat->band_pos[1] >= 3) old_val[2] = stat->upload_band[stat->band_pos[1]-3];
  else old_val[2] = stat->upload_band[stat->band_size[1]-3];
  if (stat->band_pos[1] >= 4) old_val[3] = stat->upload_band[stat->band_pos[1]-4];
  else old_val[3] = stat->upload_band[stat->band_size[1]-4];

  for (i1 = width - 1; i1 >= 0; i1--) {
    pos--;
    if (pos < 0) pos += stat->band_size[1];
    
    i2 = height * (stat->upload_band[pos]+old_val[0]+old_val[1]+old_val[2]+old_val[3]) / max / 5;

    gdk_draw_line(temp->window, gc2, i1, 0, i1, height - i2);
    gdk_draw_line(temp->window, gc, i1, height - i2, i1, height - 1);

    if ((width - i1) % 60 == 0) {
      i4 = (width - i1) / 60;
      gdk_draw_line(temp->window, gc3, i1, height - 15, i1, height - 1);
      sprintf(str, "%d min", i4);
      gdk_draw_string(temp->window, font, gc3, i1 + 2, height - 3, str);
      add = i3 / 4;
    } else {
      add = i3;
    }
    i4 = 0;
    while (1) {
      i4 += add;
      i5 = height * i4 / max;
      if (i5 > height)
	break;
      if ((i5 > i2) || (i1 % 8 == 0) || (add != i3))
	gdk_draw_point(temp->window, gc3, i1, height - i5);
    }
    bytes += old_val[0];
    old_val[0] = old_val[1];
    old_val[1] = old_val[2];
    old_val[2] = old_val[3];
    old_val[3] = stat->upload_band[pos];

    av_bytes = (long) ((double) bytes / (double) (width - i1));
    i4 = height * av_bytes / max;
    gdk_draw_point(temp->window, gc4, i1, height - i4);
  }

  theight = gdk_string_height(font, "1,23KB");
  i4 = 0;
  while (1) {
    i4 += i3;
    i5 = height * i4 / max;
    if (height - i5 < theight + 5)
      break;
    print_size(str, i4);
    gdk_draw_string(temp->window, font, gc3, 5, height - i5 + theight + 2,
		    str);
  }
  if (height - i5 > 0)
    gdk_draw_string(temp->window, font, gc3, 2, height - i5 + theight + 2,
		    _("Upload"));
  else
    gdk_draw_string(temp->window, font, gc3, 2, theight + 2, _("Upload"));
}

void statistic_log(statistic_t * stat)
{
  char str[1204];
  char str2[1204];
  int i1;
  time_t tim;

  if (global.current_time <= global.start_time)
    tim = global.start_time+1;
  else tim = global.current_time;
  
  log("statistic", LOG_OTHER, "Uptime            : %s\n",
      print_time(str, tim - global.start_time));
  log("statistic", LOG_OTHER, "Bytes downloaded  : %.0f (%s) (%s)\n",
      stat->total[0], print_size(str, stat->total[0]),
      print_speed(str2, stat->total[0] / (tim - global.start_time), 1));
  log("statistic", LOG_OTHER, "Bytes uploaded    : %.0f (%s) (%s)\n",
      stat->total[1], print_size(str, stat->total[1]),
      print_speed(str2, stat->total[1] / (tim - global.start_time), 1));
  log("statistic", LOG_OTHER,
      "---transfer--------download/upload----- :\n");
  for (i1 = 0; i1 <= S_NUMBER; i1++) {
    if (stat->no_download[i1] || stat->no_upload[i1]) {
      log("statistic", LOG_OTHER, "%17s : %5d %5d\n",
	  (i1 == S_NUMBER) ? "Total" : status_names(i1),
	  stat->no_download[i1], stat->no_upload[i1]);
    }
  }
}

access_t *access_new(char *name)
{
  access_t *result;

  result = (access_t *) l_malloc(sizeof(access_t));
  result->name = l_strdup(name);
  result->last = 0;
  result->accesses = 0;
  result->access_list = NULL;
  result->done = 0;

  return result;
}

access_t *access_add(access_t * access, char *name, int depth)
{
  access_t *sub;
  int key;
  
  access_touch(access);
  sub = access_search(access, name);
  if (!sub) {
    sub = access_new(name);
    access_ctree_insert_access(access, sub, depth);
    if (!access->access_list) {
      access->access_list = l_malloc(ACCESS_HASH_LENGTH * sizeof(access_t*));
      for (key = 0; key < ACCESS_HASH_LENGTH; key++)
	access->access_list[key] = NULL;
    }
    key = hash_key(sub->name);
    access->access_list[key] = g_list_prepend(access->access_list[key], sub);
  }
  return sub;
}

void access_touch(access_t * access)
{
  access->last = global.current_time;
}

access_t *access_search(access_t * access, char *name)
{
  GList *dlist;
  access_t *sub;
  int key;

  if (!access->access_list) return NULL;
  key = hash_key(name);

  for (dlist = access->access_list[key]; dlist; dlist = dlist->next) {
    sub = dlist->data;
    if (!strcmp(sub->name, name))
      return sub;
  }
  return NULL;
}

void access_destroy(access_t * access)
{
  GList *dlist;
  access_t *sub;
  int i1;

  if (access->access_list) {
    for (i1 = 0; i1 < ACCESS_HASH_LENGTH; i1++) {
      for (dlist = access->access_list[i1]; dlist; dlist = dlist->next) {
	sub = dlist->data;
	access_destroy(sub);
      }
      g_list_free(access->access_list[i1]);
    }
    l_free(access->access_list);
  }
  if (access->name) l_free(access->name);
  l_free(access);
}

void access_new_request(transfer_t * transfer)
{
  access_t *access1;
  access_t *access2;

  if (transfer->is_dcc) return;
  
  if (global.options.access_timeout == 0) return;
  
  if (global.statistic.access_format == 0) {
    access1 = access_add(global.statistic.file_access, transfer->longname, 1);
    access2 = access_add(access1, transfer->user_info->user, 2);
  } else {
    access1 = access_add(global.statistic.file_access, transfer->user_info->user, 1);
    access2 = access_add(access1, transfer->longname, 2);
  }

  access_touch(access2);

  // if this was a new user to this file, then increase file and global counter 
  if (!access2->accesses) {
    global.statistic.file_access->accesses++;
    access1->accesses++;
  }

  access2->accesses++;

  access_ctree_update(global.statistic.file_access);
  access_ctree_update(access1);
  access_ctree_update(access2);

  //  access_save();
}

void access_finished_request(transfer_t* transfer) {
  access_t* access1;
  access_t* access2;
  
  if (global.statistic.access_format == 0) {
    access1 = access_search(global.statistic.file_access, transfer->longname);
    if (!access1) return;
    access2 = access_search(access1, transfer->user_info->user);
    if (!access2) return;
  } else {
    access1 = access_search(global.statistic.file_access, transfer->user_info->user);
    if (!access1) return;
    access2 = access_search(access1, transfer->longname);
    if (!access2) return;
  }
  access2->done++;
  access1->done++;
  global.statistic.file_access->done++;

  if (access2->done == 1) access_ctree_mark_access(access2);
  access_ctree_update(access1);
  access_ctree_update(global.statistic.file_access);
}

GtkCTreeNode* access_ctree_insert_real(GtkCTree* ctree, GtkCTreeNode* node,
				       access_t * access, int depth)
{
  GtkCTreeNode *node2;

  if (global.statistic.access_format == 0) {
    if (depth == 1) strcpy(tstr[0], extract_short_name(access->name));
    else strcpy(tstr[0], access->name);
  } else {
    if (depth == 2) strcpy(tstr[0], extract_short_name(access->name));
    else strcpy(tstr[0], access->name);
  }

  if (depth == 2) sprintf(tstr[1], "%d", access->accesses);
  else  sprintf(tstr[1], "%d (%d)", access->accesses, access->done);

  if (access->last) {
    strcpy(tstr[2], ctime(&access->last));
    tstr[2][strlen(tstr[2]) - 1] = 0;
  } else
    strcpy(tstr[2], _("None yet"));

  if (depth == 1) {
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 5,
				  global.pix.folder,
				  global.pix.folderb,
				  global.pix.folder_open,
				  global.pix.folder_openb, FALSE, FALSE);
  } else {
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 5,
				  NULL, NULL, NULL, NULL, FALSE, FALSE);
  }
  gtk_ctree_node_set_row_data(ctree, node2, access);

  return node2;
}

GtkCTreeNode* access_ctree_insert_node(GtkCTreeNode* node, access_t * access, int depth) {
  static GtkCTree* ctree = NULL;

  if (!ctree) ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  return access_ctree_insert_real(ctree, node, access, depth);
}

GtkCTreeNode* access_ctree_insert_access(access_t* parent, access_t * access, int depth) {
  static GtkCTree* ctree = NULL;
  GtkCTreeNode* node = NULL;

  if (!ctree) ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  if (parent) node = gtk_ctree_find_by_row_data(ctree, NULL, parent);
  
  return access_ctree_insert_real(ctree, node, access, depth);
}

void access_ctree_update(access_t * access)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, access);
  if (node) {
    if (access->access_list)
      sprintf(tstr[0], "%d (%d)", access->accesses, access->done);
    else sprintf(tstr[0], "%d", access->accesses);

    gtk_ctree_node_set_text(ctree, node, 1, tstr[0]);

    if (access->last) {
      strcpy(tstr[0], ctime(&access->last));
      tstr[0][strlen(tstr[0]) - 1] = 0;
    } else
      strcpy(tstr[0], _("None yet"));
    gtk_ctree_node_set_text(ctree, node, 2, tstr[0]);
  }

}

void access_ctree_mark_real(GtkCTree* ctree, GtkCTreeNode* node)
{
  style_t* style;

  style = style_get(global.scheme, "library_unshared");
  if (style) {
    gtk_ctree_node_set_foreground(ctree, node, style->fore);
    gtk_ctree_node_set_background(ctree, node, style->back);
  }
}

void access_ctree_mark_node(GtkCTreeNode* node)
{
  static GtkCTree *ctree = NULL;

  if (!node) return;
  if (!ctree) ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));

  access_ctree_mark_real(ctree, node);
}

void access_ctree_mark_access(access_t * access)
{
  static GtkCTree *ctree = NULL;
  GtkCTreeNode *node;

  if (!ctree) ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, access);
  if (!node) return;

  access_ctree_mark_real(ctree, node);
}

void access_ctree_remove_old()
{
  GtkCTree *ctree;
  access_t *access;
  GList *dlist;
  GtkCTreeNode *node;
  int i1;
  int cnt = 0;

  if (global.options.access_timeout <= 0) return;
  if (!global.statistic.file_access) return;
  if (!global.statistic.file_access->access_list) return;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_clist_freeze(GTK_CLIST(ctree));

  for (i1 = 0; i1 < ACCESS_HASH_LENGTH; i1++) {
    dlist = global.statistic.file_access->access_list[i1];
    while (dlist) {
      access = dlist->data;
      dlist = dlist->next;
      if (global.current_time - access->last >
	  (time_t) (global.options.access_timeout) *60 * 60) {
	global.statistic.file_access->access_list[i1] =
	  g_list_remove(global.statistic.file_access->access_list[i1], access);
	node = gtk_ctree_find_by_row_data(ctree, NULL, access);
	if (node)
	  gtk_ctree_remove_node(ctree, node);
	global.statistic.file_access->accesses -= access->accesses;
	access_destroy(access);
      }
    }
    if (global.statistic.file_access->access_list[i1]) cnt++;
  }
  if (cnt == 0) {
    l_free(global.statistic.file_access->access_list);
    global.statistic.file_access->access_list = NULL;
  }
  access_ctree_update(global.statistic.file_access);
  gtk_clist_thaw(GTK_CLIST(ctree));
}

access_t *access_add2(access_t * access, char *name)
{
  access_t *sub;
  int key;
  
  sub = access_search(access, name);
  if (!sub) {
    sub = access_new(name);
    if (!access->access_list) {
      access->access_list = l_malloc(ACCESS_HASH_LENGTH * sizeof(access_t*));
      for (key = 0; key < ACCESS_HASH_LENGTH; key++)
	access->access_list[key] = NULL;
    }
    key = hash_key(name);
    access->access_list[key] = g_list_prepend(access->access_list[key], sub);
  }
  return sub;
}

gint access_load_idle(gpointer data)
{
  FILE *fd = (FILE *) data;
  char line[2048];
  int cnt = 0;
  static access_t *current = NULL;
  access_t *access;
  int child;
  char* name;
  char* last;
  char* accesses;
  char* done;

  while (fgets(line, 2048 - 1, fd)) {
    cnt++;
    name = arg(line, 0);
    if (!name) continue;
    if (!strcasecmp(name, "AccessFormat")) {
      last = arg(NULL, 0);
      if (last) {
	global.statistic.access_format = atoi(last);
	if (global.statistic.file_access->name)
	  l_free(global.statistic.file_access->name);
	if (global.statistic.access_format)
	  global.statistic.file_access = access_new(_("User Request Statistic"));
	else
	  global.statistic.file_access = access_new(_("File Request Statistic"));
      }
      continue;
    } else if (*name == '-') {
      if (!current) continue;
      name = arg(NULL, 0);
      child = 1;
    } else {
      child = 0;
      current = global.statistic.file_access;
    }

    last = arg(NULL, 0);
    accesses = arg(NULL, 0);
    done = arg(NULL, 0);
    if (!last || !accesses) continue;
    
    access = access_add2(current, name);
    
    access->last = strtoul(last, NULL, 10);
    access->accesses = atoi(accesses);
    if (done) access->done = atoi(done);
    else access->done = 0;
    access->access_list = NULL;
    
    if (global.statistic.file_access->last < access->last)
      global.statistic.file_access->last = access->last;

    if (!child) {
      current = access;
    } else {
      global.statistic.file_access->accesses++;
      if (access->done) global.statistic.file_access->done++;
      //      current->accesses++;
    }
    if (cnt > 10) return 1;
  }

  fclose(fd);

  //  printf("access_load done(): %ld\n", time(NULL));
  global.status.access_read = 1;
  access_show(global.statistic.file_access);
  return 0;
}

void access_load()
{
  FILE *fd;
  char *fname;

  //  printf("access_load(): %ld\n", time(NULL));

  global.statistic.access_format = 0;
  global.statistic.file_access = access_new(_("File Request Statistic"));

  fname = l_strdup_printf("%s/access.list", global.options.config_dir);
  if ((fd = fopen(fname, "r")) == NULL) {
    global.status.access_read = 1;
    l_free(fname);
    access_show(global.statistic.file_access);
    return;
  }
  l_free(fname);

  gtk_idle_add(access_load_idle, (gpointer) fd);
}

void access_save()
{
  GList *dlist;
  GList *dlist2;
  char *fname;
  char *fname_new;
  FILE *fd;
  access_t *access1;
  access_t *access2;
  int i1, i2;

  fname = l_strdup_printf("%s/access.list", global.options.config_dir);

  if (!global.options.access_save || !global.statistic.file_access->access_list) {
    unlink(fname);
    l_free(fname);
    return;
  }
  fname_new = l_strdup_printf("%s/access.list.new", global.options.config_dir);

  if ((fd = fopen(fname_new, "w")) == NULL) {
    g_warning(_("Could not write [%s]\n"), fname);
    l_free(fname);
    l_free(fname_new);
    return;
  }

  fprintf(fd, "AccessFormat %d\n", global.statistic.access_format);
  for (i1 = 0; i1 < ACCESS_HASH_LENGTH; i1++) {
    for (dlist = global.statistic.file_access->access_list[i1]; dlist; dlist = dlist->next) {
      access1 = dlist->data;
      if (!access1->access_list) continue;
      fprintf(fd, "\"%s\" %lu %d %d\n",
	      access1->name, access1->last, access1->accesses, access1->done);
      for (i2 = 0; i2 < ACCESS_HASH_LENGTH; i2++) {
	for (dlist2 = access1->access_list[i2]; dlist2; dlist2 = dlist2->next) {
	  access2 = dlist2->data;
	  fprintf(fd, "- \"%s\" %lu %d %d\n",
		  access2->name, access2->last, access2->accesses, access2->done);
	}
      }
    }
  }

  if (!ferror(fd))
    rename(fname_new, fname);
  else {
    g_warning(_("Could not write [%s]\n"), fname);
  }

  fclose(fd);
  l_free(fname);
  l_free(fname_new);
}

void access_show(access_t* file_access) {
  GList* dlist;
  GList* dlist2;
  access_t* access1, *access2;
  GtkCTree *ctree;
  int i1, i2;
  GtkCTreeNode* node1;
  GtkCTreeNode* node2;
  GtkCTreeNode* node3;

  if (!file_access) return;

  //  printf("access_show(): %ld\n", time(NULL));

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_clist_freeze(GTK_CLIST(ctree));
  
  node1 = access_ctree_insert_node(NULL, file_access, 0);

  if (!file_access->access_list) {
    gtk_clist_thaw(GTK_CLIST(ctree));
    return;
  }

  for (i1 = 0; i1 < ACCESS_HASH_LENGTH; i1++) {
    //    printf("showing %d %p\n", i1, node1);
    for (dlist = file_access->access_list[i1]; dlist; dlist = dlist->next) {
      access1 = dlist->data;
      node2 = access_ctree_insert_node(node1, access1, 1);
      if (!access1->access_list) continue;
      for (i2 = 0; i2 < ACCESS_HASH_LENGTH; i2++) {
	for (dlist2 = access1->access_list[i2]; dlist2; dlist2 = dlist2->next) {
	  access2 = dlist2->data;
	  node3 = access_ctree_insert_node(node2, access2, 2);
	  if (access2->done > 0) access_ctree_mark_node(node3);
	}
      }
    }
  }
  gtk_clist_thaw(GTK_CLIST(ctree));
  //  printf("access_show_done(): %ld\n", time(NULL));
}

void access_convert() {
  GtkCTree *ctree;
  GList* dlist;
  GList* dlist2;
  access_t* acc1, *acc2;
  access_t* access1, *access2;
  access_t* file_access = NULL;
  int i1, i2;

  //  printf("converting access\n");

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_clist_clear(GTK_CLIST(ctree));
  if (global.statistic.access_format) {
    global.statistic.access_format = 0;
    file_access = access_new(_("File Request Statistic"));
  } else {
    global.statistic.access_format = 1;
    file_access = access_new(_("User Request Statistic"));
  }

  if (global.statistic.file_access->access_list) {
    for (i1 = 0; i1 < ACCESS_HASH_LENGTH; i1++) {
      for (dlist = global.statistic.file_access->access_list[i1]; dlist; dlist = dlist->next) {
	acc1 = dlist->data;
	if (!acc1->access_list) continue;
	for (i2 = 0; i2 < ACCESS_HASH_LENGTH; i2++) {
	  for (dlist2 = acc1->access_list[i2]; dlist2; dlist2 = dlist2->next) {
	    acc2 = dlist2->data;
	    
	    access1 = access_add2(file_access, acc2->name);
	    access2 = access_add2(access1, acc1->name);
	    
	    access2->last = acc2->last;
	    access2->accesses = acc2->accesses;
	    access2->done = acc2->done;
	    if (access2->done) access1->done++;
	    if (access1->last < access2->last) access1->last = access2->last;
	    access1->accesses++;
	    if (file_access->last < access2->last) file_access->last = access2->last;
	    if (access2->done) file_access->done++;
	    file_access->accesses++;
	  }
	}
      }
    }
  }
  access_destroy(global.statistic.file_access);
  global.statistic.file_access = file_access;
  access_show(file_access);
  access_save();
}

void on_access_collapse(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_ctree_collapse_recursive(ctree, NULL);
}

void on_access_expand(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_ctree_expand_recursive(ctree, NULL);
}

void on_access_play(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  access_t *access;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node)
    return;

  access = (access_t *) gtk_ctree_node_get_row_data(ctree, node);
  play_file(access->name);
}

void on_access_mode(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  access_convert();
}

GtkWidget *create_access_popup(void)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  GtkWidget *popup;
  GtkWidget *user_popup;
  GtkWidget *item;
  GtkWidget *separator;
  GtkAccelGroup *popup_accels;
  int mode;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node) return NULL;

  popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(popup));

  if (global.statistic.access_format == 0) {
    if (global.popup_row == 0) mode = 0;
    else if (GTK_CTREE_ROW(node)->children == NULL) mode = 2;   // user
    else if (GTK_CTREE_ROW(node)->parent) mode = 1;
    else mode = 0;
  } else {
    if (global.popup_row == 0) mode = 0;
    else if (GTK_CTREE_ROW(node)->children == NULL) mode = 1;   // file
    else if (GTK_CTREE_ROW(node)->parent) mode = 2;
    else mode = 0;
  }
  if (mode != 0) {
    if (mode == 1) {
      item = gtk_menu_item_new_with_label(_("Open File"));
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
      gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_access_play), node);
    
    } else if (mode == 2) {
      item = gtk_menu_item_new_with_label(_("User Menu"));
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
      
      user_popup = create_user_popup(M_ACCESS);
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), user_popup);
    }
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
  }

  item = gtk_menu_item_new_with_label(_("Expand"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_access_expand), NULL);

  item = gtk_menu_item_new_with_label(_("Collapse"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_access_collapse), NULL);

  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup), separator);
  gtk_widget_set_sensitive(separator, FALSE);
  
  if (global.statistic.access_format == 0)
    item = gtk_menu_item_new_with_label(_("Show by user"));
  else
    item = gtk_menu_item_new_with_label(_("Show by file"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_access_mode), NULL);

  return popup;
}
