%{

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "grammar.h"

void yyerror(char *c);
%}

%option yylineno

%%

unsigned\ char	{ yylval.num = 8; return T_SIZE; }
signed\ char	{ yylval.num = 8; return T_SIZE; }
char	{ yylval.num = 8; return T_SIZE; }
unsigned\ int	{ yylval.num = 32; return T_SIZE; }
signed\ int	{ yylval.num = 32; return T_SIZE; }
int	{ yylval.num = 32; return T_SIZE; }
__u16	{ yylval.num = 16; return T_SIZE; }
__u32	{ yylval.num = 32; return T_SIZE; }
(u_)?int8_t	{ yylval.num = 8; return T_SIZE; }
(u_)?int16_t	{ yylval.num = 16; return T_SIZE; }
(u_)?int32_t	{ yylval.num = 32; return T_SIZE; }

packet	return T_PKT;
struct	return T_PKT;
accept	return T_ACCEPT;
deny	return T_DENY;
if	return T_IF;
base	return T_BASE;

\<<	return T_LSH;
>>	return T_RSH;
\!=	return T_NE;
\<=	return T_LE;
\<	return T_LT;
>=	return T_GE;
>	return T_GT;
==	return T_EQ;
\|\|	return T_LOR;
&&	return T_LAND;
\{	return '{';
\}	return '}';
;	return ';';
\.	return '.';
\(	return '(';
\)	return ')';
\[	return '[';
\]	return ']';
\+	return '+';
\*	return '*';
-	return '-';
\/	return '/';
&	return '&';
\|	return '|';
,	return ',';
:	return ':';

([0-9]{1,3}\.){3}[0-9]{1,3}	{
			yylval.num = ntohl(inet_addr(yytext));
			return(T_NUM);
		}
0[xX][[:xdigit:]]+	{
			yylval.num = strtol(yytext, NULL, 0);
			return(T_NUM);
		}
[[:digit:]]+	{
			yylval.num = strtol(yytext, NULL, 0);
			return(T_NUM);
		}
[[:blank:]\n]+
[[:alnum:]_]+	{
			yylval.cp = strdup(yytext);
			return(T_ID);
		}

%%

void dummy() { yyunput(0, NULL); } /* shutup gcc */
