/*
 * OpenTrace.h
 *
 * Copyright (C) 1999 Karim Yaghmour.
 *
 * This is distributed under GPL.
 *
 * Header for open trace window.
 *
 * History : 
 *    K.Y., 23/06/1999, Initial typing.
 *
 * Note : The current version of this toolkit is for linux 2.2.0.
 */

#ifndef __TRACE_TOOLKIT_OPEN_TRACE__
#define __TRACE_TOOLKIT_OPEN_TRACE__

#include <EventOptions.h>

#include <gtk/gtk.h>

/* Define the two different files to get */
#define OT_PROF_FILE  0
#define OT_PROC_FILE  1

/* Define what the OK and Cancel callbacks look like */
typedef void _OTCBCancel
         (gpointer  /* The system view corresponding to this open trace */);
typedef void _OTCBOK
         (gpointer  /* The system view corresponding to this open trace */,
	  gchar*    /* Prof file name string */,
	  gchar*    /* Proc file name string */,
	  int       /* Is this a flight recorder trace? */);


/* Trace file selection window */
typedef struct _openTraceWindow
{
  /* The data */
  gpointer      SysView;
  GtkWidget*    ParentWin;          /* Parent window */
  _OTCBOK*      CBOK;   
  _OTCBCancel*  CBCancel;

  /* The widgets */
  GtkWidget*    Window;             /* Window to choose files */

  GtkWidget*    VBox;               /* Main vertical box */

  GtkWidget*    ProfHBox;           /* Horizontal box containing text and browse button for prof */
  GtkWidget*    ProcHBox;           /* Horizontal box containing text and browse button for proc */
  GtkWidget*    ButtonHBox;         /* Box containing OKButton and CancelButton */

  GtkWidget*    ProfLabel;          /* Label asking for prof file */
  GtkWidget*    ProcLabel;          /* Label asking for proc file */

  GtkWidget*    ProfFileTextEntry;  /* Where prof file name is displayed */
  GtkWidget*    ProcFileTextEntry;  /* Where proc file name is displayed */

  GtkWidget*    ProfFileBrowse;     /* Button to browse for prof file */
  GtkWidget*    ProcFileBrowse;     /* Button to browse for proc file */

  GtkWidget*    ProfFileSelect;     /* The window where the prof file is to be selected */
  GtkWidget*    ProcFileSelect;     /* The window where the proc file is to be selected */

  GtkWidget*    OKButton;           /* OK Button */
  GtkWidget*    CancelButton;       /* Cancel Button */
} openTraceWindow;

_OTCBCancel OTCBCancel;
_OTCBOK     OTCBOK;

#if 0
/* Callback function prototypes */
void OTCBCancel
         (gpointer  /* The system view corresponding to this open trace */);
void OTCBOK
         (gpointer  /* The system view corresponding to this open trace */,
	  gchar*    /* Prof file name string */,
	  gchar*    /* Proc file name string */);
#endif

/* Function prototypes */
void             OTSetFocus
                      (openTraceWindow* /* The open trace window */);
void             OTConnectSignals
                      (openTraceWindow* /* The open trace window */);
void             OTShowOpenTraceWindow
                      (openTraceWindow* /* The open trace window */);
openTraceWindow* OTCreateOpenTraceWindow
		      (gpointer         /* The system view */,
		       GtkWidget*       /* The parent window */,
                       _OTCBOK*         /* Function to call in case of OK */,
		       _OTCBCancel*     /* Function to call in case of cancel or close */);
void             OTDestroyOpenTraceWindow
                      (openTraceWindow* /* The open trace window */);


#endif /* __TRACE_TOOLKIT_OPEN_TRACE__ */

