-- vim:sw=4:sts=4
--
-- List of fundamental data types supported by this library.
--


---
-- For each fundamental type, give the FFI type to use when building
-- the parameter list, and a numerical type for handling the types in
-- a switch statement.
--
-- key = type name as it appears in types.xml
-- data = { ffi_type, flags, handlers, handlers_ptr, handlers_ptr_ptr, ... }
--
--  flags:
--	1 = numeric (don't think that's being used anymore)
--	2 = integer (don't think that's being used anymore)
--	4 = const (only used for const char*)
--
--  handlers, handlers_ptr etc.: for each level of indirection the handlers
--  to use; all of them are optional and may be missing or nil.
--	{ lua2ffi, ffi2lua, lua2struct, struct2lua }
--
fundamental_map = {
    -- Note: ffi_type for vararg is "void".  This is not exactly true, as
    -- a vararg will be replaced by zero or more arguments of variable type in
    -- an actual function call.  types.c:lua2ffi_vararg will replace it anyway
    -- so it could be anything, but it can't be nil, because then
    -- call.c:_call_build_parameters would complain about using a type with
    -- undefined ffi_type.
    ["vararg"] = { "void", 0, { "vararg", nil, nil, nil } },

    ["void"] = { "void", 0,
	{ nil, "void", nil, nil },
	{ "void_ptr", "void_ptr", nil, "void_ptr" },
    },

    ["enum"] = { "uint", 3,
	{ "enum", "enum", "enum", "enum" },
	{ "enum_ptr", "enum_ptr" },
	{ "enum_ptr_ptr", "enum_ptr_ptr" },
    },

    ["struct"] = { "pointer", 0,
    	{ nil, nil, nil, "struct" },	-- for globals XXX may be wrong
	{ "struct_ptr", "struct_ptr", nil, "struct_ptr" },
	{ "struct_ptr_ptr", "struct_ptr_ptr" },
    },
	    
    ["union"] = { "pointer", 0, 
	{ nil, nil, nil, "struct" },
	{ "struct_ptr", "struct_ptr", nil, "struct_ptr" },
	{ "struct_ptr_ptr", "struct_ptr_ptr" },
    },

    ["char"] = { "schar", 3,
	{ },
	{ "char_ptr", "char_ptr", nil, "char_ptr" },
	{ "char_ptr_ptr", "char_ptr_ptr" },
    },

    ["short unsigned int"] = { "ushort", 3, { "long", "long", "long", "long" } },

    ["short int"] = { "sshort", 3, { "long", "long", "long", "long" } },

    ["unsigned char"] = { "uchar", 3,
	{ "uchar", "uchar" },
	{ "char_ptr", "char_ptr", nil, "char_ptr" },
    },

    ["signed char"] = { "schar", 3, { } },

    ["long long unsigned int"] = { "uint64", 3, { "longlong" } },

    ["long unsigned int"] = { "ulong", 3,
	{ "long", "long", "long" },
	{ "long_unsigned_int_ptr", "long_unsigned_int_ptr" },
    },

    ["long long int"] = { "sint64", 3, { "longlong" } },

    ["long int"] = { "slong", 3, { "long", "long", "long", "long" } },

    ["int"] = { "sint", 3,
	{ "long", "long", "long", "long" },
	{ "int_ptr", "int_ptr" },
    },

    ["unsigned int"] = { "uint", 3,
	{ "long", "long", "long", "long" },
	{ "unsigned_int_ptr", "unsigned_int_ptr" },
    },

    ["long double"] = { "double", 1, { "double" } },

    ["double"] = { "double", 1, { "double", "double", "double", "double" } },

    ["float"] = { "float", 1, { "float" } },

    ["boolean"] = { "uint", 3, { "bool", "bool" } },

    ["func"] = { "void", 0,
	{ },
	{ "func_ptr", nil, "func_ptr" },
    },
}

