/*
 * tools/lvmiopversion.c
 *
 * Copyright (C) 2000  Andreas Dilger <adilger@turbolinux.com>
 * Modifications to act as wrapper (C) 2000 Tom Lees <tom@debian.org>
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LVM; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <lvm_user.h>

#ifdef DEBUG
int opt_d;
#endif

char *cmd = "lvmiopversion";

int main(int argc, char *argv[])
{
	struct stat st;
	int ver = lvm_get_iop_version();
	char lvm_prog[256];
	char *name;
	
	name = basename (argv[0]);
	if (!strcmp (name, "lvmiopversion"))
	{
		if (ver < 0)
		{
			fprintf(stderr, "%s -- LVM driver/module not loaded?\n\n", cmd);
			return LVM_EDRIVER;
		}
		printf ("%d\n", ver);
		return 0;
	}
	
	if (ver < 0)
		snprintf (lvm_prog, 256, "/lib/lvm-default/%s", name);
	else
		snprintf (lvm_prog, 256, "/lib/lvm-%d/%s", ver, name);
	
	/* Check at least for the existence of lvm_prog; if not, try lvm-default */
	if (stat (lvm_prog, &st) < 0)
		snprintf (lvm_prog, 256, "/lib/lvm-default/%s", name);
	
	execv (lvm_prog, argv);
	
	fprintf(stderr, "%s -- Exec of %s failed\n\n", cmd, name);
	perror (cmd);
	return LVM_EDRIVER;
}
