/*   This is part of LWIPv6
 *   Developed for the Ale4NET project
 *   Application Level Environment for Networking
 *   
 *   Copyright 2005 Diego Billi University of Bologna - Italy
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 * Copyright (c) 2001-2003 Swedish Institute of Computer Science.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Author: Adam Dunkels <adam@sics.se>
 *
 */
#ifndef __LWIPOPTS_H__
#define __LWIPOPTS_H__


/*
 * These are the default options of liblwip.so library. 
 * Some of these are necessary if you are going to
 * use Lwipv6a as UMVIEWOS module (lwipv6.so).
 */
#define LWIP_DEBUG 

/*
 * Remove assertions.
 */
#define LWIP_NOASSERT


/* Enable NETLINK sockets to support network configuration by using iproute2 tools */
#define LWIP_NL                        1

/* Enable PACKET socket if you want to use udhcpc with UMVIEWOS */
#define LWIP_PACKET                    1

#define IPv6                           1
#define IPv4_CHECK_CHECKSUM            1
#define IPv4_FRAGMENTATION             1
#define IPv6_FRAGMENTATION             1

#define IPv6_AUTO_CONFIGURATION        1

#define IPv6_ROUTER_ADVERTISEMENT      0
#define IPv6_RADVCONF                  0

#define LWIP_USERFILTER                0
#define LWIP_NAT                       0

/* Set to 1 to enable DHCP IPv4 */
#define LWIP_DHCP                      0



/* ---------- Memory options ---------- */

/* MEM_ALIGNMENT: should be set to the alignment of the CPU for which
   lwIP is compiled. 4 byte alignment -> define MEM_ALIGNMENT to 4, 2
   byte alignment -> define MEM_ALIGNMENT to 2. */
#define MEM_ALIGNMENT           4

/* MEM_SIZE: the size of the heap memory. If the application will send
a lot of data that needs to be copied, this should be set high. */
#define MEM_SIZE                65536

/* MEMP_NUM_PBUF: the number of memp struct pbufs. If the application
   sends a lot of data out of ROM (or other static memory), this
   should be set high. */
#define MEMP_NUM_PBUF           256

/* MEMP_NUM_UDP_PCB: the number of UDP protocol control blocks. One
   per active UDP "connection". */
#define MEMP_NUM_UDP_PCB        8

/* MEMP_NUM_TCP_PCB: the number of simulatenously active TCP
   connections. */
#define MEMP_NUM_TCP_PCB        16

/* MEMP_NUM_TCP_PCB_LISTEN: the number of listening TCP
   connections. */
#define MEMP_NUM_TCP_PCB_LISTEN 8

/* MEMP_NUM_TCP_SEG: the number of simultaneously queued TCP
   segments. */
#define MEMP_NUM_TCP_SEG        16

/* MEMP_NUM_SYS_TIMEOUT: the number of simulateously active
   timeouts. */
#define MEMP_NUM_SYS_TIMEOUT    30


/* The following four are used only with the sequential API and can be
   set to 0 if the application only will use the raw API. */
/* MEMP_NUM_NETBUF: the number of struct netbufs. */
#define MEMP_NUM_NETBUF         8

/* MEMP_NUM_NETCONN: the number of struct netconns. */
#define MEMP_NUM_NETCONN        8

/* MEMP_NUM_APIMSG: the number of struct api_msg, used for
   communication between the TCP/IP stack and the sequential
   programs. */
#define MEMP_NUM_API_MSG        64

/* MEMP_NUM_TCPIPMSG: the number of struct tcpip_msg, which is used
   for sequential API communication and incoming packets. Used in
   src/api/tcpip.c. */
#define MEMP_NUM_TCPIP_MSG      64

/* These two control is reclaimer functions should be compiled
   in. Should always be turned on (1). */
#define MEM_RECLAIM             1
#define MEMP_RECLAIM            1


/* ---------- Pbuf options ---------- */

/* PBUF_POOL_SIZE: the number of buffers in the pbuf pool. */
#define PBUF_POOL_SIZE          64

/* PBUF_POOL_BUFSIZE: the size of each pbuf in the pbuf pool. */
#define PBUF_POOL_BUFSIZE       32768

/* PBUF_LINK_HLEN: the number of bytes that should be allocated for a
   link level header. */
#define PBUF_LINK_HLEN          16


/* ---------- ARP options ---------- */

#define ARP_TABLE_SIZE      10

#define ARP_QUEUEING        1

/* ---------- IP options ---------- */

/* Define IP_FORWARD to 1 if you wish to have the ability to forward
   IP packets across network interfaces. If you are going to run lwIP
   on a device with only one network interface, define this to 0. */
#define IP_FORWARD              1

/* If defined to 1, IP options are allowed (but not parsed). If
   defined to 0, all packets with IP options are dropped. */
#define IP_OPTIONS              1

/* # of suspended fragments */
#define IP_REASS_POOL_SIZE      5

/* ---------- ICMP options ---------- */

#define ICMP_TTL                255


/* ---------- UDP options ---------- */

#define LWIP_UDP                1
#define UDP_TTL                 255


/* ---------- TCP options ---------- */

#define LWIP_TCP                1
#define TCP_TTL                 255

/* Controls if TCP should queue segments that arrive out of
   order. Define to 0 if your device is low on memory. */
#define TCP_QUEUE_OOSEQ         1

/* TCP Maximum segment size. */
#define TCP_MSS                 1488

/* TCP sender buffer space (bytes). */
#define TCP_SND_BUF             32768

/* TCP sender buffer space (pbufs). This must be at least = 2 *
   TCP_SND_BUF/TCP_MSS for things to work. */
#define TCP_SND_QUEUELEN        4 * TCP_SND_BUF/TCP_MSS

/* TCP receive window. */
#define TCP_WND                 32768

/* Maximum number of retransmissions of data segments. */
#define TCP_MAXRTX              12

/* Maximum number of retransmissions of SYN segments. */
#define TCP_SYNMAXRTX           4



#ifndef LWIP_COMPAT_SOCKETS
#define LWIP_COMPAT_SOCKETS      0
#endif

/* ---------- TCP/UDP sub-system thread ---------- */

/* TCP/UDP sub-system thread priority */
#define TCPIP_THREAD_PRIO       3


/* ---------- Statistics options ---------- */

/* By default, statistics are enabled */
#define LWIP_STATS   0
#ifdef STATS
#define LINK_STATS   1
#define IP_STATS     1
#define ICMP_STATS   1
#define UDP_STATS    1
#define TCP_STATS    1
#define MEM_STATS    1
#define MEMP_STATS   1
#define PBUF_STATS   1
#define SYS_STATS    1
#endif /* STATS */

/* ---------- Debug options ------------- */

#define DBG_MIN_LEVEL 0

#define DBG_TYPES_ON    (DBG_ON|DBG_TRACE|DBG_STATE|DBG_FRESH|DBG_HALT)

//#define MEMP_DEBUG              DBG_ON
//#define PBUF_DEBUG              DBG_ON
//#define ETHARP_DEBUG            DBG_ON
//#define ROUTE_DEBUG             DBG_ON
//#define DHCP_DEBUG              DBG_ON

//#define IP_DEBUG                DBG_ON
//#define IP_REASS_DEBUG          DBG_ON
//#define IP_AUTOCONF_DEBUG       DBG_ON

//#define PMTU_DEBUG              DBG_ON
//#define IPv6_ADDRSELECT_DBG     DBG_ON


//#define IP_RADV_DEBUG           DBG_ON
//#define IP_RADVCONF_DEBUG       DBG_ON

//#define USERFILTER_DEBUG        DBG_ON
//#define NAT_DEBUG               DBG_ON

//#define ICMP_DEBUG              DBG_ON
//#define UDP_DEBUG               DBG_ON


//#define TCPIP_DEBUG             DBG_ON
//#define SOCKETS_DEBUG           DBG_ON



/* ---------- Debug options for /contrib/port/unix/netif files ------------- */

/* These are not defined in opt.h */
//#define VDEIF_DEBUG             DBG_ON
//#define TUNIF_DEBUG             DBG_ON
//#define TAPIF_DEBUG             DBG_ON


#endif /* __LWIPOPTS_H__ */
