/* 
**  header.c -- Apache layout module
**  $Revision: 1.5 $
*/

#include "mod_layout.h"

LAYOUT_EXPORT(void)layout_header(request_rec *r, layout_conf *cfg, layout_request *info) {
	int x = 0;
	int assbackwards = 0;
	int status = OK;
	layout_string **current_header;

  current_header = (layout_string **) cfg->header->elts;

	for(x = 0; x < cfg->header->nelts; x++) {
		if(isOn(cfg->comment)){
			unless((x == 0 && (info->http == HEADER)))
				ap_rprintf(r, "\n\n<!-- Beginning of: %s -->\n\n", current_header[x]->comment);
		}

#ifdef DEBUG
		printf("Calling Header %s\n", current_header[x]->comment);
#endif

		/* Now lets see about headers */
		if (current_header[x]->type > 0) {
			ap_rputs(current_header[x]->string, r);
		} else {
			if(x == 0 && (info->http == HEADER)) {
				assbackwards = 0;
			} else {
				assbackwards = 1;
			}

			if ((status = call_container(r, current_header[x]->string, cfg, info, assbackwards)) != OK){
				ap_log_rerror(APLOG_MARK, APLOG_NOERRNO | APLOG_ERR, r, "The following error occured while processing the LayoutHeader : %d", status); 
			}
		}
		if (isOn(cfg->comment)) 
			ap_rprintf(r, "\n\n<!-- End of: %s -->\n\n", current_header[x]->comment );
	}
}
